/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpd.opplugin.web.sign.validator;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtpd.common.sign.constants.SignCardConstants;

public class SignImportValidator
extends HRDataBaseValidator
implements SignCardConstants {
    private static final Log LOG = LogFactory.getLog(SignImportValidator.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        LOG.info("SignImportValidator size:{}", (Object)dataEntities.length);
        Set attFileBoIdList = Arrays.stream(dataEntities).map(item -> item.getDataEntity().getLong("attfilebo.id")).collect(Collectors.toSet());
        String properties = WTCStringUtils.joinStr((String[])new String[]{"id", ",", "boid", ",", "bsed", ",", "bsled", ",", "startdate", ",", "enddate", ",", "atttag.attendstatus", ",", "wtteinfo.frozenstartdate", ",", "wtteinfo.frozenenddate"});
        AttFileF7QueryParam queryParam = new AttFileF7QueryParam();
        queryParam.setFormId("wtpd_signcard");
        queryParam.setAppId("wtpm");
        queryParam.setPermField("attfile");
        queryParam.setProperties(properties);
        queryParam.setAttStatus(null);
        queryParam.setSetBoIds(attFileBoIdList);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(queryParam);
        if (CollectionUtils.isEmpty((Collection)attFiles)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                String msg = ResManager.loadKDString((String)"\u65e0\u8003\u52e4\u6863\u6848.\u7f16\u7801\"{0}\"\u6743\u9650", (String)"SignImportValidator_0", (String)"wtc-wtpd-opplugin", (Object[])new Object[0]);
                String desc = MessageFormat.format(msg, dataEntity.getDataEntity().get("attfilebo.number"));
                this.addErrorMessage(dataEntity, desc);
            }
            return;
        }
        Map<Long, List<DynamicObject>> attFileMap = attFiles.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long attFileBoId = dataEntity.getDataEntity().getLong("attfilebo.id");
            String attFileNumber = dataEntity.getDataEntity().getString("attfilebo.number");
            List<DynamicObject> list = attFileMap.get(attFileBoId);
            if (CollectionUtils.isEmpty(list)) {
                String msg = ResManager.loadKDString((String)"\u65e0\u8003\u52e4\u6863\u6848.\u7f16\u7801\"{0}\"\u6743\u9650", (String)"SignImportValidator_0", (String)"wtc-wtpd-opplugin", (Object[])new Object[0]);
                String desc = MessageFormat.format(msg, attFileNumber);
                this.addErrorMessage(dataEntity, desc);
                continue;
            }
            this.validateDetail(dataEntity, list, attFileNumber);
        }
    }

    private void validateDetail(ExtendedDataEntity dataEntity, List<DynamicObject> list, String attFileNumber) {
        String desc;
        String msg;
        Date signDateTime = dataEntity.getDataEntity().getDate("signpoint");
        boolean invalidDate = true;
        boolean invalidStatus = true;
        boolean invalidFrozen = false;
        for (DynamicObject attFile : list) {
            if (attFile.getDate("startdate").compareTo(signDateTime) > 0 || attFile.getDate("enddate").compareTo(signDateTime) < 0) continue;
            invalidDate = false;
            if (AttStatusEnum.ATT_NORMAL.getCode().equals(attFile.getString("atttag.attendstatus"))) {
                invalidStatus = false;
            }
            Date start = attFile.getDate("wtteinfo.frozenstartdate");
            Date end = attFile.getDate("wtteinfo.frozenenddate");
            if (null == start || start.compareTo(signDateTime) > 0 || null == end || end.compareTo(signDateTime) < 0) continue;
            invalidFrozen = true;
        }
        if (invalidDate) {
            msg = ResManager.loadKDString((String)"\u4e0d\u5728\u8003\u52e4\u6863\u6848.\u7f16\u7801\"{0}\"\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185", (String)"SignImportValidator_1", (String)"wtc-wtpd-opplugin", (Object[])new Object[0]);
            desc = MessageFormat.format(msg, attFileNumber);
            this.addErrorMessage(dataEntity, desc);
            return;
        }
        if (invalidStatus) {
            msg = ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u7f16\u7801\"{0}\"\u7684\u8003\u52e4\u72b6\u6001\u4e3a\u201c\u505c\u6b62\u8003\u52e4\u201d\u3002", (String)"SignImportValidator_2", (String)"wtc-wtpd-opplugin", (Object[])new Object[0]);
            desc = MessageFormat.format(msg, attFileNumber);
            this.addErrorMessage(dataEntity, desc);
            return;
        }
        if (invalidFrozen) {
            msg = ResManager.loadKDString((String)"\u6253\u5361\u65f6\u95f4\"{0}\"\u5bf9\u5e94\u7684\u8003\u52e4\u5468\u671f\u65e5\u671f\u5df2\u51bb\u7ed3\u3002", (String)"SignImportValidator_3", (String)"wtc-wtpd-opplugin", (Object[])new Object[0]);
            desc = MessageFormat.format(msg, signDateTime.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDateTime().toString());
            this.addErrorMessage(dataEntity, desc);
        }
    }
}

