/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpd.formplugin.sign;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.wtpd.common.constants.SignCardConstants;

public class SignCardAccessPlugin
extends HRDataBaseEdit
implements SignCardConstants {
    public void afterCreateNewData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getModel().deleteEntryData("entryentity");
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        this.generateEntry(ids);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (operateKey.equals("confirm")) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put("confirm", "confirm");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String opKey = pageCache.get("confirm");
        if (!HRStringUtils.equals((String)"confirm", (String)opKey)) {
            return;
        }
        pageCache.remove("confirm");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (HRObjectUtils.isEmpty((Object)entry) || entry.size() == 0) {
            return;
        }
        HashMap returnData = new HashMap(16);
        for (DynamicObject dy : entry) {
            String oldAccess = dy.getString("oldaccesstag");
            String access = dy.getString("accesstag");
            boolean emptyNotChange = HRStringUtils.isEmpty((String)oldAccess) && HRStringUtils.equals((String)"empty", (String)access);
            if (emptyNotChange || HRStringUtils.equals((String)oldAccess, (String)access)) continue;
            HashMap<String, String> map = new HashMap<String, String>(4);
            String note = dy.getString("note");
            map.put("access", access);
            map.put("note", note);
            returnData.put(dy.getLong("id"), map);
        }
        view.returnDataToParent(returnData);
        view.sendFormAction(parentView);
    }

    private void generateEntry(List<Long> ids) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] signCardDys = helper.query("id,attfile,signpoint,accesstag", new QFilter[]{new QFilter("id", "in", ids)});
        if (HRObjectUtils.isEmpty((Object)signCardDys)) {
            return;
        }
        List<DynamicObject> signCardList = Arrays.asList(signCardDys);
        signCardList.sort(Comparator.comparing(dyn -> dyn.getDate("signpoint")).reversed());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        for (DynamicObject signCard : signCardDys) {
            DynamicObject row = new DynamicObject(entry.getDynamicObjectType());
            row.set("id", (Object)signCard.getLong("id"));
            row.set("attfile", (Object)signCard.getDynamicObject("attfile"));
            row.set("signpoint", (Object)signCard.getDate("signpoint"));
            String accessTag = signCard.getString("accesstag");
            row.set("oldaccesstag", (Object)accessTag);
            row.set("accesstag", (Object)(HRStringUtils.isEmpty((String)accessTag) ? "empty" : accessTag));
            entry.add((Object)row);
        }
    }
}

