/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpd.formplugin.sign;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.wtpd.common.constants.SignCardConstants;
import kd.wtc.wtbs.wtp.enums.supple.SignCardSourceEnum;
import kd.wtc.wtpd.common.sign.constants.SignCardKDString;

public class SignCardList
extends HRDataBaseList
implements SignCardConstants {
    private static final Log LOG = LogFactory.getLog(SignCardList.class);

    public void setFilter(SetFilterEvent event) {
        QFilter qFilter2;
        List qFilters = event.getQFilters();
        Map param = (Map)this.getView().getFormShowParameter().getCustomParam("param");
        if (!HRMapUtils.isEmpty((Map)param)) {
            Date startDate = (Date)JSONObject.parseObject((String)String.valueOf(param.get("startdate")), Date.class);
            Date endDate = (Date)JSONObject.parseObject((String)String.valueOf(param.get("enddate")), Date.class);
            if (null != startDate && null != endDate) {
                qFilters.add(new QFilter("signpointshort", ">=", (Object)startDate).and(new QFilter("signpointshort", "<=", (Object)endDate)));
            }
        }
        for (QFilter qFilter2 : qFilters) {
            List nests;
            if (HRStringUtils.equalsIgnoreCase((String)"signpointshort", (String)qFilter2.getProperty())) {
                qFilter2.__setProperty("signpoint");
                List qFilterNest = qFilter2.getNests(true);
                if (!CollectionUtils.isEmpty((Collection)qFilterNest)) {
                    QFilter.QFilterNest nest = (QFilter.QFilterNest)qFilterNest.get(0);
                    nest.getFilter().__setProperty("signpoint");
                }
            }
            if ((nests = qFilter2.getNests(true)) == null || nests.isEmpty()) continue;
            for (QFilter.QFilterNest qFilterNest : nests) {
                QFilter subFilter = qFilterNest.getFilter();
                if (!HRStringUtils.equalsIgnoreCase((String)"signpointshort", (String)subFilter.getProperty())) continue;
                subFilter.__setProperty("signpoint");
                List subFilterNest = subFilter.getNests(true);
                if (CollectionUtils.isEmpty((Collection)subFilterNest)) continue;
                QFilter.QFilterNest subNest = (QFilter.QFilterNest)subFilterNest.get(0);
                subNest.getFilter().__setProperty("signpoint");
            }
        }
        if (HRMapUtils.isEmpty((Map)param)) {
            return;
        }
        List attFileBoIdList = (List)param.get("attFileBoIdList");
        if (HRCollUtil.isEmpty((Collection)attFileBoIdList)) {
            return;
        }
        qFilter2 = new QFilter("attfile.boid", "in", (Object)attFileBoIdList);
        event.getQFilters().add(qFilter2);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                rows.forEach(row -> {
                    if (HRStringUtils.isNotEmpty((String)row.getString("modifytype"))) {
                        row.set("modifytype", (Object)ResManager.loadKDString((String)"\u5386\u53f2\u8bb0\u5f55", (String)"SignCardList_3", (String)"wtc-wtpd-formplugin", (Object[])new Object[0]));
                    }
                });
                return rows;
            }
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map param = (Map)this.getView().getFormShowParameter().getCustomParam("param");
        if (HRMapUtils.isEmpty((Map)param)) {
            return;
        }
        List attFileBoIdList = (List)param.get("attFileBoIdList");
        if (HRCollUtil.isEmpty((Collection)attFileBoIdList)) {
            return;
        }
        args.getCommonFilterColumns().removeIf(item -> "org.name".equalsIgnoreCase(item.getFieldName()) || "signpointshort".equalsIgnoreCase(item.getFieldName()) || "attfile.affiliateadminorg.name".equalsIgnoreCase(item.getFieldName()));
        List filterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!"status".equals(fieldName)) continue;
            filterColumn.setDefaultValue("1");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String evt = args.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Set<Long> ids = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
        switch (evt) {
            case "invalid": {
                this.invalidSignCard();
                break;
            }
            case "effect": {
                this.effectSignCard(ids);
                break;
            }
            case "access": {
                this.updateAccessTag(ids);
                break;
            }
        }
    }

    private void updateAccessTag(Set<Long> ids) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtpd_signcardaccess");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accessback"));
        formShowParameter.setCustomParam("ids", new ArrayList<Long>(ids));
        this.getView().showForm(formShowParameter);
    }

    private void effectSignCard(Set<Long> ids) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] signCardDys = hrBaseServiceHelper.query("id,attfilebo.id", new QFilter[]{new QFilter("id", "in", ids)});
        Set attFileBoIds = Arrays.stream(signCardDys).map(dy -> dy.getLong("attfilebo.id")).collect(Collectors.toSet());
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setAuthCheck(Boolean.FALSE);
        queryParam.setProperties("name");
        queryParam.setSetBoIds(attFileBoIds);
        queryParam.setAttStatus(null);
        HashSet<String> status = new HashSet<String>(2);
        status.add("-1");
        queryParam.setUsableStatus(status);
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        if (HRCollUtil.isNotEmpty((Collection)attFileList) && ids.size() == 1) {
            this.getView().showErrorNotification(SignCardKDString.attFileHasInvalid());
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtpd_signcardnote");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "effectback"));
        this.getView().showForm(formShowParameter);
    }

    private void invalidSignCard() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtpd_signcardnote");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invalidback"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "invalidback": {
                this.invalidSignCardCallBack(event);
                break;
            }
            case "effectback": {
                this.effectSignCardCallBack(event);
                break;
            }
            case "accessback": {
                this.updateAccessTagCallBack(event);
                break;
            }
        }
    }

    private void updateAccessTagCallBack(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (HRMapUtils.isEmpty((Map)returnData)) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Set idSet = returnData.keySet();
        HRBaseServiceHelper signCardServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] data = signCardServiceHelper.query("id,accesstag,source,remark,modifytype,attfilebo.id", new QFilter[]{new QFilter("id", "in", idSet)});
        HRBaseServiceHelper noteHisHelper = new HRBaseServiceHelper("wtpd_signnotehis");
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        DynamicObject[] noteHisDys = new DynamicObject[data.length];
        for (int index = 0; index < data.length; ++index) {
            DynamicObject row = data[index];
            Map map = (Map)returnData.get(row.getLong("id"));
            if (HRMapUtils.isEmpty((Map)map)) continue;
            String access = (String)map.get("access");
            row.set("accesstag", (Object)(HRStringUtils.equals((String)access, (String)"empty") ? "" : access));
            String note = (String)map.get("note");
            row.set("remark", (Object)note);
            row.set("modifytype", (Object)"0");
            DynamicObject noteHisDy = noteHisHelper.generateEmptyDynamicObject();
            noteHisDy.set("creator", (Object)currUserId);
            noteHisDy.set("createtime", (Object)now);
            noteHisDy.set("signcardid", (Object)row.getLong("id"));
            noteHisDy.set("remark", (Object)note);
            String type = HRStringUtils.equals((String)"on", (String)access) ? "3" : (HRStringUtils.equals((String)"off", (String)access) ? "4" : "5");
            noteHisDy.set("type", (Object)type);
            noteHisDys[index] = noteHisDy;
        }
        signCardServiceHelper.save(data);
        noteHisHelper.save(noteHisDys);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"SignCardList_1", (String)"wtc-wtpd-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void effectSignCardCallBack(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (null == returnData || null == returnData.get("note")) {
            return;
        }
        String note = (String)returnData.get("note");
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Set idSet = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
        HRBaseServiceHelper signCardServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] data = signCardServiceHelper.query("id,status,source,remark,modifytype,attfilebo.id", new QFilter[]{new QFilter("id", "in", idSet)});
        HRBaseServiceHelper noteHisHelper = new HRBaseServiceHelper("wtpd_signnotehis");
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        Set attFileBoIds = Arrays.stream(data).map(signCard -> signCard.getLong("attfilebo.id")).collect(Collectors.toSet());
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setAuthCheck(Boolean.FALSE);
        queryParam.setProperties("id");
        queryParam.setSetBoIds(attFileBoIds);
        queryParam.setAttStatus(null);
        HashSet<String> status = new HashSet<String>(2);
        status.add("-1");
        queryParam.setUsableStatus(status);
        queryParam.setBeCurrent(Boolean.valueOf(true));
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        Set discardAttFileBoIds = attFileList.stream().map(file -> file.getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> legalDataList = Arrays.stream(data).filter(signCard -> !discardAttFileBoIds.contains(signCard.getLong("attfilebo.id"))).collect(Collectors.toList());
        if (HRCollUtil.isEmpty(legalDataList)) {
            return;
        }
        DynamicObject[] legalData = legalDataList.toArray(new DynamicObject[0]);
        this.updateSupQuotaPool(legalData, "effect");
        DynamicObject[] noteHisDys = new DynamicObject[legalData.length];
        for (int i = 0; i < legalData.length; ++i) {
            DynamicObject row2 = legalData[i];
            row2.set("status", (Object)"1");
            row2.set("remark", (Object)note);
            row2.set("modifytype", (Object)"1");
            DynamicObject noteHisDy = noteHisHelper.generateEmptyDynamicObject();
            noteHisDy.set("creator", (Object)currUserId);
            noteHisDy.set("createtime", (Object)now);
            noteHisDy.set("signcardid", (Object)row2.getLong("id"));
            noteHisDy.set("remark", (Object)note);
            noteHisDy.set("type", (Object)"1");
            noteHisDys[i] = noteHisDy;
        }
        signCardServiceHelper.save(legalData);
        noteHisHelper.save(noteHisDys);
        this.getView().invokeOperation("refresh");
    }

    private void invalidSignCardCallBack(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (null == returnData || null == returnData.get("note")) {
            return;
        }
        String note = (String)returnData.get("note");
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Set idSet = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
        HRBaseServiceHelper signCardServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] data = signCardServiceHelper.query("id,status,source,remark,modifytype,attfilebo.id", new QFilter[]{new QFilter("id", "in", idSet)});
        HRBaseServiceHelper noteHisHelper = new HRBaseServiceHelper("wtpd_signnotehis");
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        this.updateSupQuotaPool(data, "invalid");
        DynamicObject[] noteHisDys = new DynamicObject[data.length];
        for (int i = 0; i < data.length; ++i) {
            DynamicObject row2 = data[i];
            row2.set("status", (Object)"0");
            row2.set("remark", (Object)note);
            row2.set("modifytype", (Object)"0");
            DynamicObject noteHisDy = noteHisHelper.generateEmptyDynamicObject();
            noteHisDy.set("creator", (Object)currUserId);
            noteHisDy.set("createtime", (Object)now);
            noteHisDy.set("signcardid", (Object)row2.getLong("id"));
            noteHisDy.set("remark", (Object)note);
            noteHisDy.set("type", (Object)"2");
            noteHisDys[i] = noteHisDy;
        }
        signCardServiceHelper.save(data);
        noteHisHelper.save(noteHisDys);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"SignCardList_1", (String)"wtc-wtpd-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long rowId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        if (HRStringUtils.equalsIgnoreCase((String)fieldName, (String)"modifytype")) {
            ListShowParameter parameter = new ListShowParameter();
            StyleCss style = new StyleCss();
            style.setWidth("800");
            style.setHeight("500");
            parameter.getOpenStyle().setInlineStyleCss(style);
            parameter.setCaption(ResManager.loadKDString((String)"\u539f\u59cb\u5361\u5386\u53f2\u8bb0\u5f55", (String)"SignCardList_2", (String)"wtc-wtpd-formplugin", (Object[])new Object[0]));
            parameter.setFormId("wtpm_listborderless");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setBillFormId("wtpd_signnotequery");
            parameter.setCustomParam("id", (Object)rowId);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void updateSupQuotaPool(DynamicObject[] data, String evt) {
        LOG.info("SignCardList.updateSupQuotaPool begin");
        if (data == null || data.length <= 0) {
            LOG.info("SignCardList.updateSupQuotaPool data is empty.");
            return;
        }
        String opType = "invalid".equals(evt) ? "0" : "1";
        HashSet<Long> signCardIds = new HashSet<Long>(data.length);
        for (DynamicObject signCard : data) {
            DynamicObject sourceDy;
            if (opType.equals(signCard.getString("status")) || (sourceDy = signCard.getDynamicObject("source")) == null || !SignCardSourceEnum.SOURCE_1010_S.getId().equals(sourceDy.getLong("id"))) continue;
            signCardIds.add(signCard.getLong("id"));
        }
        LOG.info("SignCardList.updateSupQuotaPool signCardIds.size:{}", (Object)signCardIds.size());
        if (!CollectionUtils.isEmpty(signCardIds)) {
            String serviceName = "ISupSignService";
            String methodName = "signCardValidOpUpdateSupQuotaPool";
            WTCServiceHelper.invokeWtcWtpmBizService((String)serviceName, (String)methodName, (Object[])new Object[]{signCardIds, opType});
        }
    }
}

