/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.sign.mobile;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.wtc.wtpm.constants.sign.mobile.MobileAdBatchStyleConstants;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.vo.mobile.suppleapply.MobileAdBatchOrgPersonItem;

public class MobileAdBatchControlService
implements MobileAdBatchStyleConstants {
    private MobileAdBatchControlService() {
    }

    public static Map<String, Object> createDeptFlexControl(MobileAdBatchOrgPersonItem orgPersonItem) {
        FlexPanelAp deptTopFlex = MobileAdBatchControlService.createDeptTopFlex(orgPersonItem);
        FlexPanelAp deptNameFlex = MobileAdBatchControlService.createDeptNameFlex(orgPersonItem);
        LabelAp deptNameLabel = MobileAdBatchControlService.createDeptNameLabel(orgPersonItem);
        deptNameFlex.getItems().add(deptNameLabel);
        if (orgPersonItem.getExpPerson() > 0L) {
            LabelAp expPersonLabel = MobileAdBatchControlService.createExpPersonLabel(orgPersonItem);
            deptNameFlex.getItems().add(expPersonLabel);
        }
        FlexPanelAp personCountFlex = MobileAdBatchControlService.createPersonCountFlex(orgPersonItem);
        LabelAp personCountLabel = MobileAdBatchControlService.createPersonCountLabel(orgPersonItem);
        personCountFlex.getItems().add(personCountLabel);
        VectorAp vectorAp = MobileAdBatchControlService.createVectorAp(orgPersonItem);
        personCountFlex.getItems().add(vectorAp);
        deptTopFlex.getItems().add(deptNameFlex);
        deptTopFlex.getItems().add(personCountFlex);
        return deptTopFlex.createControl();
    }

    public static TabAp createPubPersonTabAp(List<MobileAdBatchOrgPersonItem> orgPersonItems) {
        TabAp tabAp = new TabAp();
        tabAp.setId("tabap");
        tabAp.setKey("tabap");
        for (MobileAdBatchOrgPersonItem orgPersonItem : orgPersonItems) {
            TabPageAp tabPageAp = new TabPageAp();
            String controlKey = MobileAdBatchControlService.getControlKey("tabpage", orgPersonItem);
            tabPageAp.setId(controlKey);
            tabPageAp.setKey(controlKey);
            String tabName = orgPersonItem.getOrgName();
            tabPageAp.setName(new LocaleString(tabName));
            tabPageAp.setParentId(tabAp.getId());
            tabPageAp.setGrow(0);
            tabPageAp.setShrink(1);
            tabAp.getItems().add(tabPageAp);
        }
        return tabAp;
    }

    private static FlexPanelAp createDeptTopFlex(MobileAdBatchOrgPersonItem orgPersonItem) {
        String key = MobileAdBatchControlService.getControlKey("deptflex", orgPersonItem);
        FlexPanelAp deptFlex = MobileAdBatchControlService.createFlexPanelAp(key, "row", "space-between", "center");
        deptFlex.setHeight(new LocaleString("48px"));
        Style style = new Style();
        Border border = new Border();
        border.setTop("0.5px solid #E5E5E5");
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setLeft("12px");
        padding.setRight("12px");
        style.setPadding(padding);
        deptFlex.setStyle(style);
        deptFlex.setGrow(0);
        deptFlex.setShrink(1);
        deptFlex.setZIndex(99);
        deptFlex.setBackColor("#ffffff");
        deptFlex.setClickable(true);
        return deptFlex;
    }

    private static FlexPanelAp createDeptNameFlex(MobileAdBatchOrgPersonItem orgPersonItem) {
        String key = MobileAdBatchControlService.getControlKey("deptnameflex", orgPersonItem);
        FlexPanelAp deptNameFlex = MobileAdBatchControlService.createFlexPanelAp(key, "row", "space-between", "center");
        deptNameFlex.setGrow(0);
        deptNameFlex.setShrink(1);
        return deptNameFlex;
    }

    private static FlexPanelAp createPersonCountFlex(MobileAdBatchOrgPersonItem orgPersonItem) {
        String key = MobileAdBatchControlService.getControlKey("personcountflex", orgPersonItem);
        FlexPanelAp personCountFlex = MobileAdBatchControlService.createFlexPanelAp(key, "row", "flex-start", "stretch");
        personCountFlex.setGrow(0);
        personCountFlex.setShrink(0);
        return personCountFlex;
    }

    private static LabelAp createDeptNameLabel(MobileAdBatchOrgPersonItem orgPersonItem) {
        String key = MobileAdBatchControlService.getControlKey("deptnamelbl", orgPersonItem);
        String name = orgPersonItem.getOrgName();
        LabelAp deptNameLabel = MobileAdBatchControlService.createLabelAp(key, name, 16, "#666666");
        Style deptNameLabelStyle = new Style();
        Margin deptNameLabelMargin = new Margin();
        deptNameLabelMargin.setRight("12px");
        deptNameLabelStyle.setMargin(deptNameLabelMargin);
        deptNameLabel.setStyle(deptNameLabelStyle);
        deptNameLabel.setShrink(1);
        return deptNameLabel;
    }

    private static LabelAp createExpPersonLabel(MobileAdBatchOrgPersonItem orgPersonItem) {
        String controlKey = MobileAdBatchControlService.getControlKey("exppersonlbl", orgPersonItem);
        String name = SupSignKDString.expCountDesc((Object)orgPersonItem.getExpPerson());
        LabelAp expPersonLabel = MobileAdBatchControlService.createLabelAp(controlKey, name, 12, "#212121");
        expPersonLabel.setBackColor("#f2f2f2");
        Style expPersonLabelStyle = new Style();
        Border expPersonLabelBorder = new Border();
        expPersonLabelBorder.setTop("0px");
        expPersonLabelBorder.setBottom("0px");
        expPersonLabelBorder.setLeft("0px");
        expPersonLabelBorder.setRight("0px");
        expPersonLabelStyle.setBorder(expPersonLabelBorder);
        Padding expPersonLabelPadding = new Padding();
        expPersonLabelPadding.setLeft("8px");
        expPersonLabelPadding.setRight("8px");
        expPersonLabelStyle.setPadding(expPersonLabelPadding);
        Margin margin = new Margin();
        margin.setRight("12px");
        expPersonLabelStyle.setMargin(margin);
        expPersonLabel.setStyle(expPersonLabelStyle);
        expPersonLabel.setTextAlign("center");
        expPersonLabel.setLabelStyle("1");
        expPersonLabel.setLineHeight("20px");
        return expPersonLabel;
    }

    private static LabelAp createPersonCountLabel(MobileAdBatchOrgPersonItem orgPersonItem) {
        String controlKey = MobileAdBatchControlService.getControlKey("personcountlbl", orgPersonItem);
        String name = SupSignKDString.totalPerson((Object)orgPersonItem.getTotalPerson());
        LabelAp personCountLabel = MobileAdBatchControlService.createLabelAp(controlKey, name, 16, "#212121");
        Style personCountLabelStyle = new Style();
        Margin personCountLabelMargin = new Margin();
        personCountLabelMargin.setRight("12px");
        personCountLabelStyle.setMargin(personCountLabelMargin);
        personCountLabel.setStyle(personCountLabelStyle);
        return personCountLabel;
    }

    private static VectorAp createVectorAp(MobileAdBatchOrgPersonItem orgPersonItem) {
        String controlKey = MobileAdBatchControlService.getControlKey("vectorchoose", orgPersonItem);
        VectorAp vectorAp = new VectorAp();
        vectorAp.setId(controlKey);
        vectorAp.setKey(controlKey);
        vectorAp.setFontSize(16);
        vectorAp.setForeColor("#cccccc");
        vectorAp.setGrow(0);
        vectorAp.setShrink(0);
        vectorAp.setfontClass("kdfont kdfont-jinru");
        return vectorAp;
    }

    private static FlexPanelAp createFlexPanelAp(String key, String direction, String justifyContent, String alignItems) {
        FlexPanelAp personCountFlex = new FlexPanelAp();
        personCountFlex.setId(key);
        personCountFlex.setKey(key);
        personCountFlex.setDirection(direction);
        personCountFlex.setJustifyContent(justifyContent);
        personCountFlex.setAlignItems(alignItems);
        return personCountFlex;
    }

    private static LabelAp createLabelAp(String key, String name, int fontSie, String foreColor) {
        LabelAp labelAp = new LabelAp();
        labelAp.setId(key);
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(name));
        labelAp.setFontSize(fontSie);
        labelAp.setForeColor(foreColor);
        labelAp.setGrow(0);
        labelAp.setShrink(0);
        return labelAp;
    }

    private static String getControlKey(String prefix, MobileAdBatchOrgPersonItem orgPersonItem) {
        return MobileAdBatchControlService.getControlKey(prefix, orgPersonItem.getOrgId());
    }

    public static String getControlKey(String prefix, Object obj) {
        return prefix + "_" + obj;
    }
}

