/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.bill.ExRecordQuery;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtpm.business.signcard.SignCardHelperFactory;
import kd.wtc.wtpm.business.signcard.signcardapply.helper.SignCardApplyHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.vo.suppleapply.ApplyReqVo;

public class SignCardBatchService {
    private static final Log LOG = LogFactory.getLog(SignCardBatchService.class);

    private SignCardBatchService() {
    }

    public static List<DynamicObject> getAttFiles(Collection<Long> attFileIds, String queryProperty, QFilter qFilter) {
        return SignCardBatchService.getAttFiles(attFileIds, queryProperty, qFilter, null);
    }

    public static List<DynamicObject> getAttFiles(Collection<Long> attFileIds, String queryProperty, QFilter qFilter, Set<String> usableStatus) {
        if (CollectionUtils.isEmpty(attFileIds)) {
            return Collections.emptyList();
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setStartDate(null);
        attFileQueryParam.setEndDate(null);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setSetBoIds((Set)Sets.newHashSet(attFileIds));
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setqFilter(qFilter);
        if (HRStringUtils.isNotEmpty((String)queryProperty)) {
            attFileQueryParam.setProperties(queryProperty);
        }
        if (WTCCollections.isNotEmpty(usableStatus)) {
            attFileQueryParam.setUsableStatus(usableStatus);
        }
        List<DynamicObject> attFiles = SupSignHelper.queryAttFile(attFileQueryParam);
        LOG.info("SignCardbatchService.getAttFiles attFileIds.size={},attFiles.size={}", (Object)attFileIds.size(), (Object)attFiles.size());
        return attFiles;
    }

    public static List<DynamicObject> genPunchCardByListDataList(List<DynamicObject> listDatas) {
        if (CollectionUtils.isEmpty(listDatas)) {
            return new ArrayList<DynamicObject>(0);
        }
        LOG.info("SignCardBatchService.genPunchCardByListDataList.init data");
        ArrayList<DynamicObject> punchCardList = new ArrayList<DynamicObject>(listDatas.size());
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpd_signcard");
        Set<Long> timeZoneSetId = listDatas.stream().map(listDataDy -> listDataDy.getLong("supsigninfo.timezone.id")).collect(Collectors.toSet());
        List<DynamicObject> timeZoneList = SupSignHelper.getTimeZone(timeZoneSetId);
        Map<Long, DynamicObject> timeZoneMap = timeZoneList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        long userId = RequestContext.get().getCurrUserId();
        Date now = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now());
        for (DynamicObject listDataDy2 : listDatas) {
            DynamicObject punchCardDy = serviceHelper.generateEmptyDynamicObject();
            punchCardDy.set("id", listDataDy2.get("id"));
            DynamicObject attFileV = listDataDy2.getDynamicObject("attfilev");
            punchCardDy.set("org", attFileV.get("org"));
            punchCardDy.set("attperson", listDataDy2.get("attperson"));
            punchCardDy.set("attfile", (Object)attFileV);
            punchCardDy.set("attfilebo", listDataDy2.get("attfile"));
            punchCardDy.set("attcard", listDataDy2.get("card"));
            DynamicObject signInfoDy = listDataDy2.getDynamicObject("supsigninfo");
            SignCardBatchService.setSupSignInfo(signInfoDy, punchCardDy, timeZoneMap);
            punchCardDy.set("creator", (Object)userId);
            punchCardDy.set("createtime", (Object)now);
            punchCardDy.set("modifier", (Object)userId);
            punchCardDy.set("modifytime", (Object)now);
            punchCardList.add(punchCardDy);
        }
        if (!CollectionUtils.isEmpty(punchCardList)) {
            LOG.info("SignCardBatchService.genPunchCardByListDataList punchCardList size:{}", (Object)punchCardList.size());
            try (TXHandle tx = TX.requiresNew();){
                try {
                    SupSignHelper.savePunchCard(punchCardList);
                }
                catch (Exception throwable) {
                    tx.markRollback();
                    String errorMsg = throwable.getMessage();
                    LOG.warn("SupSignTaskHandleService.afterProcess.Exception:{}", (Object)errorMsg);
                    throw new KDBizException((Throwable)throwable, new ErrorCode("", errorMsg), new Object[0]);
                }
            }
        }
        return punchCardList;
    }

    public static void genPunchCardByBillEntity(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        LOG.info("SignCardBatchService.genPunchCardByBillEntity.init data");
        ArrayList<DynamicObject> punchCardList = new ArrayList<DynamicObject>(dataEntities.length);
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpd_signcard");
        ArrayList supSignInfoList = new ArrayList(dataEntities.length);
        HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            supSignInfoList.addAll(dataEntity.getDynamicObjectCollection("entryentity"));
            attFileBoIds.add(dataEntity.getLong("attfile.id"));
        }
        Map<Long, List<DynamicObject>> cardMap = SupSignHelper.queryCardHis(attFileBoIds);
        Set<Long> timeZoneSetId = supSignInfoList.stream().map(item -> item.getLong("timezone.id")).collect(Collectors.toSet());
        long userId = RequestContext.get().getCurrUserId();
        Date now = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now());
        List<DynamicObject> timeZoneList = SupSignHelper.getTimeZone(timeZoneSetId);
        Map<Long, DynamicObject> timeZoneMap = timeZoneList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection signInfoColl = dataEntity.getDynamicObjectCollection("entryentity");
            DynamicObject attFileV = dataEntity.getDynamicObject("attfilebasef7");
            for (DynamicObject signInfoDy : signInfoColl) {
                DynamicObject punchCardDy = serviceHelper.generateEmptyDynamicObject();
                punchCardDy.set("id", signInfoDy.get("id"));
                punchCardDy.set("org", attFileV.get("org"));
                punchCardDy.set("attperson", dataEntity.get("personid"));
                punchCardDy.set("attfile", (Object)attFileV);
                punchCardDy.set("attfilebo", dataEntity.get("attfile"));
                SignCardBatchService.setSignCardAttCard(punchCardDy, cardMap, dataEntity, signInfoDy);
                SignCardBatchService.setSupSignInfo(signInfoDy, punchCardDy, timeZoneMap);
                punchCardDy.set("modifier", (Object)userId);
                punchCardDy.set("modifytime", (Object)now);
                punchCardDy.set("creator", (Object)userId);
                punchCardDy.set("createtime", (Object)now);
                punchCardList.add(punchCardDy);
            }
        }
        LOG.info("SignCardBatchService.genPunchCardByBillEntity.init data end");
        if (!CollectionUtils.isEmpty(punchCardList)) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    SupSignHelper.savePunchCard(punchCardList);
                    LOG.info("SignCardBatchService.genPunchCardByBillEntity.savePunchCard end size={}", (Object)punchCardList.size());
                }
                catch (Exception throwable) {
                    tx.markRollback();
                    String errorMsg = throwable.getMessage();
                    LOG.warn("SupSignTaskHandleService.genPunchCardByBillEntity.Exception:{}", (Object)errorMsg);
                    throw new KDBizException((Throwable)throwable, new ErrorCode("", errorMsg), new Object[0]);
                }
            }
        }
    }

    private static void setSupSignInfo(DynamicObject signInfoDy, DynamicObject punchCardDy, Map<Long, DynamicObject> timeZoneMap) {
        long timeZoneId;
        int timeDif = 0;
        DynamicObject timeZoneDy = signInfoDy.getDynamicObject("timezone");
        if (timeZoneDy != null && (timeZoneDy = timeZoneMap.get(timeZoneId = timeZoneDy.getLong("id"))) != null) {
            timeDif = timeZoneDy.getInt("timedif");
        }
        Date signDate = signInfoDy.getDate("signdate");
        Date signPoint = WTCDateUtils.getDate((Date)signDate, (Integer)signInfoDy.getInt("suppleworktime"));
        LocalDateTime signPointLocal = WTCDateUtils.toLocalDateTime((Date)signPoint);
        LocalDateTime localDateTime = signPointLocal.plusHours((long)timeDif * -1L);
        punchCardDy.set("signpointshort", (Object)signDate);
        punchCardDy.set("signpoint", (Object)signPoint);
        punchCardDy.set("signpointutc", (Object)WTCDateUtils.toDate((LocalDateTime)localDateTime));
        punchCardDy.set("source", signInfoDy.get("source"));
        punchCardDy.set("device", signInfoDy.get("equipment"));
        punchCardDy.set("remark", signInfoDy.get("remark"));
        punchCardDy.set("status", (Object)"1");
        punchCardDy.set("accesstag", signInfoDy.get("accesstag"));
        punchCardDy.set("pointtag", signInfoDy.get("pointtag"));
        punchCardDy.set("timezone", signInfoDy.get("timezone"));
        punchCardDy.set("applyreason", signInfoDy.get("applyreason"));
    }

    private static void setSignCardAttCard(DynamicObject punchCardDy, Map<Long, List<DynamicObject>> cardMap, DynamicObject dataEntity, DynamicObject signInfoDy) {
        Long attFileBoId = dataEntity.getLong("attfile.id");
        List<DynamicObject> cardHisList = cardMap.get(attFileBoId);
        Date signDate = signInfoDy.getDate("signdate");
        punchCardDy.set("attcard", (Object)SignCardBatchService.getCardHisByDate(cardHisList, signDate));
    }

    public static String getCardHisByDate(List<DynamicObject> cardHisList, Date date) {
        if (CollectionUtils.isEmpty(cardHisList)) {
            return "";
        }
        Optional<DynamicObject> any = cardHisList.stream().filter(item -> date.compareTo(item.getDate("bsed")) >= 0 && date.compareTo(item.getDate("bsled")) <= 0).findAny();
        if (any.isPresent()) {
            return any.get().getString("card");
        }
        return "";
    }

    public static List<Map<String, Object>> getCurrentAttFilesBoIds(DynamicObject dataEntity) {
        boolean isMulPri = SignCardBatchService.billIsMulPri(dataEntity);
        if (isMulPri) {
            return SignCardBatchService.getMulPriSupAttFiles(dataEntity);
        }
        return SignCardBatchService.getMulPubSupAttFiles(dataEntity);
    }

    public static List<Map<String, Object>> getBatchBillAttFileIds(ApplyReqVo applyReqVo) {
        String taskCategory = applyReqVo.getTaskCategory();
        long billId = applyReqVo.getBillId();
        String queryProp = "attfile.id,attfile.boid,attfile.attperson.id,attfile.org.id,attfile.atttag.id";
        List<DynamicObject> dataList = "wtpm_supsign".equals(taskCategory) ? SupSignHelper.queryBatchBillDetailByBillId(Lists.newArrayList((Object[])new Long[]{billId}), null, queryProp) : SignCardApplyHelper.querySignCardListPropByBillIds(Lists.newArrayList((Object[])new Long[]{billId}), null, queryProp);
        if (WTCCollections.isNotEmpty(dataList)) {
            HashSet attFileIdSet = Sets.newHashSetWithExpectedSize((int)dataList.size());
            List disAttFileDataList = dataList.stream().filter(item -> attFileIdSet.add(item.getLong("attfile.id"))).collect(Collectors.toList());
            ArrayList<Map<String, Object>> attFileMapList = new ArrayList<Map<String, Object>>(disAttFileDataList.size());
            for (DynamicObject attFile : disAttFileDataList) {
                attFileMapList.add(SignCardBatchService.setTaskParamsOfAttFileHavePrefix(attFile));
            }
            return attFileMapList;
        }
        return Collections.emptyList();
    }

    private static List<Map<String, Object>> getMulPriSupAttFiles(DynamicObject dataEntity) {
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentitymultipri");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> attFileList = new ArrayList<Map<String, Object>>(dynamicObjectCollection.size());
        HashSet attFileBoIdSet = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            long attFileBoId;
            DynamicObject attFile = dynamicObject.getDynamicObject("multipriattfile");
            if (attFile == null || !attFileBoIdSet.add(attFileBoId = attFile.getLong("boid"))) continue;
            attFileList.add(SignCardBatchService.setTaskParamsOfAttFile(attFile));
        }
        return attFileList;
    }

    public static List<Map<String, Object>> getMulPubSupAttFiles(DynamicObject dataEntity) {
        boolean withOrg = dataEntity.getBoolean("withorg");
        boolean withPerson = dataEntity.getBoolean("withperson");
        ArrayList<Long> includeAttFileBoIds = new ArrayList<Long>(16);
        ArrayList<Map<String, Object>> attFileMapList = new ArrayList<Map<String, Object>>(16);
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet excludeAttFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        if (withPerson) {
            SignCardBatchService.log("SignCardBatchService.getMulPubSupAttFiles withPerson begin", new Object[0]);
            SignCardBatchService.getSelectPerson(dataEntity, includeAttFileBoIds, attFileMapList);
            SignCardBatchService.log("SignCardBatchService.getMulPubSupAttFiles withPerson end", new Object[0]);
        }
        if (withOrg) {
            SignCardBatchService.getSelectAdminOrgAndExcludeAttFile(dataEntity, adminOrgIds, excludeAttFileBoIds, includeAttFileBoIds);
        }
        if (!CollectionUtils.isEmpty((Collection)adminOrgIds)) {
            DynamicObjectCollection supSignInfoColl = dataEntity.getDynamicObjectCollection("entryentitysupinfo");
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
            SignCardBatchService.getApplyDateRangeFilter(supSignInfoColl, "signdate", attFileQueryParam);
            attFileQueryParam.setAffiliateAdminOrgSetIds((Set)adminOrgIds);
            excludeAttFileBoIds.addAll(includeAttFileBoIds);
            if (!CollectionUtils.isEmpty((Collection)excludeAttFileBoIds)) {
                attFileQueryParam.setBoDelSetIds((Set)excludeAttFileBoIds);
            }
            attFileQueryParam.setBeCurrent(Boolean.TRUE);
            attFileQueryParam.setAuthCheck(Boolean.FALSE);
            attFileQueryParam.setAttStatus(null);
            attFileQueryParam.setProperties(WTCStringUtils.joinOnComma((String[])new String[]{"attperson.id", "boid", "id", "org.id", "atttag.id"}));
            SignCardBatchService.log("SignCardBatchService.getMulPubSupAttFiles.queryAttFile.begin", new Object[0]);
            StopWatch watch = StopWatch.createStarted();
            List<DynamicObject> attFileList = SupSignHelper.queryAttFile(attFileQueryParam);
            watch.stop();
            SignCardBatchService.log("SignCardBatchService.getMulPubSupAttFiles.queryAttFile.size={},time={}ms", attFileList.size(), watch.getTime());
            for (DynamicObject attFile : attFileList) {
                attFileMapList.add(SignCardBatchService.setTaskParamsOfAttFile(attFile));
            }
        }
        return attFileMapList;
    }

    private static Map<String, Object> setTaskParamsOfAttFile(DynamicObject attFile) {
        HashMap attFileMap = Maps.newHashMapWithExpectedSize((int)5);
        attFileMap.put("attFileId", attFile.getLong("id"));
        attFileMap.put("attFileBoId", attFile.getLong("boid"));
        attFileMap.put("attPersonId", attFile.getLong("attperson.id"));
        attFileMap.put("org", attFile.getLong("org.id"));
        attFileMap.put("attTagId", attFile.getLong("atttag.id"));
        return attFileMap;
    }

    private static Map<String, Object> setTaskParamsOfAttFileHavePrefix(DynamicObject attFile) {
        HashMap attFileMap = Maps.newHashMapWithExpectedSize((int)5);
        attFileMap.put("attFileId", attFile.getLong("attfile.id"));
        attFileMap.put("attFileBoId", attFile.getLong("attfile.boid"));
        attFileMap.put("attPersonId", attFile.getLong("attfile.attperson.id"));
        attFileMap.put("org", attFile.getLong("attfile.org.id"));
        attFileMap.put("attTagId", attFile.getLong("attfile.atttag.id"));
        return attFileMap;
    }

    private static void getApplyDateRangeFilter(DynamicObjectCollection supSignInfoEntry, String propKey, AttFileQueryParam attFileQueryParam) {
        ArrayList<Date> signDates = new ArrayList<Date>(supSignInfoEntry.size());
        for (DynamicObject signCardInfo : supSignInfoEntry) {
            Date date = signCardInfo.getDate(propKey);
            signDates.add(date);
        }
        signDates.sort(Date::compareTo);
        Date beginDate = (Date)signDates.get(0);
        Date endDate = (Date)signDates.get(signDates.size() - 1);
        attFileQueryParam.setStartDate(beginDate);
        attFileQueryParam.setEndDate(endDate);
    }

    private static void getSelectPerson(DynamicObject dataEntity, List<Long> includeAttFileBoIds, List<Map<String, Object>> attFileMapList) {
        DynamicObjectCollection extraPersonColl = dataEntity.getDynamicObjectCollection("entryentityperson");
        if (CollectionUtils.isEmpty((Collection)extraPersonColl)) {
            return;
        }
        for (DynamicObject dynamicObject : extraPersonColl) {
            DynamicObject attFile = dynamicObject.getDynamicObject("exteaattfile");
            if (attFile == null) continue;
            long boid = attFile.getLong("boid");
            attFileMapList.add(SignCardBatchService.setTaskParamsOfAttFile(attFile));
            includeAttFileBoIds.add(boid);
        }
    }

    public static void getSelectAdminOrgAndExcludeAttFile(DynamicObject dataEntity, Set<Long> adminOrgIds, Set<Long> excludeAttFileBoIds, List<Long> includeAttFileBoIds) {
        SignCardBatchService.log("SignCardBatchService.getSelectAdminOrgAndExcludeAttFile begin", new Object[0]);
        DynamicObjectCollection orgColl = dataEntity.getDynamicObjectCollection("entryentityorg");
        if (CollectionUtils.isEmpty((Collection)orgColl)) {
            return;
        }
        for (DynamicObject entryOrgDy : orgColl) {
            String orgType = entryOrgDy.getString("orgtype");
            long orgClassId = entryOrgDy.getLong("orgclass.id");
            if (!"haos_adminorghr".equals(orgType)) continue;
            adminOrgIds.add(orgClassId);
            DynamicObjectCollection excludePersonColl = entryOrgDy.getDynamicObjectCollection("excperson");
            if (CollectionUtils.isEmpty((Collection)excludePersonColl)) continue;
            excludePersonColl.forEach(excludePersonDy -> {
                long attFileBoId;
                DynamicObject dynamicObject = excludePersonDy.getDynamicObject("fbasedataid");
                if (dynamicObject != null && !includeAttFileBoIds.contains(attFileBoId = dynamicObject.getLong("boid"))) {
                    excludeAttFileBoIds.add(attFileBoId);
                }
            });
        }
        SignCardBatchService.log("SignCardBatchService.getSelectAdminOrgAndExcludeAttFile begin", new Object[0]);
        if (!CollectionUtils.isEmpty(adminOrgIds)) {
            SignCardBatchService.log("SignCardBatchService.getSubAdminOrg begin", new Object[0]);
            List<Long> subOrgIdList = SignCardBatchService.getSubAdminOrg(Lists.newArrayList(adminOrgIds));
            adminOrgIds.addAll(subOrgIdList);
            SignCardBatchService.log("SignCardBatchService.getSubAdminOrg begin", new Object[0]);
        }
    }

    public static List<Long> getSubAdminOrg(List<Long> adminOrgList) {
        StopWatch watch = StopWatch.createStarted();
        List adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg(adminOrgList, new Date());
        List<Long> subOrgIdList = adminOrgAllSubList.stream().map(item -> (Long)item.get("orgId")).collect(Collectors.toList());
        subOrgIdList.addAll(adminOrgList);
        watch.stop();
        LOG.info("SignCardBatchService.getSubAdminOrg.time:{}", (Object)watch.getTime());
        return subOrgIdList;
    }

    public static Tuple<Date, Date> getBatchApplyDateRange(DynamicObject dataEntity) {
        DynamicObjectCollection supSignInfoEntry;
        DynamicObjectCollection mulPriSupInfo;
        boolean isMulPriSup = SignCardBatchService.billIsMulPri(dataEntity);
        List allApplyDate = isMulPriSup ? (CollectionUtils.isEmpty((Collection)(mulPriSupInfo = dataEntity.getDynamicObjectCollection("entryentitymultipri"))) ? null : mulPriSupInfo.stream().map(item -> item.getDate("prisigndate")).collect(Collectors.toList())) : (CollectionUtils.isEmpty((Collection)(supSignInfoEntry = dataEntity.getDynamicObjectCollection("entryentitysupinfo"))) ? null : supSignInfoEntry.stream().map(item -> item.getDate("signdate")).collect(Collectors.toList()));
        if (allApplyDate == null) {
            return new Tuple(null, null);
        }
        allApplyDate.sort(Date::compareTo);
        return new Tuple(allApplyDate.get(0), allApplyDate.get(allApplyDate.size() - 1));
    }

    public static boolean billIsMulPri(DynamicObject dataEntity) {
        boolean isMulPriSup = false;
        if (dataEntity.containsProperty("batchsuptype")) {
            String batchSupType = dataEntity.getString("batchsuptype");
            isMulPriSup = "1".equals(batchSupType);
        }
        return isMulPriSup;
    }

    public static QFilter getDataRuleForBdProp(String propKey, String entityId, String appNumber) {
        if (!WtbsBusinessUtils.isSuperUser() && HRStringUtils.isNotEmpty((String)appNumber) && HRStringUtils.isNotEmpty((String)entityId)) {
            return HRAuthService.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), appNumber, entityId, propKey, "47150e89000000ac", new HashMap(1));
        }
        return null;
    }

    public static boolean isPartSuccessSubmit() {
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        String checkSubmitType = billSystemParam.getCheckSubmitType();
        return "2".equals(checkSubmitType);
    }

    public static Map<Long, List<DynamicObject>> getExRecordByAttPersonAndDate(List<ExRecordQuery> exRecordQueryList) {
        HashSet attPersonIdSet = Sets.newHashSetWithExpectedSize((int)exRecordQueryList.size());
        HashSet recordDateSet = Sets.newHashSetWithExpectedSize((int)exRecordQueryList.size());
        for (ExRecordQuery exRecordQuery : exRecordQueryList) {
            attPersonIdSet.add(exRecordQuery.getAttPersonId());
            recordDateSet.add(exRecordQuery.getRecordDate());
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_exrecord");
        String queryField = "personid,recorddate,exattributeid,exprocessid,attfileid,attitemid";
        QFilter qFilter = new QFilter("personid", "in", (Object)attPersonIdSet);
        List recordDateList = recordDateSet.stream().sorted().collect(Collectors.toList());
        Date beginDate = (Date)recordDateList.get(0);
        Date endDate = (Date)recordDateList.get(recordDateList.size() - 1);
        QFilter dateFilter = new QFilter("recorddate", ">=", (Object)beginDate);
        dateFilter.and(new QFilter("recorddate", "<=", (Object)endDate));
        DynamicObject[] exRecordArr = serviceHelper.queryOriginalArray(queryField, new QFilter[]{qFilter, dateFilter});
        return Arrays.stream(exRecordArr).collect(Collectors.groupingBy(item -> item.getLong("attfileid")));
    }

    public static boolean isCalcCountBySignCard() {
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        String supCountCalType = billSystemParam.getSupCountCalType();
        return "2".equals(supCountCalType);
    }

    private static void log(String log, Object ... params) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(log, params);
        }
    }

    public static void batchRemoveEntryCache(DynamicObject[] dataEntities, String entryKey, String bsEntityId) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        try {
            ArrayList infoPkIds = new ArrayList(16);
            for (DynamicObject dynamicObject : dataEntities) {
                DynamicObjectCollection supsignInfoColl = dynamicObject.getDynamicObjectCollection(entryKey);
                if (WTCCollections.isEmpty((Collection)supsignInfoColl)) continue;
                List pkIds = supsignInfoColl.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
                infoPkIds.addAll(pkIds);
            }
            if (WTCCollections.isNotEmpty(infoPkIds)) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bsEntityId);
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)mainEntityType);
                cacheManager.removeByPrimaryKey(infoPkIds.toArray());
            }
        }
        catch (Exception ex) {
            LOG.warn("SignCardBatchService.batchRemoveEntryCache error", (Throwable)ex);
        }
    }
}

