/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.common.concurrent.WTCMutexHelper;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolTaskService;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;

public class SupSignChangeService {
    private static String OPERATE_KEY = "modify";
    private static String MUTEX_OPERATE_KEY = "operationkey";
    private static String MUTEX_ENTITY_ID = "entitykey";
    private static String MUTEX_PK_ID = "objectid";
    private static String MUTEX_DATA_LOCK_USER = "user";
    private static String CHANGENUM = "changenum";
    private static final Log Log = LogFactory.getLog(SupSignChangeService.class);
    private static SupSignChangeService signCommonService;
    private static final Map<String, String> ENTITY_QUERYCONF_MAP;

    public static SupSignChangeService getInstance() {
        if (signCommonService == null) {
            signCommonService = new SupSignChangeService();
        }
        return signCommonService;
    }

    public void preOpenFormOfSetCaption(BillShowParameter billShowParameter) {
        Object pkId = billShowParameter.getPkId();
        if (pkId != null) {
            String caption;
            String formId = billShowParameter.getFormId();
            if (HRStringUtils.equals((String)"wtpm_supsignpc", (String)formId)) {
                caption = ResManager.loadKDString((String)"\u4e3a\u4ed6\u4eba\u7533\u8bf7\u8865\u7b7e", (String)"SupSignChangeService_0", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)"wtpm_supsignpcchange", (String)formId)) {
                caption = ResManager.loadKDString((String)"\u4e3a\u4ed6\u4eba\u7533\u8bf7\u8865\u7b7e\u53d8\u66f4", (String)"SupSignChangeService_1", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)"wtpm_supsignself", (String)formId)) {
                caption = ResManager.loadKDString((String)"\u8865\u7b7e\u7533\u8bf7", (String)"SupSignChangeService_2", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            } else if (HRStringUtils.equals((String)"wtpm_supsignselfchange", (String)formId)) {
                caption = ResManager.loadKDString((String)"\u8865\u7b7e\u7533\u8bf7\u53d8\u66f4", (String)"SupSignChangeService_3", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            } else {
                return;
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_supsignpc");
            DynamicObject dy = helper.queryOne(pkId);
            DynamicObject attFile = dy.getDynamicObject("attfile");
            if (attFile != null) {
                caption = caption + "-" + attFile.getLocaleString("name");
            }
            billShowParameter.setCaption(caption);
        }
    }

    public void setChangeData(IFormView billView) {
        if (billView == null) {
            return;
        }
    }

    public void openNewChange(Long pkId, IFormView formView, AbstractFormPlugin closeCallBackPlugin) {
        if (formView == null) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getEntity(formView));
        DynamicObject dynamicObject = helper.queryOne((Object)pkId);
        if (dynamicObject == null) {
            return;
        }
        boolean isNewBill = dynamicObject.getBoolean("isnewbill");
        if (!isNewBill) {
            formView.showTipNotification(BillUnifyKDStringHelper.changeRepeat((String)BillTypeEnum.SUPPLEMENTBILL.getBillName()));
            return;
        }
        if (dynamicObject.getBoolean("ischange")) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d8\u66f4\u5355\u4e0d\u5141\u8bb8\u591a\u6b21\u53d8\u66f4\uff0c\u8bf7\u52ff\u591a\u6b21\u64cd\u4f5c\u3002", (String)"SupSignChangeService_4", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            return;
        }
        String billStatus = dynamicObject.getString("billstatus");
        if ("C".equals(billStatus)) {
            long cPersonId;
            BillShowParameter showParameter = new BillShowParameter();
            String applytype = dynamicObject.getString("applytyperadio");
            long personId = dynamicObject.getLong("personid.id");
            if (personId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u8003\u52e4\u4eba\u7684\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"SupSignChangeService_5", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            }
            Long currentPersonId = BillUnifyService.getUserId();
            long l = cPersonId = currentPersonId == null ? 0L : currentPersonId;
            if (personId == cPersonId && HRStringUtils.equals((String)applytype, (String)BillApplyTypeEnum.SELF.getCode())) {
                showParameter.setFormId("wtpm_supsignselfchange");
            } else {
                showParameter.setFormId("wtpm_supsignpcchange");
            }
            showParameter.setStatus(OperationStatus.ADDNEW);
            HashMap map = Maps.newHashMapWithExpectedSize((int)8);
            DynamicObject attFileBo = dynamicObject.getDynamicObject("attfile");
            DynamicObject attFilebase = dynamicObject.getDynamicObject("attfilebasef7");
            long attFileBoId = attFileBo != null ? (Long)attFileBo.getPkValue() : 0L;
            long attFileId = attFilebase != null ? (Long)attFilebase.getPkValue() : 0L;
            DynamicObject org = dynamicObject.getDynamicObject("org");
            long orgId = 0L;
            if (org != null) {
                orgId = (Long)org.getPkValue();
            }
            map.put("personid", personId);
            map.put("attfile", attFileBoId);
            map.put("attfilebasef7", attFileId);
            map.put("org", orgId);
            map.put("iscancel", dynamicObject.getBoolean("iscancel"));
            map.put("parent", dynamicObject.getPkValue());
            map.put("applytyperadio", applytype);
            if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"billstyle")) {
                map.put("billstyle", dynamicObject.get("billstyle"));
            }
            map.put("parent", dynamicObject.getPkValue());
            DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection("entryentity");
            map.put("entryentity", entryColl);
            showParameter.setCustomParam("SUP_CHANGE_DATA", (Object)map);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (closeCallBackPlugin != null) {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)closeCallBackPlugin, "sup_change_close_callback"));
            }
            showParameter.setCustomParam("billopenfrom", formView.getFormShowParameter().getCustomParam("billopenfrom"));
            formView.showForm((FormShowParameter)showParameter);
        } else {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u3002", (String)"SupSignChangeService_6", (String)"wtc-wtpm-business", (Object[])new Object[0]));
        }
    }

    public String getEntity(IFormView formView) {
        String entityId = formView.getEntityId();
        if (formView instanceof ListView) {
            entityId = ((ListView)formView).getEntityTypeId();
        }
        if (ENTITY_QUERYCONF_MAP.containsKey(entityId)) {
            entityId = ENTITY_QUERYCONF_MAP.get(entityId);
        }
        return entityId;
    }

    public String getEntity(String pageName) {
        if (HRStringUtils.isEmpty((String)pageName)) {
            return "";
        }
        String entityName = ENTITY_QUERYCONF_MAP.get(pageName);
        entityName = HRStringUtils.isBlank((CharSequence)entityName) ? "" : entityName;
        return entityName;
    }

    public String billName() {
        return ResManager.loadKDString((String)"\u539f\u5355\u4fe1\u606f", (String)"SupSignChangeService_7", (String)"wtc-wtpm-business", (Object[])new Object[0]);
    }

    public String billName(int index) {
        return ResManager.loadKDString((String)"\u7b2c{0}\u6b21\u53d8\u66f4", (String)"SupSignChangeService_8", (String)"wtc-wtpm-business", (Object[])new Object[]{index});
    }

    public void launchList(HyperLinkClickArgs args, IFormView formView) {
        if (formView == null || args == null) {
            return;
        }
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = clickEvent.getFieldName();
        BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object primaryKeyValue = billListHyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
        if (fieldName.equals("barcode")) {
            String formId;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(SupSignChangeService.getInstance().getEntity(formView));
            DynamicObject dynamicObject = serviceHelper.queryOne(primaryKeyValue);
            args.setCancel(true);
            if (dynamicObject == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"SupSignChangeService_24", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            }
            Long parentId = dynamicObject.getLong("parent");
            ArrayList<Long> list = new ArrayList<Long>();
            list.add((Long)dynamicObject.getPkValue());
            this.getIdList(list, parentId, formView);
            ListShowParameter lsp = new ListShowParameter();
            ListFilterParameter fParameter = new ListFilterParameter();
            QFilter filter = new QFilter("id", "in", list);
            fParameter.setFilter(filter);
            lsp.setListFilterParameter(fParameter);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            if ("0".equals(dynamicObject.getString("applytyperadio"))) {
                formId = "wtpm_supsignselfchange";
            } else {
                formId = "wtpm_supsignpcchange";
                ListView listView = (ListView)formView;
                if (HRStringUtils.equals((String)"wtpm_supsignself", (String)listView.getBillFormId())) {
                    lsp.setCustomParam("wtcbill_hasright", (Object)"1");
                }
            }
            lsp.setBillFormId(formId);
            OpenStyle openStyle = lsp.getOpenStyle();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("1050px");
            styleCss.setHeight("400px");
            openStyle.setInlineStyleCss(styleCss);
            lsp.setHasRight(true);
            lsp.setCaption(ResManager.loadKDString((String)"\u8865\u7b7e\u53d8\u66f4\u5386\u53f2", (String)"SupSignChangeService_23", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            formView.showForm((FormShowParameter)lsp);
        }
    }

    private void getIdList(List<Long> list, Long parentId, IFormView formView) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(SupSignChangeService.getInstance().getEntity(formView));
        DynamicObject parentDynamicObject = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        if (parentDynamicObject == null) {
            return;
        }
        boolean isChange = parentDynamicObject.getBoolean("ischange");
        list.add(parentId);
        if (isChange) {
            Long id = parentDynamicObject.getLong("parent");
            this.getIdList(list, id, formView);
        }
    }

    public void changeEffectEvent(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList isCancelDyList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            if (!dataEntity.getBoolean("iscancel")) continue;
            isCancelDyList.add(dataEntity);
        }
        DynamicObject[] afterFilter = isCancelDyList.toArray(new DynamicObject[0]);
        this.handleSignCardByChangeData(afterFilter);
        if (SignCardBatchService.isCalcCountBySignCard()) {
            Log.info("changeEffectEvent isCalcCountBySignCard is ture");
            SupQuotaPoolTaskService.dispatchUpdateQuotaPoolTask(afterFilter, "out_effective", SignCardBillTypeEnum.OTHER_BILL, true, false);
        } else {
            Log.info("changeEffectEvent isCalcCountBySignCard is false");
            SupQuotaPoolTaskService.dispatchUpdateQuotaPoolTask(afterFilter, "audit", SignCardBillTypeEnum.OTHER_BILL, true, false);
        }
    }

    private void handleSignCardByChangeData(DynamicObject[] dataEntities) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_supsignpc");
        Set originalIds = Arrays.stream(dataEntities).map(dy -> dy.getLong("originalid")).collect(Collectors.toSet());
        DynamicObject[] original = serviceHelper.query("entryentity.id", new QFilter[]{new QFilter("id", "in", originalIds)});
        if (original == null || original.length == 0) {
            Log.info("handleSignCardByChangeData_change empty original");
            return;
        }
        HashSet<Long> signCardIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : original) {
            DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity");
            if (WTCCollections.isEmpty((Collection)coll)) continue;
            for (DynamicObject entry : coll) {
                signCardIds.add(entry.getLong("id"));
            }
        }
        HRBaseServiceHelper signCardService = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] signCardDyArr = signCardService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", signCardIds)});
        if (signCardDyArr == null || signCardDyArr.length == 0) {
            Log.info("handleSignCardByChangeData_change empty");
            return;
        }
        for (DynamicObject signCardByChangeDatum : signCardDyArr) {
            signCardByChangeDatum.set("status", (Object)"0");
        }
        Log.info("handleSignCardByChangeData_change.size = {}", (Object)signCardDyArr.length);
        signCardService.update(signCardDyArr);
    }

    public void beforeDoOperationOfChange(BeforeDoOperationEventArgs args, IFormView formView) {
        HashSet ps = new HashSet();
        HashSet longs = new HashSet();
        ListSelectedRowCollection listSelectedDatas = args.getListSelectedData();
        listSelectedDatas.forEach(row -> {
            long id = (Long)row.getPrimaryKeyValue();
            longs.add(id);
            ps.add(row);
        });
        if (longs.size() != 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5355\u636e\u53d8\u66f4\u3002", (String)"SupSignChangeService_10", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListSelectedRow row2 = (ListSelectedRow)ps.iterator().next();
        long id = (Long)row2.getPrimaryKeyValue();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getEntity(formView));
        DynamicObject dynamicObject = helper.queryOne((Object)id);
        if (dynamicObject == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"SupSignChangeService_11", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String billStatus = dynamicObject.getString("billstatus");
        if (!HRStringUtils.equals((String)"C", (String)billStatus)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u3002", (String)"SupSignChangeService_12", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (dynamicObject.getBoolean("ischange")) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d8\u66f4\u5355\u4e0d\u5141\u8bb8\u591a\u6b21\u53d8\u66f4\uff0c\u8bf7\u52ff\u591a\u6b21\u64cd\u4f5c\u3002", (String)"SupSignChangeService_13", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListView listView = (ListView)formView;
        if (HRStringUtils.equals((String)"wtpm_supsignpc", (String)this.getEntity((IFormView)listView)) && BillUnifyService.verifyAttFileContainsCurrentUser((DynamicObject[])new DynamicObject[]{dynamicObject})) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5728\u4e3a\u4ed6\u4eba\u7533\u8bf7\u9875\u9762\u53d8\u66f4\u672c\u4eba\u7533\u8bf7\u7684\u5355\u636e\u3002", (String)"SupSignChangeService_14", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (HRStringUtils.equals((String)"wtpm_supsignself", (String)this.getEntity((IFormView)listView)) && dynamicObject.getBoolean("applytyperadio")) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5728\u672c\u4eba\u7533\u8bf7\u9875\u9762\u53d8\u66f4\u4ed6\u4eba\u4e3a\u6211\u7533\u8bf7\u7684\u5355\u636e\u3002", (String)"SupSignChangeService_15", (String)"wtc-wtpm-business", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void openMobileChangeView(IFormView view, boolean self) {
        HRBaseServiceHelper supTypeDao = new HRBaseServiceHelper("wtpm_supsignpc");
        long id = view.getModel().getDataEntity().getLong("id");
        QFilter enable = new QFilter("id", "=", (Object)id);
        DynamicObject query = supTypeDao.loadDynamicObject(enable);
        if (query == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u52a0\u73ed\u7533\u8bf7\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"SupSignChangeService_16", (String)"wtc-wtpm-business", (Object[])new Object[0]));
        } else if ("F".equals(query.getString("billstatus"))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u8865\u7b7e\u7533\u8bf7\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u5df2\u88ab\u5e9f\u5f03\u3002", (String)"SupSignChangeService_17", (String)"wtc-wtpm-business", (Object[])new Object[0]));
        } else if ("C".equals(query.getString("billstatus"))) {
            HashMap<String, String> param = new HashMap<String, String>(16);
            param.put("id", String.valueOf(id));
            String openFormId = self ? "wtpm_supsignselfch_m" : "wtpm_supsignpcchan_m";
            BillContainerService.getInstance().openChangePage(view, openFormId, param);
        }
    }

    public void releaseMutexIfIsCurrentUser(Long objectId, String entityType) {
        if (HRStringUtils.equals((String)"wtpm_supsignpcchan_tempm", (String)entityType) || HRStringUtils.equals((String)"wtpm_supsignpcchan_m", (String)entityType)) {
            entityType = "wtpm_supsignpcchange";
        } else if (HRStringUtils.equals((String)"wtpm_supsignselfch_tempm", (String)entityType) || HRStringUtils.equals((String)"wtpm_supsignselfch_m", (String)entityType)) {
            entityType = "wtpm_supsignselfchange";
        }
        if (this.currentUserHasMutex(objectId, entityType)) {
            WTCMutexHelper.release((String)entityType, (String)OPERATE_KEY, (String)String.valueOf(objectId));
        }
    }

    private boolean currentUserHasMutex(Long objectId, String EntityType) {
        if (objectId == null) {
            return false;
        }
        QFilter operateKeyFilter = new QFilter(MUTEX_OPERATE_KEY, "=", (Object)OPERATE_KEY);
        QFilter entityKeyFilter = new QFilter(MUTEX_ENTITY_ID, "=", (Object)EntityType);
        QFilter objectIdFilter = new QFilter(MUTEX_PK_ID, "=", (Object)String.valueOf(objectId));
        QFilter userFilter = new QFilter(MUTEX_DATA_LOCK_USER, "=", (Object)RequestContext.get().getCurrUserId());
        HRBaseServiceHelper dataLockHelper = new HRBaseServiceHelper("bos_datalock");
        DynamicObject[] dynamicObjects = dataLockHelper.query("id", new QFilter[]{objectIdFilter, operateKeyFilter, entityKeyFilter, userFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }

    public void setChangeTitleInfo(IFormView view) {
        Label otTypeChangeTips;
        Label billTitle = (Label)view.getControl("billtitle");
        if (billTitle != null) {
            DynamicObject otBill = view.getModel().getDataEntity();
            billTitle.setText(ResManager.loadKDString((String)"%s\u7684\u8865\u7b7e\u53d8\u66f4\u5355", (String)"SupSignChangeService_19", (String)"wtc-wtpm-business", (Object[])new Object[]{otBill.getString("personid.name")}));
        }
        if ((otTypeChangeTips = (Label)view.getControl("optypechangetips")) != null) {
            String text = ResManager.loadKDString((String)"\u5b9e\u9645\u6ca1\u6709\u8865\u7b7e\uff0c\u65e0\u9700\u7ef4\u62a4\u8865\u7b7e\u4fe1\u606f\uff0c\u539f\u8865\u7b7e\u5355\u505a\u5931\u6548\u5904\u7406", (String)"SupSignChangeService_21", (String)"wtc-wtpm-business", (Object[])new Object[0]);
            otTypeChangeTips.setText(text);
        }
    }

    public String supName(String name, String applyTypeName, String applyOrChangeName) {
        return ResManager.loadKDString((String)"%1$s\u7684%2$s\u8865\u7b7e%3$s\u5355", (String)"SupSignChangeService_22", (String)"wtc-wtpm-business", (Object[])new Object[]{name, applyTypeName, applyOrChangeName});
    }

    public String changeToDetail(IFormView view) {
        String curFormId = view.getFormShowParameter().getFormId();
        if (HRStringUtils.equals((String)"wtpm_supsignpcchan_m", (String)curFormId)) {
            return "wtpm_supsignpcchan_tempm";
        }
        return "wtpm_supsignselfch_tempm";
    }

    public String detailToChange(IFormView view) {
        String curFormId = view.getFormShowParameter().getFormId();
        if (HRStringUtils.equals((String)"wtpm_supsignpcchan_tempm", (String)curFormId)) {
            return "wtpm_supsignpcchan_m";
        }
        return "wtpm_supsignselfch_m";
    }

    public void setChangeDetailTitleInfo(IFormView view) {
        Label billHeader = (Label)view.getControl("billheader");
        if (billHeader != null) {
            DynamicObject otBill = view.getModel().getDataEntity();
            billHeader.setText(ResManager.loadKDString((String)"%s\u7684\u8865\u7b7e\u53d8\u66f4\u5355", (String)"SupSignChangeService_20", (String)"wtc-wtpm-business", (Object[])new Object[]{otBill.getString("personid.name")}));
        }
    }

    public DynamicObject copyFieldByParent(long parentId, IDataModel model, String openChangeEntity) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(openChangeEntity);
        DynamicObject oldDy = helper.loadSingle((Object)parentId);
        if (oldDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"SupSignChangeService_25", (String)"wtc-wtpm-business", (Object[])new Object[0]));
        }
        DynamicObject dataEntity = model.getDataEntity(true);
        HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)dataEntity, (Set)Sets.newHashSet((Object[])new String[]{"id", "billno", "billstatus", "auditstatus", "creator", "creator_id", "modifier", "modifier_id", "auditor", "auditor_id", "auditdate", "createtime", "modifytime", "isexistsworkflow", "submitter", "submitdate", "applytyperadio", "iscancel", "parent", "isnewbill", "ischange", "originalid"}));
        dataEntity.set("ischange", (Object)true);
        dataEntity.set("iscancel", (Object)true);
        dataEntity.set("isnewbill", (Object)true);
        model.setValue("parent", (Object)parentId);
        BillApplyTypeEnum billApplyTypeEnum = null;
        if ("wtpm_supsignpcchange".equals(openChangeEntity)) {
            billApplyTypeEnum = BillApplyTypeEnum.OTHER;
        } else if ("wtpm_supsignselfchange".equals(openChangeEntity)) {
            billApplyTypeEnum = BillApplyTypeEnum.SELF;
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7533\u8bf7\u7c7b\u578b\u3002", (String)"SupSignChangeService_26", (String)"wtc-wtpm-business", (Object[])new Object[0]));
        }
        model.setValue("applytyperadio", (Object)billApplyTypeEnum.getCode());
        return model.getDataEntity(true);
    }

    static {
        ENTITY_QUERYCONF_MAP = new HashMap<String, String>(16);
        ENTITY_QUERYCONF_MAP.put("wtpm_supsignselfquery", "wtpm_supsignself");
        ENTITY_QUERYCONF_MAP.put("wtpm_supsignselfqueryconf", "wtpm_supsignself");
        ENTITY_QUERYCONF_MAP.put("wtpm_supsignpcquery", "wtpm_supsignpc");
        ENTITY_QUERYCONF_MAP.put("wtpm_supsignpcqueryconf", "wtpm_supsignpc");
    }
}

