/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.job;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtpm.business.signcard.job.AdBillTask;
import kd.wtc.wtpm.vo.suppleapply.AdDispatchTaskParam;

public class BillJobDispatchService {
    private static final Log LOG = LogFactory.getLog(BillJobDispatchService.class);

    private BillJobDispatchService() {
    }

    public static void dispatchBillTask(AdDispatchTaskParam param) {
        boolean sync = param.isSync();
        if (sync) {
            BillJobDispatchService.processTask(param);
        } else {
            BillJobDispatchService.dispatchTask(param);
        }
    }

    private static void processTask(AdDispatchTaskParam param) {
        String className = param.getClassName();
        AdBillTask bean = (AdBillTask)((Object)WTCAppContextHelper.getBean((String)className, AdBillTask.class));
        bean.executeTask(RequestContext.get(), param);
    }

    private static void dispatchTask(AdDispatchTaskParam param) {
        long taskId = ID.genLongId();
        WTCTaskRequestStd requestStd = new WTCTaskRequestStd();
        requestStd.setTaskId(taskId);
        requestStd.setVersion(String.valueOf(taskId));
        requestStd.setCategory("wtpm_billtask");
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)param), Map.class);
        requestStd.setParams(map);
        requestStd.setAppId("wtpm");
        requestStd.setTimeoutInSecond(600);
        JobInfo jobInfo = WTCDistributeTaskHelper.getMainTaskExecutorJobInfo((WTCTaskRequest)requestStd, new ArrayList());
        BillJobDispatchService.saveTask(jobInfo);
        ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        LOG.info("BillJobDispatchService.dispatchTask dispatch success,taskId:{}", (Object)taskId);
    }

    private static void saveTask(JobInfo jobInfo) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                WTCDistributeTaskHelper.saveTask((Map)jobInfo.getParams());
            }
            catch (Exception throwable) {
                tx.markRollback();
                String errorMsg = throwable.getMessage();
                LOG.warn("BillJobDispatchService.dispatchTask saveTask Exception:{}", (Object)errorMsg);
                throw new KDBizException((Throwable)throwable, new ErrorCode("", errorMsg), new Object[0]);
            }
        }
    }
}

