/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.signcard.AdCheckService;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.job.AdBillTask;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;
import kd.wtc.wtpm.vo.suppleapply.AdDispatchTaskParam;

public class SignCardOpUpdatePoolTask
extends AdBillTask {
    private static final Log LOG = LogFactory.getLog(SignCardOpUpdatePoolTask.class);

    @Override
    public void executeTask(RequestContext requestContext, AdDispatchTaskParam param) throws KDException {
        List<DynamicObject> batchBillDetailList;
        boolean calcCountBySignCard = SignCardBatchService.isCalcCountBySignCard();
        if (!calcCountBySignCard) {
            return;
        }
        Set signCardIds = param.getDataIds();
        String opType = param.getOpType();
        String opKey = "0".equals(opType) ? "out_effective" : "in_effective";
        LOG.info("SignCardValidOpUpdateSupQuotaPoolTask.execute,opType:{}", (Object)opType);
        List<DynamicObject> supSignBillList = SupSignHelper.querySupSignBillByEntryIds(signCardIds);
        ArrayList<AdCheckVo> singleBillAdCheckVoList = new ArrayList<AdCheckVo>(16);
        for (DynamicObject dataEntity : supSignBillList) {
            long billId = dataEntity.getLong("id");
            DynamicObject attFileDy = dataEntity.getDynamicObject("attfile");
            DynamicObjectCollection supSignColl = dataEntity.getDynamicObjectCollection("entryentity");
            ArrayList<DynamicObject> supSignInfoList = new ArrayList<DynamicObject>(supSignColl.size());
            for (DynamicObject supSignInfo : supSignColl) {
                long entryId = supSignInfo.getLong("id");
                if (!signCardIds.remove(entryId)) continue;
                supSignInfoList.add(supSignInfo);
            }
            singleBillAdCheckVoList.addAll(AdCheckService.genAdCheckVoList(billId, Lists.newArrayList((Object[])new DynamicObject[]{attFileDy}), supSignInfoList));
        }
        if (!CollectionUtils.isEmpty(singleBillAdCheckVoList)) {
            AdCheckService.initCalcAdCheckVoQuotaPool(singleBillAdCheckVoList, opKey, SignCardBillTypeEnum.OTHER_BILL);
            LOG.info("SignCardValidOpUpdateSupQuotaPoolTask.singleBillAdCheckVoList size:{}", (Object)singleBillAdCheckVoList.size());
        }
        if (!CollectionUtils.isEmpty((Collection)signCardIds) && !CollectionUtils.isEmpty(batchBillDetailList = SupSignHelper.queryBatchBillDetailByDetailId(signCardIds))) {
            List<AdCheckVo> batchBillAdCheckVoList = AdCheckService.genAdCheckVoList(batchBillDetailList);
            AdCheckService.initCalcAdCheckVoQuotaPool(batchBillAdCheckVoList, opKey, SignCardBillTypeEnum.SUPSIGN_BATCHBILL);
            LOG.info("SignCardValidOpUpdateSupQuotaPoolTask.batchBillAdCheckVoList size:{}", (Object)singleBillAdCheckVoList.size());
        }
    }
}

