/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.signcardapply.helper;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.signcard.SignCardHelperFactory;

public class SignCardApplyHelper {
    private SignCardApplyHelper() {
    }

    public static void deleteSignCardList(Collection<Long> billIdList) {
        QFilter qFilter = new QFilter("billid", "in", billIdList);
        SignCardApplyHelper.deleteSignCardList(qFilter);
    }

    public static void deleteSignCardList(QFilter qFilter) {
        if (qFilter == null) {
            return;
        }
        HRBaseServiceHelper listDao = SignCardHelperFactory.getHelper("wtpm_signcardlist");
        listDao.deleteByFilter(qFilter.toArray());
    }

    public static DynamicObject querySignCardListById(Long listId) {
        HRBaseServiceHelper listDao = SignCardHelperFactory.getHelper("wtpm_signcardlist");
        return listDao.loadDynamicObject(new QFilter("id", "=", (Object)listId));
    }

    public static List<DynamicObject> querySignCardList(Collection<Long> listIds) {
        HRBaseServiceHelper listDao = SignCardHelperFactory.getHelper("wtpm_signcardlist");
        return Lists.newArrayList((Object[])listDao.loadDynamicObjectArray(new QFilter("id", "in", listIds).toArray()));
    }

    public static List<DynamicObject> querySignCardListPropByBillIds(Collection<Long> billIds, String queryProp) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        HRBaseServiceHelper listDao = SignCardHelperFactory.getHelper("wtpm_signcardlist");
        return Lists.newArrayList((Object[])listDao.queryOriginalArray(queryProp, qFilter.toArray()));
    }

    public static List<DynamicObject> querySignCardListPropByBillIds(Collection<Long> billIds, Boolean isValid, String queryProp) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        if (isValid != null) {
            qFilter.and("isvalid", "=", (Object)isValid);
        }
        HRBaseServiceHelper listDao = SignCardHelperFactory.getHelper("wtpm_signcardlist");
        if (HRStringUtils.isNotEmpty((String)queryProp)) {
            return Lists.newArrayList((Object[])listDao.queryOriginalArray(queryProp, qFilter.toArray()));
        }
        return Lists.newArrayList((Object[])listDao.loadDynamicObjectArray(qFilter.toArray()));
    }

    public static List<DynamicObject> querySignCardListByBillId(Collection<Long> billIdSet, Collection<Long> attFileBoIds) {
        QFilter qFilter = new QFilter("billid", "in", billIdSet);
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        if (!CollectionUtils.isEmpty(attFileBoIds)) {
            qFilter.and("attfile", "in", attFileBoIds);
        }
        HRBaseServiceHelper listDao = SignCardHelperFactory.getHelper("wtpm_signcardlist");
        return Lists.newArrayList((Object[])listDao.loadDynamicObjectArray(qFilter.toArray()));
    }

    public static DynamicObject[] querySignCardApply(Set<Long> billIdSet) {
        QFilter qFilter = new QFilter("id", "in", billIdSet);
        HRBaseServiceHelper applyDao = SignCardHelperFactory.getHelper("wtpm_signcardapply");
        return applyDao.loadDynamicObjectArray(qFilter.toArray());
    }

    public static DynamicObject querySignCardApply(Long billId) {
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        HRBaseServiceHelper applyDao = SignCardHelperFactory.getHelper("wtpm_signcardapply");
        return applyDao.loadDynamicObject(qFilter);
    }

    public static void saveSignCardList(List<DynamicObject> listDys) {
        if (!CollectionUtils.isEmpty(listDys)) {
            HRBaseServiceHelper listDao = SignCardHelperFactory.getHelper("wtpm_signcardlist");
            listDao.save(listDys.toArray(new DynamicObject[listDys.size()]));
        }
    }

    public static void updateSignCardBill(DynamicObject billDataEntity) {
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_signcardapply");
        serviceHelper.updateDataOne(billDataEntity);
    }
}

