/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.supplyapply.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtp.enums.supple.SignCardSourceEnum;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.SignCardHelperFactory;
import kd.wtc.wtpm.constants.suppleapply.SuppleApplyConstants;
import kd.wtc.wtpm.vo.suppleapply.SupSignCount;

public class SupSignHelper {
    private SupSignHelper() {
    }

    public static DynamicObject[] queryCountSet(Collection<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtp_countset");
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static Map<Long, List<SupSignCount>> querySupSignList(Tuple<Date, Date> maxDateRangeTuple, Collection<Long> attFileBoIds, List<String> status) {
        Date zeroDate = WTCDateUtils.getBeforeDate((Date)WTCDateUtils.getZeroDate((Date)((Date)maxDateRangeTuple.item1)));
        Date dayLastDate = WTCDateUtils.getNextDate((Date)WTCDateUtils.getDayLastDate((Date)((Date)maxDateRangeTuple.item2)));
        String querySupSignFields = "entryentity.signdate signdate,entryentity.applyreason applyreason,personid attperson,attfile attfilebo,entryentity.pointtag pointtag";
        QFilter supSignFilter = new QFilter("entryentity.signdate", ">=", (Object)zeroDate);
        supSignFilter.and("entryentity.signdate", "<=", (Object)dayLastDate);
        supSignFilter.and("attfile", "in", attFileBoIds);
        supSignFilter.and("billstatus", "in", status);
        HRBaseServiceHelper adServiceHelper = new HRBaseServiceHelper("wtpm_supsignpc");
        DynamicObject[] adBills = adServiceHelper.queryOriginalArray(querySupSignFields, supSignFilter.toArray());
        List<SupSignCount> adCountList = SupSignHelper.punchCardToSupSignCount(adBills, true);
        String queryBatchFields = "supsigninfo.signdate signdate,supsigninfo.applyreason applyreason,attperson attperson,attfile attfilebo,supsigninfo.pointtag pointtag";
        QFilter supSignBatchFilter = new QFilter("supsigninfo.signdate", ">=", (Object)zeroDate);
        supSignBatchFilter.and("supsigninfo.signdate", "<=", (Object)dayLastDate);
        supSignBatchFilter.and("attfile", "in", attFileBoIds);
        supSignBatchFilter.and("billid.billstatus", "in", status);
        supSignBatchFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        HRBaseServiceHelper adBatchServiceHelper = new HRBaseServiceHelper("wtpm_supsignlist");
        DynamicObject[] adBatchBills = adBatchServiceHelper.queryOriginalArray(queryBatchFields, supSignBatchFilter.toArray());
        adCountList.addAll(SupSignHelper.punchCardToSupSignCount(adBatchBills, true));
        return adCountList.stream().collect(Collectors.groupingBy(SupSignCount::getAttFileId));
    }

    public static Map<Long, List<SupSignCount>> queryUsedBillCount(Tuple<Date, Date> maxDateRangeTuple, Set<Long> attFileIdSet, String supCountCalType) {
        Date zeroDate = WTCDateUtils.getBeforeDate((Date)WTCDateUtils.getZeroDate((Date)((Date)maxDateRangeTuple.item1)));
        Date dayLastDate = WTCDateUtils.getNextDate((Date)WTCDateUtils.getDayLastDate((Date)((Date)maxDateRangeTuple.item2)));
        if ("1".equals(supCountCalType)) {
            List<SupSignCount> onceCardCountList = SupSignHelper.getOnceCardCountList(zeroDate, dayLastDate, attFileIdSet);
            List<SupSignCount> multiCardCountList = SupSignHelper.getMultiCardCountList(zeroDate, dayLastDate, attFileIdSet);
            onceCardCountList.addAll(multiCardCountList);
            return onceCardCountList.stream().collect(Collectors.groupingBy(SupSignCount::getAttFileId));
        }
        QFilter signCardFilter = new QFilter("signpoint", ">=", (Object)zeroDate);
        signCardFilter.and("signpoint", "<=", (Object)dayLastDate);
        signCardFilter.and("attfilebo", "in", attFileIdSet);
        signCardFilter.and("status", "=", (Object)"1");
        signCardFilter.and("source", "=", (Object)SignCardSourceEnum.SOURCE_1010_S.getId());
        String querySignCardFields = "signpoint signdate,applyreason,attperson,attfilebo,pointtag";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray(querySignCardFields, signCardFilter.toArray());
        List<SupSignCount> supSignCountList = SupSignHelper.punchCardToSupSignCount(dynamicObjects, true);
        return supSignCountList.stream().collect(Collectors.groupingBy(SupSignCount::getAttFileId));
    }

    private static List<SupSignCount> getOnceCardCountList(Date beginDate, Date endDate, Set<Long> attFileIdSet) {
        QFilter onceCardFilter = new QFilter("shiftdate", ">=", (Object)beginDate);
        onceCardFilter.and("shiftdate", "<=", (Object)endDate);
        onceCardFilter.and("attfilebo", "in", attFileIdSet);
        onceCardFilter.and("source", "=", (Object)SignCardSourceEnum.SOURCE_1010_S.getId());
        String queryOnceCardFields = "shiftdate signpoint,applyreason,attperson,attfilebo";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_oncecard");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray(queryOnceCardFields, onceCardFilter.toArray());
        return SupSignHelper.punchCardToSupSignCount(dynamicObjects, false);
    }

    private static List<SupSignCount> getMultiCardCountList(Date beginDate, Date endDate, Set<Long> attFileIdSet) {
        QFilter multiCardFilter = new QFilter("shiftdate", ">=", (Object)beginDate);
        multiCardFilter.and("shiftdate", "<=", (Object)endDate);
        multiCardFilter.and("attfilebo", "in", attFileIdSet);
        multiCardFilter.and("entryentity.source", "=", (Object)SignCardSourceEnum.SOURCE_1010_S.getId());
        String queryMultiCardFields = "shiftdate signpoint,entryentity.applyreason applyreason,attperson,attfilebo";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_multicard");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray(queryMultiCardFields, multiCardFilter.toArray());
        return SupSignHelper.punchCardToSupSignCount(dynamicObjects, false);
    }

    private static List<SupSignCount> punchCardToSupSignCount(DynamicObject[] dynamicObjects, boolean isSignCard) {
        ArrayList<SupSignCount> multiCardCountList = new ArrayList<SupSignCount>(dynamicObjects.length);
        for (DynamicObject multiCardDy : dynamicObjects) {
            SupSignCount multiCardCount = new SupSignCount();
            multiCardCount.setAttFileId(Long.valueOf(multiCardDy.getLong("attfilebo")));
            multiCardCount.setApplyReason(Long.valueOf(multiCardDy.getLong("applyreason")));
            if (isSignCard) {
                multiCardCount.setSignDate(SignCardCommonService.getShiftBelongDate(multiCardDy));
            } else {
                multiCardCount.setSignDate(WTCDateUtils.getZeroDate((Date)multiCardDy.getDate("signpoint")));
            }
            multiCardCount.setCount(Integer.valueOf(1));
            multiCardCountList.add(multiCardCount);
        }
        return multiCardCountList;
    }

    public static DynamicObject[] queryAttPolicyById(Collection<Long> policyIdList) {
        if (CollectionUtils.isEmpty(policyIdList)) {
            return new DynamicObject[0];
        }
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtbd_attpolicy");
        return serviceHelper.query("content", new QFilter("id", "in", policyIdList).toArray());
    }

    public static List<DynamicObject> queryTimeSet(Collection<Long> timeSetIdList) {
        if (CollectionUtils.isEmpty(timeSetIdList)) {
            return new ArrayList<DynamicObject>(0);
        }
        QFilter qFilter = new QFilter("id", "in", timeSetIdList);
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtp_suppletimeset");
        Object[] timeSets = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        if (timeSets == null || timeSets.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        return Lists.newArrayList((Object[])timeSets);
    }

    public static List<DynamicObject> queryAttFile(Set<Long> attFileBoIdSet) {
        return AttFileQueryHelper.queryAttFileByIds((String)SuppleApplyConstants.QUERY_ATTFILE_FIELD, (List)Lists.newArrayList(attFileBoIdSet));
    }

    public static List<DynamicObject> queryAttFile(AttFileQueryParam attFileQueryParam) {
        AttFileQueryServiceImpl queryService = AttFileQueryServiceImpl.getInstance();
        return queryService.queryAttFiles(attFileQueryParam);
    }

    public static List<DynamicObject> queryAttFileByIds(Collection<Long> attFileBoIds) {
        AttFileQueryServiceImpl queryService = AttFileQueryServiceImpl.getInstance();
        return queryService.queryAttFileByIds(HRAuthUtil.ATT_FILE_SHARD_TASK_PROPERTY, (List)Lists.newArrayList(attFileBoIds));
    }

    public static void saveSupSignDetail(List<DynamicObject> supSignDetailList) {
        if (!CollectionUtils.isEmpty(supSignDetailList)) {
            HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignlist");
            serviceHelper.save(supSignDetailList.toArray(new DynamicObject[supSignDetailList.size()]));
        }
    }

    public static Object[] savePunchCard(List<DynamicObject> punchCardList) {
        if (CollectionUtils.isEmpty(punchCardList)) {
            return new Object[0];
        }
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpd_signcard");
        return serviceHelper.save(punchCardList.toArray(new DynamicObject[punchCardList.size()]));
    }

    public static void deleteSupSignDetail(Collection<Long> billIdList) {
        QFilter qFilter = new QFilter("billid", "in", billIdList);
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignlist");
        serviceHelper.deleteByFilter(qFilter.toArray());
    }

    public static Map<Long, List<DynamicObject>> queryCardHis(Set<Long> attFileBoIdSet) {
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setFileBoIdSet(attFileBoIdSet);
        attFileScheduleQueryParam.setLoad(Boolean.FALSE);
        return AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.CARD, attFileScheduleQueryParam);
    }

    public static List<DynamicObject> getTimeZone(Collection<Long> timeZoneIds) {
        if (CollectionUtils.isEmpty(timeZoneIds)) {
            return new ArrayList<DynamicObject>(0);
        }
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("inte_timezone");
        QFilter qFilter = new QFilter("id", "in", timeZoneIds);
        return Lists.newArrayList((Object[])serviceHelper.loadDynamicObjectArray(qFilter.toArray()));
    }

    public static void updateSupSignBatchBill(DynamicObject billEntity) {
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignbatch");
        serviceHelper.updateDataOne(billEntity);
    }

    public static void updateSupSignListDataIsValid(String entityNumber, List<Long> pkBillIdList, boolean isValid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
        String alias = dataEntityType.getAlias();
        DBRoute dbRoute = DBRoute.of((String)dataEntityType.getDBRouteKey());
        String isValidStr = isValid ? "1" : "0";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update ", new Object[0]);
        sqlBuilder.append(alias, new Object[0]);
        sqlBuilder.append(" set fisvalid = ? where ", new Object[]{isValidStr});
        sqlBuilder.appendIn("fbillid", pkBillIdList.toArray());
        DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
    }

    public static DynamicObject querySupSignBillById(long billId) {
        DynamicObject[] dynamicObjects = SupSignHelper.querySupSignBillById(Lists.newArrayList((Object[])new Long[]{billId}));
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    public static DynamicObject[] querySupSignBillById(Collection<Long> billIds) {
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignpc");
        QFilter qFilter = new QFilter("id", "in", billIds);
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static DynamicObject queryBatchBillById(Long billId) {
        DynamicObject[] dynamicObjects = SupSignHelper.queryBatchBillById(Lists.newArrayList((Object[])new Long[]{billId}));
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    public static DynamicObject[] queryBatchBillById(Collection<Long> billIds) {
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignbatch");
        QFilter qFilter = billIds.size() == 1 ? new QFilter("id", "=", billIds.toArray()[0]) : new QFilter("id", "in", billIds);
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static List<DynamicObject> queryBatchBillDetailByBillId(long billId) {
        return SupSignHelper.queryBatchBillDetailByBillId(Lists.newArrayList((Object[])new Long[]{billId}));
    }

    public static List<DynamicObject> queryBatchBillDetailByBillId(Collection<Long> billIds) {
        return SupSignHelper.queryBatchBillDetailByBillId(billIds, null, null);
    }

    public static List<DynamicObject> queryBatchBillDetailByBillId(Collection<Long> billIds, Boolean isValid) {
        return SupSignHelper.queryBatchBillDetailByBillId(billIds, isValid, null);
    }

    public static List<DynamicObject> queryBatchBillDetailByBillId(Collection<Long> billIds, Boolean isValid, String queryProp) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        if (isValid != null) {
            qFilter.and("isvalid", "=", (Object)isValid);
        }
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignlist");
        if (HRStringUtils.isNotEmpty((String)queryProp)) {
            return Lists.newArrayList((Object[])serviceHelper.queryOriginalArray(queryProp, qFilter.toArray()));
        }
        return Lists.newArrayList((Object[])serviceHelper.loadDynamicObjectArray(qFilter.toArray()));
    }

    public static List<DynamicObject> queryBatchBillDetailByBillId(Collection<Long> billIds, Boolean isValid, String queryProp, String orderBy) {
        return SupSignHelper.queryBatchBillDetailByBillId(billIds, isValid, queryProp, orderBy, null);
    }

    public static List<DynamicObject> queryBatchBillDetailByBillId(Collection<Long> billIds, Boolean isValid, String queryProp, String orderBy, QFilter cusFilter) {
        return SupSignHelper.queryBatchBillDetailByBillId(billIds, isValid, queryProp, orderBy, cusFilter, -1);
    }

    public static List<DynamicObject> queryBatchBillDetailByBillId(Collection<Long> billIds, Boolean isValid, String queryProp, String orderBy, QFilter cusFilter, int limit) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        if (isValid != null) {
            qFilter.and("isvalid", "=", (Object)isValid);
        }
        if (cusFilter != null) {
            qFilter.and(cusFilter);
        }
        String entityNumber = "wtpm_supsignlist";
        if (HRStringUtils.isNotEmpty((String)queryProp)) {
            DynamicObjectCollection coll = limit > 0 ? ORM.create().query(entityNumber, queryProp, qFilter.toArray(), orderBy, limit) : ORM.create().query(entityNumber, queryProp, qFilter.toArray(), orderBy);
            return Lists.newArrayList((Iterable)coll);
        }
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignlist");
        return Lists.newArrayList((Object[])serviceHelper.loadDynamicObjectArray(qFilter.toArray()));
    }

    public static List<DynamicObject> queryBatchBillDetailCheckPass(Collection<Long> billIds) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        qFilter.and("ischeckpass", "=", (Object)Boolean.TRUE);
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignlist");
        return Lists.newArrayList((Object[])serviceHelper.loadDynamicObjectArray(qFilter.toArray()));
    }

    public static DynamicObject queryBatchBillDetailByDetailId(Long billDetailId) {
        QFilter qFilter = new QFilter("id", "=", (Object)billDetailId);
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignlist");
        return serviceHelper.queryOne(SuppleApplyConstants.SUP_SIGN_DETAIL_QUERYFIELD, qFilter);
    }

    public static List<DynamicObject> queryBatchBillDetailByDetailId(Collection<Long> billDetailIds) {
        QFilter qFilter = new QFilter("id", "in", billDetailIds);
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignlist");
        return Lists.newArrayList((Object[])serviceHelper.loadDynamicObjectArray(qFilter.toArray())).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<DynamicObject> querySupSignBillByEntryIds(Set<Long> billEntryIds) {
        HRBaseServiceHelper serviceHelper = SignCardHelperFactory.getHelper("wtpm_supsignpc");
        QFilter qFilter = new QFilter("entryentity.id", "in", billEntryIds);
        return Lists.newArrayList((Object[])serviceHelper.loadDynamicObjectArray(qFilter.toArray()));
    }

    public static DynamicObject[] querySignCardByIds(Date startDate, Date endDate, Set<Long> attPersonIds) {
        QFilter qFilter = new QFilter("attperson", "in", attPersonIds);
        qFilter.and("signpoint", ">=", (Object)WTCDateUtils.getZeroDate((Date)startDate));
        qFilter.and("signpoint", "<=", (Object)WTCDateUtils.getDayLastDate((Date)endDate));
        qFilter.and("source", "=", (Object)SignCardSourceEnum.SOURCE_1010_S.getId());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpd_signcard");
        return helper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static int queryBatchBillDetailCountByBillId(Collection<Long> billIds, Boolean isValid, QFilter cusFilter) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        if (isValid != null) {
            qFilter.and("isvalid", "=", (Object)isValid);
        }
        if (cusFilter != null) {
            qFilter.and(cusFilter);
        }
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtpm_supsignlist");
        return serviceHelper.count("wtpm_supsignlist", qFilter.toArray());
    }
}

