/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.supplyapply.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.caltask.common.billapply.BillApplyTaskDetailStatus;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;
import kd.wtc.wtpm.vo.suppleapply.BillTaskResultVo;

public class SupSignTaskHelper {
    private static final String TASKDETAIL_QUERYPROP = "attperson,attfile,matchstatus,total,success,fail";
    private static final String TASKLOG_QUERYPROP = "id,billno,optype,billid,org";

    private SupSignTaskHelper() {
    }

    public static BillTaskResultVo getBillTaskResult(long taskId, String entityId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject[] taskDetailArr = serviceHelper.queryOriginalArray(TASKDETAIL_QUERYPROP, qFilter.toArray());
        return SupSignTaskHelper.getBillTaskResult(taskDetailArr);
    }

    private static BillTaskResultVo getBillTaskResult(DynamicObject[] taskDetailArr) {
        BillTaskResultVo billTaskResultVo = new BillTaskResultVo();
        int totalAttFile = taskDetailArr.length;
        if (totalAttFile == 0) {
            return billTaskResultVo;
        }
        int totalCard = 0;
        int successAttFile = 0;
        int successCard = 0;
        int partSuccessAttFile = 0;
        int partSuccessCard = 0;
        int partFailCard = 0;
        int allFailAttFile = 0;
        int allFailCard = 0;
        int notRunAttFile = 0;
        int notRunCard = 0;
        for (DynamicObject taskDetail : taskDetailArr) {
            int total = taskDetail.getInt("total");
            int success = taskDetail.getInt("success");
            int fail = taskDetail.getInt("fail");
            String matchStatus = taskDetail.getString("matchstatus");
            totalCard += total;
            if (BillApplyTaskDetailStatus.SUCCESS.code.equals(matchStatus)) {
                successCard += total;
                ++successAttFile;
                continue;
            }
            if (BillApplyTaskDetailStatus.NOTRUN.code.equals(matchStatus)) {
                notRunCard += total;
                ++notRunAttFile;
                continue;
            }
            if (fail == total) {
                allFailCard += total;
                ++allFailAttFile;
                continue;
            }
            partSuccessCard += success;
            partFailCard += fail;
            ++partSuccessAttFile;
        }
        billTaskResultVo.setTotalAttFile(Integer.valueOf(totalAttFile));
        billTaskResultVo.setTotalCard(Integer.valueOf(totalCard));
        billTaskResultVo.setSuccessAttFile(Integer.valueOf(successAttFile));
        billTaskResultVo.setSuccessCard(Integer.valueOf(successCard));
        billTaskResultVo.setPartSuccessAttFile(Integer.valueOf(partSuccessAttFile));
        billTaskResultVo.setPartSuccessCard(Integer.valueOf(partSuccessCard));
        billTaskResultVo.setPartFailCard(Integer.valueOf(partFailCard));
        billTaskResultVo.setAllFailAttFile(Integer.valueOf(allFailAttFile));
        billTaskResultVo.setAllFailCard(Integer.valueOf(allFailCard));
        billTaskResultVo.setNotRunAttFile(Integer.valueOf(notRunAttFile));
        billTaskResultVo.setNotRunCard(Integer.valueOf(notRunCard));
        return billTaskResultVo;
    }

    public static DynamicObject getTaskLogByTaskId(long taskId, String entityId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(entityId);
        QFilter qFilter = new QFilter("task", "=", (Object)taskId);
        return baseServiceHelper.queryOriginalOne(TASKLOG_QUERYPROP, qFilter.toArray());
    }

    public static DynamicObject queryTaskById(long taskId, String entityId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(entityId);
        QFilter qFilter = new QFilter("id", "=", (Object)taskId);
        return baseServiceHelper.queryOriginalOne("matchstatus,taskstatus", qFilter.toArray());
    }

    public static void showTaskResultForm(IFormView view, IFormView parentView, long taskId, String taskCategoty) {
        String entityId = BillApplyTaskFactoryService.getTaskEntityId(taskCategoty);
        DynamicObject taskDy = SupSignTaskHelper.queryTaskById(taskId, entityId);
        if (taskDy != null && !"RUNNING".equals(taskDy.getString("matchstatus"))) {
            FormShowParameter formShowParameter = new FormShowParameter();
            String formId = "wtpm_supsigntaskresult";
            if ("wtpm_signcard".equals(taskCategoty)) {
                formId = "wtpm_signcardtaskresul";
            }
            formShowParameter.setFormId(formId);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("taskid", (Object)taskId);
            formShowParameter.setCustomParam("taskCategory", (Object)taskCategoty);
            if (parentView != null) {
                formShowParameter.setCustomParam("parentViewPageId", (Object)parentView.getPageId());
            }
            view.showForm(formShowParameter);
        }
    }

    public static DynamicObject getTaskLogByBillIdInProcess(long billId, String entityId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(entityId);
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        qFilter.and("task.matchstatus", "=", (Object)"RUNNING");
        return baseServiceHelper.queryOne(TASKLOG_QUERYPROP, qFilter.toArray());
    }
}

