/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.supplyapply.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineHelper;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineService;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineInParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.AdCheckService;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHisHelper;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.enums.MonthEnum;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.enums.TimeRangeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;
import kd.wtc.wtpm.vo.suppleapply.SupQuotaPoolVo;
import kd.wtc.wtpm.vo.suppleapply.SupSignCount;

public class SupSignService {
    private static final Log LOG = LogFactory.getLog(SupSignService.class);

    private SupSignService() {
    }

    public static List<DynamicObject> getAttFilePlan(long attFileBoId) {
        if (attFileBoId == 0L) {
            return Collections.emptyList();
        }
        Map<Long, List<DynamicObject>> attFilePLanMap = SupSignHisHelper.getAttFilePlanHis(Lists.newArrayList((Object[])new Long[]{attFileBoId}));
        return attFilePLanMap.get(attFileBoId);
    }

    public static Optional<DynamicObject> getAttFilePlan(long attFileBoId, Date signDate) {
        if (attFileBoId == 0L) {
            return Optional.empty();
        }
        Map<Long, List<DynamicObject>> attFilePLanMap = SupSignHisHelper.getAttFilePlanHis(Lists.newArrayList((Object[])new Long[]{attFileBoId}), signDate, signDate);
        List<DynamicObject> planList = attFilePLanMap.get(attFileBoId);
        if (CollectionUtils.isEmpty(planList)) {
            return Optional.empty();
        }
        return Optional.of(planList.get(0));
    }

    public static Map<Long, List<DynamicObject>> getPlan(long attFileBoId) {
        if (attFileBoId == 0L) {
            return Collections.emptyMap();
        }
        List<DynamicObject> attFilePanList = SupSignService.getAttFilePlan(attFileBoId);
        if (!CollectionUtils.isEmpty(attFilePanList)) {
            HashMap dateList = Maps.newHashMapWithExpectedSize((int)attFilePanList.size());
            for (DynamicObject attFileDy : attFilePanList) {
                dateList.put(attFileDy.getLong("ad.id"), new Tuple((Object)attFileDy.getDate("startdate"), (Object)attFileDy.getDate("enddate")));
            }
            return SupSignHisHelper.getPlanHis(dateList);
        }
        return Collections.emptyMap();
    }

    public static Optional<DynamicObject> getPlan(long attFileBoId, Date signDate) {
        if (attFileBoId == 0L) {
            return Optional.empty();
        }
        Optional<DynamicObject> attFilePanOptional = SupSignService.getAttFilePlan(attFileBoId, signDate);
        if (!attFilePanOptional.isPresent()) {
            return Optional.empty();
        }
        long adPlanId = SignCardCommonService.getObjectId(attFilePanOptional.get(), "ad");
        Map<Long, List<DynamicObject>> attFilePLanMap = SupSignHisHelper.getPlanHis(Lists.newArrayList((Object[])new Long[]{adPlanId}), signDate, signDate);
        List<DynamicObject> planList = attFilePLanMap.get(adPlanId);
        if (CollectionUtils.isEmpty(planList)) {
            return Optional.empty();
        }
        return Optional.of(planList.get(0));
    }

    public static Optional<DynamicObject> getRule(long attFileBoId, Date signDate) {
        if (attFileBoId == 0L || signDate == null) {
            return Optional.empty();
        }
        Optional<DynamicObject> planOptional = SupSignService.getPlan(attFileBoId, signDate);
        if (!planOptional.isPresent()) {
            return Optional.empty();
        }
        DynamicObject planDy = planOptional.get();
        return SupSignService.getRuleByPlan(attFileBoId, planDy, signDate);
    }

    public static Optional<DynamicObject> getRuleByPlan(long attFileBoId, DynamicObject planDy, Date signDate) {
        String ruleType = planDy.getString("ruletype");
        if ("1".equals(ruleType)) {
            DynamicObject supRuleDy = planDy.getDynamicObject("rule");
            if (supRuleDy == null) {
                return Optional.empty();
            }
            Long ruleId = (Long)supRuleDy.getPkValue();
            Map<Long, List<DynamicObject>> ruleMap = SupSignHisHelper.querySuppleRuleHis(Lists.newArrayList((Object[])new Long[]{ruleId}), signDate, signDate);
            List<DynamicObject> ruleList = ruleMap.get(ruleId);
            if (CollectionUtils.isEmpty(ruleList)) {
                return Optional.empty();
            }
            return Optional.of(ruleList.get(0));
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setBoId(attFileBoId);
        attFileQueryParam.setStartDate(signDate);
        attFileQueryParam.setEndDate(signDate);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        List<DynamicObject> attFileList = SupSignHelper.queryAttFile(attFileQueryParam);
        if (!CollectionUtils.isEmpty(attFileList)) {
            DynamicObject attFileDy = attFileList.get(0);
            DutyShiftResponse dutyShiftResponse = EvaluationServiceHelper.getDutyShiftsByAttFileBoId((List)Lists.newArrayList((Object[])new Long[]{attFileDy.getLong("id")}), (Date)signDate, (Date)signDate);
            PlanRuleEngineInParam inParam = SupSignService.getPlanRuleEngineParam(signDate, attFileList, dutyShiftResponse, planDy);
            PlanRuleEngineService planRuleEngineService = PlanRuleEngineService.getInstance();
            List outParamList = planRuleEngineService.batchCallRuleEngine(PlanSceneEnum.AD, (List)Lists.newArrayList((Object[])new PlanRuleEngineInParam[]{inParam}));
            PlanRuleEngineOutParam outParam = (PlanRuleEngineOutParam)outParamList.get(0);
            DynamicObject rule = outParam.getRule();
            if (rule == null) {
                return Optional.empty();
            }
            return Optional.of(rule);
        }
        return Optional.empty();
    }

    private static PlanRuleEngineInParam getPlanRuleEngineParam(Date signDate, List<DynamicObject> attFileList, DutyShiftResponse dutyShiftResponse, DynamicObject planDy) {
        PlanRuleEngineInParam inParam = new PlanRuleEngineInParam();
        inParam.setDate(signDate);
        if (!CollectionUtils.isEmpty(attFileList)) {
            DynamicObject attFileDy = SignCardCommonService.getDyDate(attFileList, signDate, true);
            inParam.setAttFile(attFileDy);
            Optional optionalShift = dutyShiftResponse.getCurrShiftHis(Long.valueOf(attFileDy.getLong("id")), signDate);
            if (optionalShift.isPresent()) {
                Shift shift = (Shift)optionalShift.get();
                inParam.setShift(shift);
            }
            inParam.setPlan(planDy);
        }
        return inParam;
    }

    public static Optional<DynamicObjectCollection> getSupSignReasonColl(long attFileBoId, Date signDate) {
        if (signDate == null) {
            return Optional.empty();
        }
        Optional<DynamicObject> optionalRule = SupSignService.getRule(attFileBoId, signDate);
        if (!optionalRule.isPresent()) {
            return Optional.empty();
        }
        DynamicObject ruleDy = optionalRule.get();
        DynamicObjectCollection reasonPolicyColl = ruleDy.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)reasonPolicyColl)) {
            return Optional.empty();
        }
        return Optional.of(reasonPolicyColl);
    }

    public static Optional<List<DynamicObject>> getSupSignReason(long attFileBoId, Date signDate) {
        if (signDate == null || attFileBoId == 0L) {
            return Optional.empty();
        }
        Optional<DynamicObjectCollection> optional = SupSignService.getSupSignReasonColl(attFileBoId, signDate);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        DynamicObjectCollection reasonPolicyColl = optional.get();
        List reasonList = reasonPolicyColl.stream().map(reasonPolicyDy -> reasonPolicyDy.getDynamicObject("reason")).collect(Collectors.toList());
        return Optional.of(reasonList);
    }

    public static Optional<Long> getPolicyByReason(long attFileBoId, long reasonId, Date signDate) {
        Optional<DynamicObjectCollection> optional = SupSignService.getSupSignReasonColl(attFileBoId, signDate);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        DynamicObjectCollection reasonPolicyColl = optional.get();
        Optional<DynamicObject> policyOptional = reasonPolicyColl.stream().filter(reasonPolicyDy -> reasonId == reasonPolicyDy.getLong("reason.id")).findFirst();
        if (!policyOptional.isPresent()) {
            return Optional.empty();
        }
        DynamicObject reasonPolicyDy2 = policyOptional.get();
        long policyId = SignCardCommonService.getObjectId(reasonPolicyDy2, "attpolicy");
        return Optional.of(policyId);
    }

    public static Optional<String> getPolicyContent(Map<String, Long> reasonPolicyMap) {
        StringBuilder policyContent = new StringBuilder();
        Collection<Long> policyIdSet = reasonPolicyMap.values();
        DynamicObject[] policyDyArr = SupSignHelper.queryAttPolicyById(policyIdSet);
        Map policyDyMap = Arrays.stream(policyDyArr).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
        int index = 0;
        for (Map.Entry<String, Long> entry : reasonPolicyMap.entrySet()) {
            DynamicObject policyDy = (DynamicObject)policyDyMap.get(entry.getValue());
            if (policyDy == null) continue;
            if (index > 0) {
                policyContent.append("<hr style=\"border-style: dashed;\">");
            }
            policyContent.append("<p><strong><span style=\"font-size: 14px;color: #212121;\">").append(entry.getKey()).append(':').append("</span></strong></p><p></p>");
            String content = policyDy.getString("content");
            policyContent.append(content);
            policyContent.append("</br><p></p>");
            ++index;
        }
        if (policyContent.length() > 0) {
            return Optional.of(policyContent.toString());
        }
        return Optional.empty();
    }

    public static Optional<String> getPolicyContent(Collection<Long> policyIdSet) {
        DynamicObject[] policyDyArr = SupSignHelper.queryAttPolicyById(policyIdSet);
        StringBuilder policyContent = new StringBuilder();
        if (policyDyArr != null && policyDyArr.length > 0) {
            List<DynamicObject> dynamicObjects = Arrays.asList(policyDyArr);
            Iterator<DynamicObject> iterator = dynamicObjects.iterator();
            while (iterator.hasNext()) {
                SupSignService.appendPolicyContent(iterator, policyContent);
            }
        }
        return Optional.of(policyContent.toString());
    }

    private static void appendPolicyContent(Iterator<DynamicObject> iterator, StringBuilder policyContent) {
        DynamicObject dy = iterator.next();
        String content = dy.getString("content");
        if (HRStringUtils.isNotEmpty((String)content)) {
            policyContent.append(content);
            if (iterator.hasNext()) {
                policyContent.append("</br>");
            }
        }
    }

    public static List<String> getMultipleCountLimitList(List<AdCheckVo> adCheckVoList) {
        LOG.info("SupSignService.getMultipleCountLimitList begin");
        AdCheckService.initCalcAdCheckVoQuotaPool(adCheckVoList, "save", SignCardBillTypeEnum.SELF_BILL);
        adCheckVoList.sort(Comparator.comparing(AdCheckVo::getShiftBelongDate));
        ArrayList<SupQuotaPoolVo> supQuotaPoolVoList = new ArrayList<SupQuotaPoolVo>(adCheckVoList.size());
        HashSet signSet = Sets.newHashSetWithExpectedSize((int)adCheckVoList.size());
        for (AdCheckVo adCheckVo : adCheckVoList) {
            String supQuotaPoolSign = adCheckVo.getSupQuotaPoolSign();
            if (!HRStringUtils.isNotEmpty((String)supQuotaPoolSign) || !signSet.add(supQuotaPoolSign)) continue;
            supQuotaPoolVoList.add(new SupQuotaPoolVo(adCheckVo.getSupQuotaPool(), adCheckVo.getShiftBelongDate()));
        }
        List<String> countLimitDescList = new ArrayList<String>(0);
        if (!CollectionUtils.isEmpty(supQuotaPoolVoList)) {
            countLimitDescList = SupSignService.getCountLimitExplain(supQuotaPoolVoList);
        }
        return countLimitDescList;
    }

    public static long getWaySupSingCount(List<SupSignCount> waySupSignCountList, Date beginDate, Date endDate, long reasonId) {
        if (CollectionUtils.isEmpty(waySupSignCountList)) {
            return 0L;
        }
        if (reasonId != 0L) {
            return waySupSignCountList.stream().filter(dy -> {
                Date signDate = dy.getSignDate();
                return dy.getApplyReason() == reasonId && signDate.compareTo(beginDate) >= 0 && signDate.compareTo(endDate) <= 0;
            }).count();
        }
        return waySupSignCountList.stream().filter(dy -> {
            Date signDate = dy.getSignDate();
            return signDate.compareTo(beginDate) >= 0 && signDate.compareTo(endDate) <= 0;
        }).count();
    }

    private static List<String> getCountLimitExplain(List<SupQuotaPoolVo> supQuotaPoolVoList) {
        ArrayList<String> countLimitDescList = new ArrayList<String>(supQuotaPoolVoList.size());
        String countLimitDesc = "";
        for (SupQuotaPoolVo poolVo : supQuotaPoolVoList) {
            DynamicObject pool = poolVo.getSupQuotaPool();
            DynamicObject reasonDy = pool.getDynamicObject("reason");
            countLimitDesc = reasonDy == null ? SupSignService.getCountLimitDescByCard(poolVo) : SupSignService.getCountLimitDescByReason(poolVo);
            if (HRStringUtils.isNotEmpty((String)countLimitDesc) && !countLimitDescList.contains(countLimitDesc)) {
                countLimitDescList.add(countLimitDesc);
            }
            LOG.info("SupSignService.getCountLimitExplain countLimitDesc:{}", (Object)countLimitDesc);
        }
        return countLimitDescList;
    }

    private static String getCountLimitDescByCard(SupQuotaPoolVo poolVo) {
        DynamicObject supQuotaPool = poolVo.getSupQuotaPool();
        Date signDate = poolVo.getSignDate();
        String countSco = supQuotaPool.getString("timescope");
        String timeScopeBegin = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)supQuotaPool.getDate("timescopebegin"));
        String timeScopeEnd = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)supQuotaPool.getDate("timescopeend"));
        int normalUsable = supQuotaPool.getInt("normalusable");
        int normalUsed = supQuotaPool.getInt("normalused");
        int normalFreeze = supQuotaPool.getInt("normalfreeze");
        int normalRemain = Math.max(supQuotaPool.getInt("normalremain"), 0);
        int aboveUsable = supQuotaPool.getInt("aboveusable");
        int aboveUsed = supQuotaPool.getInt("aboveused");
        int aboveFreeze = supQuotaPool.getInt("abovefreeze");
        int aboveRemain = Math.max(supQuotaPool.getInt("aboveremain"), 0);
        boolean isAllowAbove = "1".equals(supQuotaPool.getString("allowabove"));
        String countLimitDesc = "";
        TimeRangeEnum countScoEnum = TimeRangeEnum.of((String)countSco);
        if (TimeRangeEnum.MONTH == countScoEnum) {
            int nowMonth = WTCDateUtils.getNowMonth((Date)signDate);
            MonthEnum monthEnum = MonthEnum.of((Integer)nowMonth);
            countLimitDesc = isAllowAbove ? (aboveUsable > 0 ? MessageFormat.format(SupSignKDString.countDescAbove(), monthEnum.getName(), normalUsable, normalUsed + normalFreeze, normalRemain, aboveUsable, aboveUsed + aboveFreeze, aboveRemain) : MessageFormat.format(SupSignKDString.countDescAbove0(), monthEnum.getName(), normalUsable, normalUsed + normalFreeze, normalRemain, aboveUsed + aboveFreeze)) : MessageFormat.format(SupSignKDString.countDescNotAbove(), monthEnum.getName(), normalUsable, normalUsed + normalFreeze, normalRemain);
        } else {
            countLimitDesc = isAllowAbove ? (aboveUsable > 0 ? MessageFormat.format(SupSignKDString.countDescAboveRange(), timeScopeBegin, timeScopeEnd, normalUsable, normalUsed + normalFreeze, normalRemain, aboveUsable, aboveUsed + aboveFreeze, aboveRemain) : MessageFormat.format(SupSignKDString.countDescAboveRange0(), timeScopeBegin, timeScopeEnd, normalUsable, normalUsed + normalFreeze, normalRemain, aboveUsed + aboveFreeze)) : MessageFormat.format(SupSignKDString.countDescNotAboveRange(), timeScopeBegin, timeScopeEnd, normalUsable, normalUsed + normalFreeze, normalRemain);
        }
        return countLimitDesc;
    }

    private static String getCountLimitDescByReason(SupQuotaPoolVo poolVo) {
        DynamicObject supQuotaPool = poolVo.getSupQuotaPool();
        Date signDate = poolVo.getSignDate();
        String countSco = supQuotaPool.getString("timescope");
        String timeScopeBegin = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)supQuotaPool.getDate("timescopebegin"));
        String timeScopeEnd = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)supQuotaPool.getDate("timescopeend"));
        int normalUsable = supQuotaPool.getInt("normalusable");
        int normalUsed = supQuotaPool.getInt("normalused");
        int normalFreeze = supQuotaPool.getInt("normalfreeze");
        int normalRemain = Math.max(supQuotaPool.getInt("normalremain"), 0);
        boolean isAllowAbove = "1".equals(supQuotaPool.getString("allowabove"));
        int aboveUsable = supQuotaPool.getInt("aboveusable");
        int aboveUsed = supQuotaPool.getInt("aboveused");
        int aboveFreeze = supQuotaPool.getInt("abovefreeze");
        int aboveRemain = Math.max(supQuotaPool.getInt("aboveremain"), 0);
        String reasonName = SignCardCommonService.getObjectName(supQuotaPool, "reason");
        String countLimitDesc = "";
        TimeRangeEnum countScoEnum = TimeRangeEnum.of((String)countSco);
        if (TimeRangeEnum.MONTH == countScoEnum) {
            int nowMonth = WTCDateUtils.getNowMonth((Date)signDate);
            MonthEnum monthEnum = MonthEnum.of((Integer)nowMonth);
            countLimitDesc = isAllowAbove ? (aboveUsable > 0 ? MessageFormat.format(SupSignKDString.countDescAboveReason(), monthEnum.getName(), reasonName, normalUsable, normalUsed + normalFreeze, normalRemain, aboveUsable, aboveUsed + aboveFreeze, aboveRemain) : MessageFormat.format(SupSignKDString.countDescAboveReason0(), monthEnum.getName(), reasonName, normalUsable, normalUsed + normalFreeze, normalRemain, aboveUsed + aboveFreeze)) : MessageFormat.format(SupSignKDString.countDescNotAboveReason(), monthEnum.getName(), reasonName, normalUsable, normalUsed + normalFreeze, normalRemain);
        } else {
            countLimitDesc = isAllowAbove ? (aboveUsable > 0 ? MessageFormat.format(SupSignKDString.countDescAboveReasonRange(), timeScopeBegin, timeScopeEnd, reasonName, normalUsable, normalUsed + normalFreeze, normalRemain, aboveUsable, aboveUsed + aboveFreeze, aboveRemain) : MessageFormat.format(SupSignKDString.countDescAboveReasonRange0(), timeScopeBegin, timeScopeEnd, reasonName, normalUsable, normalUsed + normalFreeze, normalRemain, aboveUsed + aboveFreeze)) : MessageFormat.format(SupSignKDString.countDescNotAboveReasonRange(), timeScopeBegin, timeScopeEnd, reasonName, normalUsable, normalUsed + normalFreeze, normalRemain);
        }
        return countLimitDesc;
    }

    public static String getAdBatchListOrderBy() {
        return "id desc";
    }

    public static Set<Long> getRuleByEngineAttFileBoIds(List<Long> attFileBoIds, AttFileScheduleEnum attFileScheduleEnum, String planEntityNumber) {
        if (WTCCollections.isEmpty(attFileBoIds)) {
            return Collections.emptySet();
        }
        AttFileScheduleServiceImpl scheduleService = new AttFileScheduleServiceImpl();
        Map attFilePlanMap = scheduleService.queryAttFileSchedule(attFileBoIds, attFileScheduleEnum, false);
        if (WTCCollections.isEmpty((Map)attFilePlanMap)) {
            return Collections.emptySet();
        }
        HashMap planAttFileMap = Maps.newHashMapWithExpectedSize((int)attFilePlanMap.size());
        String scheduleIdKey = WTCStringUtils.joinStr((String[])new String[]{attFileScheduleEnum.getKey(), ".", "id"});
        for (Map.Entry entry : attFilePlanMap.entrySet()) {
            Long attFileBoId = (Long)entry.getKey();
            List plans = (List)entry.getValue();
            for (DynamicObject planDy : plans) {
                Set longs = planAttFileMap.computeIfAbsent(planDy.getLong(scheduleIdKey), item -> new HashSet(4));
                longs.add(attFileBoId);
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(planEntityNumber);
        Set planBoIds = planAttFileMap.keySet();
        QFilter qFilter = WTCHisServiceHelper.validQFilterByBoNoStatus(planBoIds);
        DynamicObject[] planVersions = serviceHelper.queryOriginalArray("id,boid", qFilter.toArray());
        if (planVersions == null || planVersions.length == 0) {
            return Collections.emptySet();
        }
        Map<Long, Long> planIdMap = Arrays.stream(planVersions).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getLong("boid")));
        HashSet byEngineAttFileBoIds = Sets.newHashSetWithExpectedSize((int)attFileBoIds.size());
        List ruleSetWays = PlanRuleEngineHelper.getPolicyByPlanIds(planIdMap.keySet());
        if (WTCCollections.isNotEmpty((Collection)ruleSetWays)) {
            for (DynamicObject ruleSetWayDy : ruleSetWays) {
                long planId = ruleSetWayDy.getLong("planid");
                Long planBoId = planIdMap.get(planId);
                if (planBoId == null) continue;
                byEngineAttFileBoIds.addAll((Collection)planAttFileMap.get(planBoId));
            }
        }
        return byEngineAttFileBoIds;
    }
}

