/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.task;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.billapply.BillApplyTaskDetail;
import kd.wtc.wtbs.business.caltask.common.billapply.BillApplyTaskDetailStatus;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.sharding.std.WTCTaskCalShardingDetail;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;
import kd.wtc.wtpm.business.signcard.task.BillTaskEntity;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.vo.suppleapply.ApplyReqVo;
import kd.wtc.wtpm.vo.suppleapply.BillExDetailVo;
import kd.wtc.wtpm.vo.suppleapply.BillSubTaskVo;
import kd.wtc.wtpm.vo.suppleapply.BillTaskProcessVo;

public class BillApplyTaskHelper {
    private BillApplyTaskHelper() {
    }

    public static void callBackDispatchTask(BillTaskEntity billTaskVo) {
        List<WTCCalTaskDetailEntity> details = billTaskVo.getBillApplyTaskDetailList();
        WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(details, (String)billTaskVo.getTaskCategory());
        WTCCalSubTaskEntity subTask = new WTCCalSubTaskEntity();
        subTask.setId(billTaskVo.getSubTaskId().longValue());
        subTask.setTaskId(billTaskVo.getTaskId().longValue());
        subTask.setStartDate(billTaskVo.getStartDate());
        Date nowDate = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now());
        subTask.setEndDate(nowDate);
        subTask.setRefreshTime(nowDate);
        BillSubTaskVo billSubTaskVo = billTaskVo.getBillSubTaskVo();
        subTask.setTotalAttFile(billSubTaskVo.getTotalAttFile().intValue());
        subTask.setRunAttFile(billSubTaskVo.getTotalAttFile() - billSubTaskVo.getNotRunAttFile());
        subTask.setSucceedAttFile(billSubTaskVo.getSuccessAttFile().intValue());
        subTask.setFailedAttFile(billSubTaskVo.getFailAttFile().intValue());
        subTask.setNotRunAttFile(billSubTaskVo.getNotRunAttFile().intValue());
        subTask.setTotalAttPerson(billSubTaskVo.getTotalAttPerson().intValue());
        subTask.setRunAttPerson(billSubTaskVo.getTotalAttPerson() - billSubTaskVo.getNotRunAttPerson());
        subTask.setFailedAttPerson(billSubTaskVo.getFailAttPerson().intValue());
        subTask.setSucceedAttPerson(billSubTaskVo.getSuccessAttPerson().intValue());
        subTask.setNotRunAttPerson(billSubTaskVo.getNotRunAttPerson().intValue());
        subTask.setSubTaskStatus(WTCSubTaskStatus.FINISHED);
        WTCTaskServiceHelper.updateTaskSub((String)billTaskVo.getTaskCategory(), (WTCSubTaskEntity)subTask);
    }

    public static void callBackDispatchTaskOfError(BillTaskProcessVo billTaskProcessVo) {
        List taskShardingDetails = billTaskProcessVo.getShardingDetails();
        ArrayList<BillApplyTaskDetail> details = new ArrayList<BillApplyTaskDetail>(taskShardingDetails.size());
        ArrayList<DynamicObject> exDetailList = new ArrayList<DynamicObject>(taskShardingDetails.size());
        HRBaseServiceHelper exServiceHelper = new HRBaseServiceHelper(BillApplyTaskFactoryService.getExDetailEntityId(billTaskProcessVo.getTaskCategory()));
        long taskId = billTaskProcessVo.getTaskId();
        long subTaskId = billTaskProcessVo.getSubTaskId();
        String errorMsg = SupSignKDString.sysExcep();
        for (Object detail : taskShardingDetails) {
            WTCTaskCalShardingDetail shardingDetail = (WTCTaskCalShardingDetail)detail;
            BillApplyTaskDetail entity = new BillApplyTaskDetail();
            entity.setTaskId(taskId);
            entity.setSubTaskId(subTaskId);
            entity.setAttPersonId(shardingDetail.getAttPersonId());
            entity.setAttFileId(shardingDetail.getAttFileBoId());
            entity.setAttFileBoId(shardingDetail.getAttFileBoId());
            entity.setRealCalStartDate(null);
            entity.setRealCalEndDate(null);
            entity.setTaskDetailState(WTCTaskDetailStatus.FAIL);
            entity.setTotal(Integer.valueOf(0));
            entity.setSuccess(Integer.valueOf(0));
            entity.setFail(Integer.valueOf(0));
            entity.setStatus(BillApplyTaskDetailStatus.NOTRUN);
            details.add(entity);
            DynamicObject exDetail = exServiceHelper.generateEmptyDynamicObject();
            exDetail.set("evadate", null);
            exDetail.set("attfileid", (Object)shardingDetail.getAttFileBoId());
            exDetail.set("excode", (Object)"0");
            exDetail.set("exinfo", (Object)errorMsg);
            exDetail.set("taskid", (Object)taskId);
            exDetail.set("subtaskid", (Object)subTaskId);
            exDetailList.add(exDetail);
        }
        WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(details, (String)billTaskProcessVo.getTaskCategory());
        exServiceHelper.save(exDetailList.toArray(new DynamicObject[exDetailList.size()]));
        WTCCalSubTaskEntity subTask = new WTCCalSubTaskEntity();
        subTask.setId(subTaskId);
        subTask.setTaskId(taskId);
        Date nowDate = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now());
        subTask.setStartDate(nowDate);
        subTask.setEndDate(nowDate);
        subTask.setRefreshTime(nowDate);
        int detailSize = details.size();
        subTask.setTotalAttFile(detailSize);
        subTask.setRunAttFile(0);
        subTask.setSucceedAttFile(0);
        subTask.setFailedAttFile(0);
        subTask.setNotRunAttFile(detailSize);
        subTask.setTotalAttPerson(detailSize);
        subTask.setRunAttPerson(0);
        subTask.setFailedAttPerson(0);
        subTask.setSucceedAttPerson(0);
        subTask.setNotRunAttPerson(detailSize);
        subTask.setSubTaskStatus(WTCSubTaskStatus.ERROR);
        WTCTaskServiceHelper.updateTaskSub((String)billTaskProcessVo.getTaskCategory(), (WTCSubTaskEntity)subTask);
    }

    public static void saveExDetail(BillTaskEntity billTaskVo) {
        List<BillExDetailVo> billExDetailVoList = billTaskVo.getBillExDetailVoList();
        if (CollectionUtils.isEmpty(billExDetailVoList)) {
            return;
        }
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(BillApplyTaskFactoryService.getExDetailEntityId(billTaskVo.getTaskCategory()));
        DynamicObject[] exDetailArr = new DynamicObject[billExDetailVoList.size()];
        for (int index = 0; index < billExDetailVoList.size(); ++index) {
            BillExDetailVo billExDetailVo = billExDetailVoList.get(index);
            DynamicObject exDetail = baseServiceHelper.generateEmptyDynamicObject();
            exDetail.set("evadate", (Object)billExDetailVo.getEvaDate());
            exDetail.set("attfileid", (Object)billExDetailVo.getAttFileId());
            exDetail.set("excode", (Object)billExDetailVo.getExCode());
            exDetail.set("exinfo", (Object)billExDetailVo.getExInfo());
            exDetail.set("taskid", (Object)billTaskVo.getTaskId());
            exDetail.set("subtaskid", (Object)billTaskVo.getSubTaskId());
            exDetail.set("suppleworktime", (Object)billExDetailVo.getSuppleWorkTime());
            exDetailArr[index] = exDetail;
        }
        baseServiceHelper.save(exDetailArr);
    }

    public static void saveTaskLog(ApplyReqVo applyReqVo) {
        if (applyReqVo != null) {
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(BillApplyTaskFactoryService.getTaskLogEntityId(applyReqVo.getTaskCategory()));
            DynamicObject applyLog = baseServiceHelper.generateEmptyDynamicObject();
            applyLog.set("id", (Object)applyReqVo.getTaskId());
            applyLog.set("billno", (Object)applyReqVo.getBillNo());
            applyLog.set("billid", (Object)applyReqVo.getBillId());
            applyLog.set("optype", (Object)applyReqVo.getOpType());
            applyLog.set("task", (Object)applyReqVo.getTaskId());
            applyLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            applyLog.set("org", (Object)applyReqVo.getOrgId());
            applyLog.set("startdate", (Object)applyReqVo.getStartDate());
            applyLog.set("enddate", (Object)applyReqVo.getEndDate());
            baseServiceHelper.saveOne(applyLog);
        }
    }

    public static DynamicObject getTaskLog(Long taskId, String entityId) {
        QFilter qFilter = new QFilter("task", "=", (Object)taskId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        return serviceHelper.loadDynamicObject(qFilter);
    }
}

