/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtpm.vo.suppleapply.ApplyReqVo;

public class BillApplyTaskService {
    protected static final Log LOG = LogFactory.getLog(BillApplyTaskService.class);

    private BillApplyTaskService() {
    }

    public static WTCTaskRequestStd setDistributedTaskRequest(ApplyReqVo applyReqVo) {
        LOG.info("BillApplyTaskService.setDistributedTaskRequest.start");
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        request.setTaskId(applyReqVo.getTaskId().longValue());
        request.setVersion(applyReqVo.getVersion());
        request.setCategory(applyReqVo.getTaskCategory());
        request.setCreatorId(RequestContext.get().getCurrUserId());
        request.setSource("1");
        request.setStartDate(applyReqVo.getStartDate());
        request.setEndDate(applyReqVo.getEndDate());
        request.setTrial(false);
        request.setAppId("wtpm");
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
        paramMap.put("taskId", applyReqVo.getTaskId());
        paramMap.put("taskCategory", applyReqVo.getTaskCategory());
        paramMap.put("billid", applyReqVo.getBillId());
        paramMap.put("billstatus", applyReqVo.getTargetBillStatus());
        paramMap.put("opType", applyReqVo.getOpType());
        request.setParams((Map)paramMap);
        LOG.info("BillApplyTaskService.setDistributedTaskRequest.end");
        return request;
    }

    @Deprecated
    public static DistributeSessionlessCache getDistributeSessionlessCache() {
        return WTCCacheUtils.getCache();
    }

    public static String getTaskCacheKey(long billId) {
        return "taskid" + billId;
    }

    public static void cacheTaskStatus(long billId) {
        String cacheKey = "taskStatus_" + billId;
        cacheKey = WTCCacheUtils.getKey((String)"wtpm", (String)cacheKey);
        BillApplyTaskService.getDistributeSessionlessCache().put(cacheKey, (Object)"true", 20);
    }

    public static boolean taskStatusIsRun(long billId) {
        String cacheKey = "taskStatus_" + billId;
        cacheKey = WTCCacheUtils.getKey((String)"wtpm", (String)cacheKey);
        String s = (String)BillApplyTaskService.getDistributeSessionlessCache().get(cacheKey);
        return Boolean.parseBoolean(s);
    }

    public static void deleteTaskStatusCache(long billId) {
        String cacheKey = "taskStatus_" + billId;
        cacheKey = WTCCacheUtils.getKey((String)"wtpm", (String)cacheKey);
        BillApplyTaskService.getDistributeSessionlessCache().remove(cacheKey);
    }
}

