/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.task;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.log.WTCAppLogInfo;
import kd.wtc.wtbs.business.log.WTCAppOperationLog;
import kd.wtc.wtbs.business.signcard.common.WTCMatchTaskStatus;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskLifeCycleCallBack;
import kd.wtc.wtbs.business.task.common.WTCTaskBusinessStatusEnum;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.task.SignCardTaskStatusCallBack;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;

public abstract class BillApplyTaskStatusCallBack
implements MainTaskLifeCycleCallBack {
    private static final Log LOG = LogFactory.getLog(SignCardTaskStatusCallBack.class);
    private static final String TASKDETAIL_QUERYPROP = WTCStringUtils.joinOnComma((String[])new String[]{"total", "success", "fail", "matchstatus"});
    protected static final List<String> FAIL_STATUS = Lists.newArrayList((Object[])new String[]{"2", "3"});
    protected static final List<String> SUCCESS_STATUS = Lists.newArrayList((Object[])new String[]{"1", "3"});
    private int successCard = 0;
    private int failCard = 0;
    private int totalAttFile = 0;
    private int failAttFile = 0;
    private int partAttFile = 0;
    private int successAttFile = 0;
    protected DynamicObject taskLog;

    public Map<String, Object> onMainTaskEnd(Long bizTaskId, String category, WTCTaskStatus wtcTaskStatus, List<String> shardingCustomDataList) {
        WTCTaskStateTransfer.transferToSpecialState((Long)bizTaskId, (WTCTaskStatus)wtcTaskStatus, (String)category);
        this.statusChangeCallBack(bizTaskId, wtcTaskStatus, WTCTaskInstanceHelper.getRepository((String)category), category);
        this.finishedCallBack(bizTaskId);
        return new HashMap<String, Object>(0);
    }

    public void onMainTaskBootSuccess(MainTask mainTask) {
        WTCTaskStateTransfer.transferToSpecialState((Long)mainTask.getBizTaskId(), (WTCTaskStatus)WTCTaskStatus.RUNNING, (String)mainTask.getCategory());
    }

    public void onAcceptTerminating(Long bizTaskId, String category) {
        WTCTaskStateTransfer.transferToSpecialState((Long)bizTaskId, (WTCTaskStatus)WTCTaskStatus.TERMINATING, (String)category);
    }

    private void statusChangeCallBack(Long bizTaskId, WTCTaskStatus wtcTaskStatus, WTCTaskRepository repository, String category) {
        LOG.info("BillApplyTaskStatusCallBack.statusChangeCallBack wtcTaskStatus:{}", (Object)wtcTaskStatus.getCode());
        WTCCalTaskRepository matchRepository = (WTCCalTaskRepository)repository;
        DynamicObject dyn = matchRepository.loadTaskDynByTaskId(bizTaskId.longValue(), null);
        WTCTaskBusinessStatusEnum wtcTaskBusinessStatusEnum = WTCTaskServiceHelper.getWTCTaskBusinessStatusEnumByTaskId((String)category, (long)bizTaskId);
        WTCMatchTaskStatus wtcMatchTaskStatus = WTCMatchTaskStatus.fromBySign((String)wtcTaskBusinessStatusEnum.getSign());
        dyn.set("matchstatus", (Object)wtcMatchTaskStatus.getCode());
        matchRepository.updateTaskDyn(dyn);
    }

    protected void finishedCallBack(Long taskId) {
    }

    protected DynamicObject getTaskLog(Long taskId) {
        return null;
    }

    @Deprecated
    protected void callBackUpdateTaskLog(String matchStatus, String taskStatus, Long taskId) {
        DynamicObject taskLogDy = this.getTaskLog(taskId);
        taskLogDy.set("taskstatus", (Object)taskStatus);
    }

    private List<DynamicObject> getTaskDetail(Long taskId, String entityId) {
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        Object[] dynamicObjects = serviceHelper.queryOriginalArray(TASKDETAIL_QUERYPROP, qFilter.toArray());
        return Lists.newArrayList((Object[])dynamicObjects);
    }

    protected List<DynamicObject> getTaskDetailStatusOneData(Long taskId, String entityId, boolean isQuerySuccess) {
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        qFilter.and("taskdetailstate", "!=", (Object)WTCTaskDetailStatus.NOT_ACCOUNT.getCode());
        if (isQuerySuccess) {
            qFilter.and(new QFilter("success", ">", (Object)0));
        } else {
            qFilter.and(new QFilter("fail", ">", (Object)0));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        DynamicObject dynamicObjects = serviceHelper.queryOriginalOne(TASKDETAIL_QUERYPROP, qFilter);
        if (dynamicObjects == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new DynamicObject[]{dynamicObjects});
    }

    protected void getTaskDetailData(Long taskId, String taskCategory) {
        String taskDetailEntityId = this.getTaskDetailEntityId(taskCategory);
        List<DynamicObject> taskDetailList = this.getTaskDetail(taskId, taskDetailEntityId);
        this.totalAttFile = taskDetailList.size();
        for (DynamicObject taskDetail : taskDetailList) {
            int total = taskDetail.getInt("total");
            int success = taskDetail.getInt("success");
            int fail = taskDetail.getInt("fail");
            this.successCard += success;
            this.failCard += fail;
            if (success == total) {
                ++this.successAttFile;
                continue;
            }
            if (fail == total) {
                ++this.failAttFile;
                continue;
            }
            ++this.partAttFile;
        }
    }

    protected void addAppOperateLog(String taskCategory, String opKey) {
        String logInfo = MessageFormat.format(SupSignKDString.appLogInfo(), this.totalAttFile, this.successAttFile, this.partAttFile, this.failAttFile);
        Map params = this.takeReqParams();
        String loginIP = (String)params.get("loginIP");
        if ("wtpm_supsign".equals(taskCategory)) {
            WTCAppLogInfo wtcAppOperationLog = new WTCAppLogInfo(logInfo, "wtam", "wtpm_supsignbatch", opKey, loginIP);
            WTCAppOperationLog.addOperateLog((WTCAppLogInfo)wtcAppOperationLog);
        } else if ("wtpm_signcard".equals(taskCategory)) {
            WTCAppLogInfo wtcAppOperationLog = new WTCAppLogInfo(logInfo, "wtpm", "wtpm_signcardapply", opKey, loginIP);
            WTCAppOperationLog.addOperateLog((WTCAppLogInfo)wtcAppOperationLog);
        }
    }

    protected void sendResultMessage(Long taskLogId, String billNo, String taskCategory) {
    }

    private String getUrl(Map<String, Object> params) {
        StringBuilder stringBuilder = new StringBuilder(UrlService.getDomainContextUrl()).append("/?");
        Iterator<Map.Entry<String, Object>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            stringBuilder.append(next.getKey()).append('=').append(next.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    private static String getTaskLogDetailEntityId(String taskCategory) {
        String entityId = "";
        if ("wtpm_supsign".equals(taskCategory)) {
            entityId = "wtpm_supsigntasklog";
        } else if ("wtpm_signcard".equals(taskCategory)) {
            entityId = "wtpm_signcardtasklog";
        }
        return entityId;
    }

    private String getTaskDetailEntityId(String taskCategory) {
        String entityId = "";
        if ("wtpm_supsign".equals(taskCategory)) {
            entityId = "wtpm_supsigntaskdetail";
        } else if ("wtpm_signcard".equals(taskCategory)) {
            entityId = "wtpm_signcardtaskdetail";
        }
        return entityId;
    }

    protected boolean isPartSuccessSubmit() {
        return SignCardBatchService.isPartSuccessSubmit();
    }
}

