/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHisHelper;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class AttFilePlanCheckService
extends AbstractSupSignCheckService {
    private boolean checkResult = true;

    public AttFilePlanCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    @Override
    public void init() {
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return;
        }
        Map<Long, List<DynamicObject>> attFilePlanMap = SupSignHisHelper.getAttFilePlanHis(this.attFileBoIdList, (Date)this.ctx.getBillMaxDateRange().item1, (Date)this.ctx.getBillMaxDateRange().item2);
        ArrayList attFilePlanList = new ArrayList(this.remainAdCheckVoList.size());
        this.remainAdCheckVoList.forEach(adCheckVo -> {
            DynamicObject attPlanDy;
            List attPlanList = (List)attFilePlanMap.get(adCheckVo.getAttFileId());
            if (!CollectionUtils.isEmpty((Collection)attPlanList) && (attPlanDy = this.getDyDate(attPlanList, adCheckVo.getShiftBelongDate(), false)) != null) {
                attFilePlanList.add(attPlanDy);
                adCheckVo.setAttPlanDy(attPlanDy);
            }
        });
        Set planIdSet = attFilePlanList.stream().map(attFilePlan -> SignCardCommonService.getObjectId(attFilePlan, "ad")).collect(Collectors.toSet());
        this.ctx.setPlanIdSet(planIdSet);
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            LOG.info("AbstractSupSignCheckService AttFilePlanCheckService remainAdCheckVoList isEmpty");
            return true;
        }
        for (int index = 0; index < this.remainAdCheckVoList.size(); ++index) {
            AdCheckVo adCheckVo = (AdCheckVo)this.remainAdCheckVoList.get(index);
            this.checkAttAdPlan(adCheckVo);
        }
        LOG.info("AbstractSupSignCheckService AttFilePlanCheckService check result:{}", (Object)this.checkResult);
        return this.checkResult;
    }

    private void checkAttAdPlan(AdCheckVo adCheckVo) {
        if (adCheckVo.getAttPlanDy() == null) {
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.AttFilePlanCheck, this.date2Str(adCheckVo.getSignDate()));
            this.checkResult = false;
        }
    }
}

