/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolService;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolServiceImpl;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.enums.MonthEnum;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.enums.TimeRangeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class CountSetCheckService
extends AbstractSupSignCheckService {
    private boolean checkCountSet = true;
    private Map<Long, Map<Long, List<AdCheckVo>>> remainAdCheckVoAttFileMap = new HashMap<Long, Map<Long, List<AdCheckVo>>>(16);
    private boolean checkResult = true;
    private String opKey;
    private SignCardBillTypeEnum billType;
    private SupQuotaPoolService supQuotaPoolService = new SupQuotaPoolServiceImpl();

    public CountSetCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    public CountSetCheckService(AdCheckContext ctx, boolean checkCountSet) {
        super(ctx);
        this.checkCountSet = checkCountSet;
    }

    @Override
    public void init() {
        LOG.info("CountSetCheckService.init begin");
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return;
        }
        this.opKey = this.ctx.getOpKey();
        if (HRStringUtils.isEmpty((String)this.opKey)) {
            this.opKey = "save";
        }
        this.billType = this.ctx.getBillType();
        if (SignCardBillTypeEnum.SELF_BILL == this.billType || SignCardBillTypeEnum.OTHER_BILL == this.billType) {
            this.remainAdCheckVoAttFileMap = this.remainAdCheckVoList.stream().collect(Collectors.groupingBy(AdCheckVo::getId, Collectors.groupingBy(AdCheckVo::getAttFileId)));
        } else if (SignCardBillTypeEnum.SUPSIGN_BATCHBILL == this.billType) {
            this.remainAdCheckVoAttFileMap.put(0L, this.remainAdCheckVoList.stream().collect(Collectors.groupingBy(AdCheckVo::getAttFileId)));
        }
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            LOG.info("AbstractSupSignCheckService CountSetCheckService remainAdCheckVoList isEmpty");
            return true;
        }
        LOG.info("CountSetCheckService.check begin");
        this.remainAdCheckVoAttFileMap.forEach((id, adCheckVoAttFileMap) -> adCheckVoAttFileMap.forEach((attFileBoId, adCheckVoList) -> {
            String lockKey = this.supQuotaPoolService.getLockKey((long)attFileBoId);
            try (DLock dLock = DLock.create((String)lockKey);){
                dLock.lock();
                this.supQuotaPoolService.getOrInitSupQuotaPool((List<AdCheckVo>)adCheckVoList, this.opKey);
                String targetOpKey = this.getTargetOpKey((List<AdCheckVo>)adCheckVoList);
                this.supQuotaPoolService.saveOrUpdateSupQuotaPool((long)attFileBoId, (List<AdCheckVo>)adCheckVoList, targetOpKey);
            }
        }));
        LOG.info("AbstractSupSignCheckService CountSetCheckService check result:{}", (Object)this.checkResult);
        return this.checkResult;
    }

    private String getTargetOpKey(List<AdCheckVo> adCheckVoList) {
        String realOpKey = this.opKey;
        if (this.checkCountSet) {
            for (AdCheckVo adCheckVo : adCheckVoList) {
                boolean result = this.checkCount(adCheckVo, adCheckVoList);
                if (result) continue;
                this.checkResult = false;
            }
            realOpKey = "save";
        }
        return realOpKey;
    }

    private boolean checkCount(AdCheckVo adCheckVo, List<AdCheckVo> adCheckVoList) {
        String supQuotaPoolSign = adCheckVo.getSupQuotaPoolSign();
        DynamicObject supQuotaPool = adCheckVo.getSupQuotaPool();
        boolean result = true;
        if (!HRStringUtils.isEmpty((String)supQuotaPoolSign) && supQuotaPool != null) {
            int normalRemain = supQuotaPool.getInt("normalremain");
            int aboveUsable = supQuotaPool.getInt("aboveusable");
            int aboveRemain = supQuotaPool.getInt("aboveremain");
            boolean isAllowAbove = "1".equals(supQuotaPool.getString("allowabove"));
            Date timeRangeBegin = supQuotaPool.getDate("timescopebegin");
            Date timeRangeEnd = supQuotaPool.getDate("timescopeend");
            long reasonId = SignCardCommonService.getObjectId(supQuotaPool, "reason");
            int applyCount = SignCardCommonService.getBatchCheckedApplyCount(adCheckVoList, timeRangeBegin, timeRangeEnd, reasonId) + 1;
            if (isAllowAbove) {
                if (aboveUsable > 0 && normalRemain + aboveRemain < applyCount) {
                    result = false;
                    this.setAllowAboveErrorMsg(adCheckVo);
                }
            } else if (normalRemain < applyCount) {
                result = false;
                this.setNotAllowAboveErrorMsg(adCheckVo);
            }
            if (reasonId != 0L) {
                adCheckVo.setCountReasonChecked(true);
            } else {
                adCheckVo.setCountChecked(true);
            }
        }
        return result;
    }

    private void setAllowAboveErrorMsg(AdCheckVo adCheckVo) {
        DynamicObject supQuotaPool = adCheckVo.getSupQuotaPool();
        DynamicObject reasonDy = supQuotaPool.getDynamicObject("reason");
        int normalUsable = supQuotaPool.getInt("normalusable");
        int normalRemain = supQuotaPool.getInt("normalremain");
        int aboveUsable = supQuotaPool.getInt("aboveusable");
        int aboveRemain = supQuotaPool.getInt("aboveremain");
        String timeRange = supQuotaPool.getString("timescope");
        Date timeRangeBegin = supQuotaPool.getDate("timescopebegin");
        Date timeRangeEnd = supQuotaPool.getDate("timescopeend");
        if (SignCardBillTypeEnum.SUPSIGN_BATCHBILL == this.billType) {
            normalRemain = 0;
            aboveRemain = 0;
        }
        if (reasonDy != null) {
            String reasonName = reasonDy.getString("name");
            if (TimeRangeEnum.MONTH.getCode().equals(timeRange)) {
                int nowMonth = WTCDateUtils.getNowMonth((Date)adCheckVo.getShiftBelongDate());
                MonthEnum monthEnum = MonthEnum.of((Integer)nowMonth);
                this.setErrorMsg(adCheckVo, SupSignKDString.countCheckAboveReason(), monthEnum.getName(), reasonName, normalUsable, normalRemain, aboveUsable, aboveRemain);
            } else {
                this.setErrorMsg(adCheckVo, SupSignKDString.countCheckAboveReasonRange(), this.date2Str(timeRangeBegin), this.date2Str(timeRangeEnd), reasonName, normalUsable, normalRemain, aboveUsable, aboveRemain);
            }
        } else if (TimeRangeEnum.MONTH.getCode().equals(timeRange)) {
            int nowMonth = WTCDateUtils.getNowMonth((Date)adCheckVo.getShiftBelongDate());
            MonthEnum monthEnum = MonthEnum.of((Integer)nowMonth);
            this.setErrorMsg(adCheckVo, SupSignKDString.countCheckAbove(), monthEnum.getName(), normalUsable, normalRemain, aboveUsable, aboveRemain);
        } else {
            this.setErrorMsg(adCheckVo, SupSignKDString.countCheckAboveRange(), this.date2Str(timeRangeBegin), this.date2Str(timeRangeEnd), normalUsable, normalRemain, aboveUsable, aboveRemain);
        }
    }

    private void setNotAllowAboveErrorMsg(AdCheckVo adCheckVo) {
        DynamicObject supQuotaPool = adCheckVo.getSupQuotaPool();
        DynamicObject reasonDy = supQuotaPool.getDynamicObject("reason");
        int normalUsable = supQuotaPool.getInt("normalusable");
        int normalRemain = supQuotaPool.getInt("normalremain");
        String timeRange = supQuotaPool.getString("timescope");
        Date timeRangeBegin = supQuotaPool.getDate("timescopebegin");
        Date timeRangeEnd = supQuotaPool.getDate("timescopeend");
        if (SignCardBillTypeEnum.SUPSIGN_BATCHBILL == this.billType) {
            normalRemain = 0;
        }
        if (reasonDy != null) {
            String reasonName = reasonDy.getString("name");
            if (TimeRangeEnum.MONTH.getCode().equals(timeRange)) {
                int nowMonth = WTCDateUtils.getNowMonth((Date)adCheckVo.getShiftBelongDate());
                MonthEnum monthEnum = MonthEnum.of((Integer)nowMonth);
                this.setErrorMsg(adCheckVo, SupSignKDString.countCheckNotAboveReason(), monthEnum.getName(), reasonName, normalUsable, normalRemain);
            } else {
                this.setErrorMsg(adCheckVo, SupSignKDString.countCheckNotAboveReasonRange(), this.date2Str(timeRangeBegin), this.date2Str(timeRangeEnd), reasonName, normalUsable, normalRemain);
            }
        } else if (TimeRangeEnum.MONTH.getCode().equals(timeRange)) {
            int nowMonth = WTCDateUtils.getNowMonth((Date)adCheckVo.getShiftBelongDate());
            MonthEnum monthEnum = MonthEnum.of((Integer)nowMonth);
            this.setErrorMsg(adCheckVo, SupSignKDString.countCheckNotAbove(), monthEnum.getName(), normalUsable, normalRemain);
        } else {
            this.setErrorMsg(adCheckVo, SupSignKDString.countCheckNotAboveRange(), this.date2Str(timeRangeBegin), this.date2Str(timeRangeEnd), normalUsable, normalRemain);
        }
    }

    @Override
    protected boolean busDiffCheck(AdCheckVo adCheckVo) {
        return Objects.nonNull(adCheckVo.getCountBeginDate()) && Objects.nonNull(adCheckVo.getCountEndDate());
    }
}

