/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.util.Collection;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class ReasonCheckService
extends AbstractSupSignCheckService {
    private boolean checkResult = true;

    public ReasonCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    @Override
    public void init() {
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return true;
        }
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            DynamicObject adRuleDy = adCheckVo.getAdRuleDy();
            DynamicObjectCollection reasonPolicyColl = adRuleDy.getDynamicObjectCollection("entryentity");
            DynamicObject applyReason = adCheckVo.getReason();
            if (applyReason == null) continue;
            long applyReasonId = applyReason.getLong("id");
            Optional<DynamicObject> any = reasonPolicyColl.stream().filter(item -> SignCardCommonService.getObjectId(item, "reason") == applyReasonId).findAny();
            if (any.isPresent()) continue;
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.MachReasonCheck, applyReason.getString("name"));
            this.checkResult = false;
        }
        return this.checkResult;
    }
}

