/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.applybill.ruleengine.IPlanRuleEngineService;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineService;
import kd.wtc.wtbs.common.bill.ExRecordQuery;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineInParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.predata.wtbd.PreDataBillType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHisHelper;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class RuleCheckService
extends AbstractSupSignCheckService {
    private boolean needQueryEx = true;
    private boolean checkResult = true;
    private IPlanRuleEngineService planRuleEngineService = PlanRuleEngineService.getInstance();
    private Map<Long, List<DynamicObject>> exRecordGroupByPersonMap = new HashMap<Long, List<DynamicObject>>(16);
    private Map<Long, List<DynamicObject>> exProcessMap = new HashMap<Long, List<DynamicObject>>(16);
    private static final int EXNAMESHOWLENGTH = 10;

    public RuleCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    public RuleCheckService(AdCheckContext ctx, boolean needQueryEx) {
        super(ctx);
        this.needQueryEx = needQueryEx;
    }

    @Override
    public void init() {
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return;
        }
        Map<Long, List<DynamicObject>> ruleHisMap = SupSignHisHelper.querySuppleRuleHis(this.ctx.getRuleIdSet(), (Date)this.ctx.getBillMaxDateRange().item1, (Date)this.ctx.getBillMaxDateRange().item2);
        List<PlanRuleEngineOutParam> outParamList = this.requestRuleEngine(this.remainAdCheckVoList);
        ArrayList<DynamicObject> adRuleList = new ArrayList<DynamicObject>(this.remainAdCheckVoList.size());
        ArrayList<ExRecordQuery> exRecordQueryList = new ArrayList<ExRecordQuery>(this.remainAdCheckVoList.size());
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            Date signDate;
            DynamicObject ruleDy;
            DynamicObject planDy = adCheckVo.getAdPlanDy();
            List<DynamicObject> ruleList = this.matchRule(planDy, ruleHisMap, outParamList, adCheckVo);
            if (CollectionUtils.isEmpty(ruleList) || (ruleDy = this.getDyDate(ruleList, signDate = adCheckVo.getShiftBelongDate(), true)) == null) continue;
            adCheckVo.setAdRuleDy(ruleDy);
            adRuleList.add(ruleDy);
            exRecordQueryList.add(new ExRecordQuery(adCheckVo.getPersonId(), signDate));
        }
        if (!CollectionUtils.isEmpty(exRecordQueryList) && this.needQueryEx) {
            this.exRecordGroupByPersonMap = SignCardBatchService.getExRecordByAttPersonAndDate(exRecordQueryList);
            this.queryExProcess();
        }
        HashSet timeSetIdSet = Sets.newHashSetWithExpectedSize((int)adRuleList.size());
        HashSet countSetIdSet = Sets.newHashSetWithExpectedSize((int)adRuleList.size());
        for (DynamicObject ruleDy : adRuleList) {
            long countSetId;
            long timeSetId = SignCardCommonService.getObjectId(ruleDy, "timeset");
            if (timeSetId != 0L) {
                timeSetIdSet.add(timeSetId);
            }
            if ((countSetId = SignCardCommonService.getObjectId(ruleDy, "countset")) == 0L) continue;
            countSetIdSet.add(countSetId);
        }
        this.ctx.setTimeSetIdSet((Set)timeSetIdSet);
        this.ctx.setCountSetIdSet((Set)countSetIdSet);
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            LOG.info("AbstractSupSignCheckService RuleCheckService remainAdCheckVoList isEmpty");
            return true;
        }
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            this.checkRule(adCheckVo);
        }
        LOG.info("AbstractSupSignCheckService RuleCheckService checkResult:{}", (Object)this.checkResult);
        return this.checkResult;
    }

    private void checkRule(AdCheckVo adCheckVo) {
        DynamicObject adRuleDy = adCheckVo.getAdRuleDy();
        if (adRuleDy == null) {
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.RuleCheck, this.date2Str(adCheckVo.getSignDate()));
            this.checkResult = false;
        } else {
            boolean onlyExSupple = adRuleDy.getBoolean("onlyexsupple");
            if (onlyExSupple && this.needQueryEx) {
                this.checkRuleSetEx(adCheckVo);
            }
        }
    }

    private void checkRuleSetEx(AdCheckVo adCheckVo) {
        DynamicObjectCollection exEntryColl = adCheckVo.getAdRuleDy().getDynamicObjectCollection("extypeentry");
        HashSet allowSuppleExIdSet = Sets.newHashSetWithExpectedSize((int)exEntryColl.size());
        HashMap exInfoMap = Maps.newHashMapWithExpectedSize((int)exEntryColl.size());
        StringBuilder exNameSb = new StringBuilder();
        this.getRuleSetExInfo(exEntryColl, allowSuppleExIdSet, exNameSb, exInfoMap);
        Long attFileBoId = adCheckVo.getAttFileId();
        Date shiftBelongDate = adCheckVo.getShiftBelongDate();
        List<DynamicObject> exRecordList = this.exRecordGroupByPersonMap.get(attFileBoId);
        if (CollectionUtils.isEmpty(exRecordList)) {
            this.setErrorMsg(adCheckVo, SupSignKDString.notHaveEx(), this.date2Str(adCheckVo.getSignDate()), exNameSb);
            this.checkResult = false;
        } else {
            List<DynamicObject> collect = exRecordList.stream().filter(item -> WTCDateUtils.betweenDay((Date)item.getDate("recorddate"), (Date)shiftBelongDate, (Date)shiftBelongDate) && allowSuppleExIdSet.contains(item.getLong("exattributeid"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                this.setErrorMsg(adCheckVo, SupSignKDString.notHaveEx(), this.date2Str(adCheckVo.getSignDate()), exNameSb);
                this.checkResult = false;
            } else {
                this.checkCtrlByExProcess(adCheckVo, collect, exInfoMap);
            }
        }
    }

    private void checkCtrlByExProcess(AdCheckVo adCheckVo, List<DynamicObject> exRecordList, Map<Long, Boolean> exInfoMap) {
        Date shiftBelongDate = adCheckVo.getShiftBelongDate();
        for (DynamicObject exRecord : exRecordList) {
            if (!adCheckVo.isCheckPass()) {
                return;
            }
            long exAttributeId = exRecord.getLong("exattributeid");
            Boolean isCtrlByExProcess = exInfoMap.get(exAttributeId);
            long attItemId = exRecord.getLong("attitemid");
            if (isCtrlByExProcess == null || !isCtrlByExProcess.booleanValue()) continue;
            long exProcessId = exRecord.getLong("exprocessid");
            List<DynamicObject> exProcessList = this.exProcessMap.get(exProcessId);
            if (CollectionUtils.isEmpty(exProcessList)) {
                this.setErrorMsg(adCheckVo, SupSignKDString.exProcessNoAd(), this.date2Str(adCheckVo.getSignDate()));
                this.checkResult = false;
                return;
            }
            DynamicObject exProcess = WTCHisServiceHelper.getHisVersionDy((Date)shiftBelongDate, exProcessList);
            if (exProcess == null) {
                this.setErrorMsg(adCheckVo, SupSignKDString.exProcessNoAd(), this.date2Str(adCheckVo.getSignDate()));
                this.checkResult = false;
                return;
            }
            this.checkCtrlByExProcess(adCheckVo, exProcess, exAttributeId, attItemId);
        }
    }

    private void checkCtrlByExProcess(AdCheckVo adCheckVo, DynamicObject exProcess, long exAttributeId, long attItemId) {
        if (exProcess != null) {
            HashMap<Long, DynamicObjectCollection> attItemMap = new HashMap<Long, DynamicObjectCollection>(4);
            HashMap<Long, DynamicObjectCollection> attributeMap = new HashMap<Long, DynamicObjectCollection>(4);
            this.initExProcessAction(exProcess, attItemMap, attributeMap);
            DynamicObjectCollection dynsOfAttitem = (DynamicObjectCollection)attItemMap.get(attItemId);
            DynamicObjectCollection dynsOfAtttribution = (DynamicObjectCollection)attributeMap.get(exAttributeId);
            HashSet billTypeIds = Sets.newHashSetWithExpectedSize((int)attItemMap.size());
            if (attItemId > 0L && !CollectionUtils.isEmpty((Collection)dynsOfAttitem)) {
                billTypeIds.addAll(dynsOfAttitem.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList()));
            }
            if (exAttributeId > 0L && !CollectionUtils.isEmpty((Collection)dynsOfAtttribution)) {
                billTypeIds.addAll(dynsOfAtttribution.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList()));
            }
            if (!billTypeIds.contains(PreDataBillType.PD_SUPPLY_SIGN_ID)) {
                this.setErrorMsg(adCheckVo, SupSignKDString.exProcessNoAd(), this.date2Str(adCheckVo.getSignDate()));
                this.checkResult = false;
            }
        }
    }

    private void initExProcessAction(DynamicObject exProcess, Map<Long, DynamicObjectCollection> attItemMap, Map<Long, DynamicObjectCollection> attributeMap) {
        DynamicObjectCollection handleTypeColl = exProcess.getDynamicObjectCollection("entryentity");
        for (DynamicObject handleType : handleTypeColl) {
            DynamicObjectCollection attItems = handleType.getDynamicObjectCollection("attitem");
            for (DynamicObject attItem : attItems) {
                attItemMap.put(attItem.getLong("fbasedataid.id"), handleType.getDynamicObjectCollection("action"));
            }
            DynamicObjectCollection attributes = handleType.getDynamicObjectCollection("exattribute");
            for (DynamicObject attribute : attributes) {
                attributeMap.put(attribute.getLong("fbasedataid.id"), handleType.getDynamicObjectCollection("action"));
            }
        }
    }

    private void queryExProcess() {
        if (CollectionUtils.isEmpty(this.exRecordGroupByPersonMap)) {
            return;
        }
        HashSet exProcessBoIdSet = Sets.newHashSetWithExpectedSize((int)this.exRecordGroupByPersonMap.size());
        for (Map.Entry<Long, List<DynamicObject>> exRecordGroupEntry : this.exRecordGroupByPersonMap.entrySet()) {
            List<DynamicObject> value = exRecordGroupEntry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            Set boIdSets = value.stream().map(item -> item.getLong("exprocessid")).collect(Collectors.toSet());
            exProcessBoIdSet.addAll(boIdSets);
        }
        if (!CollectionUtils.isEmpty((Collection)exProcessBoIdSet)) {
            QFilter qFilterId = new QFilter("boid", "in", (Object)exProcessBoIdSet);
            QFilter qFilterVersion = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
            QFilter qFilter = WTCHisServiceHelper.dataStatusValidQFilter();
            QFilter[] qs = new QFilter[]{qFilterId, qFilterVersion, qFilter};
            HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)"wtp_exprocess");
            DynamicObject[] processArray = helper.loadDynamicObjectArray(qs);
            this.exProcessMap = Arrays.stream(processArray).collect(Collectors.groupingBy(item -> item.getLong("boid")));
        }
    }

    private void getRuleSetExInfo(DynamicObjectCollection exEntryColl, Set<Long> allowSuppleExIdSet, StringBuilder exNameSb, Map<Long, Boolean> exInfoMap) {
        int index = 0;
        for (DynamicObject dynamicObject : exEntryColl) {
            DynamicObject exDy = dynamicObject.getDynamicObject("exattribute");
            if (exDy == null) continue;
            long exAttId = exDy.getLong("id");
            boolean isCtrlByExProcess = dynamicObject.getBoolean("ctrlbyexprocess");
            exInfoMap.put(exAttId, isCtrlByExProcess);
            allowSuppleExIdSet.add(exDy.getLong("id"));
            if (index < 10) {
                exNameSb.append(exDy.getString("name")).append('\uff0c');
            }
            ++index;
        }
        int length = exNameSb.length();
        if (length > 0) {
            int start = exNameSb.length() - 1;
            exNameSb.replace(start, length, "");
            if (index > 10) {
                exNameSb.append("...");
            }
        }
    }

    private List<PlanRuleEngineOutParam> requestRuleEngine(List<AdCheckVo> remainAdCheckVoList) {
        ArrayList<PlanRuleEngineInParam> planRuleEngineParamList = new ArrayList<PlanRuleEngineInParam>(remainAdCheckVoList.size());
        for (AdCheckVo adCheckVo : remainAdCheckVoList) {
            DynamicObject planDy = adCheckVo.getAdPlanDy();
            DynamicObject attFileDy = adCheckVo.getAttFileVersion();
            if (!Objects.nonNull(attFileDy) || !"2".equals(adCheckVo.getAdPlanDy().getString("ruletype"))) continue;
            PlanRuleEngineInParam inParam = new PlanRuleEngineInParam();
            inParam.setAttFile(attFileDy);
            inParam.setShift(adCheckVo.getShift());
            inParam.setPlan(planDy);
            inParam.setDate(adCheckVo.getShiftBelongDate());
            planRuleEngineParamList.add(inParam);
        }
        if (!CollectionUtils.isEmpty(planRuleEngineParamList)) {
            return this.planRuleEngineService.batchCallRuleEngine(PlanSceneEnum.AD, planRuleEngineParamList);
        }
        return Collections.emptyList();
    }

    private List<DynamicObject> matchRule(DynamicObject planDy, Map<Long, List<DynamicObject>> ruleHisMap, List<PlanRuleEngineOutParam> outParamList, AdCheckVo adCheckVo) {
        List<Object> ruleList = null;
        String ruleType = planDy.getString("ruletype");
        if ("2".equals(ruleType)) {
            Optional ruleOptional = this.planRuleEngineService.getRuleFromRuleEngineParam(outParamList, planDy, adCheckVo.getShiftBelongDate(), adCheckVo.getAttFileVersion());
            if (ruleOptional.isPresent()) {
                ruleList = Collections.singletonList(ruleOptional.get());
            }
        } else {
            long ruleId = SignCardCommonService.getObjectId(planDy, "rule");
            ruleList = ruleHisMap.get(ruleId);
        }
        return ruleList;
    }
}

