/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.signcard.validator;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtpm.business.signcard.validator.AbstractSupSignCheckService;
import kd.wtc.wtpm.enums.SupSignCheckErrorMsgEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckContext;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class ShiftCheckService
extends AbstractSupSignCheckService {
    private static final Log LOG = LogFactory.getLog(ShiftCheckService.class);
    private boolean checkResult = true;

    public ShiftCheckService(AdCheckContext ctx) {
        super(ctx);
    }

    @Override
    public void init() {
        LOG.info("ShiftCheckService.init");
        if (this.remainAdCheckVoList != null) {
            return;
        }
        this.getRemainAdCheckVoList();
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return;
        }
        Date rangeBeginDate = (Date)this.ctx.getBillMaxDateRange().item1;
        Date rangeEndDate = (Date)this.ctx.getBillMaxDateRange().item2;
        DutyShiftResponse dutyShiftResponse = EvaluationServiceHelper.getDutyShiftsByAttFileBoId((List)this.attFileBoIdList, (Date)rangeBeginDate, (Date)rangeEndDate);
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            Optional optionalShift = dutyShiftResponse.getCurrShiftHis(adCheckVo.getAttFileId(), adCheckVo.getShiftBelongDate());
            if (!optionalShift.isPresent()) continue;
            Shift shift = (Shift)optionalShift.get();
            adCheckVo.setShift(shift);
        }
        LOG.info("ShiftCheckService.init.end");
    }

    @Override
    public boolean check() {
        if (CollectionUtils.isEmpty((Collection)this.remainAdCheckVoList)) {
            return true;
        }
        LOG.info("ShiftCheckService.check");
        for (AdCheckVo adCheckVo : this.remainAdCheckVoList) {
            this.checkShift(adCheckVo);
        }
        LOG.info("ShiftCheckService.check.end{}", (Object)this.checkResult);
        return this.checkResult;
    }

    private void checkShift(AdCheckVo adCheckVo) {
        Shift shift = adCheckVo.getShift();
        if (shift == null) {
            this.setErrorMsg(adCheckVo, SupSignCheckErrorMsgEnum.ShiftCheckNoShift, this.date2Str(adCheckVo.getSignDate()));
            this.checkResult = false;
        }
    }
}

