/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.supquotapool;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.proxy.Joiner;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.business.signcard.supplyapply.service.SupSignService;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolHelper;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolService;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;
import kd.wtc.wtpm.vo.suppleapply.CountSetCheckVo;
import kd.wtc.wtpm.vo.suppleapply.SupQuotaPoolVo;
import kd.wtc.wtpm.vo.suppleapply.SupSignCount;

public class SupQuotaPoolServiceImpl
implements SupQuotaPoolService {
    private String supCountCalType = SystemParamQueryUtil.getBillSystemParam().getSupCountCalType();

    @Override
    public String getLockKey(long attFileBoId) {
        return Joiner.on((char)'_').join((Iterable)Lists.newArrayList((Object[])new Serializable[]{"wtc", "wtpm", "AD", Long.valueOf(attFileBoId)}));
    }

    @Override
    public void getOrInitSupQuotaPool(List<AdCheckVo> adCheckVoList, String opKey) {
        LOG.info("SupQuotaPoolServiceImpl.getOrInitSupQuotaPool begin,opKey={}", (Object)opKey);
        HashSet signSet = Sets.newHashSetWithExpectedSize((int)adCheckVoList.size());
        this.getQuotaPoolSign(adCheckVoList, signSet);
        HashMap poolCacheMap = Maps.newHashMapWithExpectedSize((int)adCheckVoList.size());
        List<AdCheckVo> needNewPoolList = this.getNeedNewPoolList(adCheckVoList, signSet, poolCacheMap);
        if (!CollectionUtils.isEmpty(needNewPoolList) && !"card_match".equals(opKey)) {
            long[] longs = ID.genLongIds((int)needNewPoolList.size());
            long userId = RequestContext.get().getCurrUserId();
            for (int index = 0; index < needNewPoolList.size(); ++index) {
                AdCheckVo adCheckVo = needNewPoolList.get(index);
                this.newQuotaPool(adCheckVo, poolCacheMap, longs[index], userId);
            }
        }
        Collection poolDys = poolCacheMap.values();
        HashSet timeRangeDateSet = Sets.newHashSetWithExpectedSize((int)poolDys.size());
        HashSet attFileIdSet = Sets.newHashSetWithExpectedSize((int)poolDys.size());
        HashSet needInitPools = Sets.newHashSetWithExpectedSize((int)poolDys.size());
        for (DynamicObject poolDy : poolDys) {
            if (!this.isNeedInitPool(opKey, poolDy)) continue;
            timeRangeDateSet.add(poolDy.getDate("timescopebegin"));
            timeRangeDateSet.add(poolDy.getDate("timescopeend"));
            attFileIdSet.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)poolDy, (String)"attfile"));
            needInitPools.add(poolDy);
        }
        if (!CollectionUtils.isEmpty((Collection)needInitPools)) {
            List timeRangeDateList = timeRangeDateSet.stream().sorted().collect(Collectors.toList());
            Date minDate = (Date)timeRangeDateList.get(0);
            Date maxDate = (Date)timeRangeDateList.get(timeRangeDateList.size() - 1);
            Map<Long, List<SupSignCount>> submitBillCountMap = this.getSubmitBillCount(minDate, maxDate, attFileIdSet);
            Map<Long, List<SupSignCount>> usedBillCountMap = this.getUsedBillCount(minDate, maxDate, attFileIdSet);
            for (DynamicObject poolDy : needInitPools) {
                this.initSupQuotaPoolCount(poolDy, submitBillCountMap, usedBillCountMap);
            }
        }
        LOG.info("SupQuotaPoolServiceImpl.getOrInitSupQuotaPool end");
    }

    private boolean isNeedInitPool(String opKey, DynamicObject poolDy) {
        return poolDy != null && ("card_match".equals(opKey) || !poolDy.getDataEntityState().getFromDatabase());
    }

    private void getQuotaPoolSign(List<AdCheckVo> adCheckVoList, Set<String> signSet) {
        for (AdCheckVo adCheckVo : adCheckVoList) {
            Optional<String> signOptional;
            DynamicObject reason;
            Optional<CountSetCheckVo> countSetCheckVoOptional;
            DynamicObject countSetDy = adCheckVo.getCountSetDy();
            if (countSetDy == null || !(countSetCheckVoOptional = this.getCountSetCheckVo(reason = adCheckVo.getReason(), adCheckVo.getCountBeginDate(), adCheckVo.getCountEndDate(), countSetDy)).isPresent() || !(signOptional = this.getSupQuotaPoolSign(countSetCheckVoOptional.get(), adCheckVo.getAttFileId())).isPresent()) continue;
            String sign = signOptional.get();
            signSet.add(sign);
            adCheckVo.setSupQuotaPoolSign(sign);
        }
    }

    private List<AdCheckVo> getNeedNewPoolList(List<AdCheckVo> adCheckVoList, Set<String> signSet, Map<String, DynamicObject> poolCacheMap) {
        ArrayList<AdCheckVo> needNewPoolList = new ArrayList<AdCheckVo>(adCheckVoList.size());
        Map<String, DynamicObject> supQuotaPoolMap = SupQuotaPoolHelper.queryBySigns(signSet);
        for (AdCheckVo adCheckVo : adCheckVoList) {
            String supQuotaPoolSign = adCheckVo.getSupQuotaPoolSign();
            if (!HRStringUtils.isNotEmpty((String)supQuotaPoolSign)) continue;
            DynamicObject poolDy = supQuotaPoolMap.get(supQuotaPoolSign);
            if (poolDy != null) {
                adCheckVo.setSupQuotaPool(poolDy);
                poolCacheMap.put(supQuotaPoolSign, poolDy);
                continue;
            }
            needNewPoolList.add(adCheckVo);
        }
        return needNewPoolList;
    }

    private void newQuotaPool(AdCheckVo adCheckVo, Map<String, DynamicObject> poolCacheMap, long id, long userId) {
        String sign = adCheckVo.getSupQuotaPoolSign();
        if (HRStringUtils.isEmpty((String)sign)) {
            return;
        }
        DynamicObject poolDy = poolCacheMap.get(sign);
        if (poolDy != null) {
            if (HRStringUtils.isEmpty((String)poolDy.getString("sign"))) {
                adCheckVo.setSupQuotaPool(null);
            } else {
                adCheckVo.setSupQuotaPool(poolDy);
            }
        } else {
            long personId = adCheckVo.getPersonId();
            long attFileBoId = adCheckVo.getAttFileId();
            DynamicObject countSetDy = adCheckVo.getCountSetDy();
            Optional<CountSetCheckVo> countSetCheckVoOptional = this.getCountSetCheckVo(adCheckVo.getReason(), adCheckVo.getCountBeginDate(), adCheckVo.getCountEndDate(), countSetDy);
            poolDy = SupQuotaPoolHelper.genEmptyPoolDy();
            if (!countSetCheckVoOptional.isPresent()) {
                poolCacheMap.put(sign, poolDy);
            } else {
                poolDy.set("attperson", (Object)personId);
                poolDy.set("attfile", (Object)attFileBoId);
                CountSetCheckVo countSetCheckVo = countSetCheckVoOptional.get();
                poolDy.set("timescope", (Object)countSetCheckVo.getTimeScope());
                poolDy.set("timescopebegin", (Object)countSetCheckVo.getTimeScopeBegin());
                poolDy.set("timescopeend", (Object)countSetCheckVo.getTimeScopeEnd());
                poolDy.set("reason", (Object)countSetCheckVo.getReasonDy());
                poolDy.set("normalusable", (Object)countSetCheckVo.getCount());
                poolDy.set("aboveusable", (Object)countSetCheckVo.getAboveCount());
                poolDy.set("allowabove", (Object)countSetCheckVo.getAllowAbove());
                poolDy.set("sign", (Object)adCheckVo.getSupQuotaPoolSign());
                poolDy.set("isvalid", (Object)Boolean.TRUE);
                poolDy.set("id", (Object)id);
                poolDy.set("creator", (Object)userId);
                poolCacheMap.put(sign, poolDy);
                adCheckVo.setSupQuotaPool(poolDy);
            }
        }
    }

    @Override
    public void saveOrUpdateSupQuotaPool(long attFileBoId, List<AdCheckVo> adCheckVoList, String opKey) {
        LOG.info("SupQuotaPoolServiceImpl saveOrUpdateSupQuotaPool opkey:{}", (Object)opKey);
        ArrayList<SupQuotaPoolVo> supQuotaPoolVoList = new ArrayList<SupQuotaPoolVo>(adCheckVoList.size());
        HashSet signSet = Sets.newHashSetWithExpectedSize((int)adCheckVoList.size());
        HashSet reasonIds = Sets.newHashSetWithExpectedSize((int)adCheckVoList.size());
        HashSet signDateSet = Sets.newHashSetWithExpectedSize((int)adCheckVoList.size());
        for (AdCheckVo adCheckVo : adCheckVoList) {
            DynamicObject reason;
            if (!adCheckVo.isCheckPass()) continue;
            signDateSet.add(adCheckVo.getShiftBelongDate());
            String supQuotaPoolSign = adCheckVo.getSupQuotaPoolSign();
            DynamicObject supQuotaPool = adCheckVo.getSupQuotaPool();
            if (!HRStringUtils.isNotEmpty((String)supQuotaPoolSign) || supQuotaPool == null) continue;
            if (signSet.add(supQuotaPoolSign)) {
                SupQuotaPoolVo supQuotaPoolVo = new SupQuotaPoolVo(supQuotaPool);
                int applyCount = this.getApplyCount(adCheckVoList, supQuotaPoolVo);
                supQuotaPoolVo.setCount(applyCount);
                supQuotaPoolVoList.add(supQuotaPoolVo);
            }
            if ((reason = adCheckVo.getReason()) == null) continue;
            reasonIds.add(reason.getLong("id"));
        }
        HashSet poolIdSet = Sets.newHashSetWithExpectedSize((int)supQuotaPoolVoList.size());
        ArrayList<DynamicObject> needUpdatePoolList = new ArrayList<DynamicObject>(supQuotaPoolVoList.size());
        for (SupQuotaPoolVo quotaPoolVo : supQuotaPoolVoList) {
            DynamicObject supQuotaPool = quotaPoolVo.getSupQuotaPool();
            if (!"save".equals(opKey)) {
                this.calcSupQuotaPoolCount(supQuotaPool, opKey, quotaPoolVo.getCount());
            }
            needUpdatePoolList.add(supQuotaPool);
            poolIdSet.add(supQuotaPool.getLong("id"));
        }
        if (!"save".equals(opKey)) {
            SupQuotaPoolHelper.invalidByAttFileIdAndDate(attFileBoId, signDateSet, poolIdSet, reasonIds);
        }
        SupQuotaPoolHelper.updateSupQuotaPool(needUpdatePoolList);
    }

    public int getApplyCount(List<AdCheckVo> adCheckVoList, SupQuotaPoolVo supQuotaPoolVo) {
        DynamicObject supQuotaPool = supQuotaPoolVo.getSupQuotaPool();
        Date beginDate = supQuotaPool.getDate("timescopebegin");
        Date endDate = supQuotaPool.getDate("timescopeend");
        Long reasonId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)supQuotaPool, (String)"reason");
        return SignCardCommonService.getApplyCount(adCheckVoList, beginDate, endDate, reasonId);
    }

    private void calcSupQuotaPoolCount(DynamicObject supQuotaPool, String opKey, int count) {
        LOG.info("SupQuotaPoolServiceImpl.calcSupQuotaPoolCount begin,opKey:{},", (Object)opKey);
        switch (opKey) {
            case "submit": {
                this.calcSupQuotaPoolCount(supQuotaPool, 0, count);
                break;
            }
            case "submiteffect": 
            case "in_effective": {
                this.calcSupQuotaPoolCount(supQuotaPool, count, 0);
                break;
            }
            case "audit": {
                this.calcSupQuotaPoolCount(supQuotaPool, count, -1 * count);
                break;
            }
            case "unsubmit": 
            case "wfauditnotpass": 
            case "wfrejecttosubmit": {
                this.calcSupQuotaPoolCount(supQuotaPool, 0, -1 * count);
                break;
            }
            case "out_effective": {
                this.calcSupQuotaPoolCount(supQuotaPool, -1 * count, 0);
                break;
            }
        }
    }

    private void calcSupQuotaPoolCount(DynamicObject supQuotaPool, int used, int freeze) {
        int normalUsable = supQuotaPool.getInt("normalusable");
        int normalUsed = supQuotaPool.getInt("normalused");
        int normalFreeze = supQuotaPool.getInt("normalfreeze");
        int normalRemain = supQuotaPool.getInt("normalremain");
        int aboveUsable = supQuotaPool.getInt("aboveusable");
        int aboveUsed = supQuotaPool.getInt("aboveused");
        int aboveFreeze = supQuotaPool.getInt("abovefreeze");
        int aboveRemain = supQuotaPool.getInt("aboveremain");
        boolean isAllowAbove = "1".equals(supQuotaPool.getString("allowabove"));
        int allUsed = normalUsed + aboveUsed + used;
        int allFreeze = normalFreeze + aboveFreeze + freeze;
        if (isAllowAbove) {
            normalUsed = Math.max(0, Math.min(normalUsable, allUsed));
            normalFreeze = Math.max(0, Math.min(allFreeze, normalUsable - normalUsed));
            normalRemain = normalUsable - normalUsed - normalFreeze;
            aboveUsed = Math.max(0, allUsed - normalUsed);
            aboveFreeze = Math.max(0, allFreeze - normalFreeze);
            aboveRemain = Math.max(aboveUsable - aboveUsed - aboveFreeze, 0);
        } else {
            normalUsed = Math.max(0, allUsed);
            normalFreeze = Math.max(0, allFreeze);
            normalRemain = Math.max(normalUsable - normalUsed - normalFreeze, 0);
        }
        this.setPoolUsedFreeze(supQuotaPool, normalUsed, normalFreeze, normalRemain, aboveUsed, aboveFreeze, aboveRemain);
    }

    private void setPoolUsedFreeze(DynamicObject supQuotaPool, int normalUsed, int normalFreeze, int normalRemain, int aboveUsed, int aboveFreeze, int aboveRemain) {
        supQuotaPool.set("normalused", (Object)normalUsed);
        supQuotaPool.set("normalfreeze", (Object)normalFreeze);
        supQuotaPool.set("normalremain", (Object)normalRemain);
        supQuotaPool.set("aboveused", (Object)aboveUsed);
        supQuotaPool.set("abovefreeze", (Object)aboveFreeze);
        supQuotaPool.set("aboveremain", (Object)aboveRemain);
    }

    private void initSupQuotaPoolCount(DynamicObject poolDy, Map<Long, List<SupSignCount>> submitBillCountMap, Map<Long, List<SupSignCount>> usedBillCountMap) {
        int normalRemain;
        int normalFreeze;
        int normalUsed;
        long reasonId = SignCardCommonService.getObjectId(poolDy, "reason");
        long attFileBoId = SignCardCommonService.getObjectId(poolDy, "attfile");
        List<SupSignCount> submitBillCountList = submitBillCountMap.get(attFileBoId);
        List<SupSignCount> usedBillCountList = usedBillCountMap.get(attFileBoId);
        Date timeRangeBegin = poolDy.getDate("timescopebegin");
        Date timeRangeEnd = poolDy.getDate("timescopeend");
        int normalUsable = poolDy.getInt("normalusable");
        int aboveUsable = poolDy.getInt("aboveusable");
        boolean isAllowAbove = "1".equals(poolDy.getString("allowabove"));
        int submitCount = 0;
        int usedCount = 0;
        int aboveUsed = 0;
        int aboveFreeze = 0;
        int aboveRemain = 0;
        if (!CollectionUtils.isEmpty(submitBillCountList)) {
            submitCount = (int)SupSignService.getWaySupSingCount(submitBillCountList, timeRangeBegin, timeRangeEnd, reasonId);
        }
        if (!CollectionUtils.isEmpty(usedBillCountList)) {
            usedCount = (int)SupSignService.getWaySupSingCount(usedBillCountList, timeRangeBegin, timeRangeEnd, reasonId);
        }
        if (isAllowAbove) {
            normalUsed = Math.min(normalUsable, usedCount);
            normalFreeze = Math.min(submitCount, normalUsable - normalUsed);
            normalRemain = normalUsable - normalUsed - normalFreeze;
            aboveUsed = Math.max(0, usedCount - normalUsed);
            aboveFreeze = Math.max(0, submitCount - normalFreeze);
            aboveRemain = Math.max(aboveUsable - aboveUsed - aboveFreeze, 0);
        } else {
            normalUsed = Math.max(0, usedCount);
            normalFreeze = Math.max(0, submitCount);
            normalRemain = Math.max(normalUsable - normalUsed - normalFreeze, 0);
        }
        this.setPoolUsedFreeze(poolDy, normalUsed, normalFreeze, normalRemain, aboveUsed, aboveFreeze, aboveRemain);
    }

    private Map<Long, List<SupSignCount>> getSubmitBillCount(Date minDate, Date maxDate, Set<Long> attFileIdSet) {
        ArrayList submitBillStatus = Lists.newArrayList((Object[])new String[]{"B", "D"});
        Map<Long, List<SupSignCount>> submitBillCountMap = SupSignHelper.querySupSignList((Tuple<Date, Date>)new Tuple((Object)minDate, (Object)maxDate), attFileIdSet, submitBillStatus);
        LOG.info("SupQuotaPoolServiceImpl.getSubmitBillCount,minDate:{},maxDate:{},submitBillCountMap:{}", new Object[]{minDate, maxDate, submitBillCountMap});
        if (submitBillCountMap == null) {
            submitBillCountMap = new HashMap<Long, List<SupSignCount>>(0);
        }
        return submitBillCountMap;
    }

    private Map<Long, List<SupSignCount>> getUsedBillCount(Date minDate, Date maxDate, Set<Long> attFileIdSet) {
        Map<Long, List<SupSignCount>> usedBillCountMap = SupSignHelper.queryUsedBillCount((Tuple<Date, Date>)new Tuple((Object)minDate, (Object)maxDate), attFileIdSet, this.supCountCalType);
        LOG.info("SupQuotaPoolServiceImpl.getUsedBillCount,minDate:{},maxDate:{},submitBillCountMap:{}", new Object[]{minDate, maxDate, usedBillCountMap});
        if (usedBillCountMap == null) {
            usedBillCountMap = new HashMap<Long, List<SupSignCount>>(0);
        }
        return usedBillCountMap;
    }

    private Optional<String> getSupQuotaPoolSign(CountSetCheckVo countSetCheckVo, long attFileBoId) {
        if (countSetCheckVo == null) {
            return Optional.empty();
        }
        String timeScopeBegin = WTCDateUtils.date2Str((Date)countSetCheckVo.getTimeScopeBegin(), (String)"yyyy-MM-dd");
        String timeScopeEnd = WTCDateUtils.date2Str((Date)countSetCheckVo.getTimeScopeEnd(), (String)"yyyy-MM-dd");
        if (HRStringUtils.isEmpty((String)this.supCountCalType)) {
            this.supCountCalType = SystemParamQueryUtil.getBillSystemParam().getSupCountCalType();
        }
        List<Object> joinList = Lists.newArrayList((Object[])new Object[]{attFileBoId, this.supCountCalType, countSetCheckVo.getTimeScope(), timeScopeBegin, timeScopeEnd, countSetCheckVo.getLimitType(), countSetCheckVo.getReasonId(), countSetCheckVo.getAllowAbove(), countSetCheckVo.getCount(), countSetCheckVo.getAboveCount()});
        LOG.info("SupQuotaPoolServiceImpl.getSupQuotaPoolSign p1:{},p2:{}", (Object)countSetCheckVo.getAllowAbove(), (Object)countSetCheckVo.getAboveCount());
        joinList = joinList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        String join = Joiner.on((char)'_').join((Iterable)joinList);
        String sign = UUID.nameUUIDFromBytes(join.getBytes(StandardCharsets.UTF_8)).toString();
        return Optional.of(sign.replace("-", ""));
    }

    private Optional<CountSetCheckVo> getCountSetCheckVo(DynamicObject reasonDy, Date timeRangeBegin, Date timeRangeEnd, DynamicObject countSetDy) {
        int count = 0;
        int aboveCount = 0;
        String allowAbove = "0";
        String limitType = countSetDy.getString("limittype");
        String timeScope = "";
        if ("A".equals(limitType)) {
            count = countSetDy.getInt("count");
            allowAbove = countSetDy.getString("allowabove");
            if ("1".equals(allowAbove)) {
                aboveCount = countSetDy.getInt("abovecount");
            }
            timeScope = countSetDy.getString("countsco");
            reasonDy = null;
        } else {
            DynamicObjectCollection byReasonLimitColl;
            boolean hasMatchReason = false;
            if (reasonDy != null && !CollectionUtils.isEmpty((Collection)(byReasonLimitColl = countSetDy.getDynamicObjectCollection("entryentity")))) {
                long reasonId = reasonDy.getLong("id");
                for (DynamicObject byReasonDy : byReasonLimitColl) {
                    long byReasonId = SignCardCommonService.getObjectId(byReasonDy, "reason");
                    if (byReasonId != reasonId) continue;
                    count = byReasonDy.getInt("enticount");
                    allowAbove = byReasonDy.getString("entiallowabove");
                    if ("1".equals(allowAbove)) {
                        aboveCount = byReasonDy.getInt("entiabovecount");
                    }
                    timeScope = byReasonDy.getString("enticountsco");
                    hasMatchReason = true;
                    break;
                }
            }
            if (!hasMatchReason) {
                return Optional.empty();
            }
        }
        return Optional.of(new CountSetCheckVo(Integer.valueOf(count), Integer.valueOf(aboveCount), allowAbove, limitType, reasonDy, timeScope, timeRangeBegin, timeRangeEnd));
    }
}

