/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.business.supquotapool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.proxy.Joiner;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtpm.business.signcard.AdCheckService;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.job.BillJobDispatchService;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;
import kd.wtc.wtpm.vo.suppleapply.AdDispatchTaskParam;
import kd.wtc.wtpm.vo.suppleapply.AdTriggerMatch;

public class SupQuotaPoolTaskService {
    private static final Log LOG = LogFactory.getLog(SupQuotaPoolTaskService.class);

    private SupQuotaPoolTaskService() {
    }

    public static List<AdTriggerMatch> getSupInfoByAdjoinDate(List<AdCheckVo> adCheckVoList) {
        Map<Long, List<AdCheckVo>> attFileAdCheckVoMap = adCheckVoList.stream().collect(Collectors.groupingBy(AdCheckVo::getAttFileId));
        ArrayList<AdTriggerMatch> adTriggerMatches = new ArrayList<AdTriggerMatch>(adCheckVoList.size());
        for (Map.Entry<Long, List<AdCheckVo>> adCheckVoEntry : attFileAdCheckVoMap.entrySet()) {
            adCheckVoEntry.getValue().sort(Comparator.comparing(AdCheckVo::getShiftBelongDate));
            AdTriggerMatch adTriggerMatch = null;
            for (AdCheckVo adCheckVo : adCheckVoEntry.getValue()) {
                Date shiftDate = adCheckVo.getShiftBelongDate();
                if (adTriggerMatch == null) {
                    adTriggerMatch = new AdTriggerMatch();
                    adTriggerMatch.setStartDate(shiftDate);
                    adTriggerMatch.setEndDate(shiftDate);
                    adTriggerMatch.getAttFileIds().add(adCheckVo.getAttFileId());
                    adTriggerMatch.getAttPersonIds().add(adCheckVo.getPersonId());
                    adTriggerMatches.add(adTriggerMatch);
                    continue;
                }
                if (shiftDate.getTime() - adTriggerMatch.getEndDate().getTime() > 86400000L) {
                    adTriggerMatch = new AdTriggerMatch();
                    adTriggerMatch.setStartDate(shiftDate);
                    adTriggerMatch.setEndDate(shiftDate);
                    adTriggerMatch.getAttFileIds().add(adCheckVo.getAttFileId());
                    adTriggerMatch.getAttPersonIds().add(adCheckVo.getPersonId());
                    adTriggerMatches.add(adTriggerMatch);
                    continue;
                }
                adTriggerMatch.setEndDate(shiftDate);
            }
        }
        ArrayList<AdTriggerMatch> joinAdTriggerMatches = new ArrayList<AdTriggerMatch>(adTriggerMatches.size());
        for (int index = 0; index < adTriggerMatches.size(); ++index) {
            AdTriggerMatch triggerMatch = (AdTriggerMatch)adTriggerMatches.get(index);
            if (triggerMatch.isMerged()) continue;
            for (int jj = index + 1; jj < adTriggerMatches.size(); ++jj) {
                AdTriggerMatch match = (AdTriggerMatch)adTriggerMatches.get(jj);
                if (match.isMerged() || triggerMatch.getEndDate().compareTo(match.getEndDate()) != 0 || triggerMatch.getStartDate().compareTo(match.getStartDate()) != 0) continue;
                triggerMatch.getAttFileIds().addAll(match.getAttFileIds());
                triggerMatch.getAttPersonIds().addAll(match.getAttPersonIds());
                match.setMerged(true);
            }
            triggerMatch.setMerged(true);
            joinAdTriggerMatches.add(triggerMatch);
        }
        return joinAdTriggerMatches;
    }

    public static void updateQuotaPoolByCardMatch(AdDispatchTaskParam params) {
        LOG.info("SupQuotaPoolTaskService.updateQuotaPoolByMatch begin");
        StopWatch stopWatch = StopWatch.createStarted();
        Date startDate = params.getStartDate();
        Date endDate = params.getEndDate();
        Set attPersonIds = params.getDataIds();
        DynamicObject[] signCards = SupSignHelper.querySignCardByIds(startDate, endDate, attPersonIds);
        ArrayList<AdCheckVo> allAdCheckVoList = new ArrayList<AdCheckVo>(signCards.length);
        HashSet attFileBoSignDateSet = Sets.newHashSetWithExpectedSize((int)signCards.length);
        for (DynamicObject signCard : signCards) {
            DynamicObject personDy;
            DynamicObject attFile = signCard.getDynamicObject("attfilebo");
            if (attFile == null) continue;
            Date signPoint = WTCDateUtils.getZeroDate((Date)signCard.getDate("signpoint"));
            DynamicObject reasonDy = signCard.getDynamicObject("applyreason");
            String attFileBoSignDate = SupQuotaPoolTaskService.getJoinRepeatKey(attFile, reasonDy, signPoint);
            if (!attFileBoSignDateSet.add(attFileBoSignDate) || (personDy = signCard.getDynamicObject("attperson")) == null) continue;
            AdCheckVo adCheckVo = new AdCheckVo();
            adCheckVo.setPersonId(Long.valueOf(personDy.getLong("id")));
            adCheckVo.setPersonName(personDy.getString("name"));
            long attFileBoId = attFile.getLong("boid");
            adCheckVo.setAttFileId(Long.valueOf(attFileBoId));
            adCheckVo.setAttFile(attFile);
            adCheckVo.setSignDate(signPoint);
            adCheckVo.setShiftBelongDate(SignCardCommonService.getShiftBelongDate(adCheckVo.getSignDate(), signCard.getString("pointtag")));
            adCheckVo.setReason(reasonDy);
            adCheckVo.setSupSignInfoId(Long.valueOf(signCard.getLong("id")));
            allAdCheckVoList.add(adCheckVo);
        }
        if (!CollectionUtils.isEmpty(allAdCheckVoList)) {
            AdCheckService.initCalcAdCheckVoQuotaPool(allAdCheckVoList, "card_match", SignCardBillTypeEnum.SUPSIGN_BATCHBILL);
            LOG.info("SupQuotaPoolTaskService.updateQuotaPoolByMatch allAdCheckVoList size:{}", (Object)allAdCheckVoList.size());
        }
        stopWatch.stop();
        LOG.info("SupQuotaPoolTaskService.updateQuotaPoolByMatch end use time:{}", (Object)stopWatch.getTime());
    }

    private static String getJoinRepeatKey(DynamicObject attFile, DynamicObject reasonDy, Date signPoint) {
        long attFileId = attFile == null ? 0L : attFile.getLong("id");
        long reasonId = reasonDy == null ? 0L : reasonDy.getLong("id");
        return Joiner.on((char)'_').join((Object)attFileId, (Object)signPoint.getTime(), new Object[]{reasonId});
    }

    public static void dispatchUpdateQuotaPoolTask(DynamicObject[] dataEntities, String opKey, SignCardBillTypeEnum billType, boolean isSync) {
        SupQuotaPoolTaskService.dispatchUpdateQuotaPoolTask(dataEntities, opKey, billType, isSync, true);
    }

    public static void dispatchUpdateQuotaPoolTask(DynamicObject[] dataEntities, String opKey, SignCardBillTypeEnum billType, boolean isSync, boolean needGenSignCard) {
        List billIdList = Arrays.stream(dataEntities).map(item -> item.getLong("id")).collect(Collectors.toList());
        AdDispatchTaskParam param = new AdDispatchTaskParam();
        param.setClassName("kd.wtc.wtpm.business.signcard.job.AdUpdatePoolTask");
        param.setBillType(billType);
        param.setOpType(opKey);
        param.setDataIds((Set)Sets.newHashSet(billIdList));
        param.setSync(isSync);
        param.setNeedGenSignCard(needGenSignCard);
        BillJobDispatchService.dispatchBillTask(param);
    }

    public static void updateAdQuotaPool(Date startDate, Date endDate, Set<Long> attPersonIds, boolean isAync) {
        LOG.info("SupQuotaPoolTaskService.updateAdQuotaPool signCardIds size :{}", (Object)attPersonIds.size());
        boolean calcCountBySignCard = SignCardBatchService.isCalcCountBySignCard();
        if (!CollectionUtils.isEmpty(attPersonIds) && !calcCountBySignCard) {
            AdDispatchTaskParam adDispatchTaskParam = new AdDispatchTaskParam();
            adDispatchTaskParam.setDataIds(attPersonIds);
            adDispatchTaskParam.setStartDate(startDate);
            adDispatchTaskParam.setEndDate(endDate);
            adDispatchTaskParam.setOpType("card_match");
            adDispatchTaskParam.setClassName("kd.wtc.wtpm.business.signcard.job.AdUpdatePoolTask");
            adDispatchTaskParam.setSync(isAync);
            BillJobDispatchService.dispatchBillTask(adDispatchTaskParam);
        }
    }
}

