/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.mservice;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sdk.wtc.wtp.business.adplan.AdPlanRuleQuery;
import kd.sdk.wtc.wtp.business.adplan.AdPlanRuleResp;
import kd.wtc.wtbs.business.web.billservice.common.BillSetCommonService;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.business.web.billservice.rule.BillRuleService;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.model.billservice.BillDutyDatePlanInfo;
import kd.wtc.wtbs.common.model.billservice.BillDutyDateRuleInfo;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtpm.mservice.api.IAdPlanService;

public class AdPlanServiceImpl
implements IAdPlanService {
    public List<AdPlanRuleResp> getAdPlanAndRule(List<AdPlanRuleQuery> adPlanRuleParams) {
        if (WTCCollections.isEmpty(adPlanRuleParams)) {
            return new ArrayList<AdPlanRuleResp>(0);
        }
        List<BillDutyDatePlanInfo> billDutyDatePlanInfos = this.convertToBillPlanServiceParams(adPlanRuleParams);
        BillPlanService billPlanService = BillPlanService.getInstance();
        billPlanService.fillPlanByAttFileAndDate(billDutyDatePlanInfos, AttFileScheduleEnum.AD, "wtp_suppleplan");
        List<BillDutyDateRuleInfo> billDutyDateRuleInfos = this.convertToBillRuleServiceParams(billDutyDatePlanInfos);
        BillRuleService billRuleService = new BillRuleService();
        billRuleService.fillRuleDy(billDutyDateRuleInfos, PlanSceneEnum.AD, "rule", "wtp_supplerule", true);
        return this.setResultToRequestParams(billDutyDatePlanInfos, billDutyDateRuleInfos, adPlanRuleParams);
    }

    private List<BillDutyDatePlanInfo> convertToBillPlanServiceParams(List<AdPlanRuleQuery> adPlanRuleParams) {
        ArrayList<BillDutyDatePlanInfo> result = new ArrayList<BillDutyDatePlanInfo>(adPlanRuleParams.size());
        for (AdPlanRuleQuery adPlanRuleParam : adPlanRuleParams) {
            result.add(new BillDutyDatePlanInfo(adPlanRuleParam.getAttFileBoId(), adPlanRuleParam.getAdDate()));
        }
        return result;
    }

    private List<BillDutyDateRuleInfo> convertToBillRuleServiceParams(List<BillDutyDatePlanInfo> billDutyDatePlanInfos) {
        ArrayList<BillDutyDateRuleInfo> result = new ArrayList<BillDutyDateRuleInfo>(billDutyDatePlanInfos.size());
        for (int index = 0; index < billDutyDatePlanInfos.size(); ++index) {
            BillDutyDatePlanInfo billDutyDatePlanInfo = billDutyDatePlanInfos.get(index);
            BillDutyDateRuleInfo ruleInfo = new BillDutyDateRuleInfo(billDutyDatePlanInfo.getAttFileBoId(), billDutyDatePlanInfo.getQueryDate(), billDutyDatePlanInfo.getPlanDy(), Long.valueOf(0L));
            result.add(ruleInfo);
        }
        return result;
    }

    private List<AdPlanRuleResp> setResultToRequestParams(List<BillDutyDatePlanInfo> billDutyDatePlanInfos, List<BillDutyDateRuleInfo> billDutyDateRuleInfos, List<AdPlanRuleQuery> adPlanRuleParams) {
        ArrayList<AdPlanRuleResp> respList = new ArrayList<AdPlanRuleResp>(adPlanRuleParams.size());
        ArrayList<DynamicObject> engineQuery = new ArrayList<DynamicObject>(10);
        for (BillDutyDatePlanInfo billDutyDatePlanInfo : billDutyDatePlanInfos) {
            if (billDutyDatePlanInfo.getPlanDy() == null) continue;
            engineQuery.add(billDutyDatePlanInfo.getPlanDy());
        }
        Map planIdAndUseEngine = BillPlanService.getInstance().usePlanEngine(engineQuery);
        for (int index = 0; index < adPlanRuleParams.size(); ++index) {
            Tuples.Tuple2 ruleRange;
            BillDutyDateRuleInfo billDutyDateRuleInfo;
            if (index >= billDutyDateRuleInfos.size() || (billDutyDateRuleInfo = billDutyDateRuleInfos.get(index)) == null) continue;
            DynamicObject attFileVersionDy = billDutyDateRuleInfo.getAttFileVersionDy();
            DynamicObject planVersionDy = billDutyDateRuleInfo.getPlanDy();
            boolean usedEngine = false;
            if (planVersionDy != null) {
                usedEngine = (Boolean)planIdAndUseEngine.get(planVersionDy.getLong("id"));
            }
            AdPlanRuleResp adPlanRuleResp = new AdPlanRuleResp(adPlanRuleParams.get(index), billDutyDateRuleInfo.getPlanDy(), billDutyDateRuleInfo.getRuleDy());
            String engineCondition = usedEngine ? "usedEngine" : "";
            DynamicObject ruleVersionDy = billDutyDateRuleInfo.getRuleDy();
            Optional sideDyOption = BillPlanService.getInstance().getSideDy(billDutyDatePlanInfos, billDutyDateRuleInfo.getAttFileBoId(), billDutyDateRuleInfo.getQueryDate());
            DynamicObject sideDy = sideDyOption.orElse(null);
            LocalDate baseDate = WTCDateUtils.toLocalDate((Date)billDutyDateRuleInfo.getQueryDate());
            Tuples.Tuple2 planRange = BillSetCommonService.getInstance().splitHisPlanRange(attFileVersionDy, sideDy, planVersionDy, baseDate);
            if (planRange != null) {
                if (planRange.item1 != null) {
                    adPlanRuleResp.setPlanEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)planRange.item1)));
                }
                if (planRange.item2 != null) {
                    adPlanRuleResp.setPlanEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)planRange.item2)));
                }
            }
            if ((ruleRange = BillSetCommonService.getInstance().splitHisRuleRange(attFileVersionDy, sideDy, planVersionDy, engineCondition, ruleVersionDy, baseDate)) != null) {
                if (ruleRange.item1 != null) {
                    adPlanRuleResp.setRuleEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)ruleRange.item1)));
                }
                if (ruleRange.item2 != null) {
                    adPlanRuleResp.setRuleEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)ruleRange.item2)));
                }
            }
            respList.add(adPlanRuleResp);
        }
        return respList;
    }
}

