/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.mservice;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.sdk.wtc.wtpm.business.cardmatch.CardMatchTaskParam;
import kd.wtc.wtbs.business.shift.ShiftService;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.sign.EffectiveCardVo;
import kd.wtc.wtbs.common.model.sign.MultiCardEntryDTO;
import kd.wtc.wtbs.common.model.sign.SignCardDTO;
import kd.wtc.wtbs.common.model.sign.SignCardDailyResp;
import kd.wtc.wtbs.common.model.sign.TakeCardRule;
import kd.wtc.wtpm.business.cardmatch.CardMatchServiceImpl;
import kd.wtc.wtpm.business.cardmatch.SignCardService;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;
import kd.wtc.wtpm.mservice.api.ISignCardService;

public class SignCardServiceImpl
implements ISignCardService,
CardMatchConstants {
    private static final Log LOG = LogFactory.getLog(SignCardServiceImpl.class);

    public Map<Date, Map<String, Object>> getSignCardDetail(Long attPersonId, Date startDate, Date endDate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignCardDetail, personId:{}, startDate:{}, endDate:{}", new Object[]{attPersonId, startDate, endDate});
        }
        SignCardService service = new SignCardService();
        Map result = service.getShiftAndSignCardDetail(attPersonId, startDate, endDate);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignCardDetail,\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)result));
        }
        return result;
    }

    public Map<Long, Map<Date, Map<String, Object>>> getSignCardDetailByAttFileBoIds(Map<Long, Map<String, Date>> req) {
        if (HRMapUtils.isEmpty(req)) {
            LOG.warn("getSignCardDetailByAttFileBoIds, request is empty");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignCardDetailByAttFileBoIds, request:{}", (Object)JSON.toJSONString(req));
        }
        SignCardService service = new SignCardService();
        Map result = service.getSignCardDetailByAttFileBoIds(req);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignCardDetailByAttFileBoIds,\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)result));
        }
        return result;
    }

    private DynamicObject[] getEffectiveManyCard(Long fileboId, Date startDate, Date endDate) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_multicard");
        QFilter minDateQFilter = new QFilter("shiftdate", ">=", (Object)startDate);
        QFilter maxDateQFilter = new QFilter("shiftdate", "<=", (Object)endDate);
        QFilter idQFilter = new QFilter("attfile.boid", "=", (Object)fileboId);
        HasPermOrgResult allPermOrgs = WTCPermUtils.getAllPermOrgs((String)"wtpm", (String)"wtpm_multicard");
        QFilter orginFilter = null;
        if (!allPermOrgs.hasAllOrgPerm() && allPermOrgs.getHasPermOrgs() != null) {
            orginFilter = new QFilter("org", "in", (Object)allPermOrgs.getHasPermOrgs());
        }
        return helper.loadDynamicObjectArray(new QFilter[]{idQFilter, minDateQFilter, maxDateQFilter, orginFilter});
    }

    private DynamicObject[] getEffectiveOneCard(Long fileboId, Date startDate, Date endDate) {
        HRBaseServiceHelper oneCardserviceHelper = new HRBaseServiceHelper("wtpm_oncecard");
        QFilter minDateQFilter = new QFilter("shiftdate", ">=", (Object)startDate);
        QFilter maxDateQFilter = new QFilter("shiftdate", "<=", (Object)endDate);
        QFilter idQFilter = new QFilter("attfile.boid", "=", (Object)fileboId);
        HasPermOrgResult allPermOrgs = WTCPermUtils.getAllPermOrgs((String)"wtpm", (String)"wtpm_oncecard");
        QFilter orginFilter = null;
        if (!allPermOrgs.hasAllOrgPerm() && allPermOrgs.getHasPermOrgs() != null) {
            orginFilter = new QFilter("org", "in", (Object)allPermOrgs.getHasPermOrgs());
        }
        return oneCardserviceHelper.loadDynamicObjectArray(new QFilter[]{idQFilter, minDateQFilter, maxDateQFilter, orginFilter});
    }

    private DynamicObject[] getEffectiveCheckCard(Long fileboId, Date startDate, Date endDate) {
        HRBaseServiceHelper checkCardserviceHelper = new HRBaseServiceHelper("wtpm_checkcard");
        QFilter minDateQFilter = new QFilter("shiftdate", ">=", (Object)startDate);
        QFilter maxDateQFilter = new QFilter("shiftdate", "<=", (Object)endDate);
        QFilter idQFilter = new QFilter("attfile.boid", "=", (Object)fileboId);
        HasPermOrgResult allPermOrgs = WTCPermUtils.getAllPermOrgs((String)"wtpm", (String)"wtpm_checkcard");
        QFilter orginFilter = null;
        if (!allPermOrgs.hasAllOrgPerm() && allPermOrgs.getHasPermOrgs() != null) {
            orginFilter = new QFilter("org", "in", (Object)allPermOrgs.getHasPermOrgs());
        }
        return checkCardserviceHelper.loadDynamicObjectArray(new QFilter[]{idQFilter, minDateQFilter, maxDateQFilter, orginFilter});
    }

    public List<EffectiveCardVo> getEffectiveCard(Long fileId, Date startDate, Date endDate) {
        DynamicObject[] effectiveOneCardDys;
        DynamicObject[] effectManyCardDys = this.getEffectiveManyCard(fileId, startDate, endDate);
        ArrayList<EffectiveCardVo> effectiveCardVoList = new ArrayList<EffectiveCardVo>(10);
        this.getEffctManyCard(effectManyCardDys, effectiveCardVoList);
        for (DynamicObject oneCardDy : effectiveOneCardDys = this.getEffectiveOneCard(fileId, startDate, endDate)) {
            EffectiveCardVo effectiveCardVo = new EffectiveCardVo();
            effectiveCardVo.setEffectiveCardDate(oneCardDy.getDate("oncepoint"));
            effectiveCardVo.setEffectiveCardType(Integer.valueOf(2));
            effectiveCardVo.setSourceId(Long.valueOf(oneCardDy.getLong("source.id")));
            effectiveCardVo.setShiftDate(oneCardDy.getDate("shiftdate"));
            effectiveCardVo.setAttCard(oneCardDy.getString("attcard"));
            effectiveCardVoList.add(effectiveCardVo);
        }
        DynamicObject[] effectiveCheckCardDys = this.getEffectiveCheckCard(fileId, startDate, endDate);
        this.getEffectiveCheck(effectiveCardVoList, effectiveCheckCardDys);
        effectiveCardVoList.sort((a1, a2) -> {
            int compare = a1.getShiftDate().compareTo(a2.getShiftDate());
            if (compare == 0) {
                if (null == a1.getEffectiveCardDate() && null != a2.getEffectiveCardDate()) {
                    return -1;
                }
                if (null != a1.getEffectiveCardDate() && null == a2.getEffectiveCardDate()) {
                    return 1;
                }
                if (null == a1.getEffectiveCardDate() && null == a2.getEffectiveCardDate()) {
                    return 0;
                }
                return a1.getEffectiveCardDate().compareTo(a2.getEffectiveCardDate());
            }
            return compare;
        });
        return effectiveCardVoList;
    }

    public List<MultiCardEntryDTO> getEffectiveCard(List<SignCardDTO> signCardList, Long shiftId, TakeCardRule takeCardRule, Date matchDate) {
        CardMatchServiceImpl service = new CardMatchServiceImpl();
        LocalDate localDate = matchDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        ShiftService shiftService = new ShiftService();
        ArrayList<Long> shiftIdList = new ArrayList<Long>();
        shiftIdList.add(shiftId);
        Map shiftMap = shiftService.getShiftEvalVoMapByVids(shiftIdList);
        Shift shift = (Shift)shiftMap.get(shiftId);
        return CardMatchServiceImpl.getEffectiveCard(signCardList, (Shift)shift, (TakeCardRule)takeCardRule, (LocalDate)localDate);
    }

    public SignCardDailyResp getSignCardDaily(Date date, Set<Long> attFileBoIds) {
        if (null == date || CollectionUtils.isEmpty(attFileBoIds)) {
            LOG.info("getSignCardDaily, request is illegal");
            return null;
        }
        LOG.info("getSignCardDaily, date:{}, attFileBoIdSize:{}", (Object)date, (Object)attFileBoIds.size());
        SignCardService service = new SignCardService();
        SignCardDailyResp result = service.getSignCardDaily(date, attFileBoIds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignCardDaily,\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)result));
        }
        return result;
    }

    public Map<Long, Boolean> getStopAttendanceEffectiveCards(Map<Long, Map<String, Date>> request) {
        if (null == request || HRMapUtils.isEmpty(request)) {
            LOG.info("getStopAttendanceEffectiveCard, request is illegal");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getStopAttendanceEffectiveCard, request:{}", (Object)JSON.toJSONString(request));
        }
        SignCardService service = new SignCardService();
        Map result = service.getStopAttendanceEffectiveCards(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getStopAttendanceEffectiveCard,response{}", (Object)JSON.toJSONString(request));
        }
        return result;
    }

    public void executeCardMatchTask(CardMatchTaskParam taskParam) {
        if (null == taskParam || null == taskParam.getStartDate() || null == taskParam.getEndDate()) {
            LOG.info("executeCardMatchTask, request is illegal");
            return;
        }
        LOG.info("executeCardMatchTask, start:{}");
        SignCardService service = new SignCardService();
        service.startMatch(taskParam);
        LOG.info("executeCardMatchTask,end");
    }

    public void invalidEffectiveCards(Set<Long> attFileBoIds) {
        if (HRCollUtil.isEmpty(attFileBoIds)) {
            LOG.info("invalidEffectiveCards, request is illegal");
            return;
        }
        LOG.info("invalidEffectiveCards, request.size:{}", (Object)attFileBoIds.size());
        SignCardService service = new SignCardService();
        service.invalidEffectiveCards(attFileBoIds);
    }

    public void invalidLackCards(Set<Long> attFileBoIds) {
        if (HRCollUtil.isEmpty(attFileBoIds)) {
            LOG.info("invalidEffectiveCards, request is illegal");
            return;
        }
        LOG.info("invalidEffectiveCards, request.size:{}", (Object)attFileBoIds.size());
        SignCardService service = new SignCardService();
        service.invalidLackCards(attFileBoIds);
    }

    private void getEffectiveCheck(List<EffectiveCardVo> effectiveCardVoList, DynamicObject[] effectiveCheckCardDys) {
        for (DynamicObject checkCardDy : effectiveCheckCardDys) {
            DynamicObjectCollection entryentity = checkCardDy.getDynamicObjectCollection("entryentity");
            if (entryentity == null || entryentity.isEmpty()) continue;
            Date shiftDate = checkCardDy.getDate("shiftdate");
            String attCard = checkCardDy.getString("attcard");
            for (DynamicObject dynamicObject : entryentity) {
                EffectiveCardVo effectiveCardVo = new EffectiveCardVo();
                effectiveCardVo.setEffectiveCardDate(dynamicObject.getDate("checkpoint"));
                effectiveCardVo.setEffectiveCardType(Integer.valueOf(3));
                effectiveCardVo.setShiftDate(shiftDate);
                effectiveCardVo.setAttCard(attCard);
                effectiveCardVo.setSourceId(Long.valueOf(dynamicObject.getLong("source.id")));
                effectiveCardVoList.add(effectiveCardVo);
            }
        }
    }

    private void getEffctManyCard(DynamicObject[] effectManyCardDys, List<EffectiveCardVo> effectiveCardVoList) {
        for (DynamicObject effectCardDy : effectManyCardDys) {
            DynamicObjectCollection entryentity = effectCardDy.getDynamicObjectCollection("entryentity");
            if (entryentity == null || entryentity.isEmpty()) continue;
            Date shiftDate = effectCardDy.getDate("shiftdate");
            String attCard = effectCardDy.getString("attcard");
            for (DynamicObject dynamicObject : entryentity) {
                EffectiveCardVo effectiveCardVo = new EffectiveCardVo();
                effectiveCardVo.setEffectiveCardDate(dynamicObject.getDate("effectivepoint"));
                effectiveCardVo.setEffectiveCardType(Integer.valueOf(1));
                effectiveCardVo.setMustpoint(dynamicObject.getDate("mustpoint"));
                effectiveCardVo.setSourceId(Long.valueOf(dynamicObject.getLong("source.id")));
                effectiveCardVo.setPointDescId(Long.valueOf(dynamicObject.getLong("pointdesc.id")));
                effectiveCardVo.setMustPointDesc(dynamicObject.getString("mustpointdesc"));
                effectiveCardVo.setShiftDate(shiftDate);
                effectiveCardVo.setAttCard(attCard);
                effectiveCardVoList.add(effectiveCardVo);
            }
        }
    }
}

