/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.wtc.wtbs.business.model.EffectiveEntityVo;
import kd.wtc.wtbs.business.model.PersonHasBillVo;
import kd.wtc.wtbs.common.bill.SupplePolicy;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtpm.business.mobile.suppleapply.IMobileSupSignService;
import kd.wtc.wtpm.business.mobile.suppleapply.MobileSupSignServiceImpl;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.job.BillJobDispatchService;
import kd.wtc.wtpm.mservice.api.ISupSignService;
import kd.wtc.wtpm.vo.suppleapply.AdDispatchTaskParam;

public class SupSignServiceImpl
implements ISupSignService {
    private static final IMobileSupSignService SERVICE = new MobileSupSignServiceImpl();
    private static final Log LOG = LogFactory.getLog(SignCardBatchService.class);

    public String getPolicyByReason(long attFileBoId, long reasonId, Date signDate) {
        Optional policyByReason = SERVICE.getSupplePolicyByReason(attFileBoId, reasonId, signDate);
        if (policyByReason.isPresent()) {
            return ((SupplePolicy)policyByReason.get()).getPolicyContent();
        }
        return "";
    }

    public SupplePolicy getSupplePolicyByReason(long attFileBoId, long reasonId, Date signDate) {
        Optional policyByReason = SERVICE.getSupplePolicyByReason(attFileBoId, reasonId, signDate);
        return policyByReason.orElseGet(SupplePolicy::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EffectiveEntityVo> getSupsign(Long attfileBoId, Date startDate, Date endDate) {
        LOG.info("SupSignServiceImpl.getSupsign begin");
        DataSet singleDataSet = null;
        DataSet batchDataSet = null;
        DataSet union = null;
        try {
            Date sDate = WTCDateUtils.getZeroDate((Date)WTCDateUtils.addDays((Date)startDate, (int)-1));
            Date eDate = WTCDateUtils.getLatestDate((Date[])new Date[]{WTCDateUtils.addDays((Date)endDate, (int)1)});
            String algoKey = this.getClass().getName();
            QFilter attFileFilter = new QFilter("attfile", "=", (Object)attfileBoId);
            QFilter singleBillStatusFilter = new QFilter("billstatus", "=", (Object)"C");
            QFilter singleDateFilter = new QFilter("entryentity.signdate", ">=", (Object)sDate);
            singleDateFilter.and(new QFilter("entryentity.signdate", "<=", (Object)eDate));
            String selectFields = "id,billno,entryentity.signdate signdate,entryentity.pointtag pointtag,applytyperadio applytype";
            singleDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"wtpm_supsignpc", (String)selectFields, (QFilter[])new QFilter[]{singleBillStatusFilter, singleDateFilter, attFileFilter}, null);
            QFilter batchBillStatusFilter = new QFilter("billid.billstatus", "=", (Object)"C");
            QFilter batchDateFilter = new QFilter("supsigninfo.signdate", ">=", (Object)sDate);
            singleDateFilter.and(new QFilter("supsigninfo.signdate", "<=", (Object)eDate));
            String batchSelectFields = "billid.id id,billno,supsigninfo.signdate signdate,supsigninfo.pointtag pointtag,billid.applytype applytype";
            batchDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"wtpm_supsignlist", (String)batchSelectFields, (QFilter[])new QFilter[]{batchBillStatusFilter, batchDateFilter, attFileFilter}, null);
            union = singleDataSet.union(batchDataSet);
            ArrayList<EffectiveEntityVo> effectiveEntityVos = new ArrayList<EffectiveEntityVo>(16);
            while (union.hasNext()) {
                Row next = union.next();
                String pointtag = next.getString("pointtag");
                Date date = next.getDate("signdate");
                Date shiftBelongDate = SignCardCommonService.getShiftBelongDate((Date)date, (String)pointtag);
                if (shiftBelongDate == null || shiftBelongDate.getTime() < startDate.getTime() || shiftBelongDate.getTime() > endDate.getTime()) continue;
                EffectiveEntityVo effectiveEntityVo = new EffectiveEntityVo();
                effectiveEntityVo.setId(next.getLong("id"));
                effectiveEntityVo.setBillno(next.getString("billno"));
                effectiveEntityVo.setStartDate(shiftBelongDate);
                effectiveEntityVo.setEndDate(shiftBelongDate);
                effectiveEntityVo.setFormId(this.getEntityNumberByApplyType(next.getString("applytype")));
                effectiveEntityVos.add(effectiveEntityVo);
            }
            LOG.info("SupSignServiceImpl.getSupsign effectiveEntityVos size:{}", (Object)effectiveEntityVos.size());
            ArrayList<EffectiveEntityVo> arrayList = effectiveEntityVos;
            return arrayList;
        }
        finally {
            if (singleDataSet != null) {
                singleDataSet.close();
            }
            if (batchDataSet != null) {
                batchDataSet.close();
            }
            if (union != null) {
                union.close();
            }
        }
    }

    public boolean signCardValidOpUpdateSupQuotaPool(Set<Long> signCardIds, String opType) {
        AdDispatchTaskParam adDispatchTaskParam = new AdDispatchTaskParam();
        adDispatchTaskParam.setDataIds(signCardIds);
        adDispatchTaskParam.setOpType(opType);
        adDispatchTaskParam.setClassName("kd.wtc.wtpm.business.signcard.job.SignCardOpUpdatePoolTask");
        adDispatchTaskParam.setSync(true);
        BillJobDispatchService.dispatchBillTask((AdDispatchTaskParam)adDispatchTaskParam);
        return true;
    }

    private String getEntityNumberByApplyType(String applyType) {
        String entityNumber = "0".equals(applyType) ? "wtpm_supsignself" : ("1".equals(applyType) ? "wtpm_supsignpc" : "wtpm_supsignbatch");
        return entityNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Boolean> personHasSupBill(List<PersonHasBillVo> personHasBillVoList) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personHasBillVoList.size());
        for (PersonHasBillVo personHasBillVo : personHasBillVoList) {
            Date startDate = personHasBillVo.getStartDate();
            Date endDate = personHasBillVo.getEndDate();
            DataSet singleDataSet = null;
            DataSet batchDataSet = null;
            DataSet union = null;
            try {
                Date sDate = WTCDateUtils.getZeroDate((Date)WTCDateUtils.addDays((Date)startDate, (int)-1));
                Date eDate = WTCDateUtils.getLatestDate((Date[])new Date[]{WTCDateUtils.addDays((Date)endDate, (int)1)});
                String algoKey = this.getClass().getName();
                QFilter personFilter = new QFilter("personid.id", "=", (Object)personHasBillVo.getAttPersonId());
                List<String> auditStatusList = Arrays.asList("D", "B", "C");
                QFilter singleBillStatusFilter = new QFilter("billstatus", "in", auditStatusList);
                QFilter singleDateFilter = new QFilter("entryentity.signdate", ">=", (Object)sDate);
                singleDateFilter.and(new QFilter("entryentity.signdate", "<=", (Object)eDate));
                String selectFields = "personid.id id,entryentity.signdate signdate,entryentity.pointtag pointtag";
                singleDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"wtpm_supsignpc", (String)selectFields, (QFilter[])new QFilter[]{singleBillStatusFilter, singleDateFilter, personFilter}, null);
                QFilter attPersonFilter = new QFilter("attperson.id", "=", (Object)personHasBillVo.getAttPersonId());
                QFilter batchBillStatusFilter = new QFilter("billid.billstatus", "in", auditStatusList);
                QFilter batchDateFilter = new QFilter("supsigninfo.signdate", ">=", (Object)sDate);
                singleDateFilter.and(new QFilter("supsigninfo.signdate", "<=", (Object)eDate));
                String batchSelectFields = "attperson.id id,supsigninfo.signdate signdate,supsigninfo.pointtag pointtag";
                batchDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"wtpm_supsignlist", (String)batchSelectFields, (QFilter[])new QFilter[]{batchBillStatusFilter, batchDateFilter, attPersonFilter}, null);
                union = singleDataSet.union(batchDataSet);
                while (union.hasNext()) {
                    Row next = union.next();
                    String pointtag = next.getString("pointtag");
                    Date date = next.getDate("signdate");
                    Date shiftBelongDate = SignCardCommonService.getShiftBelongDate((Date)date, (String)pointtag);
                    Long personId = next.getLong("id");
                    if (shiftBelongDate == null || shiftBelongDate.getTime() < startDate.getTime() || shiftBelongDate.getTime() > endDate.getTime()) continue;
                    resultMap.put(personHasBillVo.getId(), Boolean.TRUE);
                }
            }
            finally {
                if (singleDataSet != null) {
                    singleDataSet.close();
                }
                if (batchDataSet != null) {
                    batchDataSet.close();
                }
                if (union == null) continue;
                union.close();
            }
        }
        return resultMap;
    }
}

