/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.cardmatch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtpm.business.cardmatch.CardMatchHelper;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;
import kd.wtc.wtpm.constants.sign.CardMatchKDString;
import kd.wtc.wtpm.formplugin.cardmatch.task.MatchTaskHelper;

public class CardMatchDetailPlugin
extends HRDataBaseEdit
implements TabSelectListener,
CardMatchConstants {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.initPageData();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("task");
        if (null == taskId) {
            taskId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("taskStr"));
        }
        ListShowParameter param = new ListShowParameter();
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(tabKey);
        param.setCustomParam("task", (Object)taskId);
        param.setCustomParam("tabKey", (Object)tabKey);
        param.setShowTitle(false);
        param.setBillFormId("wtpm_matchresultdetail");
        param.setFormId("wtbs_rimlesslist");
        this.getView().getPageCache().put("pageId", param.getPageId());
        this.getView().showForm((FormShowParameter)param);
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "rerunall": 
            case "refresh": 
            case "rerunselect": {
                IFormView tabView = this.getView().getView(this.getView().getPageCache().get("pageId"));
                boolean isAuthChanged = WTCPermUtils.isViewAuthChanged((IFormView)tabView, (IFormView)this.getView());
                if (!isAuthChanged) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            List ids = (List)this.getCache().get("idset", List.class);
            switch (operateKey) {
                case "refresh": {
                    this.getView().updateView();
                    break;
                }
                case "rerunall": {
                    this.executeTask(null, true);
                    break;
                }
                case "rerunselect": {
                    if (CollectionUtils.isEmpty((Collection)ids)) {
                        this.getView().showTipNotification(CardMatchKDString.selectOneMore());
                        return;
                    }
                    this.executeTask(ids, false);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("taskCallBack".equals(actionId)) {
            WTCPageCache cache = new WTCPageCache(this.getView());
            this.taskCallBack(cache);
        }
    }

    private void taskCallBack(WTCPageCache cache) {
        Map checkErrorInfo = (Map)cache.get("errMsg", Map.class);
        Map checkWarnInfo = (Map)cache.get("warnMsg", Map.class);
        if (checkWarnInfo != null && "certInfo".equals(checkWarnInfo.get("msgType"))) {
            CertService.showWarnInfoByCertMsg((Map)checkWarnInfo, (IFormView)this.getView());
        }
        if (checkErrorInfo != null) {
            if ("notAttFiles".equals(checkErrorInfo.get("msgType"))) {
                this.getView().showErrorNotification(checkErrorInfo.get("msg").toString());
            } else if ("certInfo".equals(checkErrorInfo.get("msgType"))) {
                CertService.showErrorInfoByCertMsg((Map)checkErrorInfo, (IFormView)this.getView());
            }
            return;
        }
        String taskIdStr = cache.get("taskId");
        long taskId = Long.parseLong(taskIdStr);
        WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtpm_match", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
        if (wtcTaskEntity.getTaskStatus().isEnd()) {
            MatchTaskHelper.showTaskResultForm(this.getView(), this.getView(), taskId, true);
        } else {
            this.getView().close();
        }
    }

    private void executeTask(List<Long> ids, boolean isAll) {
        Set reRunFileBoIdSet;
        long taskId = this.getModel().getDataEntity().getLong("task.id");
        Date startDate = this.getModel().getDataEntity().getDate("matchresult.startdate");
        Date endDate = this.getModel().getDataEntity().getDate("matchresult.enddate");
        long orgId = this.getModel().getDataEntity().getLong("matchresult.org.id");
        String version = this.getModel().getDataEntity().getString("matchresult.version");
        long creatorId = this.getModel().getDataEntity().getLong("matchresult.creator.id");
        long currUserId = RequestContext.get().getCurrUserId();
        if (creatorId == 0L || creatorId != currUserId) {
            this.getView().showTipNotification(CardMatchKDString.onlyRunOwnTask());
            return;
        }
        String taskStatus = this.getModel().getDataEntity().getString("task.taskstatus");
        if (!HRStringUtils.equalsIgnoreCase((String)WTCTaskStatus.ALL_FINISHED.getCode(), (String)taskStatus) && !HRStringUtils.equalsIgnoreCase((String)WTCTaskStatus.TERMINATED.getCode(), (String)taskStatus)) {
            this.getView().showErrorNotification(CardMatchKDString.onlyReRunFinishedAndTerminatedTaskTips());
            return;
        }
        if (isAll) {
            reRunFileBoIdSet = CardMatchHelper.getReRunFileBoIds((Object)taskId, null);
        } else {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_matchtaskdetail");
            QFilter qFilter = new QFilter("taskid", "=", (Object)taskId).and(new QFilter("id", "in", ids));
            DynamicObject[] taskDetails = helper.query("attfileboid.id", new QFilter[]{qFilter});
            if (taskDetails.length < 1) {
                this.getView().showErrorNotification(CardMatchKDString.notAuthAttFiles());
                return;
            }
            Set attFileBoIds = Arrays.stream(taskDetails).map(dy -> dy.getLong("attfileboid.id")).collect(Collectors.toSet());
            reRunFileBoIdSet = CardMatchHelper.getReRunFileBoIds((Object)taskId, attFileBoIds);
        }
        if (reRunFileBoIdSet == null || reRunFileBoIdSet.size() == 0) {
            this.getView().showErrorNotification(CardMatchKDString.allFileDoNotHavePermissionTips());
            return;
        }
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setType("wtpm_match");
        String caption = CardMatchKDString.taskCaption();
        taskForm.setCaption(caption);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskCallBack");
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setCanStop(true);
        taskForm.setCanBackground(true);
        taskForm.setClickClassName("kd.wtc.wtpm.formplugin.cardmatch.task.MatchTaskClick");
        Map customParams = CardMatchHelper.getTaskCustomParams((long)orgId, (Date)startDate, (Date)endDate, (String)version, null, (Set)reRunFileBoIdSet, null);
        taskForm.setCustomParams(customParams);
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)caption, (String)"wtpm_match", (Object)taskForm);
    }

    private void initPageData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String tabKey = (String)parameter.getCustomParam("tabKey");
        Tab tab = (Tab)this.getView().getControl("tabap");
        Long taskId = (Long)parameter.getCustomParam("task");
        if (null == taskId) {
            taskId = Long.valueOf((String)parameter.getCustomParam("taskStr"));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_matchtask");
        DynamicObject task = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        TabPage runPage = (TabPage)tab.getItems().get(0);
        String runText = ResManager.loadKDString((String)"\u6267\u884c\u6863\u6848\u6570", (String)"CardMatchDetailPlugin_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        runPage.setText(new LocaleString(runText + "\uff08" + task.getLong("runattfile") + "\uff09"));
        TabPage successPage = (TabPage)tab.getItems().get(1);
        String successText = ResManager.loadKDString((String)"\u6210\u529f", (String)"CardMatchDetailPlugin_1", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        successPage.setText(new LocaleString(successText + "\uff08" + task.getLong("succeedattfile") + "\uff09"));
        TabPage failPage = (TabPage)tab.getItems().get(2);
        String failText = ResManager.loadKDString((String)"\u5931\u8d25", (String)"CardMatchDetailPlugin_2", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        failPage.setText(new LocaleString(failText + "\uff08" + task.getLong("failedattfile") + "\uff09"));
        TabPage noRunPage = (TabPage)tab.getItems().get(3);
        String noRunText = CardMatchKDString.noRunAttFileCaption();
        noRunPage.setText(new LocaleString(noRunText + "\uff08" + task.getLong("notrunattfile") + "\uff09"));
        if (HRStringUtils.isNotEmpty((String)tabKey)) {
            tab.activeTab(tabKey);
        } else {
            tab.activeTab("totaltab");
        }
        HRBaseServiceHelper resultHelper = new HRBaseServiceHelper("wtpm_matchresult");
        DynamicObject result = resultHelper.loadDynamicObject(new QFilter[]{new QFilter("task.id", "=", (Object)taskId)});
        this.getModel().getDataEntity().set("org", (Object)result.getDynamicObject("org"));
        this.getModel().setValue("matchresult", result.get("id"));
        this.getModel().setValue("task", (Object)taskId);
        this.getModel().setValue("desc", result.get("desc"));
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }
}

