/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.cardmatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.SummaryServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;
import kd.wtc.wtpm.constants.sign.CardMatchKDString;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.formplugin.cardmatch.task.MatchTaskHelper;

public class CardMatchPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener,
CardMatchConstants {
    private static final Log LOG = LogFactory.getLog(CardMatchPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        String propKey = "attfile.affiliateadminorg";
        formShowParameter.setCustomParam("customHREntityNumber", (Object)"wtpm_matchtaskdetail");
        formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)propKey);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "toolbarap", "toolbarattfile"});
        BasedataEdit personEdit = (BasedataEdit)this.getView().getControl("excludeattperson");
        personEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgNameEdit = (BasedataEdit)this.getView().getControl("orgname");
        orgNameEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit attFileEdit = (BasedataEdit)this.getControl("attfilef7");
        attFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject event) {
        OperationStatus operationStatus;
        String version = CodeRuleServiceHelper.getNumber((String)"wtpm_matchresult", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"wtpm_matchresult"), null);
        this.getModel().setValue("version", (Object)version);
        String orgIdStr = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        if (HRStringUtils.isNotEmpty((String)orgIdStr)) {
            long orgId = Long.parseLong(orgIdStr);
            LOG.info("card match,orgId = {}", (Object)orgId);
            if (orgId > 0L) {
                this.getModel().setValue("org", (Object)orgId);
            }
        }
        if ((operationStatus = this.getView().getFormShowParameter().getStatus()) == OperationStatus.ADDNEW) {
            SummaryServiceHelper.showAddSummary((IFormView)this.getView(), (String)this.getAddSummaryName());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"match", (CharSequence)operateKey)) {
            this.startCardMatch();
        }
        if (StringUtils.equals((CharSequence)"getdetail", (CharSequence)operateKey)) {
            this.showAttFileInfoDetails();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"addattperson", (CharSequence)itemKey)) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("attfilef7");
            basedataEdit.click();
        }
    }

    private void showAttFileInfoDetails() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        this.getOrgAttFiles(this.getModel(), new Date(), map);
        Set adminOrgSet = (Set)map.get("adminOrgSet");
        Set excludeBoIds = (Set)map.get("excludeAttFileBoIds");
        if (CollectionUtils.isEmpty((Collection)adminOrgSet)) {
            this.getView().showTipNotification(SupSignKDString.inputAdminOrg());
            return;
        }
        AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam();
        attFileF7QueryParam.setProperties("id");
        attFileF7QueryParam.setAffiliateAdminOrgSetIds(adminOrgSet);
        attFileF7QueryParam.setBoDelSetIds(excludeBoIds);
        attFileF7QueryParam.setFormId("wtpm_matchtaskdetail");
        attFileF7QueryParam.setAppId("wtpm");
        attFileF7QueryParam.setPermField("attfile");
        Page dynamicObjectPage = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileF7QueryParam, 0, 99999999);
        List listRecords = dynamicObjectPage.getListRecords();
        List ids = listRecords.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setBillFormId("wtp_attfileinfoquerylist");
        parameter.setFormId("wtpm_listborderless");
        parameter.setHasRight(true);
        parameter.setCustomParam("ids", ids);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1000");
        styleCss.setHeight("600");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected QFilter getPermRuleQFilter(BeforeF7SelectEvent event) {
        if (event != null) {
            FormShowParameter formShowParameter = event.getFormShowParameter();
            formShowParameter.setCustomParam("orgAppId", (Object)"wtpm");
            formShowParameter.setCustomParam("orgEntityId", (Object)"wtpm_matchtaskdetail");
            formShowParameter.setCustomParam("orgField", (Object)"attfile.affiliateadminorg");
            AttFileQueryServiceImpl.getInstance().setFileF7OrgPerm(formShowParameter, "wtpm_matchtaskdetail", "wtpm");
        }
        return SignCardBatchService.getDataRuleForBdProp((String)"attfile", (String)"wtpm_matchtaskdetail", (String)"wtpm");
    }

    private void startCardMatch() {
        LOG.info("\u53d6\u5361\u5339\u914d\u5f00\u59cb");
        DynamicObject dynamic = this.getModel().getDataEntity();
        Date startDate = dynamic.getDate("startdate");
        Date endDate = dynamic.getDate("enddate");
        if (null == endDate || null == startDate) {
            this.getView().showErrorNotification(CardMatchKDString.cardMatchSystemTips());
            return;
        }
        if (endDate.getTime() < startDate.getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"CardMatchPlugin_1", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskCallBack");
        String caption = ResManager.loadKDString((String)"\u53d6\u5361\u5339\u914d", (String)"CardMatchPlugin_3", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setType("wtpm_match");
        taskForm.setCaption(caption);
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setCanStop(true);
        taskForm.setCanBackground(true);
        taskForm.setClickClassName("kd.wtc.wtpm.formplugin.cardmatch.task.MatchTaskClick");
        Map<String, Object> customParams = this.getTaskCustomParams(this.getModel(), endDate);
        taskForm.setCustomParams(customParams);
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)caption, (String)"wtpm_match", (Object)taskForm);
    }

    private void getOrgAttFiles(IDataModel model, Date endDate, Map<String, Object> result) {
        DynamicObject dataEntity = model.getDataEntity();
        if (dataEntity.getBoolean("selectorg")) {
            DynamicObjectCollection orgEntity = model.getEntryEntity("orgentity");
            if (CollectionUtils.isEmpty((Collection)orgEntity)) {
                return;
            }
            HashSet<Long> adminOrgSet = new HashSet<Long>(orgEntity.size());
            List adminOrgAllSubList = new ArrayList(orgEntity.size());
            HashSet excludeSet = new HashSet(orgEntity.size());
            for (DynamicObject entity : orgEntity) {
                DynamicObjectCollection collection = entity.getDynamicObjectCollection("excludeattperson");
                excludeSet.addAll(collection.stream().filter(dy -> null != dy.getDynamicObject("fbasedataid")).map(dy -> dy.getDynamicObject("fbasedataid").getLong("boid")).collect(Collectors.toList()));
                result.put("excludeAttFileBoIds", excludeSet);
                String orgType = entity.getString("orgtype");
                DynamicObject orgName = (DynamicObject)entity.get("orgname");
                if (!HRStringUtils.equals((String)orgType, (String)"haos_adminorghr") || null == orgName) continue;
                adminOrgSet.add(orgName.getLong("id"));
            }
            if (!CollectionUtils.isEmpty(adminOrgSet)) {
                adminOrgAllSubList = (List)WTCServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"batchGetAllSubOrg", (Object[])new Object[]{new ArrayList(adminOrgSet), endDate});
                LOG.info("card match,batchGetAllSubOrgSize = {}", (Object)(null != adminOrgAllSubList ? adminOrgAllSubList.size() : 0));
            }
            if (!CollectionUtils.isEmpty(adminOrgAllSubList)) {
                for (Map map : adminOrgAllSubList) {
                    adminOrgSet.add((Long)map.get("orgId"));
                }
                result.put("adminOrgSet", adminOrgSet);
            }
        }
    }

    private Map<String, Object> getTaskCustomParams(IDataModel model, Date endDate) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject dataEntity = model.getDataEntity();
        result.put("org", dataEntity.getLong("org.id"));
        result.put("startdate", dataEntity.getDate("startdate"));
        result.put("enddate", dataEntity.getDate("enddate"));
        result.put("version", dataEntity.getString("version"));
        result.put("desc", dataEntity.getString("desc"));
        result.put("newTask", "true");
        Set<Long> others = this.getOtherAttFiles(dataEntity);
        result.put("attFileBoIds", others);
        this.getOrgAttFiles(model, endDate, result);
        return result;
    }

    private Set<Long> getOtherAttFiles(DynamicObject dataEntity) {
        DynamicObjectCollection data;
        HashSet<Long> others = new HashSet<Long>(16);
        if (dataEntity.getBoolean("selectperson") && !CollectionUtils.isEmpty((Collection)(data = this.getModel().getEntryEntity("personentity")))) {
            for (DynamicObject attFile : data) {
                others.add(attFile.getLong("attfile.boid"));
            }
        }
        return others;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"match", (CharSequence)operateKey)) {
            String version;
            HRBaseServiceHelper serviceHelper;
            DynamicObject result;
            DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("orgentity");
            if (!CollectionUtils.isEmpty((Collection)orgEntity) && this.getView().getModel().getDataEntity().getBoolean("selectorg")) {
                for (DynamicObject entity : orgEntity) {
                    String orgType = entity.getString("orgtype");
                    DynamicObject orgName = (DynamicObject)entity.get("orgname");
                    if (!HRStringUtils.isNotEmpty((String)orgType) || !HRObjectUtils.isEmpty((Object)orgName)) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u540d\u79f0\u3002", (String)"CardMatchPlugin_4", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (!HRObjectUtils.isEmpty((Object)(result = (serviceHelper = new HRBaseServiceHelper("wtpm_matchresult")).queryOne(new QFilter[]{new QFilter("version", "=", (Object)(version = this.getView().getModel().getDataEntity().getString("version")))})))) {
                String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5b58\u5728", (String)"CardMatchPlugin_5", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(version + msg);
                args.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        if (closedCallBackEvent.getActionId().equals("addattfile")) {
            if (null == closedCallBackEvent.getReturnData()) {
                return;
            }
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            Object[] attFileIds = returnData.getPrimaryKeyValues();
            List attFileIdList = Arrays.stream(attFileIds).map(Long.class::cast).collect(Collectors.toList());
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtp_attfilebase");
            dataModel.beginInit();
            TableValueSetter table = new TableValueSetter(new String[0]);
            HashSet<Long> ids = new HashSet<Long>();
            dataModel.getEntityEntity("personentity").forEach(data -> ids.add(data.getLong("attfile.id")));
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", attFileIdList)};
            DynamicObject[] attFiles = hrBaseServiceHelper.query("id", qFilters);
            int[] ints = new int[]{0};
            if (null != attFiles && attFiles.length > 0) {
                for (DynamicObject attFile : attFiles) {
                    long attFileId = attFile.getLong("id");
                    if (0L == attFileId || !ids.add(attFileId)) continue;
                    TableValueSetter tableValueSetter = table.addRow(new Object[0]);
                    tableValueSetter.set("attfile", attFile.get("id"), ints[0]);
                    ints[0] = ints[0] + 1;
                }
            }
            dataModel.batchCreateNewEntryRow("personentity", table);
            dataModel.endInit();
            this.getView().updateView("personentity");
        } else if (closedCallBackEvent.getActionId().equals("taskCallBack")) {
            WTCPageCache cache = new WTCPageCache(this.getView());
            this.taskCallBack(cache);
        }
    }

    private void taskCallBack(WTCPageCache cache) {
        Map checkErrorInfo = (Map)cache.get("errMsg", Map.class);
        Map checkWarnInfo = (Map)cache.get("warnMsg", Map.class);
        if (checkWarnInfo != null && "certInfo".equals(checkWarnInfo.get("msgType"))) {
            CertService.showWarnInfoByCertMsg((Map)checkWarnInfo, (IFormView)this.getView());
        }
        if (checkErrorInfo != null) {
            if ("notAttFiles".equals(checkErrorInfo.get("msgType"))) {
                this.getView().showErrorNotification(checkErrorInfo.get("msg").toString());
            }
            return;
        }
        String taskIdStr = cache.get("taskId");
        long taskId = Long.parseLong(taskIdStr);
        WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtpm_match", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
        if (wtcTaskEntity.getTaskStatus().isEnd()) {
            MatchTaskHelper.showTaskResultForm(this.getView(), this.getView(), taskId, true);
        } else {
            this.getView().close();
        }
    }

    protected String getAddSummaryName() {
        return WtbsBusinessUtils.getMainEntityDisplayName((String)this.getView().getFormShowParameter().getFormId());
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (HRStringUtils.equals((String)"excludeattperson", (String)name)) {
            int index = event.getRow();
            DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("orgentity");
            DynamicObject orgDy = (DynamicObject)orgEntity.get(index);
            DynamicObject orgName = (DynamicObject)orgDy.get("orgname");
            String orgType = orgDy.getString("orgtype");
            QFilter qFilter = null;
            ArrayList orgIdList = Lists.newArrayList((Object[])new Long[]{orgName.getLong("id")});
            if (HRStringUtils.equals((String)orgType, (String)"haos_adminorghr")) {
                List adminOrgAllSubList = HAOSMServiceImpl.getInstance().batchGetAllSubOrg((List)orgIdList, new Date());
                List subOrgIdList = adminOrgAllSubList.stream().map(item -> (Long)item.get("orgId")).collect(Collectors.toList());
                subOrgIdList.add(orgName.getLong("id"));
                AttFileF7QueryParam attFileF7QueryParam = new AttFileF7QueryParam();
                attFileF7QueryParam.setProperties("id");
                attFileF7QueryParam.setAffiliateAdminOrgSetIds(new HashSet(subOrgIdList));
                attFileF7QueryParam.setqFilter(this.getPermRuleQFilter(event));
                attFileF7QueryParam.setFormId("wtpm_matchtaskdetail");
                attFileF7QueryParam.setAppId("wtpm");
                attFileF7QueryParam.setPermField("attfile");
                Page dynamicObjectPage = AttFileQueryServiceImpl.getInstance().queryAttFileF7WithPerm(attFileF7QueryParam, 0, 99999999);
                List listRecords = dynamicObjectPage.getListRecords();
                List ids = listRecords.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                qFilter = new QFilter("id", "in", ids);
            }
            qFilters.add(qFilter);
            event.setCustomQFilters(qFilters);
        } else if (HRStringUtils.equals((String)"orgname", (String)name)) {
            int index = event.getRow();
            DynamicObjectCollection orgEntity = this.getView().getModel().getEntryEntity("orgentity");
            DynamicObject orgDy = (DynamicObject)orgEntity.get(index);
            String orgType = orgDy.getString("orgtype");
            Set sameOrgIds = orgEntity.stream().filter(entity -> HRStringUtils.equals((String)entity.getString("orgtype"), (String)orgType) && !HRObjectUtils.isEmpty((Object)entity.get("orgname"))).map(org -> org.getLong("orgname.id")).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(sameOrgIds)) {
                QFilter qFilter = new QFilter("id", "not in", sameOrgIds);
                qFilters.add(qFilter);
            }
            if (!CollectionUtils.isEmpty(qFilters)) {
                event.setCustomQFilters(qFilters);
            }
        } else if (HRStringUtils.equals((String)"attfilef7", (String)name)) {
            QFilter qFilter = this.getPermRuleQFilter(event);
            DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentity");
            if (!CollectionUtils.isEmpty((Collection)orgEntity)) {
                HashSet excludeSet = new HashSet(orgEntity.size());
                for (DynamicObject entity2 : orgEntity) {
                    DynamicObjectCollection collection = entity2.getDynamicObjectCollection("excludeattperson");
                    excludeSet.addAll(collection.stream().filter(dy -> null != dy.getDynamicObject("fbasedataid")).map(dy -> dy.getDynamicObject("fbasedataid").getLong("boid")).collect(Collectors.toList()));
                }
                qFilter = new QFilter("boid", "not in", excludeSet).and(qFilter);
            }
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.setMultiSelect(true);
            event.addCustomQFilter(qFilter);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addattfile"));
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        BillList billlistap;
        super.beforeClosed(event);
        if (this.getView().getParentView() != null && (billlistap = (BillList)this.getView().getParentView().getControl("billlistap")) != null) {
            billlistap.refresh();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

