/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.cardmatch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;

public class LackCardList
extends HRCoreBaseBillList
implements CardMatchConstants {
    private static final Date MIN_DATE = WTCDateUtils.str2Date((String)"1900-01-01", (String)"yyyy-MM-dd");

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                rows.sort(Comparator.comparing(dyn -> dyn.getDate("shiftdate")).reversed().thenComparingLong(dyn -> dyn.getLong("attfilebo_id")).thenComparing(dyn -> null != dyn.getDate("lackpoint") ? dyn.getDate("lackpoint") : MIN_DATE));
                return rows;
            }
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
            if (!commonFilterColumn.getFieldName().equals("datetype.dateproperty.name")) continue;
            commonFilterColumn.setDefaultValue(String.valueOf(DateAttribute.WORKDAY.getId()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String evt = ((FormOperate)args.getSource()).getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        if (StringUtils.equals((CharSequence)"batchapply", (CharSequence)evt)) {
            List ids = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            HRBaseServiceHelper lackCardHelper = new HRBaseServiceHelper("wtpm_lackcard");
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids)};
            DynamicObject[] lackDys = lackCardHelper.queryOriginalArray("id", qFilters);
            if (lackDys.length < 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f3a\u5361\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u5217\u8868\u3002", (String)"LackCardList_1", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
            }
            List finalIds = Arrays.asList(lackDys).stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            BillShowParameter parameter = new BillShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("wtpm_supsignbatch");
            parameter.setCustomParam("from", (Object)"lackcardlist");
            parameter.setCustomParam("ids", finalIds);
            parameter.setPageId(this.getView().getPageId() + ID.genStringId());
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
            parameter.setHasRight(false);
            WtbsBusinessUtils.openTargetFormView((IFormView)this.getView(), (FormShowParameter)parameter, (String)"wtam");
            this.getView().invokeOperation("refresh");
        }
    }
}

