/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.cardmatch;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.util.WTCOrgUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.cardmatch.CardMatchHelper;
import kd.wtc.wtpm.common.ad.AdCommonUtils;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;
import kd.wtc.wtpm.constants.sign.CardMatchKDString;
import kd.wtc.wtpm.formplugin.cardmatch.task.MatchTaskHelper;

public class MatchResultList
extends HRDataBaseList
implements CardMatchConstants {
    private static final Map<String, String> FIELD_MAPPING = new HashMap<String, String>(4);
    private static final Set<String> TASK_STATUS_NOT_FINISHED;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                DynamicSimpleProperty prop = new DynamicSimpleProperty();
                prop.setName("cost");
                ((DynamicObject)rows.get(0)).getDataEntityType().getProperties().add((Object)prop);
                rows.forEach(row -> {
                    long cost = row.getLong("task.timecost");
                    String timeStr = AdCommonUtils.msFormat((long)cost);
                    row.set("cost", (Object)timeStr);
                });
                return rows;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "match": {
                    this.newMatch();
                    break;
                }
                case "taskdetail": {
                    this.showTaskInfo();
                    break;
                }
                case "rerun": {
                    this.executeTask();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("taskCallBack".equals(actionId)) {
            WTCPageCache cache = new WTCPageCache(this.getView());
            this.taskCallBack(cache);
        }
    }

    private void taskCallBack(WTCPageCache cache) {
        Map checkErrorInfo = (Map)cache.get("errMsg", Map.class);
        Map checkWarnInfo = (Map)cache.get("warnMsg", Map.class);
        if (checkWarnInfo != null && "certInfo".equals(checkWarnInfo.get("msgType"))) {
            CertService.showWarnInfoByCertMsg((Map)checkWarnInfo, (IFormView)this.getView());
        }
        if (checkErrorInfo != null) {
            if ("notAttFiles".equals(checkErrorInfo.get("msgType"))) {
                this.getView().showErrorNotification(checkErrorInfo.get("msg").toString());
            }
            return;
        }
        String taskIdStr = cache.get("taskId");
        long taskId = Long.parseLong(taskIdStr);
        WTCCalTaskEntity wtcTaskEntity = WTCTaskServiceHelper.loadTaskByTaskId((String)"wtpm_match", (long)taskId, (QFilter)WTCTaskRepository.NO_CUSTOM_CONDITION);
        if (wtcTaskEntity.getTaskStatus().isEnd()) {
            MatchTaskHelper.showTaskResultForm(this.getView(), this.getView(), taskId, false);
        } else {
            ((IListView)this.getView()).refresh();
        }
    }

    private void executeTask() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_matchresult");
        DynamicObject resultDy = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", this.getFocusRowPkId())});
        long creatorId = resultDy.getLong("creator.id");
        long currUserId = RequestContext.get().getCurrUserId();
        if (creatorId == 0L || creatorId != currUserId) {
            this.getView().showErrorNotification(CardMatchKDString.onlyRunOwnTask());
            return;
        }
        String taskStatus = resultDy.getString("task.taskstatus");
        if (!HRStringUtils.equalsIgnoreCase((String)WTCTaskStatus.ALL_FINISHED.getCode(), (String)taskStatus) && !HRStringUtils.equalsIgnoreCase((String)WTCTaskStatus.TERMINATED.getCode(), (String)taskStatus)) {
            this.getView().showErrorNotification(CardMatchKDString.onlyReRunFinishedAndTerminatedTaskTips());
            return;
        }
        long taskId = resultDy.getLong("task.id");
        Set reRunFileBoIdSet = CardMatchHelper.getReRunFileBoIds((Object)taskId, null);
        if (reRunFileBoIdSet == null || reRunFileBoIdSet.size() == 0) {
            this.getView().showErrorNotification(CardMatchKDString.allFileDoNotHavePermissionTips());
            return;
        }
        Date startDate = resultDy.getDate("startdate");
        Date endDate = resultDy.getDate("enddate");
        long orgId = resultDy.getLong("org.id");
        String version = resultDy.getString("version");
        WTCTaskForm taskForm = new WTCTaskForm();
        taskForm.setType("wtpm_match");
        String caption = CardMatchKDString.taskCaption();
        taskForm.setCaption(caption);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskCallBack");
        taskForm.setCloseCallBack(closeCallBack);
        taskForm.setCanStop(true);
        taskForm.setCanBackground(true);
        taskForm.setClickClassName("kd.wtc.wtpm.formplugin.cardmatch.task.MatchTaskClick");
        Map customParams = CardMatchHelper.getTaskCustomParams((long)orgId, (Date)startDate, (Date)endDate, (String)version, null, (Set)reRunFileBoIdSet, null);
        taskForm.setCustomParams(customParams);
        WTCDistributeTaskHelper.showProgress((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)caption, (String)"wtpm_match", (Object)taskForm);
    }

    public void showTaskInfo() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_matchresult");
        DynamicObject resultDy = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", this.getFocusRowPkId())});
        if (resultDy != null) {
            String taskStatus = resultDy.getString("task.taskstatus");
            if (HRStringUtils.isEmpty((String)taskStatus) || TASK_STATUS_NOT_FINISHED.contains(taskStatus)) {
                this.getView().showTipNotification(CardMatchKDString.getTaskRunningTips());
                return;
            }
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setCaption(CardMatchKDString.taskInfoCaption((String)resultDy.getString("version")));
            parameter.setPageId(this.getView().getPageId() + "wtpm_matchresult" + resultDy.getString("id"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("wtpm_matchtask");
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId((Object)resultDy.getLong("task.id"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void newMatch() {
        FormShowParameter parameter = new FormShowParameter();
        String caption = ResManager.loadKDString((String)"\u65b0\u589e\u624b\u52a8\u5339\u914d", (String)"MatchResultList_3", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        parameter.setCaption(caption);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("wtpm_cardmatch");
        long orgId = WTCOrgUtils.getDefaultOrgIdOfList((ListView)((ListView)this.getView()));
        parameter.setCustomParam("orgId", (Object)String.valueOf(orgId));
        this.getView().showForm(parameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long rowId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        args.setCancel(true);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_matchresult");
        DynamicObject resultDy = helper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)rowId)});
        this.showTaskDetail(resultDy, fieldName);
    }

    private void showTaskDetail(DynamicObject resultDy, String fieldName) {
        long taskId = resultDy.getLong("task.id");
        if (HRObjectUtils.isEmpty((Object)taskId) || taskId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u5361\u5339\u914d\u4efb\u52a1\u672a\u521b\u5efa\u3002", (String)"MatchResultList_4", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String status = resultDy.getString("task.taskstatus");
        if (TASK_STATUS_NOT_FINISHED.contains(status)) {
            this.getView().showTipNotification(CardMatchKDString.getTaskRunningTips());
            return;
        }
        String version = resultDy.getString("version");
        String caption = ResManager.loadKDString((String)"\u53d6\u5361\u5339\u914d-", (String)"MatchResultList_6", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        caption = caption + version;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(caption);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("wtpm_cardmatchtaskdetail");
        parameter.setCustomParam("tabKey", (Object)FIELD_MAPPING.get(fieldName));
        parameter.setCustomParam("id", (Object)resultDy.getLong("id"));
        parameter.setCustomParam("task", (Object)taskId);
        this.getView().showForm(parameter);
    }

    static {
        FIELD_MAPPING.put("version", "runtab");
        FIELD_MAPPING.put("task_runattperson", "runtab");
        FIELD_MAPPING.put("task_succeedattperson", "successtab");
        FIELD_MAPPING.put("task_failedattperson", "failtab");
        FIELD_MAPPING.put("task_notrunattperson", "noruntab");
        TASK_STATUS_NOT_FINISHED = Sets.newHashSet((Object[])new String[]{WTCTaskStatus.NEW.code, WTCTaskStatus.RUNNING.code, WTCTaskStatus.TERMINATING.code});
    }
}

