/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.cardmatch;

import java.util.Collection;
import java.util.Comparator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtpm.constants.sign.CardMatchConstants;

public class MultiCardList
extends HRCoreBaseBillList
implements CardMatchConstants {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                rows.sort(Comparator.comparing(dyn -> dyn.getDate("shiftdate")).reversed().thenComparingLong(dyn -> dyn.getLong("attfilebo_id")).thenComparing(dyn -> dyn.getLong("entryentity.id")));
                return rows;
            }
        });
    }

    public void setFilter(SetFilterEvent event) {
        event.setOrderBy("entryentity.matchdate desc,entryentity.attpersonid asc,entryentity.seq asc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
            if (!commonFilterColumn.getFieldName().equals("datetype.dateproperty.name")) continue;
            commonFilterColumn.setDefaultValue(String.valueOf(DateAttribute.WORKDAY.getId()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String evt = ((FormOperate)args.getSource()).getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
        if (StringUtils.equals((CharSequence)"update", (CharSequence)evt)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpm_multicard");
            DynamicObject data = helper.loadSingle((Object)id);
            if (HRObjectUtils.isEmpty((Object)data)) {
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection multiCardEntry = data.getDynamicObjectCollection("entryentity");
            boolean isLegal = false;
            for (DynamicObject multiCard : multiCardEntry) {
                if (null == multiCard.getDate("multipointutc")) continue;
                isLegal = true;
                break;
            }
            if (!isLegal) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9700\u4fee\u6539", (String)"MultiCardList_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("wtpm_multicardedit");
            parameter.setCustomParam("id", (Object)id);
            this.getView().showForm(parameter);
        }
    }
}

