/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.cardmatch.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.caltask.common.WTCCalStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;

public class MatchTaskHelper {
    public static Map<String, Integer> getTaskResult(long taskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_matchtaskdetail");
        DynamicObject[] details = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        HashMap<Long, String> data = new HashMap<Long, String>(details.length);
        for (DynamicObject detail : details) {
            long attFileBoId = detail.getLong("attfileboid.id");
            String status = detail.getString("taskdetailstate");
            data.put(attFileBoId, status);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>(4);
        result.put("allnum", data.size());
        int allNum = data.size();
        int failNum = 0;
        int okNum = 0;
        int noRunNum = 0;
        for (Map.Entry entry : data.entrySet()) {
            String status = (String)entry.getValue();
            if (HRStringUtils.equalsIgnoreCase((String)WTCTaskDetailStatus.FAIL.code, (String)status)) {
                ++failNum;
            }
            if (HRStringUtils.equalsIgnoreCase((String)WTCTaskDetailStatus.SUCCESS.code, (String)status)) {
                ++okNum;
            }
            if (!HRStringUtils.equalsIgnoreCase((String)WTCTaskDetailStatus.NOT_ACCOUNT.code, (String)status)) continue;
            ++noRunNum;
        }
        int runNum = failNum + okNum;
        result.put("oknum", okNum);
        result.put("failnum", failNum);
        result.put("allnum", allNum);
        result.put("norunnum", noRunNum);
        result.put("runnum", runNum);
        return result;
    }

    public static DynamicObject queryTaskById(long taskId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtpm_matchtask");
        QFilter qFilter = new QFilter("id", "=", (Object)taskId);
        return baseServiceHelper.queryOriginalOne("matchstatus,taskstatus", qFilter.toArray());
    }

    public static void showTaskResultForm(IFormView view, IFormView parentView, long taskId, boolean needClose) {
        DynamicObject taskDy = MatchTaskHelper.queryTaskById(taskId);
        if (!HRStringUtils.equalsIgnoreCase((String)taskDy.getString("taskstatus"), (String)WTCCalStatus.RUNNING.getCode())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("wtpm_matchoverview");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("taskId", (Object)taskId);
            formShowParameter.setCustomParam("needClose", (Object)needClose);
            if (parentView != null) {
                formShowParameter.setCustomParam("parentView", (Object)parentView.getPageId());
            }
            view.showForm(formShowParameter);
        }
    }
}

