/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.sign.mobile;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtpm.business.sign.mobile.MobSupSignBusiness;
import kd.wtc.wtpm.business.signcard.SupSignChangeService;

public class MobileSupSignChangeEditPlugin
extends AbstractMobBillPlugIn {
    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)evt.getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("businessKey");
        if (customParam != null && formShowParameter.getPkId() == null) {
            long pkId = Long.parseLong(formShowParameter.getCustomParam("businessKey").toString());
            formShowParameter.setPkId((Object)pkId);
            formShowParameter.setBillStatus(BillOperationStatus.VIEW);
        }
        MobileCommonServiceHelper.getInstance().preOpenForm(evt);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)this.getView().getFormShowParameter();
        String id = (String)formShowParameter.getCustomParam("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (Objects.equals(status, OperationStatus.ADDNEW) && HRStringUtils.isNotEmpty((String)id)) {
            String entityId = this.getView().getEntityId();
            SupSignChangeService.getInstance().copyFieldByParent(Long.parseLong(id), this.getModel(), entityId);
            String formId = formShowParameter.getFormId();
            formId = HRStringUtils.equals((String)"wtpm_supsignselfch_m", (String)formId) ? "wtpm_supsignselfchange" : "wtpm_supsignpcchange";
            long newId = ORM.create().genLongId("wtpm_supsignpcchange");
            this.getModel().getDataEntity(true).set("id", (Object)newId);
            HRBaseServiceHelper attHelper = new HRBaseServiceHelper("bos_attachment");
            QFilter filter = new QFilter("finterid", "=", (Object)id);
            DynamicObject[] originalAttachments = attHelper.loadDynamicObjectArray(new QFilter[]{filter});
            if (originalAttachments != null && originalAttachments.length > 0) {
                DynamicObject[] attachments = new DynamicObject[originalAttachments.length];
                for (int i = 0; i < originalAttachments.length; ++i) {
                    DynamicObject attachment = originalAttachments[i];
                    DynamicObject newAttachment = attHelper.generateEmptyDynamicObject();
                    HRDynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)newAttachment);
                    newAttachment.set("fbilltype", (Object)formId);
                    newAttachment.set("finterid", (Object)newId);
                    attachments[i] = newAttachment;
                }
                attHelper.save(attachments);
            }
        }
        IDataModel model = this.getModel();
        MobSupSignBusiness.getInstance().setMobileSignPoint(this.getModel());
        model.setDataChanged(false);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        CardEntry entryGrid = (CardEntry)this.getView().getControl("entryentity");
        DynamicObject[] items = entryGrid.getEntryData().getDataEntitys();
        for (int index = 0; index < items.length; ++index) {
            this.getModel().setValue("billentryname", (Object)(index + 1), index);
        }
        SupSignChangeService.getInstance().setChangeTitleInfo(this.getView());
        BillCommonService billCommonService = new BillCommonService();
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr(billCommonService.getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId(), "attfilebasef7");
        billCommonService.showAttFileChangeInfoAndUpdate(this.getView(), this.getView().getModel(), unifyBillApplyAttr);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String customVal;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)"CONFIRM_TYPE_ATT_VERSION", (String)callBackId) && HRStringUtils.isNotEmpty((String)(customVal = messageBoxClosedEvent.getCustomVaule()))) {
            this.getView().invokeOperation(customVal);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            FormOperate formOperate = (FormOperate)source;
            String operateKey = formOperate.getOperateKey();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            switch (operateKey) {
                case "submit": {
                    dataEntity.set("submitter", (Object)RequestContext.get().getCurrUserId());
                    dataEntity.set("submitdate", (Object)new Date());
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        MobileBillShowParameter formShowParameter = (MobileBillShowParameter)this.getView().getFormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (operateKey) {
            case "save": {
                if (!args.getOperationResult().isSuccess()) break;
                BillContainerService.getInstance().openDetailPageOfSave(this.getView(), SupSignChangeService.getInstance().changeToDetail(this.getView()), ((Long)this.getModel().getDataEntity().getPkValue()).longValue(), new HashMap());
                break;
            }
            case "submit": {
                if (!args.getOperationResult().isSuccess()) break;
                String applyFormId = SupSignChangeService.getInstance().changeToDetail(this.getView());
                BillContainerService.getInstance().openSuccessPage(this.getView(), ResManager.loadKDString((String)"\u8865\u7b7e\u7533\u8bf7", (String)"MobileSupSignChangeEditPlugin_2", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), applyFormId, this.getModel().getDataEntity().getLong("id"));
                break;
            }
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"historyflex"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("historyflex".equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setFormId("wtpm_supsignmobhis");
            MobileBillShowParameter formShowParameter = (MobileBillShowParameter)this.getView().getFormShowParameter();
            String id = (String)formShowParameter.getCustomParam("id");
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setCustomParam("pkId", (Object)this.getModel().getDataEntity().getLong("id"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

