/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.sign.mobile;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.mobile.ComComponentsHelper;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.components.TypeSelCusStyleEnum;
import kd.wtc.wtbs.common.model.mobile.AbnormalDealModel;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpm.business.sign.mobile.MobSupSignBusiness;
import kd.wtc.wtpm.business.signcard.supplyapply.helper.SupSignHelper;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignViewHelper;

public class MobileSupSignFormPlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(MobileCommonServiceHelper.class);
    private final MobSupSignBusiness mobSupSignBusiness = MobSupSignBusiness.getInstance();

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        MobileCommonServiceHelper.getInstance().preOpenForm(args);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"vectordelete", "flexaddentry", "flexsignmantext", "flexapplyreason"});
        BasedataEdit timeZone = (BasedataEdit)this.getControl("timezone");
        timeZone.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        boolean isAbnormal;
        LOG.info("mobilehome supsign beforeBindData begin...");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object isAbnormalObj = customParams.get("isAbnormal");
        boolean bl = isAbnormal = isAbnormalObj != null && (Boolean)isAbnormalObj != false;
        if (isAbnormal) {
            String abnormalParam = (String)customParams.get("abnormalDetail");
            AbnormalDealModel abnormalDealModel = (AbnormalDealModel)SerializationUtils.deSerializeFromBase64((String)abnormalParam);
            this.mobSupSignBusiness.initAbnormal(this.getView(), abnormalDealModel);
        } else {
            this.mobSupSignBusiness.initOverworkPerson(this.getView(), true);
        }
        this.setSelfBillOrg();
        MobSupSignBusiness.getInstance().setMobileSignPoint(this.getModel());
        this.mobSupSignBusiness.accessTagIsMustInput(this.getView());
        LOG.info("mobilehome supsign beforeBindData end...");
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        this.setEmptyTip();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setEmptyTip();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.mobSupSignBusiness.showInitEntryCard(this.getView(), false);
        this.mobSupSignBusiness.initViewWithStatus(this.getView());
        this.getView().updateView("entryentity");
        DateTimeEdit signPointDateEdit = (DateTimeEdit)this.getControl("suppletime");
        if (signPointDateEdit == null) {
            signPointDateEdit = (DateTimeEdit)this.getControl("signpoint");
        }
        if (signPointDateEdit != null) {
            signPointDateEdit.setMustInput(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)"vectordelete", (String)key)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("confirmCallBack", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8865\u7b7e\uff1f", (String)"MobileSupSignFormPlugin_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else if (HRStringUtils.equals((String)"flexaddentry", (String)key)) {
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
            if (entryEntity.getRowCount() == 10) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8865\u7b7e\u4fe1\u606f\u6570\u91cf\u6700\u5927\u4e3a10\u6761\u3002", (String)"MobileSupSignFormPlugin_3", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation("newentry");
        } else if (HRStringUtils.equals((String)"flexsignmantext", (String)key)) {
            boolean sourceWF = BillCommonService.getInstance().sourceWF(this.getView());
            if (!sourceWF) {
                this.openSelectPerson();
            }
        } else if (HRStringUtils.equals((String)"flexapplyreason", (String)key)) {
            CardEntry entryGrid = (CardEntry)this.getView().getControl("entryentity");
            int focusRow = entryGrid.getEntryState().getFocusRow();
            this.openApplyReason(focusRow);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && "confirmCallBack".equals(messageBoxClosedEvent.getCallBackId())) {
            this.mobSupSignBusiness.deleteEntry(this.getView());
        }
        if (MessageBoxResult.Yes.equals((Object)result) && "ckangeorg".equals(messageBoxClosedEvent.getCallBackId())) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setLocate(false);
            showParameter.setDebugModel(false);
            showParameter.setFormId("bos_mobileorglist");
            showParameter.getOpenStyle().setNoSwitchFocus(false);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.getOpenStyle().setClientShowType(ShowType.Floating);
            showParameter.setCaption(SupSignKDString.getOrgFieldName());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ckangeorg");
            showParameter.setCloseCallBack(closeCallBack);
            String otherFilters = this.getView().getPageCache().get("otherFilters");
            showParameter.setCustomParams(MobileCommonServiceHelper.getInstance().generateMobOrgSelectParam(otherFilters));
            showParameter.setShowTitle(true);
            showParameter.setShowClose(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        LOG.info("mobilehome supsign begin... operateKey:{}", (Object)operateKey);
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"submit")) {
            if (null == this.getModel().getValue("attfile")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8865\u7b7e\u4eba\u5458\u3002", (String)"MobileSupSignFormPlugin_4", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
                Object signDate = dynamicObject.get("signdate");
                if (signDate != null) continue;
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u5206\u5f55\u201d\u7b2c{0}\u884c\uff1a\u201c\u8865\u7b7e\u65f6\u95f4\u201d\u3002", (String)"MobileSupSignFormPlugin_12", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, index + 1);
                this.getView().showErrorNotification(errorMsg);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        LOG.info("mobilehome supsign end... operateKey:{}", (Object)operateKey);
        if (HRStringUtils.equals((String)operateKey, (String)"newentry") || HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            this.mobSupSignBusiness.showInitEntryCard(this.getView(), false);
        } else if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            if (args.getOperationResult().isSuccess()) {
                String applyTypeRadio = this.getModel().getDataEntity().getString("applytyperadio");
                HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(1);
                customParams.put("flagWorkFlow", Boolean.FALSE);
                long pkId = this.getModel().getDataEntity().getLong("id");
                if ("0".equals(applyTypeRadio)) {
                    BillContainerService.getInstance().openDetailPageOfSave(this.getView(), "wtpm_supsignself_tempm", pkId, customParams);
                } else if ("1".equals(applyTypeRadio)) {
                    BillContainerService.getInstance().openDetailPageOfSave(this.getView(), "wtpm_supsignpc_tempm", pkId, customParams);
                }
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"submit") && args.getOperationResult().isSuccess()) {
            String applyTypeRadio = this.getModel().getDataEntity().getString("applytyperadio");
            if ("0".equals(applyTypeRadio)) {
                String applyName = ResManager.loadKDString((String)"\u8865\u7b7e\u7533\u8bf7", (String)"MobileSupSignFormPlugin_5", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
                BillContainerService.getInstance().openSuccessPage(this.getView(), applyName, "wtpm_supsignself_tempm", this.getModel().getDataEntity().getLong("id"));
            } else if ("1".equals(applyTypeRadio)) {
                String applyName = ResManager.loadKDString((String)"\u8865\u7b7e\u7533\u8bf7", (String)"MobileSupSignFormPlugin_5", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
                BillContainerService.getInstance().openSuccessPage(this.getView(), applyName, "wtpm_supsignpc_tempm", this.getModel().getDataEntity().getLong("id"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String fieldName = propertyChangedArgs.getProperty().getName();
        CardEntry entryGrid = (CardEntry)this.getView().getControl("entryentity");
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int focusRow = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        if (StringUtils.equals((CharSequence)"signpoint", (CharSequence)fieldName)) {
            LOG.info("mobilehome supsign begin... propertyChanged:{}", (Object)"signpoint");
            if (newValue instanceof Date) {
                boolean havePlan;
                if (null == this.getModel().getValue("attfile")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8865\u7b7e\u4eba\u5458\u3002", (String)"MobileSupSignFormPlugin_4", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("signpoint", (Object)"", focusRow);
                    return;
                }
                long attfileid = (Long)((DynamicObject)this.getModel().getValue("attfile")).get("id");
                Date chooseDate = (Date)newValue;
                Date getDate = WTCDateUtils.getZeroDate((Date)chooseDate);
                this.getModel().setValue("signdate", (Object)getDate, focusRow);
                LOG.info("mobilehome supsign checkCurrentIndex begin... ");
                List attFileList = SupSignHelper.queryAttFile((Set)Sets.newHashSet((Object[])new Long[]{attfileid}));
                LOG.info("mobilehome supsign notAuthAttFileList.size={}", (Object)attFileList.size());
                if (CollectionUtils.isEmpty((Collection)attFileList)) {
                    this.getView().showMessage(SupSignKDString.notInEffDate());
                    havePlan = false;
                } else {
                    this.getModel().setValue("applyreason", null, focusRow);
                    havePlan = SupSignViewHelper.checkCurrentIndex(this.getView(), focusRow, attFileList);
                    LOG.info("mobilehome supsign checkResult={}", (Object)havePlan);
                }
                LOG.info("mobilehome supsign checkCurrentIndex end... ");
                if (havePlan) {
                    long userId = (Long)((DynamicObject)this.getModel().getValue("personid")).get("id");
                    Optional supTimes = this.mobSupSignBusiness.getSupTimes(this.getView(), userId, attfileid, null, getDate);
                    if (supTimes.isPresent()) {
                        entryGrid.setChildVisible(true, focusRow, new String[]{"suptimestipflex"});
                        this.getModel().setValue("signtimestip", supTimes.get(), focusRow);
                    } else {
                        entryGrid.setChildVisible(false, focusRow, new String[]{"suptimestipflex"});
                    }
                    this.mobSupSignBusiness.setDefaltTimeZone(this.getView(), attfileid, chooseDate, focusRow);
                } else {
                    this.getModel().setValue("signtimestip", (Object)"", focusRow);
                    entryGrid.setChildVisible(false, focusRow, new String[]{"suptimestipflex"});
                }
                this.getModel().setValue("suppleworktime", (Object)this.mobSupSignBusiness.getSeconds(chooseDate), focusRow);
                Date signDate = (Date)this.getModel().getValue("signdate", focusRow);
                Date suppleTime = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)signDate), LocalTime.ofSecondOfDay(this.mobSupSignBusiness.getSeconds(chooseDate))));
                this.getModel().setValue("signpoint", (Object)suppleTime, focusRow);
            } else {
                this.getModel().setValue("suppleworktime", (Object)-1, focusRow);
            }
            LOG.info("mobilehome supsign end... propertyChanged:{}", (Object)"signpoint");
        } else if (StringUtils.equals((CharSequence)"applytyperadio", (CharSequence)fieldName)) {
            LOG.info("mobilehome supsign applytyperadio propertyChanged...");
            this.mobSupSignBusiness.initOverworkPerson(this.getView(), false);
            this.getView().getModel().deleteEntryData("entryentity");
            this.getView().invokeOperation("newentry");
        } else if (StringUtils.equals((CharSequence)"attfile", (CharSequence)fieldName)) {
            this.getView().getModel().deleteEntryData("entryentity");
            this.getView().invokeOperation("newentry");
        } else if (StringUtils.equals((CharSequence)"org", (CharSequence)fieldName)) {
            if (this.getPageCache().get("org") != null) {
                Label signMan = (Label)this.getView().getControl("labelsignman");
                signMan.setText("");
                this.getView().getModel().setValue("personid", null);
                this.getView().getModel().setValue("attfile", null);
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelchoose"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorchoose"});
                this.getPageCache().put("org", null);
            }
        } else if (StringUtils.equals((CharSequence)"applyreason", (CharSequence)fieldName)) {
            DynamicObject reasonDy = (DynamicObject)newValue;
            if (reasonDy == null) {
                return;
            }
            Date signDate = (Date)this.getModel().getValue("signdate", focusRow);
            long attfileid = ((DynamicObject)this.getModel().getValue("attfile")).getLong("id");
            long userId = (Long)((DynamicObject)this.getModel().getValue("personid")).get("id");
            Optional supTimes = this.mobSupSignBusiness.getSupTimes(this.getView(), userId, attfileid, reasonDy, signDate);
            this.setSupTimeTip(supTimes, false, focusRow);
        }
    }

    private void setSupTimeTip(Optional<String> supTimes, boolean isAbnormal, int focusRow) {
        CardEntry entryGrid = (CardEntry)this.getView().getControl("entryentity");
        if (supTimes.isPresent()) {
            entryGrid.setChildVisible(true, focusRow, new String[]{"suptimestipflex"});
            this.getModel().setValue("signtimestip", (Object)supTimes.get(), focusRow);
        } else {
            Label signTimesLabel = (Label)this.getControl("labelsigntimes");
            if (signTimesLabel != null) {
                signTimesLabel.setText("");
            }
            entryGrid.setChildVisible(false, focusRow, new String[]{"suptimestipflex"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"back_personid")) {
            if (null != closedCallBackEvent.getReturnData()) {
                Map returnData2 = (Map)closedCallBackEvent.getReturnData();
                this.mobSupSignBusiness.setPersonName(this.getView(), returnData2);
                this.setSelfBillOrg();
            }
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"close_back_reason")) {
            Map returnData3 = (Map)closedCallBackEvent.getReturnData();
            this.mobSupSignBusiness.setReason(this.getView(), returnData3);
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"callback_return")) {
            LOG.info("mobilehome supsign callback return");
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"ckangeorg") && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.getPageCache().put("org", "org");
            this.getModel().setValue("org", ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("timezone".equals(beforeF7SelectEvent.getProperty().getName())) {
            beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u65f6\u533a", (String)"MobileSupSignFormPlugin_6", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
        } else if ("org".equals(beforeF7SelectEvent.getProperty().getName())) {
            LOG.info("mobilehome supsign beforeF7Select:{}", (Object)beforeF7SelectEvent.getFormShowParameter());
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            Object otherFilters = formShowParameter.getCustomParams().get("_otherFilters_");
            this.getView().getPageCache().put("otherFilters", otherFilters.toString());
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("ckangeorg", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MobileSupSignFormPlugin_11", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            beforeF7SelectEvent.setCancel(true);
        }
    }

    @Deprecated
    private void openSelectAbnormal(List<AbnormalDealModel.AbnormalDetail> abnormalAdd) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_abnormalid"));
        showParameter.setFormId("wtpm_chooseaddsupsign");
        ArrayList<String> supAbnormal = new ArrayList<String>(abnormalAdd.size());
        for (int index = 0; index < abnormalAdd.size(); ++index) {
            int shiftIndex = this.mobSupSignBusiness.getShiftIndex(this.getView(), abnormalAdd.get(index).getTimeRange());
            StringBuilder showStr = new StringBuilder(ResManager.loadKDString((String)"\u5e94\u51fa\u52e4\u65f6\u6bb5", (String)"MobileSupSignFormPlugin_7", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
            showStr.append(shiftIndex);
            this.mobSupSignBusiness.initStringBuilder(showStr, abnormalAdd, index);
            supAbnormal.add(showStr.toString());
        }
        showParameter.setCustomParam("supAbnormalOption", supAbnormal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openSelectPerson() {
        String applyType = (String)this.getView().getModel().getValue("applytyperadio");
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("wtbs_selectperson");
        showParameter.setCustomParam("applytype", (Object)applyType);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "back_personid"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openApplyReason(int rowId) {
        Object fileValue = this.getModel().getValue("attfile");
        if (Objects.isNull(fileValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8865\u7b7e\u4eba\u5458\u3002", (String)"MobileSupSignFormPlugin_4", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object dateValue = this.getModel().getValue("signdate", rowId);
        if (Objects.isNull(dateValue)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8865\u7b7e\u65f6\u95f4\u3002", (String)"MobileSupSignFormPlugin_8", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
            return;
        }
        long attfileId = ((DynamicObject)fileValue).getLong("id");
        List params = this.mobSupSignBusiness.getReasonByFile(this.getView(), rowId, attfileId, (Date)dateValue);
        if (params == null || params.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u8865\u7b7e\u539f\u56e0\u6570\u636e\u3002", (String)"MobileSupSignFormPlugin_9", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close_back_reason");
        ComComponentsHelper.getInstance().openTypePage(this.getView(), ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8865\u7b7e\u539f\u56e0\u3002", (String)"MobileSupSignFormPlugin_10", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]), TypeSelCusStyleEnum.SUPSIGN.getEvent(), params, closeCallBack);
    }

    private void setEmptyTip() {
        HashMap<String, String> emptytipMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> itemMap = new HashMap<String, HashMap<String, String>>();
        HashMap<String, HashMap<String, HashMap<String, String>>> fieldMap = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        String ls = SupSignKDString.pleaseSelect();
        emptytipMap.put(Lang.en_US.toString(), ls);
        emptytipMap.put(Lang.zh_CN.toString(), ls);
        emptytipMap.put(Lang.zh_TW.toString(), ls);
        itemMap.put("emptytip", emptytipMap);
        fieldMap.put("item", itemMap);
        this.getView().updateControlMetadata("suppletime", fieldMap);
        this.getView().updateControlMetadata("signpoint", fieldMap);
        this.getView().updateControlMetadata("signdate", fieldMap);
        this.getView().updateControlMetadata("suppleworktime", fieldMap);
        this.getView().updateControlMetadata("timezone", fieldMap);
        this.getView().updateControlMetadata("accesstag", fieldMap);
        this.getView().updateControlMetadata("pointtag", fieldMap);
        this.getView().updateControlMetadata("applyreason", fieldMap);
    }

    private void setSelfBillOrg() {
        DynamicObject attFileV;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String billType = dataEntity.getString("applytyperadio");
        if ("0".equals(billType) && (attFileV = dataEntity.getDynamicObject("attfilebasef7")) != null) {
            Object org = attFileV.get("org");
            this.getModel().setValue("org", org);
        }
    }
}

