/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.signcardapply;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtpm.business.signcard.signcardapply.helper.SignCardApplyHelper;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.constants.suppleapply.SuppleApplyConstants;
import kd.wtc.wtpm.formplugin.signcardapply.helper.SignCardApplyListViewHelper;
import kd.wtc.wtpm.formplugin.suppleapply.BillApplyBatchList;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignCommonViewHelper;

public class SignCardApplyDetailBillList
extends BillApplyBatchList {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListSelectedRow selectedRow = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        Long listId = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject listDy = SignCardApplyHelper.querySignCardListById((Long)listId);
        if (listDy == null) {
            this.getView().showTipNotification(SupSignKDString.dataHaveChange());
            args.setCancel(true);
        } else {
            long billId = listDy.getLong("billid.id");
            SignCardApplyListViewHelper.openSignForm(billId, this.getView());
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        args.getListColumns().removeIf(iListColumn -> HRStringUtils.equals((String)iListColumn.getListFieldKey(), (String)"supsigninfo.suppleworktime"));
    }

    public void packageData(PackageDataEvent args) {
        SupSignCommonViewHelper.packageSuppleWorkTime(args);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (confirmopmap.containsKey(opKey)) {
            super.beforeDoOperation(args);
            if (args.isCancel()) {
                return;
            }
            this.getSelectBillIds();
            if (CollectionUtils.isEmpty((Collection)this.batchBillIds)) {
                this.getView().showTipNotification(SupSignKDString.dataHaveChange());
                args.setCancel(true);
                return;
            }
            if (this.batchBillIds.size() > 1 && SuppleApplyConstants.BATCH_SYNC_OP_MAP.containsKey(opKey)) {
                this.getView().showTipNotification(SupSignKDString.onlyOneApplyBill());
                args.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        if ("viewlog".equals(operateKey)) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"wtpm_signcardtasklog", (boolean)true, (int)0, (boolean)false);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("taskCategory", (Object)"wtpm_signcard");
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("new".equals(operateKey)) {
            SignCardApplyListViewHelper.openSignCardApplyForm(this.getView());
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && confirmopmap.containsKey(callBackId)) {
            this.getSelectBillIds();
            this.opKey = callBackId;
            this.confirmDoListOp();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SupSignCommonViewHelper.handleSupSignDateFilterRange(this.getView(), args, BillSystemParamConfigEnum.SIGNCARD, "supsigninfo.signdate");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void confirmDoListOp() {
        DynamicObject[] dynamicObjects = SignCardApplyHelper.querySignCardApply((Set)this.batchBillIds);
        if (SuppleApplyConstants.BATCH_SYNC_OP_MAP.containsKey(this.opKey)) {
            DynamicObject listDataDy = (DynamicObject)this.billLists.get(0);
            this.billId = (Long)this.batchBillIds.iterator().next();
            this.billNo = listDataDy.getString("billno");
            this.orgId = listDataDy.getLong("org.id");
            this.billEntityId = "wtpm_signcardapply";
            this.taskCategory = "wtpm_signcard";
            boolean tryOperation = this.tryOperation(dynamicObjects);
            boolean checkTaskStatus = false;
            if (tryOperation) {
                checkTaskStatus = SupSignCommonViewHelper.checkBillTaskIsFinished(this.billId, this.getView(), this.taskCategory);
            }
            if (!tryOperation || !checkTaskStatus) return;
            this.billDataEntity = SignCardApplyHelper.querySignCardApply((Long)this.billId);
            this.submitDistributeTask();
        } else {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.operationResult = OperationServiceHelper.executeOperate((String)((String)confirmopmap.get(this.opKey)), (String)"wtpm_signcardapply", (DynamicObject[])dynamicObjects, (OperateOption)operateOption);
        }
        LOG.info("SupSignInfoDetailBillList.confirmDoListOp.operationResult:{}", (Object)this.operationResult);
        this.validateOperationResult();
    }

    private void getSelectBillIds() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        List listDataIds = selectedRows.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        this.billLists = SignCardApplyHelper.querySignCardList(listDataIds);
        this.batchBillIds = this.billLists.stream().map(item -> item.getLong("billid.id")).collect(Collectors.toSet());
    }
}

