/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply.change;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;
import kd.wtc.wtpm.business.signcard.SupSignChangeService;
import kd.wtc.wtpm.formplugin.suppleapply.helper.SupSignViewHelper;

public class SupSignChangeEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(SupSignChangeEdit.class);
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtpm_supsignselfchange");

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        BillShowParameter billShowParameter = (BillShowParameter)evt.getFormShowParameter();
        Map map = (Map)billShowParameter.getCustomParam("SUP_CHANGE_DATA");
        if (map != null) {
            Long parentId = (Long)map.get("parent");
            StringBuilder errMsg = new StringBuilder();
            boolean require = WTCBillViewUtils.requireMutex((String)String.valueOf(parentId), (String)"wtpm_supsignpc", (String)"change", (StringBuilder)errMsg);
            if (!require) {
                evt.setCancel(true);
                evt.setCancelMessage(errMsg.toString());
            }
        }
        SupSignChangeService.getInstance().preOpenFormOfSetCaption(billShowParameter);
    }

    private void copyAttachment(Long parentId) {
        Long pkValue = DB.genGlobalLongId();
        this.getModel().getDataEntity().set("id", (Object)pkValue);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("finterid", "=", (Object)parentId.toString());
        DynamicObject[] originalAttachments = helper.loadDynamicObjectArray(new QFilter[]{filter});
        if (originalAttachments == null || originalAttachments.length == 0) {
            return;
        }
        DynamicObject[] attachments = new DynamicObject[originalAttachments.length];
        for (int i = 0; i < originalAttachments.length; ++i) {
            DynamicObject attachment = originalAttachments[i];
            DynamicObject newAttachment = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)newAttachment);
            newAttachment.set("fbilltype", (Object)this.getView().getFormShowParameter().getFormId());
            newAttachment.set("finterid", (Object)pkValue);
            attachments[i] = newAttachment;
        }
        helper.save(attachments);
    }

    public void createNewData(BizDataEventArgs event) {
        super.createNewData(event);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("SUP_CHANGE_DATA");
        if (map != null) {
            Object parentObj = map.get("parent");
            long parentId = 0L;
            if (parentObj != null) {
                parentId = Long.parseLong(parentObj.toString());
            }
            SupSignChangeService.getInstance().copyFieldByParent(parentId, this.getModel(), formShowParameter.getFormId());
            this.copyAttachment(parentId);
        }
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        this.getModel().setValue("treatmethodgroup", (Object)"1");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        BillCommonService billCommonService = new BillCommonService();
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr(billCommonService.getAuthAppIdForFormPlugin(this.getView()), this.getView().getEntityId(), "attfilebasef7");
        billCommonService.showAttFileChangeInfoAndUpdate(this.getView(), this.getView().getModel(), unifyBillApplyAttr);
        this.loadHis();
        SupSignViewHelper.setAttPolicy(this.getView());
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity", "attachmentpanel", "org", "attfilebasef7"});
        this.getModel().setValue("treatmethodgroup", (Object)"1");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "submit": 
            case "submiteffect": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                dataEntity.set("submitter", (Object)RequestContext.get().getCurrUserId());
                dataEntity.set("submitdate", (Object)new Date());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            if ("change".equals(operateKey)) {
                DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
                long id = dataEntity.getLong("id");
                SupSignChangeService.getInstance().openNewChange(Long.valueOf(id), this.getView(), null);
            }
            if ("discard".equals(operateKey) || "save".equals(operateKey) || "submit".equals(operateKey) || "submiteffect".equals(operateKey) || "unsubmit".equals(operateKey)) {
                this.loadHis();
            }
        }
    }

    private void loadHis() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Map map = (Map)formShowParameter.getCustomParam("change");
        long parrntId = OperationStatus.ADDNEW == status && map != null ? ((Long)map.get("parent")).longValue() : this.getView().getModel().getDataEntity().getLong("parent");
        ListShowParameter lsp = new ListShowParameter();
        ListFilterParameter fParameter = new ListFilterParameter();
        ArrayList<Long> list = new ArrayList<Long>();
        list.add((Long)this.getModel().getDataEntity().getPkValue());
        this.getIdList(list, parrntId);
        QFilter filter = new QFilter("id", "in", list);
        fParameter.setFilter(filter);
        lsp.setListFilterParameter(fParameter);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setBillFormId(formShowParameter.getFormId());
        lsp.setCustomParam("billno", (Object)this.getModel().getDataEntity().getString("billno"));
        lsp.setCustomParam("wtcbill_hasright", formShowParameter.getCustomParam("wtcbill_hasright"));
        lsp.setHasRight(true);
        lsp.setFormId("wtbs_rimlesslist");
        lsp.getOpenStyle().setTargetKey("supflex");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, null));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void getIdList(List<Long> list, Long parentId) {
        if (parentId == null || parentId == 0L) {
            return;
        }
        DynamicObject parentDynamicObject = this.serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)parentId));
        boolean isChange = parentDynamicObject.getBoolean("ischange");
        list.add(parentId);
        if (isChange) {
            Long id = parentDynamicObject.getLong("parent");
            this.getIdList(list, id);
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        ArrayList propList = Lists.newArrayList((Object[])new String[]{"treatmethodgroup"});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity != null) {
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            DataEntityState dataEntityState = dataEntity.getDataEntityState();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (String prop : propList) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)prop);
                if (iDataEntityProperty == null) continue;
                dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
        }
    }

    public void pageRelease(EventObject evt) {
        super.pageRelease(evt);
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("SUP_CHANGE_DATA");
        if (map != null) {
            DataMutex dataMutex = DataMutex.create();
            Long parentId = (Long)map.get("parent");
            dataMutex.release(parentId.toString(), "wtpm_supsignpc", "change");
        }
    }
}

