/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.formplugin.suppleapply.task;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtpm.business.signcard.task.BillApplyTaskFactoryService;

public class BillApplyTaskLogDetailPlugin
extends HRDynamicFormBasePlugin
implements TabSelectListener {
    private static final Map<String, String> TABKEYMAP = Maps.newHashMapWithExpectedSize((int)4);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        formShowParameter.setStatus(OperationStatus.VIEW);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
    }

    public void afterBindData(EventObject evt) {
        IFormView childView;
        super.afterBindData(evt);
        DynamicObject task = this.getModel().getDataEntity().getDynamicObject("task");
        this.initTabName(task);
        this.showTaskLogList(task);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String tabKey = (String)formShowParameter.getCustomParam("tabkey");
        Tab tab = (Tab)this.getView().getControl("tabap");
        String tabKeyName = TABKEYMAP.get(tabKey);
        String pageId = this.getPageCache().get("childpageId");
        if (HRStringUtils.isNotEmpty((String)pageId) && (childView = this.getView().getView(pageId)) != null) {
            childView.getPageCache().put("tabkey", tabKeyName);
            this.getView().sendFormAction(childView);
        }
        tab.activeTab(tabKeyName);
    }

    private void initTabName(DynamicObject task) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        TabPage joinPage = (TabPage)tab.getItems().get(0);
        String text = ResManager.loadKDString((String)"\u6267\u884c\u6863\u6848\u6570\uff08{0}\uff09", (String)"BillApplyTaskLogDetailPlugin_0", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        joinPage.setText(new LocaleString(MessageFormat.format(text, task.getLong("runattfile"))));
        TabPage successPage = (TabPage)tab.getItems().get(1);
        String sucessText = ResManager.loadKDString((String)"\u6210\u529f\uff08{0}\uff09", (String)"BillApplyTaskLogDetailPlugin_1", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        successPage.setText(new LocaleString(MessageFormat.format(sucessText, task.getLong("succeedattfile"))));
        TabPage failPage = (TabPage)tab.getItems().get(2);
        String failText = ResManager.loadKDString((String)"\u5931\u8d25\uff08{0}\uff09", (String)"BillApplyTaskLogDetailPlugin_2", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        failPage.setText(new LocaleString(MessageFormat.format(failText, task.getLong("failedattfile"))));
        TabPage notRunPage = (TabPage)tab.getItems().get(3);
        String notRunText = ResManager.loadKDString((String)"\u672a\u6267\u884c\u6863\u6848\u6570\uff08{0}\uff09", (String)"BillApplyTaskLogDetailPlugin_3", (String)"wtc-wtpm-formplugin", (Object[])new Object[0]);
        notRunPage.setText(new LocaleString(MessageFormat.format(notRunText, task.getLong("notrunattfile"))));
    }

    private void showTaskLogList(DynamicObject task) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskId = task.getLong("id");
        ListShowParameter param = new ListShowParameter();
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("taskloglistflex");
        String taskCategory = (String)formShowParameter.getCustomParam("taskCategory");
        param.setBillFormId(BillApplyTaskFactoryService.getTaskDetailEntityId((String)taskCategory));
        param.setFormId("wtbs_noborderlist");
        param.setCustomParam("taskid", (Object)taskId);
        param.setCustomParam("taskCategory", (Object)taskCategory);
        param.setShowTitle(false);
        this.getView().showForm((FormShowParameter)param);
        String pageId = param.getPageId();
        this.getPageCache().put("childpageId", pageId);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        IFormView childView;
        String pageId = this.getPageCache().get("childpageId");
        if (HRStringUtils.isNotEmpty((String)pageId) && (childView = this.getView().getView(pageId)) != null) {
            String tabKey = tabSelectEvent.getTabKey();
            childView.getPageCache().put("tabkey", tabKey);
            ListView subListView = (ListView)childView;
            subListView.clearSelection();
            subListView.refresh();
            this.getView().sendFormAction((IFormView)subListView);
        }
    }

    static {
        TABKEYMAP.put("billno", "totaltab");
        TABKEYMAP.put("task_runattperson", "totaltab");
        TABKEYMAP.put("task_succeedattperson", "successtab");
        TABKEYMAP.put("task_failedattperson", "failtab");
        TABKEYMAP.put("task_notrunattperson", "notruntab");
    }
}

