/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.opplugin.web.suppleapply.bill;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.signcard.SignCardCommonService;
import kd.wtc.wtpm.business.signcard.SupSignChangeService;
import kd.wtc.wtpm.business.supquotapool.SupQuotaPoolTaskService;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.opplugin.web.suppleapply.bill.SupSignOp;
import kd.wtc.wtpm.opplugin.web.suppleapply.validator.SupSignValidator;

public class SupSignSubmitEffectOp
extends SupSignOp {
    private static final Log LOG = LogFactory.getLog(SupSignSubmitEffectOp.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().addAll(Lists.newArrayList((Object[])new String[]{"isnewbill", "ischange", "iscancel", "originalid"}));
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        LOG.info("SupSignSubmitEffectOp.onAddValidators.begin");
        addValidatorsEventArgs.addValidator((AbstractValidator)new SupSignValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        SignCardCommonService.setSubmitDate((DynamicObject[])args.getDataEntities());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        LOG.info("SupSignSubmitEffectOp.endOperationTransaction.begin");
        ArrayList<DynamicObject> oriDy = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> changeDy = new ArrayList<DynamicObject>(10);
        for (DynamicObject dataEntity : args.getDataEntities()) {
            boolean isChange = dataEntity.getBoolean("ischange");
            if (isChange) {
                changeDy.add(dataEntity);
                continue;
            }
            oriDy.add(dataEntity);
        }
        if (WTCCollections.isNotEmpty(oriDy)) {
            LOG.info("SupSignSubmitEffectOp.endOperationTransaction oriDy.size = {}", (Object)oriDy.size());
            SupQuotaPoolTaskService.dispatchUpdateQuotaPoolTask((DynamicObject[])oriDy.toArray(new DynamicObject[0]), (String)"submiteffect", (SignCardBillTypeEnum)SignCardBillTypeEnum.OTHER_BILL, (boolean)true);
        }
        if (WTCCollections.isNotEmpty(changeDy)) {
            LOG.info("SupSignSubmitEffectOp.endOperationTransaction changeDy.size = {}", (Object)changeDy.size());
            SupSignChangeService.getInstance().changeEffectEvent(changeDy.toArray(new DynamicObject[0]));
        }
    }
}

