/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileRankingDataServiceHelper;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceDetailsModel;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.dto.mobilehome.DataSoureModel;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationTerminal;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;

public class HomeDetailListPlugin
extends AbstractMobFormPlugin
implements TabSelectListener {
    private static final Log logger = LogFactory.getLog(HomeDetailListPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        for (int i = 0; i < 15; ++i) {
            Container container = (Container)this.getControl("intodetailflex" + i);
            container.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        AttStatisticQueryParam attStatisticQueryParam = (AttStatisticQueryParam)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParams().get("homeDetailListModel")), AttStatisticQueryParam.class);
        long userId = MobileCommonServiceHelper.getInstance().getUserId();
        Object[] sourceStaConfigs = AttStatisticsServiceHelper.getInstance().queryTeamStaAttItemDy(userId, attStatisticQueryParam.getRuleId().longValue(), attStatisticQueryParam.getStaTypeEnum(), attStatisticQueryParam.getStaCombinationConfProEnum(), true, StaCombinationTerminal.MOBILE);
        List<DataSoureModel> sourceDataList = Arrays.stream(sourceStaConfigs).filter(Objects::nonNull).map(sourceStaConfig -> new DataSoureModel(Long.valueOf(sourceStaConfig.getLong("id")), sourceStaConfig.getString("name"))).collect(Collectors.toList());
        Long chickSourceId = attStatisticQueryParam.getChickSourceId();
        if (chickSourceId == null || chickSourceId == 0L) {
            chickSourceId = WTCCollectionIndexUtil.getEleFromArr((Object[])sourceStaConfigs, (int)0).isPresent() ? Long.valueOf(((DynamicObject)WTCCollectionIndexUtil.getEleFromArr((Object[])sourceStaConfigs, (int)0).get()).getLong("id")) : null;
            attStatisticQueryParam.setChickSourceId(chickSourceId);
        }
        this.getView().getPageCache().put("sourceDataList" + userId, SerializationUtils.toJsonString(sourceDataList));
        this.getView().getPageCache().put("homeDetailListModel" + userId, SerializationUtils.toJsonString((Object)attStatisticQueryParam));
        this.initTab(sourceDataList, chickSourceId);
    }

    public void initTab(List<DataSoureModel> sourceDataList, Long chickSourceId) {
        int index = 0;
        int clickIndex = 0;
        for (DataSoureModel datamap : sourceDataList) {
            LocaleString localeString = new LocaleString(datamap.getName());
            ((TabPage)this.getView().getControl("tabpageap" + index)).setText(localeString);
            if (chickSourceId.equals(datamap.getId())) {
                clickIndex = index;
            }
            ++index;
        }
        if (index < 15) {
            for (int i = index; i < 16; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap" + i});
            }
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("tabpageap" + clickIndex);
    }

    private void setTopTips(int clickIndex, String intoSoure) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap4" + clickIndex});
    }

    private void setTabDetail(int clickIndex, AttStatisticQueryParam attStatisticQueryParam) {
        DynamicObject dailyStaSource = TeamHomeServiceHelper.getInstance().getDynamicObjectByChickSourceId(attStatisticQueryParam);
        if (dailyStaSource == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("setTabDetail.getRankingData \u5165\u53c2{}", (Object)SerializationUtils.toJsonString((Object)attStatisticQueryParam));
        }
        StaTypeEnum staTypeEnum = attStatisticQueryParam.getStaTypeEnum();
        AttDataSourceModel attStatisticsPersonDetailData = AttStatisticsServiceHelper.getInstance().getAttStatisticsService(staTypeEnum).getAttStatisticsPersonDetailData(attStatisticQueryParam, 0);
        List dataList = attStatisticsPersonDetailData.getAttDataSourceDetails();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            this.fillDefaultShow(clickIndex, Boolean.FALSE, Boolean.TRUE);
        } else {
            this.fillDefaultShow(clickIndex, Boolean.TRUE, Boolean.FALSE);
            if (Objects.nonNull(dailyStaSource) && "1".equals(dailyStaSource.getString("showdimen"))) {
                List<AttDataSourceDetailsModel> resDataList = dataList.stream().filter(detailsModel -> detailsModel.getStaValue() != 0.0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(resDataList)) {
                    this.fillDefaultShow(clickIndex, Boolean.FALSE, Boolean.TRUE);
                } else {
                    this.fillEntryAndTotalStr(clickIndex, attStatisticQueryParam, attStatisticsPersonDetailData, resDataList);
                }
            } else {
                this.fillEntryAndTotalStr(clickIndex, attStatisticQueryParam, attStatisticsPersonDetailData, dataList);
            }
        }
    }

    private void fillDefaultShow(int clickIndex, Boolean aFalse, Boolean aTrue) {
        this.getView().setVisible(aFalse, new String[]{"flexpanelap1" + clickIndex});
        this.getView().setVisible(aFalse, new String[]{"flexpanelap2" + clickIndex});
        this.getView().setVisible(aTrue, new String[]{"flexpanelap3" + clickIndex});
    }

    private void fillEntryAndTotalStr(int clickIndex, AttStatisticQueryParam attStatisticQueryParam, AttDataSourceModel attStatisticsPersonDetailData, List<AttDataSourceDetailsModel> dataList) {
        this.getModel().deleteEntryData("entryentity" + clickIndex);
        this.getModel().batchCreateNewEntryRow("entryentity" + clickIndex, dataList.size());
        double total = 0.0;
        DynamicObject dailySourceDy = AttStatisticsServiceHelper.getInstance().getResourceDy(attStatisticQueryParam.getStaTypeEnum(), attStatisticQueryParam.getChickSourceId().longValue());
        long kpiId = 0L;
        for (int i = 0; i < dataList.size(); ++i) {
            AttDataSourceDetailsModel person = dataList.get(i);
            this.getModel().setValue("name" + clickIndex, (Object)person.getPersonName(), i);
            if (HRStringUtils.isNotEmpty((String)person.getDepemp()) || HRStringUtils.isNotEmpty((String)person.getPosition())) {
                String positionName = person.getDepemp() + " | " + person.getPosition();
                positionName = positionName.length() > 15 ? positionName.substring(0, 15) : positionName;
                this.getModel().setValue("position" + clickIndex, (Object)positionName, i);
            }
            this.getModel().setValue("personid" + clickIndex, (Object)person.getPersonId(), i);
            this.getModel().setValue("picturefield" + clickIndex, (Object)HRImageUrlUtil.getImageFullUrl((String)person.getPictureUrl()), i);
            BigDecimal bigDecimal = BigDecimal.valueOf(person.getStaValue());
            String propertyName = "detail" + clickIndex;
            if (StaTypeEnum.DAILY == attStatisticQueryParam.getStaTypeEnum() && "2".equals(attStatisticsPersonDetailData.getValTakeMethod())) {
                kpiId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dailySourceDy, (String)"teamhomekpi");
                this.getModel().setValue(propertyName, (Object)this.getTeamKpiTimeStr(bigDecimal, kpiId), i);
            } else {
                String attDataSourceValueStr = bigDecimal.setScale(3, 4).stripTrailingZeros().toPlainString();
                String unit = HRStringUtils.isEmpty((String)attStatisticsPersonDetailData.getUnit()) ? "" : attStatisticsPersonDetailData.getUnit();
                this.getModel().setValue(propertyName, (Object)(attDataSourceValueStr + unit), i);
            }
            total += person.getStaValue();
        }
        this.getView().updateView("entryentity" + clickIndex);
        this.setLabel(clickIndex, attStatisticsPersonDetailData, dataList, total, kpiId);
    }

    private String getTeamKpiTimeStr(BigDecimal bigDecimal, long kpiId) {
        long seconds = bigDecimal.setScale(3, 4).stripTrailingZeros().longValue();
        seconds = 1771695967226047488L == kpiId || 1771696297393269760L == kpiId ? (seconds /= 1000L) : (seconds *= 3600L);
        return MobileRankingDataServiceHelper.getInstance().secondToSpecifiedFormatStr(seconds);
    }

    private void setLabel(int clickIndex, AttDataSourceModel attDataSourceModel, List<AttDataSourceDetailsModel> dataList, double total, long kpiId) {
        Label label = (Label)this.getView().getControl("labelap" + clickIndex);
        if (!dataList.isEmpty()) {
            String text = "";
            BigDecimal totalbig = BigDecimal.valueOf(total);
            String totalStr = totalbig.setScale(3, 4).stripTrailingZeros().toPlainString();
            long perSum = dataList.stream().filter(data -> data.getStaValue() != 0.0).count();
            String unit = HRStringUtils.isEmpty((String)attDataSourceModel.getUnit()) ? "" : attDataSourceModel.getUnit();
            logger.info("setTabDetail.setLabel unit{}", (Object)unit);
            text = kpiId != 0L && "2".equals(attDataSourceModel.getValTakeMethod()) ? String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5171%2$s\u4eba\uff0c \u6c47\u603b\u65f6\u957f\uff1a%3$s", (String)"HomeDetailListPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), attDataSourceModel.getAttDataSourceName(), perSum, this.getTeamKpiTimeStr(totalbig, kpiId)) : this.setTotalStrByUnit(total, attDataSourceModel.getAttDataSourceName(), perSum, totalStr, unit);
            label.setText(text);
        } else {
            label.setText(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"HomeDetailListPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
    }

    private String setTotalStrByUnit(double total, String attDataSourceName, long perSum, String totalStr, String unit) {
        if (ResManager.loadKDString((String)"\u6b21", (String)"HomeDetailListPlugin_5", (String)"wtc-wtss-formplugin", (Object[])new Object[0]).equals(unit)) {
            return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5171%2$s\u4eba\uff0c \u6c47\u603b\u6b21\u6570\uff1a%3$s", (String)"HomeDetailListPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), attDataSourceName, perSum, totalStr + unit);
        }
        if (ResManager.loadKDString((String)"\u5206\u949f", (String)"HomeDetailListPlugin_3", (String)"wtc-wtss-formplugin", (Object[])new Object[0]).equals(unit)) {
            String str = "";
            if (total < 60.0) {
                str = totalStr + unit;
            } else {
                String totalHStr = "";
                String hourUnit = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"HomeDetailListPlugin_2", (String)"wtc-wtss-formplugin", (Object[])new Object[0]);
                String totalMStr = "";
                String minUnit = "";
                if (total % 60.0 == 0.0) {
                    BigDecimal totalh = BigDecimal.valueOf(total / 60.0);
                    totalHStr = totalh.setScale(3, 4).stripTrailingZeros().toPlainString();
                } else {
                    int totalhint = (int)Math.floor(total / 60.0);
                    totalHStr = String.valueOf(totalhint);
                    BigDecimal totalmin = BigDecimal.valueOf(total % 60.0);
                    totalMStr = totalmin.setScale(3, 4).stripTrailingZeros().toPlainString();
                    minUnit = ResManager.loadKDString((String)"\u5206\u949f", (String)"HomeDetailListPlugin_3", (String)"wtc-wtss-formplugin", (Object[])new Object[0]);
                }
                str = totalHStr + hourUnit + totalMStr + minUnit;
            }
            return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5171%2$s\u4eba\uff0c \u6c47\u603b\u65f6\u957f\uff1a%3$s", (String)"HomeDetailListPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), attDataSourceName, perSum, str);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5171%2$s\u4eba\uff0c \u6c47\u603b\u65f6\u957f\uff1a%3$s", (String)"HomeDetailListPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), attDataSourceName, perSum, totalStr + unit);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.contains("intodetailflex")) {
            this.showBusTripDetail();
        }
    }

    private void showBusTripDetail() {
        long userId = MobileCommonServiceHelper.getInstance().getUserId();
        Long checkIndex = Long.parseLong(this.getPageCache().get("checkindex" + userId));
        AttStatisticQueryParam attStatisticQueryParam = (AttStatisticQueryParam)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("homeDetailListModel" + userId), AttStatisticQueryParam.class);
        Date queryDate = attStatisticQueryParam.getQueryStartDate();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity" + checkIndex);
        DynamicObject intvEvl = this.getModel().getEntryRowEntity("entryentity" + checkIndex, index);
        long interviewid = intvEvl.getLong("personid" + checkIndex);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("wtss_mobilehomepage");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Floating);
        showParameter.setOpenStyle(style);
        showParameter.setCustomParam("paramUserid", (Object)interviewid);
        showParameter.setCustomParam("paramDate", (Object)WTCDateUtils.date2Str((Date)queryDate, (String)"yyyy-MM-dd"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        long userId = MobileCommonServiceHelper.getInstance().getUserId();
        int clickIndex = Integer.parseInt(tabSelectEvent.getTabKey().substring(9));
        List sourceDataList = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("sourceDataList" + userId), DataSoureModel.class);
        AttStatisticQueryParam attStatisticQueryParam = (AttStatisticQueryParam)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParams().get("homeDetailListModel")), AttStatisticQueryParam.class);
        attStatisticQueryParam.setChickSourceId(((DataSoureModel)sourceDataList.get(clickIndex)).getId());
        DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity" + clickIndex);
        if (dynamicObjects.isEmpty()) {
            this.setTabDetail(clickIndex, attStatisticQueryParam);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap4" + clickIndex});
        this.getView().getPageCache().put("checkindex" + userId, clickIndex + "");
    }
}

