/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmProxyOpServiceImpl;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.kdstring.AttConfirmKDString;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtss.business.attstatistics.AttConfirmServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.AttConfirmBillDataHandler;
import kd.wtc.wtss.common.utils.WTSSKDStringHelper;

public class MobileAttConfirmBillEdit
extends AbstractMobFormPlugin {
    private HRBaseServiceHelper attConfirmServiceHelper = new HRBaseServiceHelper("wtam_attconfirmbill");
    private HRBaseServiceHelper attConfirmRecordServiceHelper = new HRBaseServiceHelper("wtam_attconrecord");

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.EDIT);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("isshowdiff".equals(name)) {
            boolean isShowDiff = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? (Boolean)args.getChangeSet()[0].getNewValue() : false;
            this.getView().setVisible(Boolean.valueOf(!isShowDiff), new String[]{"flexdetaillist"});
            this.getView().setVisible(Boolean.valueOf(isShowDiff), new String[]{"differenceflex"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.dateParse();
        this.comparedToLastConfirmResult();
        this.updateHeadRemind();
        this.handleMobTablePriEntry();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"differenceflex"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        if ("confirm".equals(opKey) && evt.getOperationResult().isSuccess()) {
            AttConfirmRecordOpParam opParam = new AttConfirmRecordOpParam();
            opParam.setOp(AttConfirmRecordOpEnum.COMFIRM);
            opParam.setAttConfirmRecordIds(Collections.singleton(this.getAttConfirmRecordId()));
            AttConfirmProxyOpServiceImpl.getInstance().opAttConfirmRecord(opParam);
            List modelList = opParam.getAttConfirmRecordModelList();
            if (CollectionUtils.isNotEmpty((Collection)modelList)) {
                AttConfirmRecordModel recordModel = (AttConfirmRecordModel)modelList.get(0);
                Boolean opStatus = recordModel.getOpStatus();
                if (Boolean.TRUE.equals(opStatus)) {
                    IFormView parentView = this.getView().getParentView();
                    if (parentView != null) {
                        parentView.showSuccessNotification(AttConfirmKDString.getSuccessTips());
                        this.getView().sendFormAction(parentView);
                    }
                } else {
                    String msg = recordModel.getMsg();
                    this.getView().showTipNotification(msg);
                }
            }
        }
    }

    public void pageRelease(EventObject e) {
        this.getView().close();
        super.pageRelease(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getView().getModel().setDataChanged(false);
        super.beforeClosed(e);
    }

    private void dateParse() {
        DynamicObject attConfRecord = this.getModel().getDataEntity(true).getDynamicObject("attconrecord");
        if (attConfRecord == null) {
            return;
        }
        if (!AttConRecordStatusEnum.CONFIRM.getCode().equals(attConfRecord.getString("status"))) {
            long attConfirmRecordId = attConfRecord.getLong("id");
            DynamicObject currentDy = AttConfirmServiceHelper.instance().loadAttConfirmBillDyWithAttConfId(Long.valueOf(attConfirmRecordId));
            if (currentDy != null) {
                this.getModel().setValue("attconrecord", (Object)this.loadAttConfirmRecord(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)currentDy, (String)"attconrecord")));
                this.getModel().setValue("entryentity", (Object)currentDy.getDynamicObjectCollection("entryentity"));
            }
        }
        boolean byDate = AttConRecordTypeEnum.BY_DATE.getCode().equals(this.getModel().getDataEntity().getString("attconrecord.type"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.parse2PerAttItem((Collection<DynamicObject>)entryEntity, "attitem", byDate);
    }

    private void parse2PerAttItem(Collection<DynamicObject> entryEntity, String attItemKey, boolean byDate) {
        List periodIds = entryEntity.stream().filter(entry -> entry.containsProperty(attItemKey)).map(entry -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entry, (String)attItemKey)).collect(Collectors.toList());
        boolean allZero = periodIds.stream().allMatch(id -> id == null || id == 0L);
        if (allZero) {
            periodIds = entryEntity.stream().filter(entry -> entry.containsProperty(attItemKey + "_id") && entry.get(attItemKey + "_id") != null).map(entry -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entry, (String)(attItemKey + "_id"))).collect(Collectors.toList());
        }
        if (WTCCollections.isNotEmpty(periodIds)) {
            HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)(byDate ? "wtp_dailydetsource" : "wtp_persumsource"));
            DynamicObject[] perSumSourceDys = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", periodIds).toArray());
            Map<Long, DynamicObject> perSumSourceDyMap = Arrays.stream(perSumSourceDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
            for (DynamicObject entry2 : entryEntity) {
                DynamicObject perSumSourceDy;
                if (entry2.containsProperty(attItemKey) && entry2.get(attItemKey) != null) {
                    perSumSourceDy = perSumSourceDyMap.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entry2, (String)attItemKey));
                    if (perSumSourceDy == null) continue;
                    entry2.set(attItemKey, (Object)perSumSourceDy);
                    continue;
                }
                if (!entry2.containsProperty(attItemKey + "_id") || entry2.get(attItemKey + "_id") == null || (perSumSourceDy = perSumSourceDyMap.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entry2, (String)(attItemKey + "_id")))) == null) continue;
                entry2.set(attItemKey, (Object)perSumSourceDy);
            }
        }
    }

    private void comparedToLastConfirmResult() {
        DynamicObject latestRecordDy = this.loadAttConfirmRecord(this.getAttConfirmRecordId());
        if (latestRecordDy == null || !latestRecordDy.getBoolean("showlast")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isshowdiff"});
            return;
        }
        DynamicObject lastDy = this.loadLastAttConfirmDy(latestRecordDy);
        if (lastDy == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isshowdiff"});
            return;
        }
        DynamicObjectCollection lastEntryDys = lastDy.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> lastEntryDyMap = lastEntryDys.stream().collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem_id"), dy -> dy, (a, b) -> a));
        DynamicObjectCollection currentEntryDys = this.getModel().getEntryEntity("entryentity");
        Map<Long, DynamicObject> currentEntryDyMap = currentEntryDys.stream().collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem"), dy -> dy, (a, b) -> a));
        List currentAttItemIds = currentEntryDys.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem")).collect(Collectors.toList());
        List lastAttItemIds = lastEntryDys.stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attitem_id")).collect(Collectors.toList());
        HashSet<Long> modifyItemIds = new HashSet<Long>(16);
        modifyItemIds.addAll(currentAttItemIds.stream().filter(currentId -> !lastAttItemIds.contains(currentId)).collect(Collectors.toSet()));
        modifyItemIds.addAll(lastAttItemIds.stream().filter(lastId -> !currentAttItemIds.contains(lastId)).collect(Collectors.toSet()));
        block0: for (DynamicObject currentEntryDy : currentEntryDys) {
            long attItemId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)currentEntryDy, (String)"attitem");
            String currentValue = currentEntryDy.getString("value");
            for (DynamicObject lastEntryDy : lastEntryDys) {
                if (attItemId != WTCDynamicObjectUtils.getBaseDataId((DynamicObject)lastEntryDy, (String)"attitem_id")) continue;
                if (!Objects.equals(currentValue, lastEntryDy.getString("value"))) {
                    modifyItemIds.add(attItemId);
                }
                currentEntryDy.set("latestvalue", (Object)currentValue);
                currentEntryDy.set("lastvalue", (Object)lastEntryDy.getString("value"));
                continue block0;
            }
        }
        this.fillAnotherItemEntry(currentEntryDyMap, lastEntryDyMap, modifyItemIds);
    }

    private DynamicObject loadLastAttConfirmDy(DynamicObject latestDy) {
        String type = latestDy.getString("type");
        long attConfirmRecordId = latestDy.getLong("id");
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setAttFileBoIdSet((Set)Sets.newHashSet((Object[])new Long[]{WTCDynamicObjectUtils.getBaseDataId((DynamicObject)latestDy, (String)"attfile")}));
        if (AttConRecordTypeEnum.BY_DATE.getCode().equals(type)) {
            queryParam.setStartDate(latestDy.getDate("startdate"));
            queryParam.setEndDate(latestDy.getDate("enddate"));
        } else if (AttConRecordTypeEnum.BY_PERIOD.getCode().equals(type)) {
            queryParam.setPerAttPeriodIdSet((Set)Sets.newHashSet((Object[])new Long[]{WTCDynamicObjectUtils.getBaseDataId((DynamicObject)latestDy, (String)"perattperiod")}));
        }
        DynamicObject[] existsConfirmRecordDys = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordDyList(queryParam);
        if (existsConfirmRecordDys == null || existsConfirmRecordDys.length == 0) {
            return null;
        }
        DynamicObject lastConfirmRecordDy = Arrays.stream(existsConfirmRecordDys).filter(existsDy -> attConfirmRecordId != existsDy.getLong("id")).max(Comparator.comparing(existsDy -> existsDy.getDate("createtime"))).orElse(null);
        if (lastConfirmRecordDy == null || !AttConRecordStatusEnum.REVOKE.getCode().equals(lastConfirmRecordDy.getString("status")) || lastConfirmRecordDy.getDate("confirmtime") == null) {
            return null;
        }
        DynamicObject lastDy = this.loadAttConfirmBill(lastConfirmRecordDy.getLong("id"));
        if (lastDy == null) {
            return null;
        }
        return lastDy;
    }

    private DynamicObject loadAttConfirmRecord(Long attConfirmRecordId) {
        if (attConfirmRecordId == null || attConfirmRecordId == 0L) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)attConfirmRecordId);
        DynamicObject attConfirmDy = this.attConfirmRecordServiceHelper.loadDynamicObject(idFilter);
        return attConfirmDy;
    }

    private DynamicObject loadAttConfirmBill(Long attConfirmRecordId) {
        if (attConfirmRecordId == null || attConfirmRecordId == 0L) {
            return null;
        }
        DynamicObject lastDy = this.attConfirmServiceHelper.loadDynamicObject(new QFilter("attconrecord", "=", (Object)attConfirmRecordId));
        if (lastDy == null) {
            return null;
        }
        return lastDy;
    }

    private void fillAnotherItemEntry(Map<Long, DynamicObject> currentEntryDyMap, Map<Long, DynamicObject> lastEntryDyMap, Set<Long> itemIds) {
        DynamicObjectCollection diffItemEntry = this.getModel().getDataEntity().getDynamicObjectCollection("diffentryentity");
        for (Long diffItemId : itemIds) {
            String value;
            Object attItem;
            String modifyType;
            if (diffItemId == null || 0L == diffItemId) continue;
            DynamicObject lastDy = lastEntryDyMap.get(diffItemId);
            DynamicObject nowDy = currentEntryDyMap.get(diffItemId);
            String lastValue = "";
            if (nowDy != null && lastDy == null) {
                modifyType = "A";
                attItem = nowDy.get("attitem");
                if (attItem == null && nowDy.containsProperty("attitem_id")) {
                    attItem = nowDy.get("attitem_id");
                }
                value = nowDy.getString("value");
            } else if (nowDy == null && lastDy != null) {
                modifyType = "C";
                attItem = lastDy.get("attitem");
                if (attItem == null && lastDy.containsProperty("attitem_id")) {
                    attItem = lastDy.get("attitem_id");
                }
                lastValue = lastDy.getString("value");
                value = lastDy.getString("value");
            } else {
                if (nowDy == null || lastDy == null) continue;
                modifyType = "B";
                attItem = nowDy.get("attitem");
                if (attItem == null && nowDy.containsProperty("attitem_id")) {
                    attItem = nowDy.get("attitem_id");
                }
                lastValue = lastDy.getString("value");
                value = nowDy.getString("value");
            }
            DynamicObject diffItemEntryDy = diffItemEntry.addNew();
            diffItemEntryDy.set("diff_attitem", attItem);
            if (!"C".equals(modifyType)) {
                diffItemEntryDy.set("diff_latestvalue", (Object)value);
            }
            if (!"A".equals(modifyType)) {
                diffItemEntryDy.set("diff_lastvalue", (Object)lastValue);
            }
            diffItemEntryDy.set("changedescription", (Object)modifyType);
        }
        boolean byDate = AttConRecordTypeEnum.BY_DATE.getCode().equals(this.getModel().getDataEntity().getString("attconrecord.type"));
        this.parse2PerAttItem((Collection<DynamicObject>)diffItemEntry, "diff_attitem", byDate);
    }

    private void updateHeadRemind() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (!dynamicObject.containsProperty("attconrecord") || dynamicObject.get("attconrecord") == null) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtam_attconrecord");
        DynamicObject attConRecord = dynamicObject.getDynamicObject("attconrecord");
        DynamicObject attConRecordDy = helper.loadDynamicObject(new QFilter("id", "=", (Object)attConRecord.getLong("id")));
        Tuple<Tuple<Boolean, Boolean>, String> checkResult = this.beforeOpenValidator(attConRecordDy);
        if (((Boolean)((Tuple)checkResult.getKey()).getKey()).booleanValue()) {
            this.sendUpdateTabName2ParentView();
            if (((Boolean)((Tuple)checkResult.getKey()).getValue()).booleanValue() && AttConRecordStatusEnum.CONFIRM.getCode().equals(attConRecord.get("status"))) {
                if (WTCStringUtils.isNotEmpty((String)((String)checkResult.getValue()))) {
                    Label labelAp = (Label)this.getControl("headremind5");
                    labelAp.setText((String)checkResult.getValue());
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexheadremind4"});
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexdetail"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexretraction"});
                Label labelAp = (Label)this.getControl("labelap");
                labelAp.setText((String)checkResult.getValue());
                return;
            }
        }
        String confStatus = attConRecordDy.getString("status");
        String dataStatus = attConRecordDy.getString("datastatus");
        String headFlexShow = "";
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        if (AttConfirmDataStatusEnum.EFFECT.getCode().equals(dataStatus)) {
            switch (confStatus) {
                case "D": {
                    Date dateTime;
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexdetail"});
                    this.sendUpdateTabName2ParentView();
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexretraction"});
                    if (attConRecord.containsProperty("revoketime") && (dateTime = attConRecord.getDate("revoketime")) != null) {
                        Label remindDate = (Label)this.getView().getControl("headreminddate1");
                        remindDate.setText(WTCDateUtils.date2Str((Date)dateTime, (String)"yyyy-MM-dd HH:mm"));
                    }
                    headFlexShow = "flexheadremind1";
                    this.setStatusLabelStyle(map, "#F0262D", "#FFF0ED");
                    break;
                }
                case "A": {
                    Date date;
                    if (attConRecord.containsProperty("confirmendtime") && (date = attConRecord.getDate("confirmendtime")) != null) {
                        Label remindDate = (Label)this.getView().getControl("headreminddate");
                        remindDate.setText(WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd"));
                    }
                    headFlexShow = "flexheadremind";
                    this.setStatusLabelStyle(map, "#FF8F0F", "#FFFBF1");
                    this.checkLastRecordWasInvalidAndConfirmed(attConRecordDy);
                    break;
                }
                case "B": {
                    Date dateTime;
                    if (attConRecord.containsProperty("confirmtime") && (dateTime = attConRecord.getDate("confirmtime")) != null) {
                        Label remindDate = (Label)this.getView().getControl("headreminddate2");
                        remindDate.setText(WTCDateUtils.date2Str((Date)dateTime, (String)"yyyy-MM-dd HH:mm"));
                    }
                    Label attConfStatus = (Label)this.getView().getControl("labelapattconfstatus");
                    attConfStatus.setText(AttConRecordStatusEnum.CONFIRM.getName().loadKDString());
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexbutton"});
                    headFlexShow = "flexheadremind2";
                    this.setStatusLabelStyle(map, "#1DB363", "#EDFFF3");
                    break;
                }
                case "C": {
                    Date date;
                    if (attConRecord.containsProperty("confirmendtime") && (date = attConRecord.getDate("confirmendtime")) != null) {
                        Label remindDate = (Label)this.getView().getControl("headreminddate3");
                        remindDate.setText(WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd"));
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexbutton", "labelapattconfstatus"});
                    headFlexShow = "flexheadremind3";
                    this.setStatusLabelStyle(map, "#F0262D", "#FFF0ED");
                }
            }
        } else {
            Label labelAp = (Label)this.getControl("headremind5");
            labelAp.setText(WTSSKDStringHelper.attConfirmNotEffect());
            Label attConfStatus = (Label)this.getView().getControl("labelapattconfstatus");
            attConfStatus.setText(AttConfirmDataStatusEnum.INVALID.getName().loadKDString());
            headFlexShow = "flexheadremind4";
            this.setStatusLabelStyle(map, "#AAAAAA", "#FFFFFF");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexbutton"});
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{headFlexShow});
        this.getView().updateControlMetadata("labelapattconfstatus", (Map)map);
        Label dateRange = (Label)this.getView().getControl("labelattconfrange");
        if (AttConRecordTypeEnum.BY_DATE.getCode().equals(attConRecord.getString("type"))) {
            Date date = attConRecord.getDate("startdate");
            dateRange.setText(WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd"));
        } else {
            Date startDate = attConRecord.getDate("startdate");
            Date endDate = attConRecord.getDate("enddate");
            dateRange.setText(WTCDateUtils.date2Str((Date)startDate, (String)"yyyy-MM-dd") + '~' + WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd"));
        }
    }

    private long getAttConfirmRecordId() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long attConfirmBillId = 0L;
        if (customParams.get("attConfirmId") != null && WTCStringUtils.isNotEmpty((String)String.valueOf(customParams.get("attConfirmId"))) && (attConfirmBillId = Long.parseLong(String.valueOf(customParams.get("attConfirmId")))) == 0L) {
            attConfirmBillId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)this.getModel().getDataEntity(), (String)"attconrecord");
        }
        if (attConfirmBillId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8003\u52e4\u786e\u8ba4\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"MobileAttConfirmBillEdit_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        return attConfirmBillId;
    }

    private Tuple<Tuple<Boolean, Boolean>, String> beforeOpenValidator(DynamicObject attConRecord) {
        DynamicObject perAttPeriod;
        long receiver = attConRecord.getLong("receiver.id");
        long currUserId = RequestContext.get().getCurrUserId();
        if (receiver == 0L || receiver != currUserId) {
            return new Tuple((Object)new Tuple((Object)true, (Object)false), (Object)AttConfirmKDString.getDoNotHaveAccessToThisAttConfirmForm());
        }
        String conRecordType = attConRecord.getString("type");
        if (AttConRecordTypeEnum.BY_PERIOD.getCode().equals(conRecordType) && ((perAttPeriod = attConRecord.getDynamicObject("perattperiod")) == null || !this.checkPerAttPeriod(perAttPeriod))) {
            return new Tuple((Object)new Tuple((Object)true, (Object)true), (Object)AttConfirmKDString.getAttConfirmPerAttPeriodInvalid());
        }
        DynamicObject attFile = attConRecord.getDynamicObject("attfile");
        if (attFile == null) {
            return new Tuple((Object)new Tuple((Object)true, (Object)true), (Object)AttConfirmKDString.confirmBillAttFileIsDiscard());
        }
        long attFileId = attFile.getLong("id");
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtp_attfilebase");
        DynamicObject attFileDy = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)attFileId));
        if (!this.checkAttFile(attFileDy)) {
            return new Tuple((Object)new Tuple((Object)true, (Object)true), (Object)AttConfirmKDString.confirmBillAttFileIsDiscard());
        }
        Tuple<Boolean, String> attFileWtteToTuple = this.checkAttTo(attFileDy, attConRecord.getDate("enddate"));
        if (AttConRecordStatusEnum.CONFIRM.getCode().equals(attConRecord.get("status"))) {
            return new Tuple((Object)new Tuple(attFileWtteToTuple.getKey(), (Object)true), (Object)"");
        }
        return new Tuple((Object)new Tuple(attFileWtteToTuple.getKey(), (Object)false), attFileWtteToTuple.getValue());
    }

    private boolean checkPerAttPeriod(DynamicObject perAttPeriod) {
        String busStatus;
        if (perAttPeriod == null || perAttPeriod.getLong("id") == 0L) {
            return false;
        }
        long perAttPeriodId = perAttPeriod.getLong("id");
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtp_perattperiod");
        DynamicObject dynamicObject = serviceHelper.loadSingle((Object)perAttPeriodId);
        return dynamicObject != null && "1".equals(busStatus = dynamicObject.getString("busistatus"));
    }

    private boolean checkAttFile(DynamicObject dynamicObject) {
        String busStatus;
        return dynamicObject != null && "0".equals(busStatus = dynamicObject.getString("usablestatus"));
    }

    private Tuple<Boolean, String> checkAttTo(DynamicObject dynamicObject, Date attConfirmDate) {
        Date wtteDate;
        DynamicObject attTo = dynamicObject.getDynamicObject("wtteinfo");
        if (attTo != null && (wtteDate = attTo.getDate("accountto")) != null && wtteDate.before(attConfirmDate)) {
            return new Tuple((Object)true, (Object)AttConfirmKDString.getUnableToConfirmCausePartialDatesNotAccount());
        }
        return new Tuple((Object)false, null);
    }

    private void handleMobTablePriEntry() {
        MobTable mobTablePri = (MobTable)this.getControl("confattitemtable");
        mobTablePri.addMobTablePackageDataHandlerListener(event -> event.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new AttConfirmBillDataHandler((List)this.getModel().getEntryEntity("entryentity"), null)));
        Map<String, List<DynamicObject>> diffEntryMapByType = this.getModel().getEntryEntity("diffentryentity").stream().collect(Collectors.groupingBy(dy -> dy.getString("changedescription")));
        for (Map.Entry<String, List<DynamicObject>> diffEntry : diffEntryMapByType.entrySet()) {
            String key = diffEntry.getKey();
            List<DynamicObject> entry = diffEntry.getValue();
            MobTable table = (MobTable)this.getControl(key);
            table.addMobTablePackageDataHandlerListener(event -> event.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new AttConfirmBillDataHandler(entry, key)));
        }
        MobTable table = (MobTable)this.getControl("D");
        table.addMobTablePackageDataHandlerListener(event -> event.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new AttConfirmBillDataHandler((List)this.getModel().getEntryEntity("diffentryentity"), "D")));
    }

    private void sendUpdateTabName2ParentView() {
        if (this.getView().getParentView() != null && "wtss_attconfirmlist".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
            String tabPageName = "";
            DynamicObject attConRecord = this.getModel().getDataEntity(true).getDynamicObject("attconrecord");
            if (attConRecord == null) {
                return;
            }
            tabPageName = WTCDateUtils.date2Str((Date)attConRecord.getDate("startdate"), (String)"yyyy-MM-dd");
            if (AttConRecordTypeEnum.BY_PERIOD.getCode().equals(attConRecord.getString("type"))) {
                Date endDate = attConRecord.getDate("enddate");
                tabPageName = tabPageName + '~' + WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd");
            }
            HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
            map.put("text", new LocaleString(tabPageName));
            this.getView().getParentView().updateControlMetadata(String.valueOf(this.getAttConfirmRecordId()), map);
            this.getView().getParentView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap"});
            this.getView().getParentView().setVisible(Boolean.valueOf(true), new String[]{"mtoolbarap1"});
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void setStatusLabelStyle(Map<String, Object> map, String foreColorStr, String backColorStr) {
        map.put("fc", foreColorStr);
        map.put("bc", backColorStr);
        HashMap anotherBorderMap = Maps.newHashMapWithExpectedSize((int)4);
        String borderStyleStr = "1px_solid_" + foreColorStr;
        anotherBorderMap.put("r", borderStyleStr);
        anotherBorderMap.put("b", borderStyleStr);
        anotherBorderMap.put("t", borderStyleStr);
        anotherBorderMap.put("l", borderStyleStr);
        HashMap styleMap = Maps.newHashMapWithExpectedSize((int)1);
        styleMap.put("b", anotherBorderMap);
        map.put("s", styleMap);
    }

    private void checkLastRecordWasInvalidAndConfirmed(DynamicObject attConRecordDy) {
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setIds(Collections.singleton(attConRecordDy.getLong("id")));
        List currentRecordModels = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        if (WTCCollections.isNotEmpty((Collection)currentRecordModels) && AttConfirmHelper.getInstance().checkLastRecordInvalidAndReconfirmed((AttConfirmRecordModel)currentRecordModels.get(0))) {
            Label headRemind = (Label)this.getControl("headremind");
            headRemind.setText(WTSSKDStringHelper.lastInvalid());
            Label headRemind2 = (Label)this.getControl("headremind2");
            headRemind2.setText(WTSSKDStringHelper.lastInvalid2());
        }
    }
}

