/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtss.business.servicehelper.common.AttConfirmFormHelper;
import kd.wtc.wtss.common.utils.WTSSKDStringHelper;

public class MobileAttConfirmListFormPlugin
extends AbstractMobFormPlugin
implements EntryGridBindDataListener,
TabSelectListener {
    public void onGetControl(OnGetControlArgs evt) {
        super.onGetControl(evt);
        String controlKey = evt.getKey();
        List cacheRecords = AttConfirmFormHelper.getInstance().getCacheAttConfirmRecord(this.getView());
        for (AttConfirmRecordModel record : cacheRecords) {
            if (!controlKey.equals(String.valueOf(record.getId()))) continue;
            TabPage tabPage = new TabPage();
            tabPage.setKey(controlKey);
            evt.setControl((Control)tabPage);
            break;
        }
    }

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        ((Tab)this.getControl("tabap")).addTabSelectListener((TabSelectListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        AttConfirmFormHelper.getInstance().tabPageConsumer(args);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AttConfirmFormHelper.getInstance().cacheAttConfirmRecord(this.getView());
        AttConfirmFormHelper.getInstance().selectCurrentTab(this.getView());
        AttConfirmFormHelper.getInstance().cacheConfirmSort(this.getView());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap1"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("confirm".equals(operate.getOperateKey()) && !AttConfirmFormHelper.getInstance().hasAttConfirmRight(this.getView().getFormShowParameter().getAppId(), false)) {
            this.getView().showErrorNotification(WTSSKDStringHelper.notHaveAttConfirmRight());
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperationResult().isSuccess()) {
            String opKey;
            switch (opKey = evt.getOperateKey()) {
                case "confirm": {
                    boolean confirmSuccess = AttConfirmFormHelper.getInstance().invokeTabPageConfirm(this.getView());
                    AttConfirmFormHelper.getInstance().afterConfirm(this.getView(), confirmSuccess);
                }
            }
        }
    }

    public void pageRelease(EventObject e) {
        this.getView().close();
        super.pageRelease(e);
    }

    public void tabSelected(TabSelectEvent event) {
        String pageIdKey = event.getTabKey();
        boolean recordIsConfirmed = AttConfirmFormHelper.getInstance().checkCurrentTabWasConfirm(this.getView());
        if (WTCStringUtils.isEmpty((String)event.getTabKey())) {
            return;
        }
        long attConfirmId = Long.parseLong(event.getTabKey());
        if (attConfirmId == 0L) {
            return;
        }
        MobileBillShowParameter detailParameter = new MobileBillShowParameter();
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(event.getTabKey());
        detailParameter.setOpenStyle(openStyle);
        detailParameter.setStatus(OperationStatus.VIEW);
        detailParameter.setParentPageId(this.getView().getPageId());
        detailParameter.setFormId("wtss_attconfmob");
        detailParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "attconf"));
        detailParameter.getCustomParams().put("attConfirmId", attConfirmId);
        HRBaseServiceHelper confirmBillService = HRBaseServiceHelper.create((String)"wtam_attconfirmbill");
        QFilter qFilter = new QFilter("attconrecord", "=", (Object)attConfirmId);
        DynamicObject confirmBillDy = confirmBillService.queryOne(qFilter.toArray());
        if (confirmBillDy != null) {
            detailParameter.setPkId((Object)confirmBillDy.getLong("id"));
            this.getPageCache().put(pageIdKey, detailParameter.getPageId());
            this.getView().showForm((FormShowParameter)detailParameter);
        }
        if (recordIsConfirmed) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mtoolbarap1"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mtoolbarap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap1"});
        }
    }
}

