/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.enums.WTCApplyType;
import kd.sdk.wtc.wtbs.common.enums.WTCBillType;
import kd.sdk.wtc.wtss.business.homepage.BeforeShowApplyPageEvent;
import kd.sdk.wtc.wtss.business.homepage.BeforeShowDetailPageEvent;
import kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtss.business.servicehelper.mobile.MobileBillPageBusiness;
import kd.wtc.wtss.common.constants.MobileBillConstants;
import kd.wtc.wtss.common.dto.mobilebill.AuditBillModel;

public class MobileBillFormPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener,
PullRefreshListener,
EntryGridBindDataListener,
MobileSearchTextChangeListener {
    private static final Log logger = LogFactory.getLog(MobileBillFormPlugin.class);
    private final MobileBillPageBusiness mobileBillPageBusiness = MobileBillPageBusiness.getInstance();

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (!this.mobileBillPageBusiness.hasViewRight(args.getFormShowParameter().getAppId())) {
            args.setCancel(true);
            args.setCancelMessage(MobileBillConstants.NO_VIEW_RIGHT.loadKDString());
        }
    }

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        this.addClickListeners(new String[]{"flextofilter"});
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl("mobilesearchap");
        mobileSearch.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void initialize() {
        super.initialize();
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addPullRefreshlisteners((PullRefreshListener)this);
        cardEntry.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
        String billStatus = this.getPageCache().get("cacheBillStatus");
        String timeRange = this.getPageCache().get("cacheTimeRange");
        String billType = this.getPageCache().get("cacheBillType");
        this.initControls(billStatus, timeRange, billType);
    }

    public void entryGridBindData(EntryGridBindDataEvent entryGridBindDataEvent) {
        super.entryGridBindData(entryGridBindDataEvent);
        this.custEntryGridBindData(entryGridBindDataEvent);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equals((CharSequence)controlKey, (CharSequence)"flextofilter")) {
            String timeStamp = this.getPageCache().get("cacheTimestamp");
            if (!StringUtils.isEmpty((CharSequence)timeStamp)) {
                long lastTimeStamp = Long.parseLong(timeStamp);
                if (System.currentTimeMillis() - lastTimeStamp < 2000L) {
                    return;
                }
            }
            this.getPageCache().put("cacheTimestamp", String.valueOf(System.currentTimeMillis()));
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_filter_choose"));
            showParameter.setFormId("wtss_conditionfilter_m");
            this.setFilterData(showParameter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        MobileSearch search = (MobileSearch)mobileSearchTextChangeEvent.getSource();
        String searchText = search.getText();
        this.getPageCache().put("cacheSearchContent", searchText);
        this.getView().invokeOperation("refresh");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("close_filter_choose".equals(closedCallBackEvent.getActionId())) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            String billStatus = (String)returnData.get("cacheBillStatus");
            String timeRange = (String)returnData.get("cacheTimeRange");
            String billType = (String)returnData.get("cacheBillType");
            String orgId = (String)returnData.get("cacheBillOrg");
            this.getPageCache().put("cacheBillStatus", billStatus);
            this.getPageCache().put("cacheTimeRange", timeRange);
            this.getPageCache().put("cacheBillType", billType);
            this.getPageCache().put("cacheBillOrg", orgId);
            HashMap<String, String> fieldMap = new HashMap<String, String>(16);
            fieldMap.put("fc", "#276FF5");
            this.getView().updateControlMetadata("labelfilter", fieldMap);
            this.getView().updateControlMetadata("vectorfilter", fieldMap);
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)"actionid_billcontainer", (String)closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void custEntryGridBindData(EntryGridBindDataEvent entryGridBindDataEvent) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        AbstractGrid.GridState entryState = grid.getEntryState();
        String billType = this.getPageCache().get("cacheBillType");
        if (StringUtils.isEmpty((CharSequence)billType)) {
            billType = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        }
        if (StringUtils.isEmpty((CharSequence)billType)) {
            Map formRights = this.mobileBillPageBusiness.getFormRights(this.getView().getFormShowParameter().getAppId());
            Map billTypeRights = this.mobileBillPageBusiness.getBillTypeRights(formRights);
            billType = this.findFirstNotEmptyBillType(billTypeRights, entryState);
            if (StringUtils.isEmpty((CharSequence)billType)) {
                billType = this.mobileBillPageBusiness.getDefaultBillType(billTypeRights);
            }
            if (StringUtils.isEmpty((CharSequence)billType)) {
                this.getView().showErrorNotification(MobileBillConstants.NO_VIEW_RIGHT.loadKDString());
                return;
            }
        }
        this.getPageCache().put("cacheBillType", billType);
        Map<String, Object> auditBillModelsMap = this.getBillData(billType, entryState.getCurrentPageIndex() - 1, entryState.getPageRows(), false);
        List auditBillModels = (List)auditBillModelsMap.get("data");
        int totalCount = (Integer)auditBillModelsMap.get("total");
        if (entryState.getCurrentPageIndex() < 2) {
            this.getPageCache().put("cacheBillListData", SerializationUtils.serializeToBase64((Object)auditBillModels));
        } else {
            String billDatas = this.getPageCache().get("cacheBillListData");
            List auditBillModelsCache = (List)SerializationUtils.deSerializeFromBase64((String)billDatas);
            auditBillModelsCache.addAll(auditBillModels);
            this.getPageCache().put("cacheBillListData", SerializationUtils.serializeToBase64((Object)auditBillModelsCache));
        }
        if (CollectionUtils.isEmpty((Collection)auditBillModels)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
        }
        int startIndex = 0;
        int endIndex = 0;
        int rowCount = totalCount;
        int pageCount = 0;
        if (grid.isNeedPaged()) {
            pageCount = rowCount / entryState.getPageRows() + (rowCount % entryState.getPageRows() > 0 ? 1 : 0);
            if (pageCount == 0) {
                pageCount = 1;
            }
            if (entryState.getCurrentPageIndex() < 1) {
                entryState.setCurrentPageIndex(Integer.valueOf(1));
            } else if (entryState.getCurrentPageIndex() > pageCount) {
                entryState.setCurrentPageIndex(Integer.valueOf(pageCount));
            }
            startIndex = (entryState.getCurrentPageIndex() - 1) * entryState.getPageRows();
            endIndex = Math.min(startIndex + grid.getPageRow(), rowCount);
        } else {
            endIndex = rowCount;
        }
        ArrayList<RowDataEntity> objs = new ArrayList<RowDataEntity>();
        ArrayList<List> rows = new ArrayList<List>();
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("entryentity");
        DynamicObject[] dataEntitys = this.mobileBillPageBusiness.getRowDynamicObjects(entityType, auditBillModels);
        if (dataEntitys != null && dataEntitys.length > 0) {
            int range = Math.min(dataEntitys.length, endIndex - startIndex);
            for (int rowIndex = 0; rowIndex < range; ++rowIndex) {
                objs.add(new RowDataEntity(rowIndex + startIndex, dataEntitys[rowIndex]));
            }
            if (grid.getRuleCount() > 0) {
                RuleContainer ruleContainer = (RuleContainer)this.getView().getService(RuleContainer.class);
                ruleContainer.raise(new RaiseEventSource(RaiseEventType.Initialized, objs, (IDataEntityType)entityType), (RuleExecuteContext)new FormRuleExecuteContext(this.getView()));
            }
            for (RowDataEntity obj : objs) {
                BindingContext bindCtx = new BindingContext((IDataEntityType)entityType, obj.getDataEntity(), obj.getRowIndex());
                rows.add(grid.getRowBindValue(bindCtx));
            }
        }
        entryGridBindDataEvent.getData().put("rowcount", rowCount);
        entryGridBindDataEvent.getData().put("rows", rows);
        entryGridBindDataEvent.getData().put("pagecount", pageCount);
        entryGridBindDataEvent.getData().put("datacount", rowCount);
    }

    public void entryRowClick(RowClickEvent evt) {
        String billDatas = this.getPageCache().get("cacheBillListData");
        if (!StringUtils.isEmpty((CharSequence)billDatas)) {
            String timeStamp = this.getPageCache().get("cacheTimestamp");
            if (!StringUtils.isEmpty((CharSequence)timeStamp)) {
                long lastTimeStamp = Long.parseLong(timeStamp);
                if (System.currentTimeMillis() - lastTimeStamp < 2000L) {
                    return;
                }
            }
            this.getPageCache().put("cacheTimestamp", String.valueOf(System.currentTimeMillis()));
            List auditBillModels = (List)SerializationUtils.deSerializeFromBase64((String)billDatas);
            AuditBillModel auditBillModel = (AuditBillModel)auditBillModels.get(evt.getRow());
            if (auditBillModel != null) {
                String formId = AuditBillModel.getBillTypePage((int)auditBillModel.getBillType(), (boolean)auditBillModel.isChange(), (int)auditBillModel.getApplyType());
                this.openBillDetailPage(formId, auditBillModel);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        Object newValue;
        super.propertyChanged(propertyChangedArgs);
        String key = propertyChangedArgs.getProperty().getName();
        Object object = newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).get()).getNewValue() : null;
        if ("combobillstatus".equals(key)) {
            if (newValue != null) {
                this.getPageCache().put("cacheBillStatus", (String)newValue);
            }
        } else if ("combotimerange".equals(key)) {
            if (newValue != null) {
                this.getPageCache().put("cacheTimeRange", (String)newValue);
            }
        } else if (newValue != null && "combobilltype".equals(key)) {
            this.getPageCache().put("cacheBillType", (String)newValue);
        }
        this.getView().invokeOperation("refresh");
    }

    private void initControls(String billStatus, String timeRange, String billType) {
        if (StringUtils.isEmpty((CharSequence)billStatus)) {
            billStatus = ",H,";
        }
        if (StringUtils.isEmpty((CharSequence)billType)) {
            billType = String.valueOf(2);
        }
        this.getModel().setValue("combobillstatus", (Object)billStatus);
        this.getModel().setValue("combotimerange", (Object)timeRange);
        this.getModel().setValue("combobilltype", (Object)billType);
    }

    private void openBillDetailPage(String formId, AuditBillModel auditBillModel) {
        long pkid = auditBillModel.getId();
        if (StringUtils.isEmpty((CharSequence)formId) || pkid == 0L) {
            return;
        }
        WTCBillType billType = (WTCBillType)BillCommonService.getInstance().BILL_TYPE_MAP_WTSS.get(auditBillModel.getBillType());
        WTCApplyType applyType = Integer.valueOf(0).equals(auditBillModel.getApplyType()) ? WTCApplyType.SELF : WTCApplyType.OTHER;
        BeforeShowDetailPageEvent beforeShowDetailPageEvent = new BeforeShowDetailPageEvent(billType, applyType, (FormShowParameter)new MobileBillShowParameter());
        WTCPluginProxy proxy = WTCPluginProxyFactory.create(BillReplaceExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin");
        proxy.invokeReplace(plugin -> plugin.beforeShowDetailPage(beforeShowDetailPageEvent));
        FormShowParameter formShowParameter = beforeShowDetailPageEvent.getFormShowParameter();
        if (BillCommonService.getInstance().hasFormId((BeforeShowApplyPageEvent)beforeShowDetailPageEvent)) {
            ((BillShowParameter)formShowParameter).setPkId((Object)pkid);
            this.getView().showForm(formShowParameter);
            return;
        }
        String billAppId = MobileCommonServiceHelper.getInstance().getBillAppId(formId, this.getView());
        logger.info("mobilehome.openBillDetailPage:formId={},pkid={},billAppId={}", new Object[]{formId, pkid, billAppId});
        HashMap<String, Object> customParams = new HashMap<String, Object>(20);
        customParams.put("billType", auditBillModel.getBillType());
        customParams.put("isChange", auditBillModel.isChange());
        customParams.put("billapplyType", auditBillModel.getApplyType());
        customParams.put("flagWorkFlow", Boolean.FALSE);
        customParams.put("flagFromMyBill", Boolean.TRUE);
        customParams.put("sourceApp", "myTime");
        customParams.put("personid_cache", BillUnifyService.getUserId((IFormView)this.getView()));
        BillContainerService.getInstance().openContainer(billAppId, Long.valueOf(pkid), customParams, formId, this.getView(), (IFormPlugin)this);
    }

    public void pullRefesh(PullRefreshEvent pullRefreshEvent) {
        this.getView().invokeOperation("refresh");
    }

    private String findFirstNotEmptyBillType(Map<String, Boolean> billTypeRights, AbstractGrid.GridState entryState) {
        String billType = null;
        for (Map.Entry<String, Boolean> entry : billTypeRights.entrySet()) {
            Map<String, Object> countMap;
            if (!entry.getValue().booleanValue() || (countMap = this.getBillData(entry.getKey(), entryState.getCurrentPageIndex() - 1, entryState.getPageRows(), true)).get("total") == null || !(countMap.get("total") instanceof Integer) || (Integer)countMap.get("total") <= 0) continue;
            billType = entry.getKey();
            break;
        }
        return billType;
    }

    private Map<String, Object> getBillData(String billType, int pageStart, int pageSize, boolean onlyCount) {
        Long orgId;
        String billStatus = this.getPageCache().get("cacheBillStatus");
        String timeRange = this.getPageCache().get("cacheTimeRange");
        List auditStatusChoose = null;
        if (!StringUtils.isEmpty((CharSequence)billStatus)) {
            auditStatusChoose = this.mobileBillPageBusiness.getAuditStatusChoose(billStatus);
        }
        if (StringUtils.isEmpty((CharSequence)timeRange)) {
            timeRange = "3";
            this.getPageCache().put("cacheTimeRange", timeRange);
        }
        Date[] startAndEndDate = MobileBillPageBusiness.getStartAndEndDate((String)timeRange);
        String searchContent = this.getPageCache().get("cacheSearchContent");
        Long personId = this.getPersonId();
        Long userId = RequestContext.get().getCurrUserId();
        String cacheOrgId = this.getPageCache().get("cacheBillOrg");
        Long l = orgId = StringUtils.isNotBlank((CharSequence)cacheOrgId) ? Long.valueOf(cacheOrgId) : null;
        if (onlyCount) {
            Integer billCount = this.mobileBillPageBusiness.countBills(userId, personId, orgId, auditStatusChoose, startAndEndDate, Integer.parseInt(billType), searchContent, pageStart, pageSize, this.getView().getFormShowParameter().getAppId());
            return ImmutableMap.of((Object)"total", (Object)billCount);
        }
        return this.mobileBillPageBusiness.queryBills(userId, personId, orgId, auditStatusChoose, startAndEndDate, Integer.parseInt(billType), searchContent, pageStart, pageSize, this.getView().getFormShowParameter().getAppId());
    }

    private void setFilterData(MobileFormShowParameter showParameter) {
        String billStatus = this.getPageCache().get("cacheBillStatus");
        String timeRange = this.getPageCache().get("cacheTimeRange");
        String billType = this.getPageCache().get("cacheBillType");
        String orgId = this.getPageCache().get("cacheBillOrg");
        showParameter.setCustomParam("cacheBillStatus", (Object)billStatus);
        showParameter.setCustomParam("cacheTimeRange", (Object)timeRange);
        showParameter.setCustomParam("cacheBillType", (Object)billType);
        showParameter.setCustomParam("cacheBillOrg", (Object)orgId);
    }

    private long getPersonId() {
        String currPersonId;
        IPageCache pageCache = this.getView().getPageCache();
        String personId = pageCache.get(currPersonId = "currPersonId");
        if (StringUtils.isBlank((CharSequence)personId)) {
            Long userId = BillUnifyService.getUserId((IFormView)this.getView());
            personId = userId == null ? "0" : String.valueOf(userId);
            pageCache.put(currPersonId, personId);
        }
        return Long.parseLong(personId);
    }
}

