/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.common.model.bill.BillSystemParamRange;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtss.business.servicehelper.mobile.MobileBillPageBusiness;
import kd.wtc.wtss.common.constants.MobileBillConstants;
import kd.wtc.wtss.common.constants.MobileConfConstants;

public class MobileConditionFilterFormPlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private final MobileBillPageBusiness mobileBillPageBusiness = MobileBillPageBusiness.getInstance();
    private static final Log logger = LogFactory.getLog(MobileConditionFilterFormPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        String workspace = (String)args.getFormShowParameter().getCustomParam("workspace");
        logger.info("MobileConditionFilterFormPlugin.preOpenForm workspace={}", (Object)workspace);
        if (HRStringUtils.isNotEmpty((String)workspace) && "workspace_teamhomepage".equals(workspace)) {
            if (!this.mobileBillPageBusiness.hasViewRightForOther("wtss")) {
                args.setCancel(true);
                args.setCancelMessage(MobileBillConstants.NO_VIEW_RIGHT_FOR_OTHER.loadKDString());
            }
        } else if (!this.mobileBillPageBusiness.hasViewRight(args.getFormShowParameter().getAppId())) {
            args.setCancel(true);
            args.setCancelMessage(MobileBillConstants.NO_VIEW_RIGHT.loadKDString());
        }
    }

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        this.addClickListeners(new String[]{"toolreset", "toolsave"});
        ((OrgEdit)this.getControl("org")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        HashSet billSatus;
        Map billTypeRights;
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billStatus = (String)formShowParameter.getCustomParam("cacheBillStatus");
        String timeRange = (String)formShowParameter.getCustomParam("cacheTimeRange");
        String billType = (String)formShowParameter.getCustomParam("cacheBillType");
        String orgId = (String)formShowParameter.getCustomParam("cacheBillOrg");
        String workspace = (String)this.getView().getFormShowParameter().getCustomParam("workspace");
        if (HRStringUtils.isNotEmpty((String)workspace) && "workspace_teamhomepage".equals(workspace)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"org"});
        }
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            this.getModel().setValue("org", (Object)Long.valueOf(orgId));
            this.getPageCache().put("cacheBillOrg", orgId);
        }
        logger.info("MobileConditionFilterFormPlugin.beforeBindData workspace={}", (Object)workspace);
        Map formRights = HRStringUtils.isEmpty((String)workspace) ? this.mobileBillPageBusiness.getFormRights(this.getView().getFormShowParameter().getAppId()) : this.mobileBillPageBusiness.getFormRightsForOther("wtss");
        Map map = billTypeRights = HRStringUtils.isEmpty((String)workspace) ? this.mobileBillPageBusiness.getBillTypeRights(formRights) : this.mobileBillPageBusiness.getBillTypeRightsForOther(formRights);
        if ((StringUtils.isEmpty((CharSequence)billType) || !Boolean.TRUE.equals(billTypeRights.get(billType))) && StringUtils.isEmpty((CharSequence)(billType = this.mobileBillPageBusiness.getDefaultBillType(billTypeRights)))) {
            this.getView().showErrorNotification(MobileBillConstants.NO_VIEW_RIGHT.loadKDString());
        }
        LinkedHashMap billTypeControls = Maps.newLinkedHashMap();
        billTypeControls.put(String.valueOf(3), "radiowtom");
        billTypeControls.put(String.valueOf(2), "radiowtabm");
        billTypeControls.put(String.valueOf(1), "radiowtam");
        billTypeControls.put(String.valueOf(4), "radiowtpm");
        billTypeControls.put(String.valueOf(5), "radiowts");
        Object[] disableControls = (String[])billTypeRights.entrySet().stream().filter(entry -> Boolean.FALSE.equals(entry.getValue())).map(entry -> (String)billTypeControls.get(entry.getKey())).toArray(String[]::new);
        if (ArrayUtils.isNotEmpty((Object[])disableControls)) {
            WTCFormUtils.lockRadioFields((IFormView)this.getView(), (String[])disableControls);
        }
        this.getModel().setValue("radiogroupbilltype", (Object)billType);
        this.getPageCache().put("cacheBillType", billType);
        if (!StringUtils.isEmpty((CharSequence)timeRange)) {
            if (timeRange.length() < "yyyy-MM-dd HH:mm:ss;yyyy-MM-dd HH:mm:ss".length()) {
                this.getModel().setValue("radiogroupbilldate", (Object)timeRange);
            } else {
                String[] dateArray = timeRange.split(";");
                this.getModel().setValue("daterangefield_startdate", (Object)WTCDateUtils.str2Date((String)dateArray[0], (String)"yyyy-MM-dd HH:mm:ss"));
                this.getModel().setValue("daterangefield_enddate", (Object)WTCDateUtils.str2Date((String)dateArray[1], (String)"yyyy-MM-dd HH:mm:ss"));
            }
            this.getPageCache().put("cacheTimeRange", timeRange);
        } else {
            this.getModel().setValue("radiogroupbilldate", (Object)"3");
            this.getPageCache().put("cacheTimeRange", "3");
        }
        if (StringUtils.isEmpty((CharSequence)billStatus)) {
            billSatus = new HashSet(8);
            billSatus.add(MobileBillConstants.MAP_BILL_STATUS.get("checkall"));
            this.getPageCache().put("cacheBillStatus", SerializationUtils.toJsonString((Object)billSatus));
        } else {
            billSatus = Sets.newHashSet((Object[])WTCStringUtils.split((String)billStatus, (String)","));
            this.initCheckControl(billSatus);
            this.getPageCache().put("cacheBillStatus", SerializationUtils.toJsonString((Object)billSatus));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"toolsave")) {
            Object org;
            String cachedBillType = this.getPageCache().get("cacheBillType");
            if (StringUtils.isBlank((CharSequence)cachedBillType)) {
                this.getView().showErrorNotification(MobileBillConstants.NO_VIEW_RIGHT.loadKDString());
                return;
            }
            if (!this.checkBillAuth(cachedBillType)) {
                return;
            }
            if (!this.containsOrg()) {
                this.getView().showErrorNotification(MobileBillConstants.RIGHT_HAS_CHANGED.loadKDString());
                return;
            }
            if (this.getModel().getValue("radiogroupbilldate") == null && !this.checkDateRange()) {
                int billType = Integer.parseInt(cachedBillType);
                BillSystemParamRange range = this.mobileBillPageBusiness.getBillSystemParamRange(billType);
                String unit = this.mobileBillPageBusiness.genUnitStr(range);
                this.getView().showMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u5927\u53ef\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e3a%1$s", (String)"MobileConditionFilterFormPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), range.getRange()) + unit);
                return;
            }
            HashMap<String, String> returnMap = new HashMap<String, String>(3);
            Set billStatus = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("cacheBillStatus"), Set.class);
            if (!CollectionUtils.isEmpty((Collection)billStatus)) {
                returnMap.put("cacheBillStatus", String.join((CharSequence)",", billStatus));
            }
            returnMap.put("cacheBillOrg", (org = this.getModel().getValue("org")) instanceof DynamicObject ? ((DynamicObject)org).getPkValue().toString() : null);
            returnMap.put("cacheBillType", this.getPageCache().get("cacheBillType"));
            String rangeStart = this.getStartDateAsString();
            if (StringUtils.isEmpty((CharSequence)rangeStart)) {
                returnMap.put("cacheTimeRange", this.getPageCache().get("cacheTimeRange"));
            } else {
                String rangeEnd = this.getEndDateAsString();
                returnMap.put("cacheTimeRange", rangeStart + ";" + rangeEnd);
            }
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"toolreset")) {
            String workspace = (String)this.getView().getFormShowParameter().getCustomParam("workspace");
            Map formRights = HRStringUtils.isEmpty((String)workspace) ? this.mobileBillPageBusiness.getFormRights(this.getView().getFormShowParameter().getAppId()) : this.mobileBillPageBusiness.getFormRightsForOther("wtss");
            Map billTypeRights = HRStringUtils.isEmpty((String)workspace) ? this.mobileBillPageBusiness.getBillTypeRights(formRights) : this.mobileBillPageBusiness.getBillTypeRightsForOther(formRights);
            String billType = this.mobileBillPageBusiness.getDefaultBillType(billTypeRights);
            if (StringUtils.isEmpty((CharSequence)billType)) {
                this.getView().showErrorNotification(MobileBillConstants.NO_VIEW_RIGHT.loadKDString());
                return;
            }
            this.getModel().setValue("org", null);
            this.getModel().setValue("radiogroupbilltype", (Object)billType);
            this.getModel().setValue("radiogroupbilldate", (Object)"3");
            this.getModel().setValue("daterangefield_startdate", null);
            this.getModel().setValue("daterangefield_enddate", null);
            HashSet<String> billSatus = new HashSet<String>(8);
            billSatus.add((String)MobileBillConstants.MAP_BILL_STATUS.get("checkall"));
            this.getPageCache().put("cacheBillStatus", SerializationUtils.toJsonString(billSatus));
            this.initCheckControl(billSatus);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        Object newValue;
        super.propertyChanged(propertyChangedArgs);
        IDataModel model = this.getModel();
        String key = propertyChangedArgs.getProperty().getName();
        Object object = newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).get()).getNewValue() : null;
        if ("daterangefield_enddate".equals(key) && newValue == null) {
            model.setValue("radiogroupbilldate", (Object)"3");
            this.getPageCache().put("cacheTimeRange", "3");
            return;
        }
        if (newValue == null) {
            return;
        }
        if ("radiogroupbilltype".equals(key)) {
            this.getPageCache().put("cacheBillType", (String)newValue);
        } else if ("radiogroupbilldate".equals(key)) {
            this.getPageCache().put("cacheTimeRange", (String)newValue);
            model.beginInit();
            model.setValue("daterangefield_startdate", null);
            model.setValue("daterangefield_enddate", null);
            model.endInit();
            this.getView().updateView("daterangefield");
        } else if ("daterangefield_startdate".equals(key) || "daterangefield_enddate".equals(key)) {
            this.getPageCache().put("cacheTimeRange", "");
            model.setValue("radiogroupbilldate", null);
            if (!this.checkDateRange()) {
                int billType = Integer.parseInt(this.getPageCache().get("cacheBillType"));
                BillSystemParamRange range = this.mobileBillPageBusiness.getBillSystemParamRange(billType);
                String unit = this.mobileBillPageBusiness.genUnitStr(range);
                this.getView().showMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u5927\u53ef\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e3a%1$s", (String)"MobileConditionFilterFormPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), range.getRange()) + unit);
            }
        } else if (StringUtils.startsWith((CharSequence)key, (CharSequence)"check")) {
            Set billSatus = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("cacheBillStatus"), Set.class);
            if (((Boolean)newValue).booleanValue()) {
                billSatus.add(MobileBillConstants.MAP_BILL_STATUS.get(key));
                this.getPageCache().put("cacheBillStatus", SerializationUtils.toJsonString((Object)billSatus));
                if (StringUtils.equals((CharSequence)key, (CharSequence)"checkall")) {
                    model.setValue("checktemp", (Object)Boolean.FALSE);
                    model.setValue("checkapproved", (Object)Boolean.FALSE);
                    model.setValue("checkunderapproval", (Object)Boolean.FALSE);
                    model.setValue("checkreject", (Object)Boolean.FALSE);
                    model.setValue("checkabandon", (Object)Boolean.FALSE);
                    model.setValue("checktoresubmit", (Object)Boolean.FALSE);
                } else {
                    model.setValue("checkall", (Object)Boolean.FALSE);
                }
            } else {
                billSatus.remove(MobileBillConstants.MAP_BILL_STATUS.get(key));
                this.getPageCache().put("cacheBillStatus", SerializationUtils.toJsonString((Object)billSatus));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("org".equals(((Control)beforeF7SelectEvent.getSource()).getKey())) {
            HasPermOrgResult result = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtss", "wtss_mobilehomepage", "47150e89000000ac");
            if (result != null && !result.hasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)result.getHasPermOrgs())) {
                QFilter filters = new QFilter("id", "in", (Object)result.getHasPermOrgs());
                FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
                String otherFilters = (String)formShowParameter.getCustomParam("_otherFilters_");
                if (StringUtils.isNotBlank((CharSequence)otherFilters)) {
                    QFilter filter = QFilter.fromSerializedString((String)otherFilters);
                    filters.and(filter);
                }
                formShowParameter.setCustomParam("_otherFilters_", (Object)filters.toSerializedString());
                beforeF7SelectEvent.setFormShowParameter(formShowParameter);
            } else if (result == null || !result.hasAllOrgPerm() && CollectionUtils.isEmpty((Collection)result.getHasPermOrgs())) {
                QFilter filters = new QFilter("id", "=", (Object)-1);
                FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setCustomParam("_otherFilters_", (Object)filters.toSerializedString());
                beforeF7SelectEvent.setFormShowParameter(formShowParameter);
            }
        }
    }

    private void initCheckControl(Set<String> billSatus) {
        boolean isAll = billSatus.contains(MobileBillConstants.MAP_BILL_STATUS.get("checkall"));
        this.getModel().setValue("checkall", (Object)isAll);
        boolean isTemp = billSatus.contains(MobileBillConstants.MAP_BILL_STATUS.get("checktemp"));
        this.getModel().setValue("checktemp", (Object)isTemp);
        boolean isApproved = billSatus.contains(MobileBillConstants.MAP_BILL_STATUS.get("checkapproved"));
        this.getModel().setValue("checkapproved", (Object)isApproved);
        boolean isUnderApproval = billSatus.contains(MobileBillConstants.MAP_BILL_STATUS.get("checkunderapproval"));
        this.getModel().setValue("checkunderapproval", (Object)isUnderApproval);
        boolean isReject = billSatus.contains(MobileBillConstants.MAP_BILL_STATUS.get("checkreject"));
        this.getModel().setValue("checkreject", (Object)isReject);
        boolean isAbandon = billSatus.contains(MobileBillConstants.MAP_BILL_STATUS.get("checkabandon"));
        this.getModel().setValue("checkabandon", (Object)isAbandon);
        boolean isToResubmit = billSatus.contains(MobileBillConstants.MAP_BILL_STATUS.get("checktoresubmit"));
        this.getModel().setValue("checktoresubmit", (Object)isToResubmit);
    }

    private boolean checkDateRange() {
        int billType = Integer.parseInt(this.getPageCache().get("cacheBillType"));
        BillSystemParamRange range = this.mobileBillPageBusiness.getBillSystemParamRange(billType);
        if (range == null) {
            return true;
        }
        String timeRange = this.getPageCache().get("cacheTimeRange");
        ArrayList<String> dateRange = new ArrayList<String>(2);
        if (!StringUtils.isEmpty((CharSequence)timeRange)) {
            Date[] dates = MobileBillPageBusiness.getStartAndEndDate((String)timeRange);
            dateRange.add(WTCDateUtils.date2Str((Date)dates[0], (String)"yyyy-MM-dd"));
            dateRange.add(WTCDateUtils.date2Str((Date)dates[1], (String)"yyyy-MM-dd"));
        } else if (this.getModel().getValue("daterangefield_startdate") != null && this.getModel().getValue("daterangefield_enddate") != null) {
            dateRange.add(this.getStartDateAsString());
            dateRange.add(this.getEndDateAsString());
        }
        return CollectionUtils.isEmpty(dateRange) || this.mobileBillPageBusiness.dateCheckSuccess(range, dateRange);
    }

    private boolean containsOrg() {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        if (orgId == 0L) {
            return true;
        }
        String cachedBillType = this.getPageCache().get("cacheBillType");
        Object[] formKeys = this.mobileBillPageBusiness.getBillTypeFormKeys(cachedBillType);
        if (ArrayUtils.isEmpty((Object[])formKeys)) {
            return true;
        }
        boolean containsOrg = false;
        for (Object formKey : formKeys) {
            HasPermOrgResult result = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs(this.getView().getFormShowParameter().getAppId(), (String)formKey);
            if (result == null || result.hasAllOrgPerm() || result.getHasPermOrgs() == null || !result.getHasPermOrgs().contains(orgId)) continue;
            containsOrg = true;
            break;
        }
        return containsOrg;
    }

    private String getStartDateAsString() {
        return WTCDateUtils.date2Str((Date)((Date)this.getModel().getValue("daterangefield_startdate")), (String)"yyyy-MM-dd HH:mm:ss");
    }

    private String getEndDateAsString() {
        return WTCDateUtils.date2Str((Date)((Date)this.getModel().getValue("daterangefield_enddate")), (String)"yyyy-MM-dd") + " 23:59:59";
    }

    private boolean checkBillAuth(String billType) {
        String workspace = (String)this.getView().getFormShowParameter().getCustomParam("workspace");
        if ("workspace_teamhomepage".equals(workspace)) {
            Map formRights = HRStringUtils.isEmpty((String)workspace) ? this.mobileBillPageBusiness.getFormRights(this.getView().getFormShowParameter().getAppId()) : this.mobileBillPageBusiness.getFormRightsForOther("wtss");
            Map billTypeRights = HRStringUtils.isEmpty((String)workspace) ? this.mobileBillPageBusiness.getBillTypeRights(formRights) : this.mobileBillPageBusiness.getBillTypeRightsForOther(formRights);
            Boolean hasAuth = (Boolean)billTypeRights.get(billType);
            if (logger.isDebugEnabled()) {
                logger.debug("MobileConditionFilterFormPlugin#checkBillAuth billType:{},hasAuth :{}", (Object)billType, (Object)hasAuth);
            }
            if (!Boolean.TRUE.equals(hasAuth)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobileTeamHomeOtherBillPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[]{this.getBillName(billType)}));
                return false;
            }
        }
        return true;
    }

    private String getBillName(String billType) {
        switch (billType) {
            case "1": {
                return MobileConfConstants.BillTypes.H.getMultiLang().loadKDString();
            }
            case "2": {
                return MobileConfConstants.BillTypes.F.getMultiLang().loadKDString();
            }
            case "3": {
                return MobileConfConstants.BillTypes.G.getMultiLang().loadKDString();
            }
            case "4": {
                return MobileConfConstants.BillTypes.I.getMultiLang().loadKDString();
            }
            case "5": {
                return MobileConfConstants.BillTypes.J.getMultiLang().loadKDString();
            }
        }
        return "";
    }
}

