/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.business.custom.WTCCustomControlExtPlugin;
import kd.sdk.wtc.wtbs.common.enums.WTCApplyType;
import kd.sdk.wtc.wtbs.common.enums.WTCBillType;
import kd.sdk.wtc.wtss.business.homepage.BeforeChooseApplyTypeEvent;
import kd.sdk.wtc.wtss.business.homepage.BeforeShowApplyPageEvent;
import kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.model.mobile.AbnormalDealModel;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.business.cumulate.trading.QTLineDetailOuterService;
import kd.wtc.wtp.common.constants.QTSchemeConstants;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;
import kd.wtc.wtp.common.model.personhome.QuotaIndexQueryDto;
import kd.wtc.wtss.business.attstatistics.AttConfirmServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.AttConfirmFormHelper;
import kd.wtc.wtss.business.servicehelper.common.HomePageServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.PrivacyHelper;
import kd.wtc.wtss.business.servicehelper.summaryconf.SummaryConfigDetailService;
import kd.wtc.wtss.common.constants.MobileHomeConstants;
import kd.wtc.wtss.common.dto.MobileHomeConf;
import kd.wtc.wtss.common.dto.mobilehome.AbnormalDealMethodModel;
import kd.wtc.wtss.common.dto.mobilehome.AttRecordModel;
import kd.wtc.wtss.common.dto.mobilehome.CalendarGetDataModel;
import kd.wtc.wtss.common.dto.mobilehome.CalendarInitModel;
import kd.wtc.wtss.common.dto.mobilehome.DateDataModel;
import kd.wtc.wtss.common.dto.mobilehome.PeriodDetailModel;
import kd.wtc.wtss.common.dto.summaryconf.SummaryConfDetail;
import kd.wtc.wtss.common.utils.WTSSDateUtils;

public class MobileHomePageFormPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(MobileHomePageFormPlugin.class);
    private final MobileHomePageBusiness mobileHomePageBusiness = MobileHomePageBusiness.getInstance();
    public static final String PER_ATTPERIOD_CACHE_KEY = "perAttPeriodCacheMap";

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        PrivacyHelper.handlePrivacyCheck((PreOpenFormEventArgs)evt);
        evt.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6211\u7684\u5047\u52e4", (String)"MobileHomePageFormPlugin_8", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        this.addClickListeners(MobileHomeConstants.CLICK_ID);
        this.addClickListeners(MobileHomeConstants.QUOTA_INDEX_CLICK_AP);
        CardEntry container = (CardEntry)this.getView().getControl("problementity");
        container.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        boolean hasPeriod;
        String queryDataDate;
        String queryFileDate;
        Long userId;
        super.beforeBindData(eventObject);
        logger.info("mobilehome beforeBindData begin...");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParam("paramUserid") != null) {
            this.getPageCache().put("cache_isfromteam", "1");
            userId = (Long)formShowParameter.getCustomParam("paramUserid");
            queryDataDate = queryFileDate = (String)formShowParameter.getCustomParam("paramDate");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flextoteampage"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexstatisticsetting"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexmybills"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexcommproblem"});
        } else {
            Map map = this.getView().getFormShowParameter().getCustomParams();
            if (map != null && Boolean.FALSE.equals(map.get("isAgree"))) {
                this.toPrivacy(map);
                return;
            }
            userId = BillUnifyService.getUserId((IFormView)this.getView());
            queryFileDate = WTCDateUtils.date2Str((Date)new Date(), (String)"yyyy-MM-dd");
            queryDataDate = WTSSDateUtils.getLastDateString();
            this.getPageCache().put("cache_isfromteam", "0");
        }
        this.initControlState();
        Long employeeId = MobileCommonServiceHelper.getInstance().getEmployeeIdByPersonId(userId);
        logger.info("mobilehome beforeBindData getArchives begin employeeId:{}  queryFileDate:{}", (Object)employeeId, (Object)queryFileDate);
        Map attFile = MobileHomePageServiceHelper.getAttFileWithEmployeeId((Long)employeeId, (String)queryFileDate);
        if (MapUtils.isEmpty((Map)attFile)) {
            logger.info("mobilehome archives:{}", (Object)SerializationUtils.toJsonString((Object)attFile));
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnormal"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnoauthor"});
            return;
        }
        logger.info("mobilehome beforeBindData getArchives end...");
        long schemeId = MobileHomePageBusiness.getInstance().getSchemeIdWithWorkspace(attFile, "A");
        if (!this.checkScheme(schemeId)) {
            return;
        }
        logger.info("mobilehome beforeBindData getSchemeId end...");
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean hasViewRight = BillCommonService.getInstance().hasViewRight(appId, "wtss_pcteamhome");
        if (!hasViewRight) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flextoteampage"});
        }
        Long attfileBoid = Long.parseLong((String)attFile.get("boid"));
        logger.info("mobilehome archives schemeId:{} attfileBoid:{}", (Object)schemeId, (Object)attfileBoid);
        this.getPageCache().put("cache_id_boid", String.valueOf(schemeId));
        this.getPageCache().put("cache_attfile_boid", String.valueOf(attfileBoid));
        this.getPageCache().put("cache_id_userid", String.valueOf(userId));
        this.getPageCache().put("cache_id_employeeid", String.valueOf(employeeId));
        this.initHeaderInfoAssignment(attfileBoid);
        logger.info("mobilehome beforeBindData getUserAllPeriods begin...");
        List userAllPeriods = MobileHomePageServiceHelper.getUserAllPeriodsSimpleWithEmployeeId((Long)employeeId);
        if (CollectionUtils.isEmpty((Collection)userAllPeriods)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u6863\u6848\u672a\u6709\u4eba\u5458\u8003\u52e4\u671f\u95f4\uff0c\u5bfc\u81f4\u9996\u9875\u6570\u636e\u65e0\u6cd5\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonHomePCPlugin_2", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        logger.info("mobilehome beforeBindData getUserAllPeriods end...");
        PeriodDetailModel currentPeriod = this.initPeriod(userAllPeriods, queryDataDate);
        logger.info("mobilehome currentPeriod : {}", (Object)SerializationUtils.toJsonString((Object)currentPeriod));
        boolean bl = hasPeriod = currentPeriod != null && currentPeriod.getPeriod() != null;
        if (hasPeriod) {
            this.initStatistic(currentPeriod.getId(), schemeId, Long.parseLong(currentPeriod.getAttFileBid()));
            this.initQuotaStatics(schemeId);
            this.getView().getPageCache().put("cache_id_period", currentPeriod.getId());
            this.getView().getPageCache().put("PerAttId", String.valueOf(this.getPerAttPeriodKey(currentPeriod.getId())));
            AttConfirmServiceHelper.instance().updateBtnAttConfirmVisible(this.getView());
        }
        this.initControlsByAttPeriod(hasPeriod);
        this.initCalendar(currentPeriod, queryDataDate);
        this.initAuditAndCommonProblem(schemeId);
        this.showAttConfirmNotify();
        logger.info("mobilehome beforeBindData end...");
    }

    private void initQuotaStatics(long schemeId) {
        DynamicObject ruleByScheme = SchemaServiceHelper.getInstance().queryRuleByScheme(schemeId, "A");
        long quotaConfigId = ruleByScheme.getLong("quotaconfig.id");
        if (quotaConfigId == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"qttabpageap"});
            return;
        }
        this.getPageCache().put("quotaconfig.id", quotaConfigId + "");
        Date date = this.getView().getModel().getDataEntity().getDate("qtdate");
        this.initQTStatistic(quotaConfigId, date);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "flexdropdown": {
                String confStr = this.getView().getPageCache().get("cache_id_statistic");
                if (StringUtils.isEmpty((CharSequence)confStr)) break;
                List summaryConfDetail = SerializationUtils.fromJsonStringToList((String)confStr, SummaryConfDetail.class);
                this.statisticAll(summaryConfDetail, false);
                break;
            }
            case "flexpollup": {
                String confStrUp = this.getView().getPageCache().get("cache_id_statistic");
                if (StringUtils.isEmpty((CharSequence)confStrUp)) break;
                List summaryConfDetail = SerializationUtils.fromJsonStringToList((String)confStrUp, SummaryConfDetail.class);
                this.statisticShowTop(summaryConfDetail, false);
                break;
            }
            case "flexdropdownqt": {
                String confStrQT = this.getView().getPageCache().get("cache_id_statistic_qt");
                if (StringUtils.isEmpty((CharSequence)confStrQT)) break;
                List summaryConfDetail = SerializationUtils.fromJsonStringToList((String)confStrQT, SummaryConfDetail.class);
                this.statisticAll(summaryConfDetail, true);
                break;
            }
            case "flexpollupqt": {
                String confStrUpQT = this.getView().getPageCache().get("cache_id_statistic_qt");
                if (StringUtils.isEmpty((CharSequence)confStrUpQT)) break;
                List summaryConfDetail = SerializationUtils.fromJsonStringToList((String)confStrUpQT, SummaryConfDetail.class);
                this.statisticShowTop(summaryConfDetail, true);
                break;
            }
            case "flexsetting": {
                this.toConfigPage();
                break;
            }
            case "flexsettingqt": {
                this.toQTConfigPage();
                break;
            }
            case "moreproblem": {
                String isFromTeam = this.getPageCache().get("cache_isfromteam");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)isFromTeam)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u53ef\u67e5\u770b\u5458\u5de5\u8003\u52e4\u6570\u636e\uff0c\u6682\u4e0d\u652f\u6301\u6240\u9009\u64cd\u4f5c\u3002", (String)"MobileHomePageFormPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
                    return;
                }
                MobileListShowParameter showParameterProblem = new MobileListShowParameter();
                showParameterProblem.setFormId("bos_moblist");
                showParameterProblem.setBillFormId("wtp_attcommproblem");
                showParameterProblem.getOpenStyle().setShowType(ShowType.Floating);
                showParameterProblem.setHasRight(true);
                this.getView().showForm((FormShowParameter)showParameterProblem);
                break;
            }
            case "flexmybills": {
                String fromTeam = this.getPageCache().get("cache_isfromteam");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)fromTeam)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u53ef\u67e5\u770b\u5458\u5de5\u8003\u52e4\u6570\u636e\uff0c\u6682\u4e0d\u652f\u6301\u6240\u9009\u64cd\u4f5c\u3002", (String)"MobileHomePageFormPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
                    return;
                }
                MobileFormShowParameter showParameterBill = this.mobileHomePageBusiness.getShowParameter("wtss_mobilebill", ShowType.Floating);
                this.getView().showForm((FormShowParameter)showParameterBill);
                break;
            }
            case "flextoteampage": {
                List adminOrgIdList = MobileHomePageBusiness.getInstance().getAllAdminOrgIdByPersonId(MobileCommonServiceHelper.getInstance().getUserId().longValue());
                if (CollectionUtils.isEmpty((Collection)adminOrgIdList)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8fd8\u672a\u6709\u8d1f\u8d23\u90e8\u95e8\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonHomePCPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
                    return;
                }
                MobileFormShowParameter showParameterTeam = this.mobileHomePageBusiness.getShowParameter("wtss_teamhomepage_m", ShowType.Floating);
                this.getView().showForm((FormShowParameter)showParameterTeam);
                break;
            }
            case "flexpanelapqt1": 
            case "flexpanelapqt2": 
            case "flexpanelapqt3": 
            case "flexpanelapqt4": 
            case "flexpanelapqt5": 
            case "flexpanelapqt6": 
            case "flexpanelapqt7": 
            case "flexpanelapqt8": {
                int index = Integer.parseInt(key.substring(key.length() - 1)) - 1;
                String quotaSourceId = this.getView().getPageCache().get(MobileHomeConstants.STATISTIC_QT_ID[index]);
                String attItemValue = this.getView().getPageCache().get(MobileHomeConstants.VALUE_QT_ID[index]);
                if (!StringUtils.isNotEmpty((CharSequence)quotaSourceId) || !HRStringUtils.isNotEmpty((String)attItemValue)) break;
                List quotaDetailIdList = JSON.parseArray((String)this.getView().getPageCache().get(quotaSourceId), Long.class);
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("wtss_quotalistmob");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                HashMap params = Maps.newHashMap();
                params.put("currentQuotaSourceId", quotaSourceId);
                params.put("currentQuotaDetailIdList", quotaDetailIdList);
                params.put("indexIdAndQuotaDetailIdListMap", this.getView().getPageCache().get("indexIdAndQuotaDetailIdListMap"));
                if (this.getModel().getValue("qtdate") instanceof Date) {
                    params.put("selectyear", WTCDateUtils.date2Str((Date)((Date)this.getModel().getValue("qtdate")), (String)"yyyy"));
                }
                showParameter.setCustomParams((Map)params);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (opKey = op.getOperateKey()) {
            case "tobeconfirm": {
                List unConfirmRecordModels = AttConfirmFormHelper.getInstance().queryNeedConfirmList(Long.parseLong(this.getPageCache().get("cache_id_employeeid")), null, false, 0L);
                if (!unConfirmRecordModels.isEmpty()) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u786e\u8ba4\u6d88\u606f\u5df2\u5728\u5176\u4ed6\u6e20\u9053\u5b8c\u6210\u786e\u8ba4\u3002", (String)"MobileHomePageFormPlugin_12", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"unconfirmflex"});
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        if (evt.getOperationResult().isSuccess()) {
            switch (opKey) {
                case "attconf": {
                    this.showAttConfirmPage();
                    break;
                }
                case "tobeconfirm": {
                    this.showAttConfirmListPage(null, null);
                    break;
                }
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
        CardEntry cardEntry = (CardEntry)evt.getSource();
        String isFromTeam = this.getPageCache().get("cache_isfromteam");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)isFromTeam)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u53ef\u67e5\u770b\u5458\u5de5\u8003\u52e4\u6570\u636e\uff0c\u6682\u4e0d\u652f\u6301\u6240\u9009\u64cd\u4f5c\u3002", (String)"MobileHomePageFormPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)"problementity", (CharSequence)cardEntry.getKey())) {
            IFormView view = this.getView();
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setFormId("wtp_attcommproblem_mob");
            showParameter.setHasRight(true);
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
            String configString = this.getView().getPageCache().get("cache_id_config");
            if (StringUtils.isEmpty((CharSequence)configString)) {
                return;
            }
            MobileHomeConf mobileHomeConf = (MobileHomeConf)SerializationUtils.fromJsonString((String)configString, MobileHomeConf.class);
            customParams.put("question", ((MobileHomeConf.CommProblem)mobileHomeConf.getProblems().get(evt.getRow())).getProblem());
            customParams.put("answer_tag", ((MobileHomeConf.CommProblem)mobileHomeConf.getProblems().get(evt.getRow())).getAnswer());
            customParams.put("modifytime", ((MobileHomeConf.CommProblem)mobileHomeConf.getProblems().get(evt.getRow())).getModifyTime());
            showParameter.setCustomParams((Map)customParams);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("qtdate".equals(name)) {
            Long quotaConfigId = Long.valueOf(this.getPageCache().get("quotaconfig.id"));
            Date date = this.getView().getModel().getDataEntity().getDate("qtdate");
            this.initQTStatistic(quotaConfigId, date);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("close_wtss_mobileconfig".equals(closedCallBackEvent.getActionId())) {
            String periodId = this.getView().getPageCache().get("cache_id_period");
            Long boid = Long.parseLong(this.getView().getPageCache().get("cache_id_boid"));
            String statisticDate = this.getView().getPageCache().get("cache_id_statistic");
            Long attFileBid = Long.parseLong(this.getView().getPageCache().get("cache_attfile_boid"));
            logger.info("mobilehome close_wtss_mobileconfig periodid:{} boid:{} statisticDate:{} attFileBid:{}", new Object[]{periodId, boid, statisticDate, attFileBid});
            this.initStatistic(periodId, boid, attFileBid);
        } else if ("qtsetting".equals(closedCallBackEvent.getActionId())) {
            Long quotaConfigId = Long.valueOf(this.getPageCache().get("quotaconfig.id"));
            Date date = this.getView().getModel().getDataEntity().getDate("qtdate");
            this.initQTStatistic(quotaConfigId, date);
        } else if ("close_apply_choose".equals(closedCallBackEvent.getActionId())) {
            if (closedCallBackEvent.getReturnData() != null) {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                WTCBillType billType = (WTCBillType)returnData.get("billType");
                WTCApplyType applyType = (WTCApplyType)returnData.get("applyType");
                BeforeShowApplyPageEvent beforeShowApplyPageEvent = new BeforeShowApplyPageEvent(billType, applyType, (FormShowParameter)new MobileBillShowParameter());
                WTCPluginProxy proxy = WTCPluginProxyFactory.create(BillReplaceExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin");
                proxy.invokeReplace(plugin -> plugin.beforeShowApplyPage(beforeShowApplyPageEvent));
                FormShowParameter formShowParameter = beforeShowApplyPageEvent.getFormShowParameter();
                if (BillCommonService.getInstance().hasFormId(beforeShowApplyPageEvent)) {
                    this.getView().showForm(formShowParameter);
                    return;
                }
                String formId = (String)returnData.get("formId");
                String billAppId = MobileCommonServiceHelper.getInstance().getBillAppId(formId, this.getView());
                HashMap<String, Object> customParams = new HashMap<String, Object>(2);
                if (WTCApplyType.OTHER == applyType) {
                    customParams.put("billapplyType", 1);
                } else {
                    customParams.put("billapplyType", 0);
                }
                customParams.put("isAbnormal", Boolean.FALSE);
                customParams.put("sourceApp", "myTime");
                BillContainerService.getInstance().openContainer(billAppId, customParams, formId, this.getView());
            }
        } else if ("attconf".equals(closedCallBackEvent.getActionId())) {
            this.showAttConfirmNotify();
            AttConfirmServiceHelper.instance().updateBtnAttConfirmVisible(this.getView());
            String confirmDate = this.getPageCache().get("confirmDate");
            if (WTCDateUtils.str2Date((String)confirmDate, (String)"yyyy-MM-dd") != null) {
                Long employeeId = Long.parseLong(this.getView().getPageCache().get("cache_id_employeeid"));
                this.setAttRecordData(employeeId, confirmDate);
            }
        }
    }

    public void customEvent(CustomEventArgs cea) {
        JSONObject jsonEventArgs;
        Object jsonAttConfirmId;
        String key = cea.getKey();
        String eventName = cea.getEventName();
        Long employeeId = Long.parseLong(this.getView().getPageCache().get("cache_id_employeeid"));
        logger.info("mobilehome key:{} eventName:{} eventArgs:{} ", new Object[]{key, eventName, cea.getEventArgs()});
        if ("customcalendar".equals(key) && "getDateData".equals(eventName)) {
            CalendarGetDataModel getDate = (CalendarGetDataModel)SerializationUtils.fromJsonString((String)cea.getEventArgs(), CalendarGetDataModel.class);
            String cacheBoId = this.getView().getPageCache().get("cache_id_boid");
            if (StringUtils.isEmpty((CharSequence)cacheBoId)) {
                return;
            }
            Long boid = Long.parseLong(cacheBoId);
            this.initCalendarState(boid, employeeId, getDate);
            this.getPageCache().put("cacheidControlInitialled", "cacheidControlInitialled");
        } else if ("customcalendar".equals(key) && "getAttRecord".equals(eventName)) {
            this.setAttRecordData(employeeId, cea.getEventArgs());
        } else if ("customperiod".equals(key) && "selectPeriod".equals(eventName)) {
            PeriodDetailModel getPeriod = (PeriodDetailModel)SerializationUtils.fromJsonString((String)cea.getEventArgs(), PeriodDetailModel.class);
            if (getPeriod == null) {
                return;
            }
            long schemeId = Long.parseLong(this.getView().getPageCache().get("cache_id_boid"));
            this.initStatistic(getPeriod.getId(), schemeId, Long.parseLong(getPeriod.getAttFileBid()));
            this.initCalendar(getPeriod, null);
            this.getPageCache().put("cache_id_period", getPeriod.getId());
            this.getPageCache().put("PerAttId", String.valueOf(this.getPerAttPeriodKey(getPeriod.getId())));
            AttConfirmServiceHelper.instance().updateBtnAttConfirmVisible(this.getView());
            this.getView().getPageCache().put("cache_attfile_boid", String.valueOf(getPeriod.getAttFileBid()));
        } else if ("customaudit".equals(key) && "clickAudit".equals(eventName)) {
            this.toApplyPage(cea);
        } else if ("customcalendar".equals(key) && "abnormalDeal".equals(eventName)) {
            AbnormalDealModel abnormalDealModel = (AbnormalDealModel)SerializationUtils.fromJsonString((String)cea.getEventArgs(), AbnormalDealModel.class);
            String formId = (String)AbnormalDealMethodModel.APPLY_ID_MAP.get(abnormalDealModel.getMethodId());
            WTCBillType billType = (WTCBillType)BillCommonService.getInstance().BILL_TYPE_MAP.get(formId);
            BeforeShowApplyPageEvent beforeShowApplyPageEvent = new BeforeShowApplyPageEvent(billType, WTCApplyType.SELF, (FormShowParameter)new MobileBillShowParameter());
            WTCPluginProxy proxy = WTCPluginProxyFactory.create(BillReplaceExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin");
            proxy.invokeReplace(plugin -> plugin.beforeShowApplyPage(beforeShowApplyPageEvent));
            FormShowParameter formShowParameter = beforeShowApplyPageEvent.getFormShowParameter();
            if (BillCommonService.getInstance().hasFormId(beforeShowApplyPageEvent)) {
                this.getView().showForm(formShowParameter);
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("isAbnormal", Boolean.TRUE);
            if (StringUtils.equals((CharSequence)abnormalDealModel.getMethodId(), (CharSequence)"1050_S")) {
                customParams.put("abnormalDetail", SerializationUtils.serializeToBase64((Object)abnormalDealModel));
                String billCaption = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u8865\u7b7e\u7533\u8bf7", (String)"MobileHomePageFormPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), "");
                customParams.put("billcaption", billCaption);
            }
            customParams.put("sourceApp", "myTime");
            BillContainerService.getInstance().openContainer(this.getView().getFormShowParameter().getAppId(), customParams, formId, this.getView());
        } else if ("customcalendar".equals(key) && "attConfirm".equals(eventName) && (jsonAttConfirmId = (jsonEventArgs = JSONObject.parseObject((String)cea.getEventArgs())).get((Object)"attConfirmId")) != null) {
            this.getPageCache().put("attConfirmId", String.valueOf(jsonAttConfirmId));
            this.getPageCache().put("confirmDate", String.valueOf(jsonEventArgs.get((Object)"confirmDate")));
            this.getView().invokeOperation("attconf");
        }
    }

    private void initStatistic(String personAttPeriodId, Long mobileSchemeId, Long attFileBid) {
        Long userId = Long.parseLong(this.getView().getPageCache().get("cache_id_userid"));
        logger.info("mobilehome initStatistic query begin...");
        Map summaryConfig = SummaryConfigDetailService.getInstance().queryInfo(userId.longValue(), "A", personAttPeriodId, mobileSchemeId.longValue(), 1, attFileBid);
        logger.info("mobilehome initStatistic query end...");
        List showSummary = (List)summaryConfig.get("show");
        Object sourceObj = summaryConfig.get("sourceId");
        if (sourceObj != null) {
            this.getView().getPageCache().put("cache_id_source", SerializationUtils.toJsonString(sourceObj));
        }
        this.getView().getPageCache().put("cache_id_statistic", SerializationUtils.toJsonString((Object)showSummary));
        logger.info("mobilehome showSummary size: {}", (Object)showSummary.size());
        this.statisticShowTop(showSummary, false);
    }

    private void initQTStatistic(Long quotaConfigId, Date date) {
        Long userId = Long.parseLong(this.getView().getPageCache().get("cache_id_userid"));
        Long employeeId = Long.parseLong(this.getView().getPageCache().get("cache_id_employeeid"));
        Map attFileMap = HomePageServiceHelper.getInstance().getAttFileMapWithEmployeeId(employeeId, WTCDateUtils.getBeginDayOfYear((Date)date), WTCDateUtils.getEndDayOfYear((Date)date));
        if (WTCMaps.isEmpty((Map)attFileMap)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u65e5\u671f\u8303\u56f4\u5185\u65e0\u6b63\u5e38\u8003\u52e4\u7684\u8003\u52e4\u6863\u6848\u3002", (String)"MobileHomePageFormPlugin_11", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        logger.info("mobilehome initQTStatistic query begin...");
        Map summaryConfig = SummaryConfigDetailService.getInstance().queryQT(userId.longValue(), "A", quotaConfigId, 1);
        logger.info("mobilehome initQTStatistic query end...");
        List showSummary = (List)summaryConfig.get("show");
        Object sourceObj = summaryConfig.get("sourceId");
        if (sourceObj != null) {
            this.getView().getPageCache().put("cache_id_source", SerializationUtils.toJsonString(sourceObj));
        }
        this.getView().getPageCache().put("cache_id_statistic_qt", SerializationUtils.toJsonString((Object)showSummary));
        logger.info("mobilehome showSummary.size: {}", (Object)showSummary.size());
        Map<Long, List> indexIdAndAttItemIdListMap = showSummary.stream().collect(Collectors.toMap(SummaryConfDetail::getSourceId, detail -> new ArrayList(detail.getAttItems()), (a, b) -> b));
        QuotaIndexQueryDto dto = new QuotaIndexQueryDto();
        dto.setQueryByFileBoId(true);
        dto.setPersonFileBoIdList(new ArrayList(attFileMap.keySet()));
        dto.setEndDate(WTCDateUtils.getEndDayOfYear((Date)date));
        dto.setStartDate(WTCDateUtils.getBeginDayOfYear((Date)date));
        dto.setIndexIdAndAttItemIdListMap(indexIdAndAttItemIdListMap);
        QTLineDetailOuterService.queryByQuotaIndexQueryDto((QuotaIndexQueryDto)dto);
        Map indexIdAndValueMap = dto.getIndexIdAndValueMap();
        Map indexIdAndQuotaDetailIdListMap = dto.getIndexIdAndQuotaDetailIdListMap();
        Iterator iterator = showSummary.iterator();
        while (iterator.hasNext()) {
            SummaryConfDetail detail2;
            long quotaSourceId = (detail2 = (SummaryConfDetail)iterator.next()).getSourceId();
            BigDecimal value = (BigDecimal)indexIdAndValueMap.get(quotaSourceId);
            detail2.setAttItemValue(value != null ? value.setScale(2, 4).toPlainString() : new BigDecimal(0).toPlainString());
            detail2.setQuotaDetailList((Set)indexIdAndQuotaDetailIdListMap.get(quotaSourceId));
        }
        this.statisticShowTop(showSummary, true);
        this.getView().getPageCache().put("indexIdAndQuotaDetailIdListMap", JSON.toJSONString((Object)indexIdAndQuotaDetailIdListMap));
        this.getView().getPageCache().put("cache_id_statistic_qt", SerializationUtils.toJsonString((Object)showSummary));
    }

    private void initAuditAndCommonProblem(Long boid) {
        MobileHomeConf mobileHomeConf = SchemaServiceHelper.getInstance().getSchemeForHome(boid.longValue(), "A");
        if (mobileHomeConf == null) {
            logger.info("mobilehome initAuditAndCommonProblem mobileHomeConf is null");
            return;
        }
        List billTypes = mobileHomeConf.getBillTypes();
        this.initAudit(billTypes);
        if (!mobileHomeConf.isShowProblem()) {
            logger.info("mobilehome initAuditAndCommonProblem isShowProblem false");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexcommproblem"});
            return;
        }
        String homeConf = SerializationUtils.toJsonString((Object)mobileHomeConf);
        logger.info("mobilehome initAuditAndCommonProblem mobileHomeConf: {}", (Object)homeConf);
        this.getView().getPageCache().put("cache_id_config", homeConf);
        List problems = mobileHomeConf.getProblems();
        if (!CollectionUtils.isEmpty((Collection)problems)) {
            logger.info("mobilehome problems size: {}", (Object)problems.size());
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow("problementity", Math.min(problems.size(), 3));
            for (int index = 0; index < problems.size() && index <= 2; ++index) {
                model.setValue("problemtext", (Object)(index + 1 + "." + ((MobileHomeConf.CommProblem)problems.get(index)).getProblem()), index);
            }
        }
    }

    private void statisticShowTop(List<SummaryConfDetail> showSummary, boolean isQuota) {
        if (showSummary.size() > 2) {
            this.getView().setVisible(Boolean.TRUE, new String[]{isQuota ? "flexdropdownqt" : "flexdropdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{isQuota ? "flexpollupqt" : "flexpollup"});
            this.getView().setVisible(Boolean.TRUE, new String[]{isQuota ? MobileHomeConstants.STATISTIC_QT_ID[0] : MobileHomeConstants.STATISTIC_ID[0]});
            ((Label)this.getControl(isQuota ? MobileHomeConstants.LABEL_QT_ID[0] : MobileHomeConstants.LABEL_ID[0])).setText(showSummary.get(0).getName());
            ((Label)this.getControl(isQuota ? MobileHomeConstants.VALUE_QT_ID[0] : MobileHomeConstants.VALUE_ID[0])).setText(showSummary.get(0).getAttItemValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{isQuota ? MobileHomeConstants.STATISTIC_QT_ID[1] : MobileHomeConstants.STATISTIC_ID[1]});
            ((Label)this.getControl(isQuota ? MobileHomeConstants.LABEL_QT_ID[1] : MobileHomeConstants.LABEL_ID[1])).setText(showSummary.get(1).getName());
            ((Label)this.getControl(isQuota ? MobileHomeConstants.VALUE_QT_ID[1] : MobileHomeConstants.VALUE_ID[1])).setText(showSummary.get(1).getAttItemValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{isQuota ? MobileHomeConstants.STATISTIC_QT_ID[2] : MobileHomeConstants.STATISTIC_ID[2]});
            ((Label)this.getControl(isQuota ? MobileHomeConstants.LABEL_QT_ID[2] : MobileHomeConstants.LABEL_ID[2])).setText(showSummary.get(2).getName());
            ((Label)this.getControl(isQuota ? MobileHomeConstants.VALUE_QT_ID[2] : MobileHomeConstants.VALUE_ID[2])).setText(showSummary.get(2).getAttItemValue());
            for (int index = 3; index < MobileHomeConstants.STATISTIC_ID.length; ++index) {
                this.getView().setVisible(Boolean.FALSE, new String[]{isQuota ? MobileHomeConstants.STATISTIC_QT_ID[index] : MobileHomeConstants.STATISTIC_ID[index]});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{isQuota ? "flexstatisticsettingqt" : "flexstatisticsetting"});
            if (isQuota) {
                this.cacheQuotaSourceAndQuotaDetailId(showSummary);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{isQuota ? "flexdropdownqt" : "flexdropdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{isQuota ? "flexpollupqt" : "flexpollup"});
            this.setShowSummary(showSummary, isQuota);
            for (int index = showSummary.size(); index < MobileHomeConstants.STATISTIC_ID.length; ++index) {
                this.getView().setVisible(Boolean.FALSE, new String[]{isQuota ? MobileHomeConstants.STATISTIC_QT_ID[index] : MobileHomeConstants.STATISTIC_ID[index]});
            }
        }
    }

    private void cacheQuotaSourceAndQuotaDetailId(List<SummaryConfDetail> showSummary) {
        IPageCache pageCache = this.getPageCache();
        for (int index = 0; index < Math.min(showSummary.size(), QTSchemeConstants.WTSS_QT_MAX_SHOW_SIZE); ++index) {
            SummaryConfDetail detail = showSummary.get(index);
            pageCache.put(MobileHomeConstants.STATISTIC_QT_ID[index], detail.getSourceId() + "");
            pageCache.put(MobileHomeConstants.VALUE_QT_ID[index], detail.getAttItemValue());
            pageCache.put(detail.getSourceId() + "", JSON.toJSONString((Object)detail.getQuotaDetailList()));
        }
    }

    private void statisticAll(List<SummaryConfDetail> showSummary, boolean isQuota) {
        this.getView().setVisible(Boolean.FALSE, new String[]{isQuota ? "flexdropdownqt" : "flexdropdown"});
        this.getView().setVisible(Boolean.TRUE, new String[]{isQuota ? "flexpollupqt" : "flexpollup"});
        this.setShowSummary(showSummary, isQuota);
    }

    private void setShowSummary(List<SummaryConfDetail> showSummary, boolean isQuota) {
        String isFromTeam;
        for (int index = 0; index < Math.min(showSummary.size(), QTSchemeConstants.WTSS_QT_MAX_SHOW_SIZE); ++index) {
            this.getView().setVisible(Boolean.TRUE, new String[]{isQuota ? MobileHomeConstants.STATISTIC_QT_ID[index] : MobileHomeConstants.STATISTIC_ID[index]});
            ((Label)this.getControl(isQuota ? MobileHomeConstants.LABEL_QT_ID[index] : MobileHomeConstants.LABEL_ID[index])).setText(showSummary.get(index).getName());
            ((Label)this.getControl(isQuota ? MobileHomeConstants.VALUE_QT_ID[index] : MobileHomeConstants.VALUE_ID[index])).setText(showSummary.get(index).getAttItemValue());
        }
        if (isQuota) {
            this.cacheQuotaSourceAndQuotaDetailId(showSummary);
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)(isFromTeam = this.getPageCache().get("cache_isfromteam")))) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{isQuota ? "flexstatisticsettingqt" : "flexstatisticsetting"});
    }

    private PeriodDetailModel initPeriod(List<PerAttPeriod> userAllPeriods, String queryDate) {
        if (CollectionUtils.isEmpty(userAllPeriods)) {
            logger.info("mobilehome userAllPeriods is null");
            return null;
        }
        HashMap<String, Long> perAttPeriodCacheMap = new HashMap<String, Long>(userAllPeriods.size());
        for (PerAttPeriod perAttPeriod : userAllPeriods) {
            perAttPeriodCacheMap.put(perAttPeriod.getId(), perAttPeriod.getPrimaryId());
        }
        this.getPageCache().put(PER_ATTPERIOD_CACHE_KEY, SerializationUtils.toJsonString(perAttPeriodCacheMap));
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customperiod");
        return this.mobileHomePageBusiness.periodDataInit(userAllPeriods, queryDate, customcontrol);
    }

    private void initCalendar(PeriodDetailModel period, String chooseDay) {
        String currentDay = this.mobileHomePageBusiness.getEndDateValue(period);
        if (!StringUtils.isEmpty((CharSequence)chooseDay)) {
            currentDay = chooseDay;
        }
        logger.info("mobilehome currentDay : {}", (Object)currentDay);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        HashMap<String, String> data = new HashMap<String, String>(16);
        CalendarInitModel calendarInitModel = new CalendarInitModel();
        calendarInitModel.setEarliestMonth("2015-01");
        calendarInitModel.setChooseDay(currentDay);
        data.put("event", "init");
        data.put("args", (String)calendarInitModel);
        customcontrol.setData(data);
    }

    private void initHeaderInfoAssignment(Long attfileBoid) {
        Label labName = (Label)this.getView().getControl("labname");
        Label labNumber = (Label)this.getView().getControl("labnumber");
        Label labPostAndOrg = (Label)this.getView().getControl("labpostandorg");
        Image imgHead = (Image)this.getView().getControl("imahead");
        this.mobileHomePageBusiness.setPersonLabInfo(attfileBoid, labName, labNumber, labPostAndOrg, imgHead);
    }

    private void initCalendarState(Long boid, Long employeeId, CalendarGetDataModel getDate) {
        Long userId = Long.parseLong(this.getView().getPageCache().get("cache_id_userid"));
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        HashMap<String, String> data = new HashMap<String, String>(16);
        Set abnormalConfig = SchemaServiceHelper.getInstance().getAbnormalConfig(boid.longValue(), "A");
        String yearMonth = StringUtils.substring((String)getDate.getChooseDay(), (int)0, (int)7);
        Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((String)yearMonth);
        Date lastDayOfMonth = WTCDateUtils.getLastDayOfMonth((String)yearMonth);
        Map tupleMap = HomePageServiceHelper.getInstance().getAttFileMapWithEmployeeId(employeeId, beginDayOfMonth, lastDayOfMonth);
        logger.info("mobilehome initCalendarState queryScheduleInfoByAttFileBoId begin... abnormalConfig:{},tupleMap:{}", (Object)abnormalConfig, (Object)tupleMap);
        Map scheduleInfo = HomePageServiceHelper.getInstance().queryScheduleInfoByMultiBo(userId.longValue(), tupleMap, getDate.getChooseDay(), abnormalConfig);
        logger.info("mobilehome initCalendarState queryScheduleInfoByAttFileBoId end...");
        logger.info("mobilehome initCalendarState getPeriodAttItemsByScheme begin...");
        Map dailySourceData = SchemaServiceHelper.getInstance().getPeriodAttItems(boid.longValue(), "A", userId, (String)getDate.getDateList().get(0), (String)getDate.getDateList().get(getDate.getDateList().size() - 1), tupleMap, 1);
        logger.info("mobilehome initCalendarState getPeriodAttItemsByScheme end...");
        String dailySourceDataStrings = "";
        if (!HRMapUtils.isEmpty((Map)dailySourceData)) {
            dailySourceDataStrings = SerializationUtils.serializeToBase64((Object)dailySourceData);
            this.getView().getPageCache().put("cache_id_daily", dailySourceDataStrings);
            logger.info("mobilehome initCalendarState dailySourceData:{}", (Object)dailySourceData);
        }
        if (scheduleInfo != null) {
            logger.info("mobilehome initCalendarState scheduleInfo:{}", (Object)SerializationUtils.toJsonString((Object)scheduleInfo));
        }
        List dateStateModels = HomePageServiceHelper.getInstance().getCalendarData(tupleMap, getDate, scheduleInfo, dailySourceData);
        String dateStateStrings = "";
        if (!CollectionUtils.isEmpty((Collection)dateStateModels)) {
            dateStateStrings = SerializationUtils.serializeToBase64((Object)dateStateModels);
            this.getView().getPageCache().put("cache_id_date_state", dateStateStrings);
        }
        String isFromTeam = this.getView().getPageCache().get("cache_isfromteam");
        List attRecordModel = HomePageServiceHelper.getInstance().getSignCardDetailWithEmployeeId(employeeId, boid, getDate.getChooseDay(), isFromTeam, dateStateStrings, true, dailySourceDataStrings);
        DateDataModel dateDataModel = new DateDataModel();
        dateDataModel.setDateList(dateStateModels);
        dateDataModel.setAttRecord(attRecordModel);
        data.put("event", "dateData");
        data.put("args", (String)dateDataModel);
        HomePageServiceHelper.getInstance().setAttConfirmByDate(data, employeeId, WTCDateUtils.str2Date((String)getDate.getChooseDay(), (String)"yyyy-MM-dd"));
        HomePageServiceHelper.getInstance().setData(data, attRecordModel, getDate.getChooseDay(), employeeId);
        WTCPluginProxy workCalendarExtPlugin = WTCPluginProxyFactory.create(null, WTCCustomControlExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.WorkCalendarCustomExt", null);
        if (workCalendarExtPlugin.hasPlugin()) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(data));
            Map request = WTCMaps.JsonToMap((JSONObject)jsonObject);
            request.put("attPersonId", userId);
            workCalendarExtPlugin.invokeReplace(hrPlugin -> {
                hrPlugin.setCustomData(this.getView().getPageId(), "dateData", (Object)request);
                if (logger.isDebugEnabled()) {
                    logger.debug("WorkCalendarCustomExt.class:{},eventName:{}", (Object)hrPlugin.getClass().getName(), (Object)"dateData");
                }
            });
            customcontrol.setData((Object)request);
        } else {
            customcontrol.setData(data);
        }
        logger.info("mobilehome initCalendarState dateDataModel:{}", (Object)SerializationUtils.toJsonString((Object)dateDataModel));
    }

    private void setAttRecordData(Long employeeId, String date) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        Long boid = Long.parseLong(this.getView().getPageCache().get("cache_id_boid"));
        String isFromTeam = this.getView().getPageCache().get("cache_isfromteam");
        String dailySourceStr = this.getView().getPageCache().get("cache_id_daily");
        String dateState = this.getView().getPageCache().get("cache_id_date_state");
        List attRecordModel = HomePageServiceHelper.getInstance().getSignCardDetailWithEmployeeId(employeeId, boid, date, isFromTeam, dateState, true, dailySourceStr);
        attRecordModel = attRecordModel.stream().filter(model -> model.getDate() != null).collect(Collectors.toList());
        attRecordModel.sort(Comparator.comparing(AttRecordModel::getDate));
        logger.info("mobilehome attRecord:{}", (Object)SerializationUtils.toJsonString(attRecordModel));
        data.put("event", "attRecord");
        data.put("attRecord", attRecordModel);
        HomePageServiceHelper.getInstance().setAttConfirmByDate(data, employeeId, WTCDateUtils.str2Date((String)date, (String)"yyyy-MM-dd"));
        HomePageServiceHelper.getInstance().setData(data, attRecordModel, date, employeeId);
        customcontrol.setData(data);
    }

    private void initAudit(List<MobileHomeConf.BillType> billTypes) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customaudit");
        HashMap<String, List<MobileHomeConf.BillType>> data = new HashMap<String, List<MobileHomeConf.BillType>>(16);
        data.put("billTypes", billTypes);
        customcontrol.setData(data);
    }

    private void initControlState() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexdropdown"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpollup"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpollupqt"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpollupqt"});
        this.getView().setVisible(Boolean.FALSE, MobileHomeConstants.STATISTIC_ID);
        this.getView().setVisible(Boolean.FALSE, MobileHomeConstants.STATISTIC_QT_ID);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexnormal"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexnoauthor"});
    }

    private void toPrivacy(Map<String, Object> map) {
        HashMap<String, Object> customs = new HashMap<String, Object>(16);
        customs.put("content", map.get("content"));
        customs.put("name", map.get("name"));
        customs.put("id", map.get("id"));
        PrivacyHelper.showMobileForm((IFormView)this.getView(), (String)"wtss_privacymob", (ShowType)ShowType.ReplaceHomePage, customs);
    }

    private void toConfigPage() {
        IFormView view = this.getView();
        String fromTeamStr = this.getPageCache().get("cache_isfromteam");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)fromTeamStr)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u53ef\u67e5\u770b\u5458\u5de5\u8003\u52e4\u6570\u636e\uff0c\u6682\u4e0d\u652f\u6301\u6240\u9009\u64cd\u4f5c\u3002", (String)"MobileHomePageFormPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        if (view.getPageCache().get("cache_id_source") == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u6709\u6548\u671f\u95f4\u6c47\u603b\u7ec4\u5408\u3002", (String)"MobileHomePageFormPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), "kdfont kdfont-Toast-jinggao", MessageTypes.ImageWithText_m, null);
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_wtss_mobileconfig"));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("wtss_mobileconfig");
        HashMap<String, Object> configParams = new HashMap<String, Object>(2);
        String periodId = this.getView().getPageCache().get("cache_id_period");
        Long boid = Long.parseLong(this.getView().getPageCache().get("cache_id_boid"));
        String statisticDate = this.getView().getPageCache().get("cache_statistic_date");
        logger.info("mobilehome to wtss_mobileconfig periodid:{} boid:{} statisticDate:{}", new Object[]{periodId, boid, statisticDate});
        configParams.put("periodId", periodId);
        configParams.put("boid", boid);
        configParams.put("cache_attfile_boid", this.getView().getPageCache().get("cache_attfile_boid"));
        configParams.put("teamStaType", "2");
        showParameter.setCustomParams(configParams);
        view.showForm((FormShowParameter)showParameter);
    }

    private void toQTConfigPage() {
        IFormView view = this.getView();
        String fromTeamStr = this.getPageCache().get("cache_isfromteam");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)fromTeamStr)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u53ef\u67e5\u770b\u5458\u5de5\u8003\u52e4\u6570\u636e\uff0c\u6682\u4e0d\u652f\u6301\u6240\u9009\u64cd\u4f5c\u3002", (String)"MobileHomePageFormPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        if (view.getPageCache().get("quotaconfig.id") == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u6709\u6548\u5b9a\u989d\u9879\u76ee\u7ec4\u5408\u3002", (String)"MobileHomePageFormPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), "kdfont kdfont-Toast-jinggao", MessageTypes.ImageWithText_m, null);
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "qtsetting"));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("wtss_mobileconfig");
        HashMap<String, Object> configParams = new HashMap<String, Object>(2);
        String quotaConfigId = view.getPageCache().get("quotaconfig.id");
        Long boid = Long.parseLong(this.getView().getPageCache().get("cache_id_boid"));
        logger.info("mobilehome to wtss_mobileconfig quotaConfigId:{} boid:{} ", (Object)quotaConfigId, (Object)boid);
        configParams.put("quotaConfigId", quotaConfigId);
        configParams.put("boid", boid);
        configParams.put("teamStaType", "3");
        showParameter.setCustomParams(configParams);
        view.showForm((FormShowParameter)showParameter);
    }

    private void toApplyPage(CustomEventArgs args) {
        String isFromTeam = this.getPageCache().get("cache_isfromteam");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)isFromTeam)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u53ef\u67e5\u770b\u5458\u5de5\u8003\u52e4\u6570\u636e\uff0c\u6682\u4e0d\u652f\u6301\u6240\u9009\u64cd\u4f5c\u3002", (String)"MobileHomePageFormPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        String timeStamp = this.getPageCache().get("cacheTimestamp");
        if (!StringUtils.isEmpty((CharSequence)timeStamp)) {
            long lastTimeStamp = Long.parseLong(timeStamp);
            if (System.currentTimeMillis() - lastTimeStamp < 2000L) {
                return;
            }
        }
        this.getPageCache().put("cacheTimestamp", String.valueOf(System.currentTimeMillis()));
        if (!StringUtils.isEmpty((CharSequence)args.getEventArgs())) {
            String formId = MobileHomePageServiceHelper.getApplyFormId((String)args.getEventArgs(), (boolean)true);
            WTCBillType billType = (WTCBillType)BillCommonService.getInstance().BILL_TYPE_MAP.get(formId);
            BeforeChooseApplyTypeEvent beforeChooseApplyTypeEvent = new BeforeChooseApplyTypeEvent(billType);
            WTCPluginProxy proxy = WTCPluginProxyFactory.create(BillReplaceExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin");
            proxy.invokeReplace(plugin -> plugin.beforeChooseApplyType(beforeChooseApplyTypeEvent));
            Boolean showChoices = beforeChooseApplyTypeEvent.getShowChoices();
            boolean showApplyTypes = showChoices != null ? showChoices : MobileHomePageServiceHelper.canApplyOther((String)args.getEventArgs());
            if (showApplyTypes) {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_apply_choose"));
                showParameter.setFormId("wtss_applychoose_m");
                showParameter.setCustomParam("custom_apply_form", (Object)args.getEventArgs());
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                BeforeShowApplyPageEvent beforeShowApplyPageEvent = new BeforeShowApplyPageEvent(billType, WTCApplyType.SELF, (FormShowParameter)new MobileBillShowParameter());
                WTCPluginProxy beforeShowApplyPageProxy = WTCPluginProxyFactory.create(BillReplaceExtPlugin.class, (String)"kd.sdk.wtc.wtss.business.homepage.BillReplaceExtPlugin");
                beforeShowApplyPageProxy.invokeReplace(plugin -> plugin.beforeShowApplyPage(beforeShowApplyPageEvent));
                FormShowParameter formShowParameter = beforeShowApplyPageEvent.getFormShowParameter();
                if (BillCommonService.getInstance().hasFormId(beforeShowApplyPageEvent)) {
                    this.getView().showForm(formShowParameter);
                    return;
                }
                HashMap<String, Object> customParams = new HashMap<String, Object>(1);
                customParams.put("isAbnormal", Boolean.FALSE);
                customParams.put("sourceApp", "myTime");
                BillContainerService.getInstance().openContainer(this.getView().getFormShowParameter().getAppId(), customParams, formId, this.getView());
            }
        }
    }

    private void initControlsByAttPeriod(boolean hasPeriod) {
        if (hasPeriod) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nodatapanel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"customperiod"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdropdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpollup"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"qtdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapqt"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdropdownqt"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpollupqt"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodatapanel"});
        }
    }

    private boolean checkScheme(Long schemeId) {
        boolean hasScheme = true;
        if (schemeId == 0L) {
            hasScheme = false;
        } else {
            MobileHomeConf mobileHomeConf = SchemaServiceHelper.getInstance().getSchemeForHome(schemeId.longValue(), "A");
            if (mobileHomeConf == null) {
                hasScheme = false;
            }
        }
        if (!hasScheme) {
            Label label1 = (Label)this.getView().getControl("labelap12");
            Label label2 = (Label)this.getView().getControl("labelap1");
            label1.setText(ResManager.loadKDString((String)"\u60a8\u672a\u5173\u8054\u5047\u52e4\u81ea\u52a9\u65b9\u6848\uff0c", (String)"MobileHomePageFormPlugin_9", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            label2.setText(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobileHomePageFormPlugin_10", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnormal"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnoauthor"});
        }
        return hasScheme;
    }

    private void showAttConfirmPage() {
        Long attConfirmId;
        try {
            attConfirmId = Long.valueOf(this.getPageCache().get("attConfirmId"));
        }
        catch (Exception e) {
            logger.warn("MobileHomePageFormPlugin.showAttConfirmPage.getAttConfirmIdError:{}", (Object)e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8003\u52e4\u786e\u8ba4\u8bb0\u5f55\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PersonHomePCPlugin_6", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        if (attConfirmId == 0L) {
            return;
        }
        AttConfirmRecordQueryParam queryParam = new AttConfirmRecordQueryParam();
        queryParam.setIds(Collections.singleton(attConfirmId));
        queryParam.setQueryNotEffect(true);
        List recordModels = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(queryParam);
        if (WTCCollections.isEmpty((Collection)recordModels)) {
            return;
        }
        AttConfirmRecordModel currentRecordModel = (AttConfirmRecordModel)recordModels.get(0);
        AttConRecordStatusEnum status = currentRecordModel.getStatus();
        AttConfirmDataStatusEnum dataStatus = currentRecordModel.getDataStatus();
        if (AttConRecordStatusEnum.SEND.equals((Object)status) && AttConfirmDataStatusEnum.EFFECT.equals((Object)dataStatus)) {
            this.showAttConfirmListPage(currentRecordModel.getType(), String.valueOf(attConfirmId));
        } else {
            MobileBillShowParameter detailParameter = new MobileBillShowParameter();
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Floating);
            detailParameter.setOpenStyle(openStyle);
            detailParameter.setStatus(OperationStatus.VIEW);
            detailParameter.setParentPageId(this.getView().getPageId());
            detailParameter.setFormId("wtss_attconfmob");
            detailParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "attconf"));
            detailParameter.getCustomParams().put("attConfirmId", this.getPageCache().get("attConfirmId"));
            HRBaseServiceHelper confirmBillService = HRBaseServiceHelper.create((String)"wtam_attconfirmbill");
            QFilter qFilter = new QFilter("attconrecord", "=", (Object)attConfirmId);
            DynamicObject confirmBillDy = confirmBillService.queryOne(qFilter.toArray());
            if (confirmBillDy != null) {
                detailParameter.setPkId((Object)confirmBillDy.getLong("id"));
                this.getView().showForm((FormShowParameter)detailParameter);
            }
        }
    }

    private Long getPerAttPeriodKey(String attPeriodId) {
        Map attPeriodKeyMap;
        Long attPeriodKey = 0L;
        String cache = this.getPageCache().get(PER_ATTPERIOD_CACHE_KEY);
        if (WTCStringUtils.isNotEmpty((String)cache) && (attPeriodKeyMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class)).get(attPeriodId) != null) {
            attPeriodKey = (Long)attPeriodKeyMap.get(attPeriodId);
        }
        return attPeriodKey;
    }

    private void showAttConfirmNotify() {
        if (!AttConfirmFormHelper.getInstance().hasAttConfirmRight(this.getView().getFormShowParameter().getAppId(), true)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unconfirmflex"});
            return;
        }
        List unConfirmRecordModels = AttConfirmFormHelper.getInstance().queryNeedConfirmList(Long.parseLong(this.getPageCache().get("cache_id_employeeid")), null, false, 0L);
        if (WTCCollections.isEmpty((Collection)unConfirmRecordModels)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unconfirmflex"});
            return;
        }
        int unConfirmSize = unConfirmRecordModels.size();
        Label unConfirmSizeLabel = (Label)this.getControl("unconfirmsize");
        unConfirmSizeLabel.setText(unConfirmSize + "");
        this.getView().updateView("unconfirmflex");
    }

    private void showAttConfirmListPage(AttConRecordTypeEnum type, String attConfirmId) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("wtss_attconfirmlist");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("cache_attfile_boid", (Object)this.getPageCache().get("cache_attfile_boid"));
        showParameter.setCustomParam("cache_id_employeeid", (Object)this.getPageCache().get("cache_id_employeeid"));
        if (type != null) {
            showParameter.setCustomParam("confirmtype", (Object)type.getCode());
        }
        if (attConfirmId != null) {
            showParameter.setCustomParam("currentrecordid", (Object)attConfirmId);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "attconf"));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

