/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.mobile.MobilePersonSelHelper;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.UserCustomParam;
import kd.wtc.wtbs.common.model.UserListEntry;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.common.model.teamhome.TeamQuotaIndexQueryDto;
import kd.wtc.wtss.business.servicehelper.common.QuotaStatisticIndexService;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.common.constants.MobileTeamConstants;

public class MobileSelPersonPlugin
extends AbstractMobFormPlugin {
    private static final int INITPAGESIZE = 20;

    public void afterCreateNewData(EventObject e) {
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)3);
        Long userId = BillUnifyService.getUserId((IFormView)this.getView());
        if (Objects.isNull(userId)) {
            throw new KDBizException(new ErrorCode("500", ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MobileSelPersonPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        UserCustomParam userCustomParam = new UserCustomParam();
        userCustomParam.setUserId(String.valueOf(userId));
        userCustomParam.setSearchContent(null);
        userCustomParam.setPageSize(20);
        userCustomParam.setPageNum(0);
        userCustomParam.setAppId(this.getView().getFormShowParameter().getAppId());
        userCustomParam.setAuthField("attfilebasef7");
        userCustomParam.setAuthEntity("wtss_pcteamhome");
        userCustomParam.setContainCurrentUser(false);
        customParam.put("cusParam_searchParam", JSONObject.toJSONString((Object)userCustomParam));
        MobilePersonSelHelper instance = MobilePersonSelHelper.getInstance();
        Page dynamicObjectPage = instance.getAttFileF7ByName(userCustomParam);
        List mapList = instance.getFileF7Result(dynamicObjectPage.getListRecords());
        int totalPage = dynamicObjectPage.getTotalPage();
        customParam.put("cusParam_searchData", this.transUserListObject(mapList));
        customParam.put("cusParam_searchPage", JSONObject.toJSONString((Object)totalPage));
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData((Object)customParam);
    }

    private String transUserListObject(List<Map<String, String>> mapList) {
        ArrayList<UserListEntry> userList = new ArrayList<UserListEntry>(mapList.size());
        for (Map<String, String> item : mapList) {
            String headsculpture;
            String imgUrl = "";
            Map personBaseInfo = HRPIMServiceImpl.getInstance().getPersonBaseInfo(Long.valueOf(Long.parseLong(item.get("attperson.id"))));
            if (personBaseInfo != null && personBaseInfo.get("headsculpture") != null && !HRStringUtils.isEmpty((String)(headsculpture = personBaseInfo.get("headsculpture").toString())) && !headsculpture.contains("default_person_82_82")) {
                imgUrl = HRImageUrlUtil.getImageFullUrl((String)headsculpture);
            }
            UserListEntry userListEntry = new UserListEntry(imgUrl, item.get("attperson.id"), item.get("attperson.name"), item.get("attperson.name"), item.get("boid"), item.get("id"), item.get("org.name"));
            userList.add(userListEntry);
        }
        return JSONObject.toJSONString(userList);
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        switch (eventName) {
            case "employee_search": {
                this.searchEmployee(eventArgs);
                break;
            }
            case "employee_select": {
                this.selectEmployee(eventArgs);
                break;
            }
            case "employee_close": {
                this.getView().returnDataToParent(null);
                this.getView().close();
                break;
            }
        }
    }

    private void searchEmployee(String eventArgs) {
        UserCustomParam userCustomParam = (UserCustomParam)JSONObject.parseObject((String)eventArgs, UserCustomParam.class);
        long adminOrgId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("cache_admin_org"));
        Date currentDate = WTCDateUtils.str2Date((String)((String)this.getView().getFormShowParameter().getCustomParam("qtdate")), (String)"yyyy-MM-dd");
        userCustomParam.setStartDate(WTCDateUtils.getBeginDayOfYear((Date)currentDate));
        userCustomParam.setEndDate(WTCDateUtils.getDayBegin((Date)WTCDateUtils.getEndDayOfYear((Date)currentDate)));
        String key = String.valueOf(userCustomParam.getSearchContent());
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)3);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        MobilePersonSelHelper queryInstance = MobilePersonSelHelper.getInstance();
        if (!StringUtils.isEmpty((String)key)) {
            userCustomParam.setUserId("0");
            userCustomParam.setSearchContent(key);
            userCustomParam.setContainCurrentUser(true);
            userCustomParam.setAffiliateAdminOrgId(Long.valueOf(adminOrgId));
            Page attFileF7ByName = queryInstance.getAttFileF7ByName(userCustomParam);
            List mapList = queryInstance.getFileF7Result(attFileF7ByName.getListRecords());
            int totalPage = attFileF7ByName.getTotalPage();
            customParam.put("cusParam_searchData", this.transUserListObject(mapList));
            customParam.put("cusParam_searchPage", JSONObject.toJSONString((Object)totalPage));
        }
        customcontrol.setData((Object)customParam);
    }

    private void selectEmployee(String eventArgs) {
        UserListEntry userListEntry = (UserListEntry)JSONObject.parseObject((String)eventArgs, UserListEntry.class);
        ArrayList<Long> personIdList = new ArrayList<Long>(1);
        Long personId = Long.valueOf(userListEntry.getPersonId());
        personIdList.add(personId);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Date qtDate = WTCDateUtils.str2Date((String)((String)formShowParameter.getCustomParam("qtdate")), (String)"yyyy-MM-dd");
        long ruleId = Long.parseLong((String)formShowParameter.getCustomParam("cache_rule_id"));
        Date startDate = WTCDateUtils.getBeginDayOfYear((Date)qtDate);
        Date endDate = WTCDateUtils.getEndDayOfYear((Date)qtDate);
        TeamQuotaIndexQueryDto queryDto = new TeamQuotaIndexQueryDto();
        queryDto.setPersonIdList(personIdList);
        queryDto.setStartDate(startDate);
        queryDto.setEndDate(endDate);
        Long adminOrgId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("cache_admin_org"));
        queryDto.setAdminOrgId(adminOrgId);
        Map indexIdAndAttItemIdListMap = SchemaServiceHelper.getInstance().getQuotaItemIds(Long.valueOf(ruleId), "0");
        queryDto.setIndexIdAndAttItemIdListMap(indexIdAndAttItemIdListMap);
        QuotaStatisticIndexService.getInstance().getTeamQuotaStatisticData(queryDto);
        if (queryDto.getIndexIdAndQuotaDetailIdListMap() == null || queryDto.getIndexIdAndQuotaDetailIdListMap().size() == 0) {
            this.getView().showErrorNotification(MobileTeamConstants.TIPS_NO_QUOTA_DETAIL.loadKDString());
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("wtss_teamquotapersonmob");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        showParameter.setCustomParam("personid", (Object)userListEntry.getPersonId());
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

