/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.business.servicehelper.summaryconf.SummaryTeamConfigDetailService;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;

public class MobileTeamConfigSettingPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(MobileTeamConfigSettingPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        for (int i = 1; i < 4; ++i) {
            CardEntry showContainer = (CardEntry)this.getView().getControl("showentryentity" + i);
            showContainer.addRowClickListener((RowClickEventListener)this);
            CardEntry otherContainer = (CardEntry)this.getView().getControl("otherentryentity" + i);
            otherContainer.addRowClickListener((RowClickEventListener)this);
        }
        this.addClickListeners(new String[]{"buttonsave"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            String ruleStr = customParams.get("ruleid") != null ? customParams.get("ruleid").toString() : "0";
            Long ruleId = Long.parseLong(ruleStr);
            String configType = (String)customParams.get("configtype");
            this.getView().getPageCache().put("configtype", configType);
            this.resetActiveTab(customParams);
            this.initStatisticConfig(ruleId, configType);
        }
    }

    public void resetActiveTab(Map<String, Object> customParams) {
        String configTab = String.valueOf(customParams.get("configtab"));
        Tab tabap = (Tab)this.getControl("tabap");
        switch (configTab) {
            case "daycountflex": 
            case "periodcountflex": {
                tabap.activeTab("tabpageap1");
                break;
            }
            case "dayrankflex": 
            case "periodrankflex": {
                tabap.activeTab("tabpageap2");
                break;
            }
            case "daychartflex": 
            case "periodchartflex": {
                tabap.activeTab("tabpageap3");
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getView().getPageCache().put("opercloseflag", "0");
        CardEntry cardEntry = (CardEntry)evt.getSource();
        String key = cardEntry.getKey();
        String num = key.substring(key.length() - 1);
        int integer = Integer.parseInt(num);
        if (integer == 1) {
            List attOthersConEntry;
            List attDisConEntry = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_attshow"), AttDataSourceModel.class);
            if (this.setEntryDownUpMove(evt, cardEntry, attDisConEntry, attOthersConEntry = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_attother"), AttDataSourceModel.class), integer, 9)) {
                return;
            }
            this.getView().getPageCache().put("cache_attshow", SerializationUtils.toJsonString((Object)attDisConEntry));
            this.getView().getPageCache().put("cache_attother", SerializationUtils.toJsonString((Object)attOthersConEntry));
        } else if (integer == 2) {
            List rankOthersConEntry;
            List rankDisConEntry = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_rankshow"), AttDataSourceModel.class);
            if (this.setEntryDownUpMove(evt, cardEntry, rankDisConEntry, rankOthersConEntry = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_rankother"), AttDataSourceModel.class), integer, 6)) {
                return;
            }
            this.getView().getPageCache().put("cache_rankshow", SerializationUtils.toJsonString((Object)rankDisConEntry));
            this.getView().getPageCache().put("cache_rankother", SerializationUtils.toJsonString((Object)rankOthersConEntry));
        } else if (integer == 3) {
            List chartOthersConEntry;
            List chartDisConEntry = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_chartshow"), AttDataSourceModel.class);
            if (this.setEntryDownUpMove(evt, cardEntry, chartDisConEntry, chartOthersConEntry = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_chartother"), AttDataSourceModel.class), integer, 6)) {
                return;
            }
            this.getView().getPageCache().put("cache_chartshow", SerializationUtils.toJsonString((Object)chartDisConEntry));
            this.getView().getPageCache().put("cache_chartother", SerializationUtils.toJsonString((Object)chartOthersConEntry));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)"buttonsave", (String)key)) {
            this.getView().getPageCache().put("opercloseflag", "1");
            LOG.info("teammobilehomeconfig.click.starttime: {}}", (Object)System.currentTimeMillis());
            this.saveConfig();
            LOG.info("teammobilehomeconfig.click.saveConfig.endtime: {}}", (Object)System.currentTimeMillis());
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        String opCloseFlag = this.getView().getPageCache().get("opercloseflag");
        if (opCloseFlag != null && "0".equals(opCloseFlag)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("backid", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5185\u5bb9\u4e0d\u4f1a\u4fdd\u5b58\uff0c\u662f\u5426\u786e\u8ba4\u8fd4\u56de\u3002", (String)"MobileTeamConfigSettingPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            beforeClosedEvent.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && "backid".equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().getPageCache().put("opercloseflag", "1");
            this.getView().close();
        }
    }

    private boolean setEntryDownUpMove(RowClickEvent evt, CardEntry cardEntry, List<AttDataSourceModel> disCon, List<AttDataSourceModel> othersCon, int integer, int maxNum) {
        if (StringUtils.equals((CharSequence)("showentryentity" + integer), (CharSequence)cardEntry.getKey())) {
            String showCtrl = (String)this.getModel().getValue("showctrl" + integer);
            if (StringUtils.equals((CharSequence)showCtrl, (CharSequence)"1") || evt.getRow() >= disCon.size()) {
                return true;
            }
            AttDataSourceModel remove = disCon.remove(evt.getRow());
            othersCon.add(remove);
            int ret = this.getModel().createNewEntryRow("otherentryentity" + integer);
            this.getModel().setValue("othertextfield" + integer, (Object)remove.getAttDataSourceName(), ret);
            this.getModel().deleteEntryRow("showentryentity" + integer, evt.getRow());
        } else {
            if (!CollectionUtils.isEmpty(disCon) && disCon.size() >= maxNum) {
                this.getView().showMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u663e\u793a\u914d\u7f6e\u4e0d\u5141\u8bb8\u8d85\u8fc7%d\u4e2a\u3002", (String)"MobileTeamConfigSettingPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), maxNum));
                return true;
            }
            if (StringUtils.equals((CharSequence)("otherentryentity" + integer), (CharSequence)cardEntry.getKey()) && evt.getRow() < othersCon.size()) {
                AttDataSourceModel remove = othersCon.remove(evt.getRow());
                disCon.add(remove);
                this.getModel().deleteEntryRow("otherentryentity" + integer, evt.getRow());
                int ret = this.getModel().createNewEntryRow("showentryentity" + integer);
                this.getModel().setValue("showtextfield" + integer, (Object)remove.getAttDataSourceName(), ret);
            }
        }
        return false;
    }

    private void initStatisticConfig(Long ruleId, String configType) {
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        Map attConfig = SummaryTeamConfigDetailService.getInstance().queryTeamStaConfigList(userId.longValue(), ruleId.longValue(), "1", configType, "1");
        Map rankConfig = SummaryTeamConfigDetailService.getInstance().queryTeamStaConfigList(userId.longValue(), ruleId.longValue(), "1", configType, "2");
        Map chartConfig = SummaryTeamConfigDetailService.getInstance().queryTeamStaConfigList(userId.longValue(), ruleId.longValue(), "1", configType, "3");
        MobileHomePageBusiness.getInstance().setTeamSchRuleCache(this.getView(), ruleId.longValue());
        List attDisCon = (List)attConfig.get("show");
        List attOthersCon = (List)attConfig.get("others");
        List rankDisCon = (List)rankConfig.get("show");
        List rankOthersCon = (List)rankConfig.get("others");
        List chartDisCon = (List)chartConfig.get("show");
        List chartOthersCon = (List)chartConfig.get("others");
        this.getView().getPageCache().put("cache_attshow", SerializationUtils.toJsonString((Object)attDisCon));
        this.getView().getPageCache().put("cache_attother", SerializationUtils.toJsonString((Object)attOthersCon));
        this.getView().getPageCache().put("cache_rankshow", SerializationUtils.toJsonString((Object)rankDisCon));
        this.getView().getPageCache().put("cache_rankother", SerializationUtils.toJsonString((Object)rankOthersCon));
        this.getView().getPageCache().put("cache_chartshow", SerializationUtils.toJsonString((Object)chartDisCon));
        this.getView().getPageCache().put("cache_chartother", SerializationUtils.toJsonString((Object)chartOthersCon));
        for (int i = 1; i < 4; ++i) {
            if (i == 1) {
                this.createConfigEntry(i, attDisCon, attOthersCon);
                continue;
            }
            if (i == 2) {
                this.createConfigEntry(i, rankDisCon, rankOthersCon);
                continue;
            }
            this.createConfigEntry(i, chartDisCon, chartOthersCon);
        }
    }

    private void createConfigEntry(int num, List<AttDataSourceModel> displayCon, List<AttDataSourceModel> othersCon) {
        int index;
        IDataModel model = this.getModel();
        if (!CollectionUtils.isEmpty(displayCon)) {
            model.batchCreateNewEntryRow("showentryentity" + num, displayCon.size());
            for (index = 0; index < displayCon.size(); ++index) {
                model.setValue("showtextfield" + num, (Object)displayCon.get(index).getAttDataSourceName(), index);
                if (displayCon.get(index).isAdjustment()) {
                    model.setValue("showctrl" + num, (Object)"0", index);
                    continue;
                }
                model.setValue("showctrl" + num, (Object)"1", index);
            }
        }
        if (!CollectionUtils.isEmpty(othersCon)) {
            model.batchCreateNewEntryRow("otherentryentity" + num, othersCon.size());
            for (index = 0; index < othersCon.size(); ++index) {
                model.setValue("othertextfield" + num, (Object)othersCon.get(index).getAttDataSourceName(), index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig() {
        List attDisConfig = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_attshow"), AttDataSourceModel.class);
        List rankDisConfig = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_rankshow"), AttDataSourceModel.class);
        List chartDisConfig = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("cache_chartshow"), AttDataSourceModel.class);
        Long userId = MobileCommonServiceHelper.getInstance().getUserId();
        long schemeId = Long.parseLong(this.getView().getPageCache().get("cache_id_scheme"));
        Long ruleId = (Long)this.getView().getFormShowParameter().getCustomParam("ruleid");
        String configType = this.getView().getPageCache().get("configtype");
        LOG.info("teammobilehome saveConfig schemeId: {}ruleId: {}configType: {} ", new Object[]{schemeId, ruleId, configType});
        String teamStaType = configType.equals("A") ? "1" : "2";
        try (TXHandle txHandle = TX.required();){
            HashMap returnData = new HashMap(16);
            SummaryTeamConfigDetailService.getInstance().update(userId.longValue(), schemeId, ruleId.longValue(), attDisConfig, teamStaType, "1", "1", returnData);
            SummaryTeamConfigDetailService.getInstance().update(userId.longValue(), schemeId, ruleId.longValue(), rankDisConfig, teamStaType, "2", "1", returnData);
            SummaryTeamConfigDetailService.getInstance().update(userId.longValue(), schemeId, ruleId.longValue(), chartDisConfig, teamStaType, "3", "1", returnData);
        }
    }
}

