/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtss.business.attstatistics.AttStatisticsFormService;
import kd.wtc.wtss.business.attstatistics.AttStatisticsServiceHelper;
import kd.wtc.wtss.business.attstatistics.IAttStatisticsService;
import kd.wtc.wtss.business.servicehelper.common.SchemaServiceHelper;
import kd.wtc.wtss.business.servicehelper.common.TeamHomeServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileHomePageBusiness;
import kd.wtc.wtss.business.servicehelper.mobile.MobileRankingDataServiceHelper;
import kd.wtc.wtss.business.servicehelper.mobile.MobileTeamHomeBusiness;
import kd.wtc.wtss.common.constants.MobileConfConstants;
import kd.wtc.wtss.common.constants.MobileHomeConstants;
import kd.wtc.wtss.common.constants.MobileTeamConstants;
import kd.wtc.wtss.common.dto.MobileHomeConf;
import kd.wtc.wtss.common.dto.mobilehome.AttDataSourceModel;
import kd.wtc.wtss.common.dto.mobilehome.AttStatisticQueryParam;
import kd.wtc.wtss.common.dto.mobilehome.AttendanceDataModel;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationConfProEnum;
import kd.wtc.wtss.common.enums.attstatistics.StaCombinationTerminal;
import kd.wtc.wtss.common.enums.attstatistics.StaTypeEnum;
import kd.wtc.wtss.common.utils.WTSSDateUtils;
import kd.wtc.wtss.formplugin.web.mobile.MobileHomePageFormPlugin;

public class MobileTeamHomeFormPlugin
extends AbstractMobFormPlugin
implements TabSelectListener,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(MobileHomePageFormPlugin.class);
    private final MobileTeamHomeBusiness mobileTeamHomeBusiness = MobileTeamHomeBusiness.getInstance();
    private final MobileHomePageBusiness mobileHomePageBusiness = MobileHomePageBusiness.getInstance();
    private static final String IS_NOT_FIRST = "isNotFirst3";
    private static final String IS_NOT_FIRST4 = "isNotFirst4";
    static final Map<String, String> applyMap = Maps.newHashMapWithExpectedSize((int)16);

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        this.addClickListeners(MobileTeamConstants.CLICK_ID);
        this.addClickListeners(MobileTeamConstants.CLICK_FLEXID);
        this.addClickListeners(new String[]{"filterpanel"});
        this.addClickListeners(new String[]{"dailychartmoreflex", "periodchartmoreflex"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit adminOrgEdit = (BasedataEdit)this.getControl("affiliateadminorg");
        adminOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(MobileTeamConstants.CLICK_BUTTON);
        this.addClickListeners(MobileTeamConstants.CLICK_APPLY);
        this.addClickListeners(MobileTeamConstants.CLICK_SETTING);
        this.addClickListeners(new String[]{"applyrecordflex"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        MobileListShowParameter formShowParameter = (MobileListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        HashMap adminOrgIdByPersonIdPlusMap = new HashMap(16);
        ArrayList allAdminOrgIdList = new ArrayList(1);
        AttStatisticsFormService.getInstance().collectAdminOrgIdByPersonIdPlusMap(this.getView(), allAdminOrgIdList, adminOrgIdByPersonIdPlusMap);
        AttStatisticQueryParam cacheAttStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView(), StaCombinationTerminal.MOBILE);
        cacheAttStatisticQueryParam.setAdminOrgIdByPersonIdPlusMap(adminOrgIdByPersonIdPlusMap);
        cacheAttStatisticQueryParam.setAllAdminOrgIdList(allAdminOrgIdList);
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), cacheAttStatisticQueryParam);
        List allPermAdminOrg = cacheAttStatisticQueryParam.getAllAdminOrgIdList();
        LOG.info("MobileTeamHomeFormPlugin.beforeF7Select  allPermAdminOrg = {}", CollectionUtils.isEmpty((Collection)allPermAdminOrg) ? Integer.valueOf(0) : allPermAdminOrg);
        QFilter qFilter = new QFilter("id", "in", (Object)allPermAdminOrg);
        formShowParameter.getListFilterParameter().setFilter(qFilter);
        beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"TeamHomePCPlugin_8", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
    }

    public void beforeBindData(EventObject eventObject) {
        this.initControlState();
        AttStatisticQueryParam cacheAttStatisticQueryParam = AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParam(this.getView(), StaCombinationTerminal.MOBILE);
        if (cacheAttStatisticQueryParam == null) {
            this.initFail(0L, "1");
            this.getView().setEnable(Boolean.FALSE, new String[]{"affiliateadminorg"});
            this.getPageCache().put("cacheidControlInitialled", "cacheidControlInitialled");
            return;
        }
        Long ruleId = cacheAttStatisticQueryParam.getRuleId();
        this.initFail(cacheAttStatisticQueryParam.getRuleId(), "1");
        this.initQTTabShowState(ruleId);
        Date chooseDate = cacheAttStatisticQueryParam.getQueryDate();
        this.getModel().setValue("daydate", (Object)chooseDate);
        long affiliateAdminOrgId = cacheAttStatisticQueryParam.getAffiliateAdminOrgId();
        this.initSearchBoxContent(affiliateAdminOrgId);
        this.getModel().setValue("affiliateadminorg", (Object)affiliateAdminOrgId);
        this.initAttendance(chooseDate, cacheAttStatisticQueryParam.thenAttFileSet());
        this.initDayStatistic(cacheAttStatisticQueryParam);
        this.initBillControl(ruleId, "daybillquickentry");
        this.rankingAndChartInit(cacheAttStatisticQueryParam);
        this.getPageCache().put("cacheidControlInitialled", "cacheidControlInitialled");
        this.setBottomIcon("");
    }

    private void initBillControl(long ruleId, String targetKey) {
        if (ruleId == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billperiod", "billday"});
            return;
        }
        for (String key : applyMap.keySet()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{key});
        }
        MobileHomeConf mobileHomeConf = SchemaServiceHelper.getInstance().queryTeamRuleBills(Long.valueOf(ruleId));
        List billTypes = mobileHomeConf.getBillTypes();
        for (MobileHomeConf.BillType billType : billTypes) {
            if (MobileConfConstants.BillTypes.F.getType().equals(billType.getBillType())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"vacationflex"});
                continue;
            }
            if (MobileConfConstants.BillTypes.G.getType().equals(billType.getBillType())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"workovertimeflex"});
                continue;
            }
            if (MobileConfConstants.BillTypes.H.getType().equals(billType.getBillType())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"evectionflex"});
                continue;
            }
            if (MobileConfConstants.BillTypes.I.getType().equals(billType.getBillType())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"supflex"});
                continue;
            }
            if (!MobileConfConstants.BillTypes.J.getType().equals(billType.getBillType())) continue;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"swshiftflex"});
        }
    }

    private void initQTTabShowState(long ruleId) {
        if (ruleId == 0L) {
            return;
        }
        DynamicObject ruleDy = SchemaServiceHelper.getInstance().queryRuleData(ruleId);
        if (ruleDy != null && WTCDynamicObjectUtils.getBaseDataId((DynamicObject)ruleDy, (String)"quotaconfig") != 0L) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabpagequota"});
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        Object newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).get()).getNewValue() : null;
        Object oldValue = WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])propertyChangedArgs.getChangeSet(), (int)0).get()).getOldValue() : null;
        String propName = propertyChangedArgs.getProperty().getName();
        if (newValue == null) {
            if ("affiliateadminorg".equals(propName)) {
                this.getView().getModel().setValue("affiliateadminorg", oldValue);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"daydate")) {
            this.refreshDailyDataByProperty((Date)newValue);
        } else if (HRStringUtils.equals((String)"changeyear", (String)propName)) {
            if ("true".equals(this.getView().getPageCache().get(IS_NOT_FIRST4))) {
                return;
            }
            this.refreshPeriodDataByProperty();
        } else if (HRStringUtils.equals((String)"affiliateadminorg", (String)propName)) {
            this.refreshDataByAffiliateAdminOrgChange(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)((DynamicObject)newValue), (String)"id"));
        }
    }

    public void refreshDataByAffiliateAdminOrgChange(Long newValue) {
        String currentTab;
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        long oldAffiliateAdminOrgId = attStatisticQueryParam.getAffiliateAdminOrgId();
        attStatisticQueryParam.setAffiliateAdminOrgId(newValue.longValue());
        switch (currentTab = ((Tab)this.getControl("tabap")).getCurrentTab()) {
            case "tabpageday": {
                this.refreshDailyDataByTabSelected(false, oldAffiliateAdminOrgId, attStatisticQueryParam);
                break;
            }
            case "tabpageperiod": {
                this.refreshPeriodDataByTabSelected(false, oldAffiliateAdminOrgId, attStatisticQueryParam);
                break;
            }
            case "tabpagequota": {
                this.getPageCache().remove("tabpagequota");
                this.refreshQuotaData("tabpagequota", false, oldAffiliateAdminOrgId, attStatisticQueryParam);
                break;
            }
        }
    }

    private void refreshQuotaData(String tabKey, boolean source, Long oldAffiliateAdminOrgId, AttStatisticQueryParam attStatisticQueryParam) {
        long org = 0L;
        String pageId = this.getPageCache().get(tabKey);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            Long affiliateAdminOrgId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)this.getModel().getDataEntity(), (String)"affiliateadminorg");
            if (affiliateAdminOrgId == 0L) {
                this.initFail(0L, "3");
                return;
            }
            this.initFail(attStatisticQueryParam.getRuleId(), "3");
            String dateStr = this.getView().getPageCache().get("qtdate");
            Date date = null;
            if (WTCStringUtils.isNotEmpty((String)dateStr)) {
                try {
                    date = WTCDateUtils.parseDate((String)dateStr, (String)"yyyy-MM-dd");
                }
                catch (ParseException ex) {
                    LOG.warn("kd.wtc.wtss.formplugin.web.mobile.MobileTeamHomeFormPlugin.refreshQuotaData error ", (Throwable)ex);
                }
            }
            if (null == date) {
                date = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
            }
            Tuple dateTuple = new Tuple((Object)WTCDateUtils.getBeginDayOfYear((Date)date), (Object)WTCDateUtils.getEndDayOfYear((Date)date));
            if (!source) {
                if (!"true".equals(this.getView().getPageCache().get(IS_NOT_FIRST))) {
                    if (!MobileHomePageBusiness.getInstance().checkDate(true, "3", this.getView(), attStatisticQueryParam, dateTuple)) {
                        this.getView().getPageCache().put(IS_NOT_FIRST, "true");
                        this.getModel().setValue("affiliateadminorg", (Object)oldAffiliateAdminOrgId);
                        return;
                    }
                    this.show(tabKey, attStatisticQueryParam, org, date);
                }
                this.getView().getPageCache().remove(IS_NOT_FIRST);
            } else {
                if (!"true".equals(this.getView().getPageCache().get(IS_NOT_FIRST)) && !MobileHomePageBusiness.getInstance().checkDate(false, "3", this.getView(), attStatisticQueryParam, dateTuple)) {
                    date = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
                    if (null != oldAffiliateAdminOrgId) {
                        org = oldAffiliateAdminOrgId;
                        attStatisticQueryParam.setAffiliateAdminOrgId(oldAffiliateAdminOrgId.longValue());
                    } else {
                        attStatisticQueryParam.setAffiliateAdminOrgId(affiliateAdminOrgId.longValue());
                    }
                    AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
                    this.getView().getPageCache().remove(IS_NOT_FIRST);
                    this.show(tabKey, attStatisticQueryParam, org, date);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("MobileTeamHomeFormPlugin#refreshQuotaData start");
                }
                this.getView().getPageCache().remove(IS_NOT_FIRST);
                this.show(tabKey, attStatisticQueryParam, org, date);
            }
        }
    }

    private void show(String tabKey, AttStatisticQueryParam attStatisticQueryParam, long org, Date date) {
        if (LOG.isInfoEnabled()) {
            LOG.info("MobileTeamHomeFormPlugin#refreshQuotaData show start");
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("wtss_teamquotahomemob");
        parameter.getOpenStyle().setTargetKey("tabpagequota");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (0L == org) {
            org = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)this.getModel().getDataEntity(), (String)"affiliateadminorg");
        }
        parameter.setCustomParam("cache_admin_org", (Object)String.valueOf(org));
        parameter.setCustomParam("cache_rule_id", (Object)String.valueOf(attStatisticQueryParam.getRuleId()));
        parameter.setCustomParam("qtdate", (Object)date);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
        this.getPageCache().put(tabKey, parameter.getPageId());
    }

    private void refreshPeriodDataByProperty() {
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        Date periodDate = this.getModel().getDataEntity().getDate("changeyear");
        Tuple tupleDate = new Tuple((Object)WTCDateUtils.getBeginDayOfMonth((Date)periodDate), (Object)WTCDateUtils.getEndDayOfMonth((Date)periodDate));
        if (!MobileHomePageBusiness.getInstance().checkDate(true, "2", this.getView(), attStatisticQueryParam, tupleDate)) {
            this.getModel().setValue("changeyear", (Object)attStatisticQueryParam.getQueryStartDate());
            return;
        }
        attStatisticQueryParam.setQueryStartDate(WTCDateUtils.getBeginDayOfMonth((Date)periodDate));
        attStatisticQueryParam.setQueryEndDate(WTCDateUtils.getEndDayOfMonth((Date)periodDate));
        attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        this.initDayStatistic(attStatisticQueryParam);
        this.rankingAndChartInit(attStatisticQueryParam);
    }

    private void refreshDailyDataByProperty(Date newValue) {
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        if (!MobileHomePageBusiness.getInstance().checkDate(true, "1", this.getView(), attStatisticQueryParam, new Tuple((Object)newValue, (Object)newValue))) {
            this.getModel().setValue("daydate", (Object)attStatisticQueryParam.getQueryDate());
            return;
        }
        attStatisticQueryParam.setQueryDate(newValue);
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        if (attStatisticQueryParam.getRuleId() != 0L) {
            this.initDayStatistic(attStatisticQueryParam);
            this.rankingAndChartInit(attStatisticQueryParam);
            this.initAttendance(attStatisticQueryParam.getQueryDate(), attStatisticQueryParam.thenAttFileSet());
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5047\u52e4\u81ea\u52a9\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MobileTeamHomeFormPlugin_8", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), "kdfont kdfont-Toast-jinggao", MessageTypes.ImageWithText_m, null);
        }
    }

    private AttStatisticQueryParam getAttStatisticQueryParam() {
        return AttStatisticsFormService.getInstance().getCacheAttStatisticQueryParamEx(this.getView().getPageCache());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("flextostaffpage".equals(key)) {
            return;
        }
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        Long ruleId = attStatisticQueryParam.getRuleId();
        String substring = key.substring(0, 7);
        if (this.clickConfigFlex(key, attStatisticQueryParam, substring)) {
            return;
        }
        switch (key) {
            case "flexdropdown": {
                this.dayStaOpen();
                break;
            }
            case "flexpollup": {
                String confStrUp = this.getView().getPageCache().get("cache_id_daystatistic");
                if (StringUtils.isEmpty((CharSequence)confStrUp)) break;
                List attDataDayUpModel = SerializationUtils.fromJsonStringToList((String)confStrUp, AttDataSourceModel.class);
                this.statisticDayShowTop(attDataDayUpModel);
                break;
            }
            case "flexperdropdown": {
                this.perStaOpen();
                break;
            }
            case "flexperpollup": {
                String confPerStrUp = this.getView().getPageCache().get("cache_id_perstatistic");
                if (StringUtils.isEmpty((CharSequence)confPerStrUp)) break;
                List attDataDayUpModel = SerializationUtils.fromJsonStringToList((String)confPerStrUp, AttDataSourceModel.class);
                this.statisticPerShowTop(attDataDayUpModel);
                break;
            }
            case "rankingmoreflex": {
                AttStatisticQueryParam attStatisticQueryParamRanking = this.genAttStatisticQueryParam(StaTypeEnum.DAILY, 0L, StaCombinationConfProEnum.ATT_RANKING);
                this.showHomeDetailPage(attStatisticQueryParamRanking);
                break;
            }
            case "rankingmoreflex1": {
                AttStatisticQueryParam attStatisticQueryParamRanking1 = this.genAttStatisticQueryParam(StaTypeEnum.PERIOD, 0L, StaCombinationConfProEnum.ATT_RANKING);
                this.showHomeDetailPage(attStatisticQueryParamRanking1);
                break;
            }
            case "dailychartmoreflex": {
                AttStatisticQueryParam dailyChartParam = this.genAttStatisticQueryParam(StaTypeEnum.DAILY, 0L, StaCombinationConfProEnum.ATT_CHART);
                this.showHomeDetailPage(dailyChartParam);
                break;
            }
            case "periodchartmoreflex": {
                AttStatisticQueryParam periodChartParam = this.genAttStatisticQueryParam(StaTypeEnum.PERIOD, 0L, StaCombinationConfProEnum.ATT_CHART);
                this.showHomeDetailPage(periodChartParam);
                break;
            }
            case "countbutton": 
            case "applybutton": 
            case "settingbutton": {
                this.setBottomIcon(key);
                break;
            }
            case "applyrecordflex": {
                MobileFormShowParameter showParameterBill = MobileHomePageBusiness.getInstance().getShowParameter("wtss_mobileotherbill", ShowType.Floating);
                this.getView().showForm((FormShowParameter)showParameterBill);
                break;
            }
            case "evectionflex": 
            case "vacationflex": 
            case "workovertimeflex": 
            case "supflex": 
            case "swshiftflex": {
                MobileTeamHomeBusiness.getInstance().toApplyPage(applyMap.get(key), this.getView(), ruleId);
                break;
            }
            case "daycountflex": 
            case "dayrankflex": 
            case "daychartflex": {
                if (ruleId == null || ruleId == 0L) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u6709\u6548\u65e5\u7edf\u8ba1\u914d\u7f6e\u3002", (String)"MobileTeamHomeFormPlugin_6", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), "kdfont kdfont-Toast-jinggao", MessageTypes.ImageWithText_m, null);
                    return;
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close_wtss_mobileconfig");
                this.showConfigPage(this.getView(), closeCallBack, "A", key);
                break;
            }
            case "periodcountflex": 
            case "periodrankflex": 
            case "periodchartflex": {
                if (ruleId == null || ruleId == 0L) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u6709\u6548\u671f\u95f4\u7edf\u8ba1\u914d\u7f6e\u3002", (String)"MobileTeamHomeFormPlugin_7", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), "kdfont kdfont-Toast-jinggao", MessageTypes.ImageWithText_m, null);
                    return;
                }
                CloseCallBack closePerCallBack = new CloseCallBack((IFormPlugin)this, "close_wtss_mobileperconfig");
                this.showConfigPage(this.getView(), closePerCallBack, "B", key);
                break;
            }
        }
    }

    private void setBottomIcon(String clickKey) {
        this.getView().setVisible(Boolean.valueOf(false), MobileTeamConstants.VECTORLIST);
        switch (clickKey) {
            case "applybutton": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applyflex", "flex_total_notselected", "flex_apply_selected", "flex_setting_notselected"});
                break;
            }
            case "settingbutton": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"settingflex", "flex_total_notselected", "flex_apply_notselected", "flex_setting_selected"});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"countflex", "flex_total_selected", "flex_apply_notselected", "flex_setting_notselected"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = ((FormOperate)afterDoOperationEventArgs.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"donothing", (CharSequence)operateKey)) {
            String controlIntialled = this.getPageCache().get("cacheidControlInitialled");
            if (StringUtils.isEmpty((CharSequence)controlIntialled)) {
                return;
            }
            this.getPageCache().remove("cacheidControlInitialled");
            MobileFormShowParameter showParameterTeam = this.mobileHomePageBusiness.getShowParameter("wtss_mobilehomepage", ShowType.Floating);
            this.getView().showForm((FormShowParameter)showParameterTeam);
            this.getView().close();
        }
    }

    private AttStatisticQueryParam genAttStatisticQueryParam(StaTypeEnum staTypeEnum, Long chickSourceId, StaCombinationConfProEnum confProEnum) {
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        attStatisticQueryParam.setStaTypeEnum(staTypeEnum);
        attStatisticQueryParam.setChickSourceId(chickSourceId);
        attStatisticQueryParam.setStaCombinationConfProEnum(confProEnum);
        return attStatisticQueryParam;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (this.tableSelectInitFail(tabKey)) {
            return;
        }
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"tabpageday")) {
            this.refreshDailyDataByTabSelected(true, null, attStatisticQueryParam);
        } else if ("tabpageperiod".equals(tabKey)) {
            this.refreshPeriodDataByTabSelected(true, null, attStatisticQueryParam);
        } else if ("tabpagequota".equals(tabKey)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("MobileTeamHomeFormPlugin#tabSelected tabKey:{},attStatisticQueryParam:{}", (Object)tabKey, (Object)SerializationUtils.toJsonString((Object)attStatisticQueryParam));
            }
            this.refreshQuotaData(tabKey, true, null, attStatisticQueryParam);
        }
    }

    private void refreshPeriodDataByTabSelected(boolean source, Long oldAffiliateAdminOrgId, AttStatisticQueryParam attStatisticQueryParam) {
        Tuple tupleDate = new Tuple((Object)attStatisticQueryParam.getQueryStartDate(), (Object)attStatisticQueryParam.getQueryEndDate());
        if (!source) {
            if (!MobileHomePageBusiness.getInstance().checkDate(true, "2", this.getView(), attStatisticQueryParam, tupleDate)) {
                this.getModel().setValue("affiliateadminorg", (Object)oldAffiliateAdminOrgId);
                return;
            }
        } else if (!"true".equals(this.getView().getPageCache().get(IS_NOT_FIRST4)) && !MobileHomePageBusiness.getInstance().checkDate(false, "2", this.getView(), attStatisticQueryParam, tupleDate)) {
            Date date = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
            AttStatisticQueryParam.thenTupleDate((Date)date);
            attStatisticQueryParam.setQueryStartDate(WTCDateUtils.getBeginDayOfMonth((Date)date));
            attStatisticQueryParam.setQueryEndDate(WTCDateUtils.getEndDayOfMonth((Date)date));
            if (null != oldAffiliateAdminOrgId) {
                attStatisticQueryParam.setAffiliateAdminOrgId(oldAffiliateAdminOrgId.longValue());
            }
            Set periodEntryIdSet = AttStatisticsServiceHelper.getInstance().getPeriodEntryIdSet(attStatisticQueryParam.getQueryStartDate(), attStatisticQueryParam.getQueryEndDate(), attStatisticQueryParam.getAttFileMap().keySet());
            attStatisticQueryParam.setPeriodEntrySet(periodEntryIdSet);
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
            this.getView().getPageCache().put(IS_NOT_FIRST4, "true");
            this.getModel().setValue("changeyear", (Object)WTCDateUtils.getBeginDayOfMonth((Date)date));
        }
        if (null != this.getView().getPageCache().get(IS_NOT_FIRST4)) {
            this.getView().getPageCache().remove(IS_NOT_FIRST4);
        }
        this.refreshPeriodDataByTabSelected(attStatisticQueryParam);
    }

    public void refreshPeriodDataByTabSelected(AttStatisticQueryParam attStatisticQueryParam) {
        this.initFail(attStatisticQueryParam.getRuleId(), "2");
        attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.PERIOD);
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        this.initDayStatistic(attStatisticQueryParam);
        this.rankingAndChartInit(attStatisticQueryParam);
        this.initSearchBoxContent(attStatisticQueryParam.getAffiliateAdminOrgId());
        this.initBillControl(attStatisticQueryParam.getRuleId(), "periodbillquickentry");
    }

    private void refreshDailyDataByTabSelected(boolean source, Long oldAffiliateAdminOrgId, AttStatisticQueryParam attStatisticQueryParam) {
        if (!source) {
            if (!MobileHomePageBusiness.getInstance().checkDate(true, "1", this.getView(), attStatisticQueryParam, new Tuple((Object)attStatisticQueryParam.getQueryDate(), (Object)attStatisticQueryParam.getQueryDate()))) {
                this.getModel().setValue("affiliateadminorg", (Object)oldAffiliateAdminOrgId);
                return;
            }
        } else if (!MobileHomePageBusiness.getInstance().checkDate(false, "1", this.getView(), attStatisticQueryParam, new Tuple((Object)attStatisticQueryParam.getQueryDate(), (Object)attStatisticQueryParam.getQueryDate()))) {
            Date queryDate = WTCDateUtils.getZeroDate((Date)WTSSDateUtils.getLastDate());
            attStatisticQueryParam.setQueryDate(queryDate);
            if (null != oldAffiliateAdminOrgId) {
                attStatisticQueryParam.setAffiliateAdminOrgId(oldAffiliateAdminOrgId.longValue());
            }
            AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
            this.getModel().setValue("daydate", (Object)queryDate);
        }
        this.refreshDailyDataByTabSelected(attStatisticQueryParam);
    }

    public void refreshDailyDataByTabSelected(AttStatisticQueryParam attStatisticQueryParam) {
        attStatisticQueryParam.setStaTypeEnum(StaTypeEnum.DAILY);
        AttStatisticsFormService.getInstance().cacheAttStatisticQueryParam(this.getPageCache(), attStatisticQueryParam);
        if (0L == attStatisticQueryParam.getRuleId()) {
            this.initFail(0L, "1");
        }
        this.initDayStatistic(attStatisticQueryParam);
        this.rankingAndChartInit(attStatisticQueryParam);
        this.initAttendance(attStatisticQueryParam.getQueryDate(), attStatisticQueryParam.thenAttFileSet());
        this.initSearchBoxContent(attStatisticQueryParam.getAffiliateAdminOrgId());
        this.initBillControl(attStatisticQueryParam.getRuleId(), "daybillquickentry");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        StaTypeEnum staTypeEnum = null;
        if ("close_wtss_mobileconfig".equals(closedCallBackEvent.getActionId())) {
            staTypeEnum = StaTypeEnum.DAILY;
        } else if ("close_wtss_mobileperconfig".equals(closedCallBackEvent.getActionId())) {
            staTypeEnum = StaTypeEnum.PERIOD;
        }
        if (staTypeEnum != null) {
            AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
            attStatisticQueryParam.setStaTypeEnum(staTypeEnum);
            this.initDayStatistic(attStatisticQueryParam);
            this.rankingAndChartInit(attStatisticQueryParam);
        }
    }

    private void initAttendance(Date queryDate, Set<Long> attFileBoIdSet) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("gaugepercent");
        AttendanceDataModel attendanceData = AttStatisticsFormService.getInstance().getAttendanceDataModel(queryDate, attFileBoIdSet);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("event", "init");
        data.put("args", (String)attendanceData);
        customcontrol.setData(data);
    }

    private void initDayStatistic(AttStatisticQueryParam attStatisticQueryParam) {
        List attStatisticsData = AttStatisticsFormService.getInstance().getDayOrPeriodStatisticData(attStatisticQueryParam, this.getView());
        StaTypeEnum staTypeEnum = attStatisticQueryParam.getStaTypeEnum();
        if (StaTypeEnum.DAILY == staTypeEnum) {
            this.statisticDayShowTop(attStatisticsData);
        } else if (StaTypeEnum.PERIOD == staTypeEnum) {
            this.statisticPerShowTop(attStatisticsData);
        }
    }

    private void statisticDayShowTop(List<AttDataSourceModel> showList) {
        if (showList.size() > 3) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdropdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpollup"});
            this.getView().setVisible(Boolean.TRUE, new String[]{MobileHomeConstants.TEAMDAYSTA_ID[0]});
            ((Label)this.getControl(MobileHomeConstants.TEAMDAYLABEL_ID[0])).setText(showList.get(0).getAttDataSourceName() + this.fillUnit(showList.get(0)));
            ((Label)this.getControl(MobileHomeConstants.TEAMDAYVALUE_ID[0])).setText(showList.get(0).getAttDataSourceValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{MobileHomeConstants.TEAMDAYSTA_ID[1]});
            ((Label)this.getControl(MobileHomeConstants.TEAMDAYLABEL_ID[1])).setText(showList.get(1).getAttDataSourceName() + this.fillUnit(showList.get(1)));
            ((Label)this.getControl(MobileHomeConstants.TEAMDAYVALUE_ID[1])).setText(showList.get(1).getAttDataSourceValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{MobileHomeConstants.TEAMDAYSTA_ID[2]});
            ((Label)this.getControl(MobileHomeConstants.TEAMDAYLABEL_ID[2])).setText(showList.get(2).getAttDataSourceName() + this.fillUnit(showList.get(2)));
            ((Label)this.getControl(MobileHomeConstants.TEAMDAYVALUE_ID[2])).setText(showList.get(2).getAttDataSourceValue());
            for (int index = 3; index < MobileHomeConstants.TEAMDAYSTA_ID.length; ++index) {
                this.getView().setVisible(Boolean.FALSE, new String[]{MobileHomeConstants.TEAMDAYSTA_ID[index]});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdropdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpollup"});
            this.setShowDaySummary(showList);
            for (int index = showList.size(); index < MobileHomeConstants.TEAMDAYSTA_ID.length; ++index) {
                this.getView().setVisible(Boolean.FALSE, new String[]{MobileHomeConstants.TEAMDAYSTA_ID[index]});
            }
        }
    }

    private String fillUnit(AttDataSourceModel attDataSourceModel) {
        if (null != attDataSourceModel) {
            String wapUnit = "(" + attDataSourceModel.getUnit() + ")";
            return wapUnit;
        }
        return "";
    }

    private void setShowDaySummary(List<AttDataSourceModel> showList) {
        int size = Math.min(showList.size(), 9);
        for (int index = 0; index < size; ++index) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MobileHomeConstants.TEAMDAYSTA_ID[index]});
            ((Label)this.getControl(MobileHomeConstants.TEAMDAYLABEL_ID[index])).setText(showList.get(index).getAttDataSourceName() + this.fillUnit(showList.get(index)));
            ((Label)this.getControl(MobileHomeConstants.TEAMDAYVALUE_ID[index])).setText(showList.get(index).getAttDataSourceValue());
        }
    }

    private void statisticPerShowTop(List<AttDataSourceModel> showList) {
        if (showList.size() > 3) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexperdropdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexperpollup"});
            this.getView().setVisible(Boolean.TRUE, new String[]{MobileHomeConstants.TEAMPERSTA_ID[0]});
            ((Label)this.getControl(MobileHomeConstants.TEAMPERLABEL_ID[0])).setText(showList.get(0).getAttDataSourceName() + this.fillUnit(showList.get(0)));
            ((Label)this.getControl(MobileHomeConstants.TEAMPERVALUE_ID[0])).setText(showList.get(0).getAttDataSourceValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{MobileHomeConstants.TEAMPERSTA_ID[1]});
            ((Label)this.getControl(MobileHomeConstants.TEAMPERLABEL_ID[1])).setText(showList.get(1).getAttDataSourceName() + this.fillUnit(showList.get(1)));
            ((Label)this.getControl(MobileHomeConstants.TEAMPERVALUE_ID[1])).setText(showList.get(1).getAttDataSourceValue());
            this.getView().setVisible(Boolean.TRUE, new String[]{MobileHomeConstants.TEAMPERSTA_ID[2]});
            ((Label)this.getControl(MobileHomeConstants.TEAMPERLABEL_ID[2])).setText(showList.get(2).getAttDataSourceName() + this.fillUnit(showList.get(2)));
            ((Label)this.getControl(MobileHomeConstants.TEAMPERVALUE_ID[2])).setText(showList.get(2).getAttDataSourceValue());
            for (int index = 3; index < MobileHomeConstants.TEAMPERSTA_ID.length; ++index) {
                this.getView().setVisible(Boolean.FALSE, new String[]{MobileHomeConstants.TEAMPERSTA_ID[index]});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexperdropdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexperpollup"});
            this.setShowPerSummary(showList);
            for (int index = showList.size(); index < MobileHomeConstants.TEAMPERSTA_ID.length; ++index) {
                this.getView().setVisible(Boolean.FALSE, new String[]{MobileHomeConstants.TEAMPERSTA_ID[index]});
            }
        }
    }

    private void setShowPerSummary(List<AttDataSourceModel> showList) {
        int size = Math.min(showList.size(), 9);
        for (int index = 0; index < size; ++index) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MobileHomeConstants.TEAMPERSTA_ID[index]});
            ((Label)this.getControl(MobileHomeConstants.TEAMPERLABEL_ID[index])).setText(showList.get(index).getAttDataSourceName() + this.fillUnit(showList.get(index)));
            ((Label)this.getControl(MobileHomeConstants.TEAMPERVALUE_ID[index])).setText(showList.get(index).getAttDataSourceValue());
        }
    }

    private boolean clickConfigFlex(String key, AttStatisticQueryParam attStatisticQueryParam, String substring) {
        if (key.length() > 7 && substring.equals("dayflex")) {
            this.genParamShowHomeDetailPage(key, attStatisticQueryParam, "cache_id_daystatistic", StaTypeEnum.DAILY, StaCombinationConfProEnum.ATT_STATISTICS);
            return true;
        }
        if (key.length() > 7 && substring.equals("perflex")) {
            this.genParamShowHomeDetailPage(key, attStatisticQueryParam, "cache_id_perstatistic", StaTypeEnum.PERIOD, StaCombinationConfProEnum.ATT_STATISTICS);
            return true;
        }
        return false;
    }

    private void genParamShowHomeDetailPage(String key, AttStatisticQueryParam param, String cacheStr, StaTypeEnum daily, StaCombinationConfProEnum confProEnum) {
        String num = key.substring(key.length() - 1);
        int integer = StaCombinationConfProEnum.ATT_CHART == confProEnum ? Integer.parseInt(num) : Integer.parseInt(num) - 1;
        String confStr = this.getView().getPageCache().get(cacheStr);
        List attDataDayDownModel = SerializationUtils.fromJsonStringToList((String)confStr, AttDataSourceModel.class);
        AttDataSourceModel attDataSourceModel = (AttDataSourceModel)attDataDayDownModel.get(integer);
        param.setStaTypeEnum(daily);
        param.setStaCombinationConfProEnum(confProEnum);
        param.setChickSourceId(attDataSourceModel.getAttDataSourceId());
        this.showHomeDetailPage(param);
    }

    private void dayStaOpen() {
        String confStr = this.getView().getPageCache().get("cache_id_daystatistic");
        if (!StringUtils.isEmpty((CharSequence)confStr)) {
            List attDataDayDownModel = SerializationUtils.fromJsonStringToList((String)confStr, AttDataSourceModel.class);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdropdown"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpollup"});
            this.setShowDaySummary(attDataDayDownModel);
        }
    }

    private void perStaOpen() {
        String confPerStr = this.getView().getPageCache().get("cache_id_perstatistic");
        if (!StringUtils.isEmpty((CharSequence)confPerStr)) {
            List attDataDayDownModel = SerializationUtils.fromJsonStringToList((String)confPerStr, AttDataSourceModel.class);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexperdropdown"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexperpollup"});
            this.setShowPerSummary(attDataDayDownModel);
        }
    }

    private void showHomeDetailPage(AttStatisticQueryParam attStatisticQueryParam) {
        if (attStatisticQueryParam == null) {
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.getOpenStyle().setNoSwitchFocus(false);
        showParameter.setFormId("wtss_homedetail_m");
        showParameter.setCustomParam("homeDetailListModel", (Object)SerializationUtils.toJsonString((Object)attStatisticQueryParam));
        StaCombinationConfProEnum staCombinationConfProEnum = attStatisticQueryParam.getStaCombinationConfProEnum();
        StaTypeEnum staTypeEnum = attStatisticQueryParam.getStaTypeEnum();
        if (StaCombinationConfProEnum.ATT_STATISTICS == staCombinationConfProEnum) {
            this.setDetailDateAndCaption(attStatisticQueryParam, showParameter, staTypeEnum, attStatisticQueryParam.getQueryDate(), ResManager.loadKDString((String)"\u65e5\u7edf\u8ba1 %s", (String)"MobileTeamHomeFormPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u671f\u95f4\u7edf\u8ba1%s", (String)"MobileTeamHomeFormPlugin_1", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        } else if (StaCombinationConfProEnum.ATT_RANKING == staCombinationConfProEnum) {
            this.setDetailDateAndCaption(attStatisticQueryParam, showParameter, staTypeEnum, attStatisticQueryParam.getQueryStartDate(), ResManager.loadKDString((String)"\u6392\u884c\u699c %s", (String)"MobileTeamHomeFormPlugin_2", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6392\u884c\u699c%s", (String)"MobileTeamHomeFormPlugin_3", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        } else if (StaCombinationConfProEnum.ATT_CHART == staCombinationConfProEnum) {
            this.setDetailDateAndCaption(attStatisticQueryParam, showParameter, staTypeEnum, attStatisticQueryParam.getQueryStartDate(), ResManager.loadKDString((String)"\u7edf\u8ba1\u56fe\u8868 %s", (String)"MobileTeamHomeFormPlugin_16", (String)"wtc-wtss-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edf\u8ba1\u56fe\u8868%s", (String)"MobileTeamHomeFormPlugin_17", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setDetailDateAndCaption(AttStatisticQueryParam attStatisticQueryParam, MobileFormShowParameter showParameter, StaTypeEnum staTypeEnum, Date queryStartDate, String dailyCaption, String periodCaption) {
        if (StaTypeEnum.DAILY == staTypeEnum) {
            String dateStr = WTCDateUtils.date2Str((Date)queryStartDate, (String)"yyyy-MM-dd");
            String caption = String.format(Locale.ROOT, dailyCaption, dateStr);
            showParameter.setCaption(caption);
        } else if (StaTypeEnum.PERIOD == staTypeEnum) {
            String perRangeStr = this.getPerRange(attStatisticQueryParam);
            String caption = String.format(Locale.ROOT, periodCaption, perRangeStr);
            showParameter.setCaption(caption);
        }
    }

    private String getPerRange(AttStatisticQueryParam attStatisticQueryParam) {
        String beginDateStrFormat = WTCDateUtils.date2Str((Date)attStatisticQueryParam.getQueryStartDate(), (String)"MMdd");
        String endDateStrFormat = WTCDateUtils.date2Str((Date)attStatisticQueryParam.getQueryEndDate(), (String)"MMdd");
        return "(" + beginDateStrFormat + "-" + endDateStrFormat + ")";
    }

    private void showConfigPage(IFormView view, CloseCallBack closeCallBack, String configType, String configTab) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("wtss_mobileteamconfig");
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        AttStatisticQueryParam attStatisticQueryParam = this.getAttStatisticQueryParam();
        Long ruleId = attStatisticQueryParam.getRuleId();
        HashMap<String, Object> configParams = new HashMap<String, Object>(3);
        configParams.put("ruleid", ruleId);
        if ("A".equals(configType)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u65e5\u7edf\u8ba1\u8bbe\u7f6e", (String)"MobileTeamHomeFormPlugin_4", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u671f\u95f4\u7edf\u8ba1\u8bbe\u7f6e", (String)"MobileTeamHomeFormPlugin_5", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
        }
        configParams.put("configtype", configType);
        configParams.put("configtab", configTab);
        showParameter.setCustomParams(configParams);
        view.showForm((FormShowParameter)showParameter);
    }

    private void rankingAndChartInit(AttStatisticQueryParam attStatisticQueryParam) {
        String suffix = "";
        if (StaTypeEnum.PERIOD == attStatisticQueryParam.getStaTypeEnum()) {
            suffix = "1";
        }
        IAttStatisticsService attStatisticsService = AttStatisticsServiceHelper.getInstance().getAttStatisticsService(attStatisticQueryParam.getStaTypeEnum());
        attStatisticQueryParam.setStaCombinationConfProEnum(StaCombinationConfProEnum.ATT_RANKING);
        List attRankData = attStatisticsService.getAttRankOrChartData(attStatisticQueryParam);
        this.getView().getPageCache().put("attDataSourceRanking", SerializationUtils.toJsonString((Object)attRankData));
        MobileRankingDataServiceHelper.initRanking((String)suffix, (List)attRankData, (IDataModel)this.getModel(), (IFormView)this.getView());
        String prefix = StaTypeEnum.PERIOD == attStatisticQueryParam.getStaTypeEnum() ? "periodbarchartap" : "dailybarchartap";
        attStatisticQueryParam.setStaCombinationConfProEnum(StaCombinationConfProEnum.ATT_CHART);
        List attChartData = attStatisticsService.getAttRankOrChartData(attStatisticQueryParam);
        this.getView().getPageCache().put("attDataSourceChart", SerializationUtils.toJsonString((Object)attChartData));
        MobileRankingDataServiceHelper.initChart((String)prefix, (String)suffix, (List)attChartData, (IFormView)this.getView());
    }

    private void initSearchBoxContent(long orgId) {
        ((Label)this.getControl("labelsearchtext")).setText(this.mobileTeamHomeBusiness.getOrgName(orgId));
    }

    private void initControlState() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexdropdown"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpollup"});
        this.getView().setVisible(Boolean.FALSE, MobileHomeConstants.TEAMDAYSTA_ID);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexperdropdown"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexperpollup"});
        this.getView().setVisible(Boolean.FALSE, MobileHomeConstants.TEAMPERSTA_ID);
        this.getView().setVisible(Boolean.FALSE, new String[]{"billperiod", "billday", "flex_total_notselected", "flex_apply_selected", "flex_setting_selected"});
        TeamHomeServiceHelper.getInstance().setDateEditRange(null, this.getView(), "daydate", "changeyear");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"settingflex", "applyflex"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"countflex"});
    }

    private boolean tableSelectInitFail(String tabKey) {
        IPageCache iPageCache = this.getView().getPageCache();
        AttStatisticsFormService.getInstance();
        if (HRStringUtils.isEmpty((String)iPageCache.get("cache_sta_query_param"))) {
            if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"tabpageday")) {
                this.initFail(0L, "1");
            } else {
                this.initFail(0L, "2");
            }
            return true;
        }
        return false;
    }

    private void initFail(long ruleId, String type) {
        if (0L == ruleId) {
            switch (type) {
                case "1": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"daydate"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"dayvectorap"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"labelap42"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"labelap4"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap11"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"rankingseemore"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"rankingseemore2"});
                    break;
                }
                case "2": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"changeyear"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"pervectorap"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"labelap41"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"labelap421"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap111"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"rankingseemore1"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"rankingseemore21"});
                    break;
                }
                case "3": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tabpagequota"});
                    break;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    static {
        applyMap.put("evectionflex", MobileConfConstants.BillTypes.H.getEntityId());
        applyMap.put("vacationflex", MobileConfConstants.BillTypes.F.getEntityId());
        applyMap.put("workovertimeflex", MobileConfConstants.BillTypes.G.getEntityId());
        applyMap.put("supflex", MobileConfConstants.BillTypes.I.getEntityId());
        applyMap.put("swshiftflex", MobileConfConstants.BillTypes.J.getEntityId());
    }
}

