/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class QuotaDetailMobPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final String[] PROPERTIES = new String[]{"qttype.name", "usestartdate", "useenddate", "ownvalue", "usablevalue", "freezevalue", "usedvalue", "canbeodvalue", "useodvalue", "cdedvalue", "pastvalue"};

    public void preOpenForm(PreOpenFormEventArgs args) {
        Object[] quotaDetailIds = (Long[])args.getFormShowParameter().getCustomParam("quotaDetailIds");
        if (ArrayUtils.isEmpty((Object[])quotaDetailIds)) {
            args.setCancel(true);
        }
    }

    public void initialize() {
        super.initialize();
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Object quotaFilter = this.getView().getFormShowParameter().getCustomParams().get("quotalistmobfilter");
        if (!Objects.isNull(quotaFilter)) {
            Map params = (Map)SerializationUtils.fromJsonString((String)String.valueOf(quotaFilter), Map.class);
            this.setEntryEntity(params);
        } else {
            this.setEntryEntity(Maps.newHashMap());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String filterStr;
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("updateentry".equals(operateKey) && WTCStringUtils.isNotEmpty((String)(filterStr = ((AbstractOperate)args.getSource()).getOption().getVariableValue("quotalistmobfilter")))) {
            Map params = (Map)SerializationUtils.fromJsonString((String)filterStr, Map.class);
            this.setEntryEntity(params);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        boolean isDisplay = !Boolean.FALSE.equals(this.getModel().getValue("isdisplay", evt.getRow()));
        this.getModel().setValue("isdisplay", (Object)(!isDisplay ? 1 : 0), evt.getRow());
    }

    private void setEntryEntity(Map<String, Object> params) {
        String selectProperties = String.join((CharSequence)",", PROPERTIES);
        Object quotaDetailIds = this.getView().getFormShowParameter().getCustomParam("quotaDetailIds");
        QFilter idFilter = new QFilter("id", "in", quotaDetailIds);
        ArrayList filters = Lists.newArrayList();
        filters.add(idFilter);
        if (MapUtils.isNotEmpty(params)) {
            QFilter dateFilter;
            String qtTypeName = (String)params.get("qttypename");
            if (StringUtils.isNotBlank((CharSequence)qtTypeName)) {
                filters.add(new QFilter("qttype.name", "like", (Object)("%" + qtTypeName + "%")));
            }
            if ((dateFilter = this.getDateFilter(params)) != null) {
                filters.add(dateFilter);
            }
        }
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtss_qtlinedetail");
        Object[] details = detailHelper.query(selectProperties, filters.toArray(new QFilter[0]));
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (ArrayUtils.isEmpty((Object[])details)) {
            return;
        }
        model.batchCreateNewEntryRow("entryentity", details.length);
        for (int i = 0; i < details.length; ++i) {
            Object detail = details[i];
            if (detail == null) continue;
            for (String prop : PROPERTIES) {
                if ("qttype.name".equals(prop)) {
                    model.setValue("qttypename", detail.get(prop), i);
                    continue;
                }
                model.setValue(prop, detail.get(prop), i);
            }
        }
    }

    private QFilter getDateFilter(Map<String, Object> params) {
        Date endDate;
        Date startDate;
        String useDate = (String)params.get("usedate");
        LocalDate now = LocalDate.now();
        if (StringUtils.isBlank((CharSequence)useDate)) {
            startDate = WTCDateUtils.str2Date((String)((String)params.get("startdate")), (String)"yyyy-MM-dd");
            endDate = WTCDateUtils.addDays((Date)WTCDateUtils.str2Date((String)((String)params.get("enddate")), (String)"yyyy-MM-dd"), (int)1);
        } else {
            switch (useDate) {
                case "today": {
                    startDate = Date.from(now.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    endDate = WTCDateUtils.addDays((Date)startDate, (int)1);
                    break;
                }
                case "thismonth": {
                    startDate = Date.from(now.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    endDate = Date.from(now.with(TemporalAdjusters.lastDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).plusDays(1L).toInstant());
                    break;
                }
                case "thisyear": {
                    startDate = Date.from(now.with(TemporalAdjusters.firstDayOfYear()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    endDate = Date.from(now.with(TemporalAdjusters.lastDayOfYear()).atStartOfDay(ZoneId.systemDefault()).plusDays(1L).toInstant());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        QFilter dateQf = null;
        if (startDate != null) {
            dateQf = new QFilter("useenddate", ">=", (Object)startDate);
        }
        if (endDate != null) {
            if (dateQf == null) {
                dateQf = new QFilter("usestartdate", "<", (Object)endDate);
            } else {
                dateQf.and(new QFilter("usestartdate", "<", (Object)endDate));
            }
        }
        return dateQf;
    }
}

