/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtss.common.utils.WTSSKDStringHelper;

public class QuotaListMobFilterPlugin
extends AbstractMobFormPlugin {
    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        String filterStr = (String)this.getView().getFormShowParameter().getCustomParam("quotalistmobfilter");
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            IDataModel model = this.getModel();
            Map<String, Object> params = this.getQuotaListMobFilter();
            if (params.containsKey("usedate") && !Objects.isNull(params.get("usedate"))) {
                model.setValue("usedate", params.get("usedate"));
            } else {
                model.setValue("startdate", params.get("startdate"));
                model.setValue("enddate", params.get("enddate"));
            }
        } else {
            this.setDefaultFilter();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean crossYear;
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("reset".equals(operateKey)) {
            this.getModel().setValue("usedate", (Object)"thisyear");
        }
        if ("confirm".equals(operateKey) && (crossYear = this.checkCrossYear(this.getModel()))) {
            args.setCancel(true);
            this.getView().showTipNotification(WTSSKDStringHelper.getCrossYear());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("confirm".equals(args.getOperateKey())) {
            Map<String, Object> params = this.getQuotaListMobFilter();
            IDataModel model = this.getModel();
            params.put("usedate", model.getValue("usedate"));
            params.put("startdate", WTCDateUtils.date2Str((Date)((Date)model.getValue("startdate")), (String)"yyyy-MM-dd"));
            params.put("enddate", WTCDateUtils.date2Str((Date)((Date)model.getValue("enddate")), (String)"yyyy-MM-dd"));
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        Object newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).get()).getNewValue() : null;
        IDataModel model = this.getModel();
        if (newValue == null) {
            if ("startdate".equals(key) || "enddate".equals(key)) {
                model.setValue("usedate", (Object)"thisyear");
            }
            return;
        }
        if ("usedate".equals(key)) {
            model.beginInit();
            model.setValue("startdate", null);
            model.setValue("enddate", null);
            model.endInit();
            this.getView().updateView("customdate");
        } else if ("startdate".equals(key) || "enddate".equals(key)) {
            model.setValue("usedate", null);
        }
    }

    private Map<String, Object> getQuotaListMobFilter() {
        String filterStr = (String)this.getView().getFormShowParameter().getCustomParam("quotalistmobfilter");
        return StringUtils.isBlank((CharSequence)filterStr) ? Maps.newHashMap() : (Map)SerializationUtils.fromJsonString((String)filterStr, Map.class);
    }

    private void setDefaultFilter() {
        IDataModel model = this.getModel();
        model.setValue("usedate", (Object)"thisyear");
        this.getView().updateView("usedate");
    }

    private boolean checkCrossYear(IDataModel model) {
        Object startDateObj = model.getValue("startdate");
        Object endDateObj = model.getValue("enddate");
        boolean crossYear = false;
        Object selectYearObj = this.getView().getFormShowParameter().getCustomParam("selectyear");
        if (selectYearObj instanceof String && startDateObj instanceof Date && endDateObj instanceof Date) {
            String selectYear = String.valueOf(selectYearObj);
            Date selectYearDate = WTCDateUtils.str2Date((String)selectYear, (String)"yyyy");
            Date beginDay = WTCDateUtils.getBeginDayOfYear((Date)selectYearDate);
            Date endDay = WTCDateUtils.getEndDayOfYear((Date)selectYearDate);
            Date nextYearBeginDay = WTCDateUtils.getBeginDayOfYear((Date)WTCDateUtils.getNextDate((Date)endDay));
            if (((Date)startDateObj).compareTo(beginDay) < 0 || ((Date)endDateObj).compareTo(nextYearBeginDay) > 0) {
                crossYear = true;
            }
        }
        return crossYear;
    }
}

