/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class QuotaListMobPlugin
extends AbstractMobFormPlugin
implements EntryGridBindDataListener,
MobileSearchTextChangeListener,
TabSelectListener {
    public void preOpenForm(PreOpenFormEventArgs args) {
        boolean hasRight;
        HasPermOrgResult result = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs(args.getFormShowParameter().getAppId(), "wtp_qtlinedetail");
        boolean bl = hasRight = result != null && (result.hasAllOrgPerm() || CollectionUtils.isNotEmpty((Collection)result.getHasPermOrgs()));
        if (!hasRight) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u201c\u5b9a\u989d\u660e\u7ec6\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QuotaListMobPlugin_0", (String)"wtc-wtss-formplugin", (Object[])new Object[0]));
            return;
        }
        Map params = args.getFormShowParameter().getCustomParams();
        if (StringUtils.isBlank((CharSequence)((CharSequence)params.get("indexIdAndQuotaDetailIdListMap")))) {
            args.setCancel(true);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Map params = ((MobileFormShowParameter)args.getSource()).getCustomParams();
        Map idMap = (Map)JSON.parseObject((String)((String)params.get("indexIdAndQuotaDetailIdListMap")), Map.class);
        HRBaseServiceHelper quotaSourceHelper = new HRBaseServiceHelper("wtp_quotasource");
        Object[] quotaSources = quotaSourceHelper.query("id,name", new QFilter[]{new QFilter("id", "in", idMap.keySet())});
        if (ArrayUtils.isEmpty((Object[])quotaSources)) {
            return;
        }
        ArrayList tabPages = Lists.newArrayListWithExpectedSize((int)quotaSources.length);
        for (Object quotaSource : quotaSources) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(this.getTabKey(quotaSource.getPkValue()));
            tabPageAp.setName(new LocaleString(quotaSource.getString("name")));
            tabPages.add(tabPageAp.createControl());
        }
        HashMap<String, Object> cusControlPanelItems = new HashMap<String, Object>();
        cusControlPanelItems.put("id", "tabap");
        cusControlPanelItems.put("items", tabPages);
        args.getItems().add(cusControlPanelItems);
    }

    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        ((MobileSearch)this.getControl("searchbox")).addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        ((Tab)this.getControl("tabap")).addTabSelectListener((TabSelectListener)this);
        ((Container)this.getControl("filterpanel")).addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long selectedSourceId = Long.parseLong((String)params.get("currentQuotaSourceId"));
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(this.getTabKey(selectedSourceId));
    }

    public void click(EventObject event) {
        super.click(event);
        String key = ((Control)event.getSource()).getKey();
        if ("filterpanel".equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("wtss_quotalistmobfilter");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "quotalistmobfilter"));
            showParameter.setCustomParam("quotalistmobfilter", (Object)this.getPageCache().get("quotalistmobfilter"));
            Object selectYear = this.getView().getFormShowParameter().getCustomParam("selectyear");
            if (selectYear instanceof String) {
                showParameter.setCustomParam("selectyear", selectYear);
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void click(MobileSearchTextChangeEvent event) {
        this.putToFilter(ImmutableMap.of((Object)"qttypename", (Object)event.getText()));
        this.updateEntry();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("quotalistmobfilter".equals(event.getActionId())) {
            Map returnData = (Map)event.getReturnData();
            this.putToFilter(returnData);
            this.updateEntry();
        }
    }

    public void tabSelected(TabSelectEvent event) {
        String pageIdKey = this.getPageIdKey(event.getTabKey());
        String pageId = this.getPageCache().get(pageIdKey);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            long sourceId = Long.parseLong(StringUtils.substringAfter((String)event.getTabKey(), (String)"tabpage_"));
            String idMapStr = (String)this.getView().getFormShowParameter().getCustomParam("indexIdAndQuotaDetailIdListMap");
            Object[] quotaDetailIds = Optional.ofNullable(JSON.parseObject((String)idMapStr, Map.class)).map(map -> map.get(sourceId)).map(arr -> (Long[])((JSONArray)arr).toArray((Object[])new Long[0])).orElseGet(() -> null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filterpanel"});
            if (ArrayUtils.isEmpty((Object[])quotaDetailIds)) {
                return;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap7"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filterpanel"});
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wtss_quotadetailmob");
            parameter.getOpenStyle().setTargetKey(event.getTabKey());
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.setCustomParam("quotaDetailIds", (Object)quotaDetailIds);
            parameter.setCustomParam("quotalistmobfilter", (Object)this.getPageCache().get("quotalistmobfilter"));
            this.getPageCache().put(pageIdKey, parameter.getPageId());
            this.getView().showForm(parameter);
        } else {
            this.updateEntry();
        }
    }

    private String getTabKey(Object sourceId) {
        return "tabpage_" + sourceId;
    }

    private String getPageIdKey(String tabKey) {
        return tabKey + "_pageId";
    }

    private void updateEntry() {
        String pageIdKey = this.getPageIdKey(((Tab)this.getControl("tabap")).getCurrentTab());
        String pageId = this.getPageCache().get(pageIdKey);
        IFormView childView = this.getView().getView(pageId);
        if (childView == null) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("quotalistmobfilter", this.getPageCache().get("quotalistmobfilter"));
        childView.invokeOperation("updateentry", option);
        this.getView().sendFormAction(childView);
    }

    private void putToFilter(Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            return;
        }
        String cacheStr = this.getPageCache().get("quotalistmobfilter");
        HashMap cacheParams = StringUtils.isBlank((CharSequence)cacheStr) ? Maps.newHashMap() : (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        cacheParams.putAll(params);
        this.getPageCache().put("quotalistmobfilter", SerializationUtils.toJsonString((Object)cacheParams));
    }
}

