/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtss.formplugin.web.mobile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

class QuotaTabUtils {
    private static final Log logger = LogFactory.getLog(QuotaTabUtils.class);

    QuotaTabUtils() {
    }

    static void loadTabs(LoadCustomControlMetasArgs args, List<Object> sourceIds) {
        HRBaseServiceHelper quotaSourceHelper = new HRBaseServiceHelper("wtp_quotasource");
        Object[] quotaSources = quotaSourceHelper.query("id,name", new QFilter[]{new QFilter("id", "in", sourceIds)});
        if (ArrayUtils.isEmpty((Object[])quotaSources)) {
            return;
        }
        Map<Object, DynamicObject> quotaSourcesMap = Arrays.stream(quotaSources).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy, (v1, v2) -> v1));
        ArrayList tabPages = Lists.newArrayListWithExpectedSize((int)quotaSources.length);
        for (Object id : sourceIds) {
            DynamicObject quotaSource = quotaSourcesMap.get(id);
            if (quotaSource == null) continue;
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(QuotaTabUtils.getTabKey(quotaSource.getPkValue()));
            tabPageAp.setName(new LocaleString(quotaSource.getString("name")));
            tabPages.add(tabPageAp.createControl());
        }
        HashMap<String, Object> cusControlPanelItems = new HashMap<String, Object>();
        cusControlPanelItems.put("id", "tabap");
        cusControlPanelItems.put("items", tabPages);
        args.getItems().add(cusControlPanelItems);
    }

    static void selectTabPlus(AbstractFormPlugin plugin, String tabKey, String childFormId, Map<String, Object> customParams) {
        IPageCache pageCache = plugin.getPageCache();
        String pageId = pageCache.get(tabKey);
        String sourceId = StringUtils.substringAfter((String)tabKey, (String)"tabpage_");
        if (logger.isInfoEnabled()) {
            logger.info("QuotaTabUtils#selectTabPlus#pageId:{}", (Object)pageId);
        }
        if (StringUtils.isBlank((CharSequence)pageId)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(childFormId);
            parameter.getOpenStyle().setTargetKey(tabKey);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getCustomParams().putAll(customParams);
            parameter.setCustomParam("currentQuotaSourceId", (Object)sourceId);
            pageCache.put(tabKey, parameter.getPageId());
            plugin.getView().showForm(parameter);
        }
        pageCache.put("currentQuotaSourceId", sourceId);
    }

    static void selectTab(AbstractFormPlugin plugin, TabSelectEvent event, String childFormId, Map<String, Object> customParams) {
        IPageCache pageCache = plugin.getPageCache();
        String tabKey = event.getTabKey();
        String pageId = pageCache.get(tabKey);
        String sourceId = StringUtils.substringAfter((String)tabKey, (String)"tabpage_");
        if (logger.isInfoEnabled()) {
            logger.info("QuotaTabUtils#selectTab#pageId:{}", (Object)pageId);
        }
        if (StringUtils.isBlank((CharSequence)pageId)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(childFormId);
            parameter.getOpenStyle().setTargetKey(tabKey);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getCustomParams().putAll(customParams);
            parameter.setCustomParam("currentQuotaSourceId", (Object)sourceId);
            pageCache.put(tabKey, parameter.getPageId());
            plugin.getView().showForm(parameter);
        }
        pageCache.put("currentQuotaSourceId", sourceId);
    }

    static void reloadTabs(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        List sourceIds = (List)view.getFormShowParameter().getCustomParam("sourceIds");
        IPageCache pageCache = view.getPageCache();
        for (Object sourceId : sourceIds) {
            IFormView childView;
            String tabKey = QuotaTabUtils.getTabKey(sourceId);
            String pageId = pageCache.get(tabKey);
            pageCache.remove(tabKey);
            if (StringUtils.isBlank((CharSequence)pageId) || (childView = view.getView(pageId)) == null) continue;
            childView.close();
        }
        if (logger.isInfoEnabled()) {
            logger.info("QuotaTabUtils#reloadTabs");
        }
        String currentSourceId = pageCache.get("currentQuotaSourceId");
        String currentTabKey = QuotaTabUtils.getTabKey(currentSourceId);
        Tab tab = (Tab)view.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)plugin);
        tab.selectTab(currentTabKey);
    }

    static String getTabKey(Object sourceId) {
        return "tabpage_" + sourceId;
    }

    static void cacheQuotaListMobFilter(IFormView view, Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            return;
        }
        IPageCache pageCache = view.getPageCache();
        String cacheStr = pageCache.get("quotalistmobfilter");
        HashMap cacheParams = StringUtils.isBlank((CharSequence)cacheStr) ? Maps.newHashMap() : (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        cacheParams.putAll(params);
        pageCache.put("quotalistmobfilter", SerializationUtils.toJsonString((Object)cacheParams));
    }
}

